from typing import Any, Iterable, Tuple, Union


class Context:
    def load(name: str) -> int: ...


class Buffer:
    size: int
    def write(self, data: bytes, /, offset: int = 0): ...
    def map(self, /, size: int = -1, *, offset: int = 0, discard: bool = False) -> memoryview: ...
    def unmap(self) -> None: ...


class Image:
    size: Tuple[int, int]
    samples: int
    def clear(self, /, *args: Iterable[Union[float, int]]): ...
    def write(self, data: bytes, /, size: Tuple[int, int] = ..., offset: Tuple[int, int] = (0, 0), layer: int = 0): ...
    def mipmaps(self, /, *, base: int = 0, levels: int = -1): ...
    def read(self, /, size: Tuple[int, int] = ..., *, offset: Tuple[int, int] = (0, 0)): ...
    def blit(
        self, /, dst: 'Image' | None = None, *, dst_size: Tuple[int, int] = ..., dst_offset: Tuple[int, int] = (0, 0),
        src_size: Tuple[int, int] = ..., src_offset: Tuple[int, int] = (0, 0), filter: bool = True): ...


class Renderer:
    vertex_count: int
    instance_count: int
    def render(self) -> None: ...


class Instance:
    def buffer(self, /, data: bytes | None = None, *, size: int = 0, dynamic: bool = False) -> Buffer: ...
    def image(self, size: Tuple[int, int], format: str, /, data: bytes | None = None, *, samples: int = 1, texture: bool | None = None) -> Image: ...
    def renderer(
        self, *, vertex_shader: str = ..., fragment_shader: str = ..., framebuffer: Iterable[Image] = (), topology: str = 'triangles',
        layout: Iterable = (), resources: Iterable = (), vertex_buffers: Iterable = (), index_buffer: Buffer | None = None, vertex_count: int = 0,
        instance_count: int = 0, short_index: bool = False, primitive_restart: bool = False, point_size: float = 1.0, line_width: float = 1.0,
        front_face: str = 'ccw', cull_face: str = 'none', color_mask: int = 0xffffffffffffffff, depth: dict | bool | None = None,
        stencil: dict | None = None, blending: dict | None = None, polygon_offset: dict | None = None) -> Renderer: ...


def instance(context: Context | Any) -> Instance: ...
def camera(
    eye: Tuple[float, float, float], target: Tuple[float, float, float], /, up: Tuple[float, float, float] = (0.0, 0.0, 1.0), *,
    fov: float = 45.0, aspect: float = 1.0, near: float = 0.1, far: float = 1000.0, size: float = 1.0, clip: bool = False) -> bytes: ...
def rgba(data: bytes, format: str) -> bytes: ...
def pack(*arg: Iterable[Union[float, int]]) -> bytes: ...
def bind(buffer: Buffer, layout: str, *attributes: Iterable[int]) -> Any: ...
def calcsize(layout: str) -> int: ...
def context(headless: bool = False) -> Context: ...
