"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bounce = exports.BounceTemplate = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A bounce template.
 */
class BounceTemplate {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_BounceTemplateProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
}
exports.BounceTemplate = BounceTemplate;
_a = JSII_RTTI_SYMBOL_1;
BounceTemplate[_a] = { fqn: "@aws-cdk/aws-ses-actions.BounceTemplate", version: "1.156.1" };
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * Rejects the received email by returning a bounce response to the sender and,
 * optionally, publishes a notification to Amazon SNS.
 */
class Bounce {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_BounceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(_rule) {
        var _c;
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: (_c = this.props.topic) === null || _c === void 0 ? void 0 : _c.topicArn,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
_b = JSII_RTTI_SYMBOL_1;
Bounce[_b] = { fqn: "@aws-cdk/aws-ses-actions.Bounce", version: "1.156.1" };
//# sourceMappingURL=data:application/json;base64,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