"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sns = exports.EmailEncoding = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The type of email encoding to use for a SNS action.
 */
var EmailEncoding;
(function (EmailEncoding) {
    /**
     * Base 64
     */
    EmailEncoding["BASE64"] = "Base64";
    /**
     * UTF-8
     */
    EmailEncoding["UTF8"] = "UTF-8";
})(EmailEncoding = exports.EmailEncoding || (exports.EmailEncoding = {}));
/**
 * Publishes the email content within a notification to Amazon SNS.
 */
class Sns {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_SnsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(_rule) {
        return {
            snsAction: {
                encoding: this.props.encoding,
                topicArn: this.props.topic.topicArn,
            },
        };
    }
}
exports.Sns = Sns;
_a = JSII_RTTI_SYMBOL_1;
Sns[_a] = { fqn: "@aws-cdk/aws-ses-actions.Sns", version: "1.156.1" };
//# sourceMappingURL=data:application/json;base64,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