# -*- coding: utf-8 -*-
# File generated from our OpenAPI spec
from __future__ import absolute_import, division, print_function
import stripe

from tests.http_client_mock import HTTPClientMock
import io
from stripe import StripeClient
import pytest


class TestGeneratedExamples(object):
    def test_account_links_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.AccountLink.create(
            account="acct_xxxxxxxxxxxxx",
            refresh_url="https://example.com/reauth",
            return_url="https://example.com/return",
            type="account_onboarding",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/account_links",
            query_string="",
            post_data="account=acct_xxxxxxxxxxxxx&refresh_url=https%3A%2F%2Fexample.com%2Freauth&return_url=https%3A%2F%2Fexample.com%2Freturn&type=account_onboarding",
        )

    def test_account_links_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/account_links",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.account_links.create(
            {
                "account": "acct_xxxxxxxxxxxxx",
                "refresh_url": "https://example.com/reauth",
                "return_url": "https://example.com/return",
                "type": "account_onboarding",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/account_links",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="account=acct_xxxxxxxxxxxxx&refresh_url=https%3A%2F%2Fexample.com%2Freauth&return_url=https%3A%2F%2Fexample.com%2Freturn&type=account_onboarding",
        )

    @pytest.mark.anyio
    async def test_account_links_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.AccountLink.create_async(
            account="acct_xxxxxxxxxxxxx",
            refresh_url="https://example.com/reauth",
            return_url="https://example.com/return",
            type="account_onboarding",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/account_links",
            query_string="",
            post_data="account=acct_xxxxxxxxxxxxx&refresh_url=https%3A%2F%2Fexample.com%2Freauth&return_url=https%3A%2F%2Fexample.com%2Freturn&type=account_onboarding",
        )

    @pytest.mark.anyio
    async def test_account_links_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/account_links",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.account_links.create_async(
            {
                "account": "acct_xxxxxxxxxxxxx",
                "refresh_url": "https://example.com/reauth",
                "return_url": "https://example.com/return",
                "type": "account_onboarding",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/account_links",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="account=acct_xxxxxxxxxxxxx&refresh_url=https%3A%2F%2Fexample.com%2Freauth&return_url=https%3A%2F%2Fexample.com%2Freturn&type=account_onboarding",
        )

    def test_accounts_capabilities_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.list_capabilities("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities",
            query_string="",
        )

    def test_accounts_capabilities_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/capabilities",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.capabilities.list("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_capabilities_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.list_capabilities_async("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_capabilities_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/capabilities",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.capabilities.list_async("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_capabilities_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.retrieve_capability(
            "acct_xxxxxxxxxxxxx",
            "card_payments",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
            query_string="",
        )

    def test_accounts_capabilities_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.capabilities.retrieve(
            "acct_xxxxxxxxxxxxx",
            "card_payments",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_capabilities_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.retrieve_capability_async(
            "acct_xxxxxxxxxxxxx",
            "card_payments",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_capabilities_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.capabilities.retrieve_async(
            "acct_xxxxxxxxxxxxx",
            "card_payments",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_capabilities_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.modify_capability(
            "acct_xxxxxxxxxxxxx",
            "card_payments",
            requested=True,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
            query_string="",
            post_data="requested=True",
        )

    def test_accounts_capabilities_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.capabilities.update(
            "acct_xxxxxxxxxxxxx",
            "card_payments",
            {"requested": True},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="requested=True",
        )

    @pytest.mark.anyio
    async def test_accounts_capabilities_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.modify_capability_async(
            "acct_xxxxxxxxxxxxx",
            "card_payments",
            requested=True,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
            query_string="",
            post_data="requested=True",
        )

    @pytest.mark.anyio
    async def test_accounts_capabilities_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.capabilities.update_async(
            "acct_xxxxxxxxxxxxx",
            "card_payments",
            {"requested": True},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/capabilities/card_payments",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="requested=True",
        )

    def test_accounts_delete(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Account.delete("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_accounts_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/accounts/acct_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.delete("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.delete_async("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/accounts/acct_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.delete_async("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_external_accounts_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.delete_external_account(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_accounts_external_accounts_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.delete(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.delete_external_account_async(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.delete_async(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_external_accounts_delete_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.delete_external_account(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_accounts_external_accounts_delete_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.delete(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_delete_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.delete_external_account_async(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_delete_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.delete_async(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_external_accounts_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.list_external_accounts(
            "acct_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="limit=3",
        )

    def test_accounts_external_accounts_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.list(
            "acct_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.list_external_accounts_async(
            "acct_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.list_async(
            "acct_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_accounts_external_accounts_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.list_external_accounts(
            "acct_xxxxxxxxxxxxx",
            object="bank_account",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="object=bank_account&limit=3",
        )

    def test_accounts_external_accounts_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            "object=bank_account&limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.list(
            "acct_xxxxxxxxxxxxx",
            {"object": "bank_account", "limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="object=bank_account&limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.list_external_accounts_async(
            "acct_xxxxxxxxxxxxx",
            object="bank_account",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="object=bank_account&limit=3",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            "object=bank_account&limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.list_async(
            "acct_xxxxxxxxxxxxx",
            {"object": "bank_account", "limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="object=bank_account&limit=3",
            api_base="https://api.stripe.com",
        )

    def test_accounts_external_accounts_get_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.list_external_accounts(
            "acct_xxxxxxxxxxxxx",
            object="card",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="object=card&limit=3",
        )

    def test_accounts_external_accounts_get_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            "object=card&limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.list(
            "acct_xxxxxxxxxxxxx",
            {"object": "card", "limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="object=card&limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_get_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.list_external_accounts_async(
            "acct_xxxxxxxxxxxxx",
            object="card",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="object=card&limit=3",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_get_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            "object=card&limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.list_async(
            "acct_xxxxxxxxxxxxx",
            {"object": "card", "limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="object=card&limit=3",
            api_base="https://api.stripe.com",
        )

    def test_accounts_external_accounts_get_4(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.retrieve_external_account(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_accounts_external_accounts_get_4_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.retrieve(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_get_4_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.retrieve_external_account_async(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_get_4_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.retrieve_async(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_external_accounts_get_5(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.retrieve_external_account(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_accounts_external_accounts_get_5_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.retrieve(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_get_5_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.retrieve_external_account_async(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_get_5_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.retrieve_async(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_external_accounts_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.create_external_account(
            "acct_xxxxxxxxxxxxx",
            external_account="btok_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="",
            post_data="external_account=btok_xxxxxxxxxxxxx",
        )

    def test_accounts_external_accounts_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.create(
            "acct_xxxxxxxxxxxxx",
            {"external_account": "btok_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="external_account=btok_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.create_external_account_async(
            "acct_xxxxxxxxxxxxx",
            external_account="btok_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="",
            post_data="external_account=btok_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.create_async(
            "acct_xxxxxxxxxxxxx",
            {"external_account": "btok_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="external_account=btok_xxxxxxxxxxxxx",
        )

    def test_accounts_external_accounts_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.create_external_account(
            "acct_xxxxxxxxxxxxx",
            external_account="tok_xxxx_debit",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="",
            post_data="external_account=tok_xxxx_debit",
        )

    def test_accounts_external_accounts_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.create(
            "acct_xxxxxxxxxxxxx",
            {"external_account": "tok_xxxx_debit"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="external_account=tok_xxxx_debit",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.create_external_account_async(
            "acct_xxxxxxxxxxxxx",
            external_account="tok_xxxx_debit",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="",
            post_data="external_account=tok_xxxx_debit",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.create_async(
            "acct_xxxxxxxxxxxxx",
            {"external_account": "tok_xxxx_debit"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="external_account=tok_xxxx_debit",
        )

    def test_accounts_external_accounts_post_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.modify_external_account(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_accounts_external_accounts_post_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.update(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_post_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.modify_external_account_async(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_post_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.update_async(
            "acct_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_accounts_external_accounts_post_4(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.modify_external_account(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_accounts_external_accounts_post_4_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.external_accounts.update(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_post_4_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.modify_external_account_async(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_accounts_external_accounts_post_4_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.external_accounts.update_async(
            "acct_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/external_accounts/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_accounts_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Account.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts",
            query_string="limit=3",
        )

    def test_accounts_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_accounts_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_accounts_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Account.retrieve("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_accounts_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.retrieve("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.retrieve_async("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.retrieve_async("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_login_links_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.create_login_link("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/login_links",
            query_string="",
        )

    def test_accounts_login_links_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/login_links",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.login_links.create("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/login_links",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_login_links_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.create_login_link_async("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/login_links",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_login_links_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/login_links",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.login_links.create_async("acct_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/login_links",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_persons_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.delete_person(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_accounts_persons_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.persons.delete(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_persons_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.delete_person_async(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_persons_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.persons.delete_async(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_persons_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.persons(
            "acct_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons",
            query_string="limit=3",
        )

    def test_accounts_persons_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/persons",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.persons.list(
            "acct_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_persons_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.persons_async(
            "acct_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_accounts_persons_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/persons",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.persons.list_async(
            "acct_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_accounts_persons_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.retrieve_person(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_accounts_persons_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.persons.retrieve(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_accounts_persons_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.retrieve_person_async(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_accounts_persons_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.persons.retrieve_async(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_accounts_persons_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.create_person(
            "acct_xxxxxxxxxxxxx",
            first_name="Jane",
            last_name="Diaz",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons",
            query_string="",
            post_data="first_name=Jane&last_name=Diaz",
        )

    def test_accounts_persons_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/persons",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.persons.create(
            "acct_xxxxxxxxxxxxx",
            {"first_name": "Jane", "last_name": "Diaz"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="first_name=Jane&last_name=Diaz",
        )

    @pytest.mark.anyio
    async def test_accounts_persons_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.create_person_async(
            "acct_xxxxxxxxxxxxx",
            first_name="Jane",
            last_name="Diaz",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons",
            query_string="",
            post_data="first_name=Jane&last_name=Diaz",
        )

    @pytest.mark.anyio
    async def test_accounts_persons_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/persons",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.persons.create_async(
            "acct_xxxxxxxxxxxxx",
            {"first_name": "Jane", "last_name": "Diaz"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="first_name=Jane&last_name=Diaz",
        )

    def test_accounts_persons_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.modify_person(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_accounts_persons_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.persons.update(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_accounts_persons_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.modify_person_async(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_accounts_persons_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.persons.update_async(
            "acct_xxxxxxxxxxxxx",
            "person_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/persons/person_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_accounts_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Account.create(
            type="custom",
            country="US",
            email="jenny.rosen@example.com",
            capabilities={
                "card_payments": {"requested": True},
                "transfers": {"requested": True},
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts",
            query_string="",
            post_data="type=custom&country=US&email=jenny.rosen%40example.com&capabilities[card_payments][requested]=True&capabilities[transfers][requested]=True",
        )

    def test_accounts_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.create(
            {
                "type": "custom",
                "country": "US",
                "email": "jenny.rosen@example.com",
                "capabilities": {
                    "card_payments": {"requested": True},
                    "transfers": {"requested": True},
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=custom&country=US&email=jenny.rosen%40example.com&capabilities[card_payments][requested]=True&capabilities[transfers][requested]=True",
        )

    @pytest.mark.anyio
    async def test_accounts_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.create_async(
            type="custom",
            country="US",
            email="jenny.rosen@example.com",
            capabilities={
                "card_payments": {"requested": True},
                "transfers": {"requested": True},
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts",
            query_string="",
            post_data="type=custom&country=US&email=jenny.rosen%40example.com&capabilities[card_payments][requested]=True&capabilities[transfers][requested]=True",
        )

    @pytest.mark.anyio
    async def test_accounts_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.create_async(
            {
                "type": "custom",
                "country": "US",
                "email": "jenny.rosen@example.com",
                "capabilities": {
                    "card_payments": {"requested": True},
                    "transfers": {"requested": True},
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=custom&country=US&email=jenny.rosen%40example.com&capabilities[card_payments][requested]=True&capabilities[transfers][requested]=True",
        )

    def test_accounts_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Account.modify(
            "acct_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_accounts_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.update(
            "acct_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_accounts_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.modify_async(
            "acct_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_accounts_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.update_async(
            "acct_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_accounts_reject_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Account.reject(
            "acct_xxxxxxxxxxxxx",
            reason="fraud",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/reject",
            query_string="",
            post_data="reason=fraud",
        )

    def test_accounts_reject_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/reject",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.accounts.reject(
            "acct_xxxxxxxxxxxxx",
            {"reason": "fraud"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/reject",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="reason=fraud",
        )

    @pytest.mark.anyio
    async def test_accounts_reject_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Account.reject_async(
            "acct_xxxxxxxxxxxxx",
            reason="fraud",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/reject",
            query_string="",
            post_data="reason=fraud",
        )

    @pytest.mark.anyio
    async def test_accounts_reject_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/accounts/acct_xxxxxxxxxxxxx/reject",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.accounts.reject_async(
            "acct_xxxxxxxxxxxxx",
            {"reason": "fraud"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/accounts/acct_xxxxxxxxxxxxx/reject",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="reason=fraud",
        )

    def test_application_fees_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ApplicationFee.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees",
            query_string="limit=3",
        )

    def test_application_fees_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/application_fees",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.application_fees.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_application_fees_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ApplicationFee.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_application_fees_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/application_fees",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.application_fees.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_application_fees_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ApplicationFee.retrieve("fee_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_application_fees_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/application_fees/fee_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.application_fees.retrieve("fee_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_application_fees_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ApplicationFee.retrieve_async("fee_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_application_fees_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/application_fees/fee_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.application_fees.retrieve_async("fee_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_application_fees_refunds_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ApplicationFee.list_refunds(
            "fee_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
            query_string="limit=3",
        )

    def test_application_fees_refunds_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.application_fees.refunds.list(
            "fee_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_application_fees_refunds_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ApplicationFee.list_refunds_async(
            "fee_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_application_fees_refunds_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.application_fees.refunds.list_async(
            "fee_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_application_fees_refunds_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ApplicationFee.retrieve_refund(
            "fee_xxxxxxxxxxxxx",
            "fr_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_application_fees_refunds_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.application_fees.refunds.retrieve(
            "fee_xxxxxxxxxxxxx",
            "fr_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_application_fees_refunds_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ApplicationFee.retrieve_refund_async(
            "fee_xxxxxxxxxxxxx",
            "fr_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_application_fees_refunds_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.application_fees.refunds.retrieve_async(
            "fee_xxxxxxxxxxxxx",
            "fr_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_application_fees_refunds_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ApplicationFee.create_refund("fee_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
            query_string="",
        )

    def test_application_fees_refunds_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.application_fees.refunds.create("fee_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_application_fees_refunds_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ApplicationFee.create_refund_async("fee_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_application_fees_refunds_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.application_fees.refunds.create_async("fee_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_application_fees_refunds_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ApplicationFee.modify_refund(
            "fee_xxxxxxxxxxxxx",
            "fr_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_application_fees_refunds_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.application_fees.refunds.update(
            "fee_xxxxxxxxxxxxx",
            "fr_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_application_fees_refunds_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ApplicationFee.modify_refund_async(
            "fee_xxxxxxxxxxxxx",
            "fr_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_application_fees_refunds_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.application_fees.refunds.update_async(
            "fee_xxxxxxxxxxxxx",
            "fr_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/application_fees/fee_xxxxxxxxxxxxx/refunds/fr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_apps_secrets_delete_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.apps.Secret.delete_where(
            name="my-api-key",
            scope={"type": "account"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets/delete",
            query_string="",
            post_data="name=my-api-key&scope[type]=account",
        )

    def test_apps_secrets_delete_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/apps/secrets/delete",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.apps.secrets.delete_where(
            {
                "name": "my-api-key",
                "scope": {"type": "account"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets/delete",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=my-api-key&scope[type]=account",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_delete_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.apps.Secret.delete_where_async(
            name="my-api-key",
            scope={"type": "account"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets/delete",
            query_string="",
            post_data="name=my-api-key&scope[type]=account",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_delete_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/apps/secrets/delete",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.apps.secrets.delete_where_async(
            {
                "name": "my-api-key",
                "scope": {"type": "account"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets/delete",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=my-api-key&scope[type]=account",
        )

    def test_apps_secrets_find_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.apps.Secret.find(
            name="sec_123",
            scope={"type": "account"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets/find",
            query_string="name=sec_123&scope[type]=account",
        )

    def test_apps_secrets_find_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/apps/secrets/find",
            "name=sec_123&scope[type]=account",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.apps.secrets.find(
            {
                "name": "sec_123",
                "scope": {"type": "account"},
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets/find",
            query_string="name=sec_123&scope[type]=account",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_find_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.apps.Secret.find_async(
            name="sec_123",
            scope={"type": "account"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets/find",
            query_string="name=sec_123&scope[type]=account",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_find_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/apps/secrets/find",
            "name=sec_123&scope[type]=account",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.apps.secrets.find_async(
            {
                "name": "sec_123",
                "scope": {"type": "account"},
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets/find",
            query_string="name=sec_123&scope[type]=account",
            api_base="https://api.stripe.com",
        )

    def test_apps_secrets_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.apps.Secret.list(
            scope={"type": "account"},
            limit=2,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets",
            query_string="scope[type]=account&limit=2",
        )

    def test_apps_secrets_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/apps/secrets",
            "scope[type]=account&limit=2",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.apps.secrets.list({"scope": {"type": "account"}, "limit": 2})
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets",
            query_string="scope[type]=account&limit=2",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.apps.Secret.list_async(
            scope={"type": "account"},
            limit=2,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets",
            query_string="scope[type]=account&limit=2",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/apps/secrets",
            "scope[type]=account&limit=2",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.apps.secrets.list_async(
            {
                "scope": {"type": "account"},
                "limit": 2,
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets",
            query_string="scope[type]=account&limit=2",
            api_base="https://api.stripe.com",
        )

    def test_apps_secrets_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.apps.Secret.list(
            scope={"type": "account"},
            limit=2,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets",
            query_string="scope[type]=account&limit=2",
        )

    def test_apps_secrets_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/apps/secrets",
            "scope[type]=account&limit=2",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.apps.secrets.list({"scope": {"type": "account"}, "limit": 2})
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets",
            query_string="scope[type]=account&limit=2",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.apps.Secret.list_async(
            scope={"type": "account"},
            limit=2,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets",
            query_string="scope[type]=account&limit=2",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/apps/secrets",
            "scope[type]=account&limit=2",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.apps.secrets.list_async(
            {
                "scope": {"type": "account"},
                "limit": 2,
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/apps/secrets",
            query_string="scope[type]=account&limit=2",
            api_base="https://api.stripe.com",
        )

    def test_apps_secrets_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.apps.Secret.create(
            name="sec_123",
            payload="very secret string",
            scope={"type": "account"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets",
            query_string="",
            post_data="name=sec_123&payload=very%20secret%20string&scope[type]=account",
        )

    def test_apps_secrets_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/apps/secrets",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.apps.secrets.create(
            {
                "name": "sec_123",
                "payload": "very secret string",
                "scope": {"type": "account"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=sec_123&payload=very%20secret%20string&scope[type]=account",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.apps.Secret.create_async(
            name="sec_123",
            payload="very secret string",
            scope={"type": "account"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets",
            query_string="",
            post_data="name=sec_123&payload=very%20secret%20string&scope[type]=account",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/apps/secrets",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.apps.secrets.create_async(
            {
                "name": "sec_123",
                "payload": "very secret string",
                "scope": {"type": "account"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=sec_123&payload=very%20secret%20string&scope[type]=account",
        )

    def test_apps_secrets_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.apps.Secret.create(
            name="my-api-key",
            payload="secret_key_xxxxxx",
            scope={"type": "account"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets",
            query_string="",
            post_data="name=my-api-key&payload=secret_key_xxxxxx&scope[type]=account",
        )

    def test_apps_secrets_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/apps/secrets",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.apps.secrets.create(
            {
                "name": "my-api-key",
                "payload": "secret_key_xxxxxx",
                "scope": {"type": "account"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=my-api-key&payload=secret_key_xxxxxx&scope[type]=account",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.apps.Secret.create_async(
            name="my-api-key",
            payload="secret_key_xxxxxx",
            scope={"type": "account"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets",
            query_string="",
            post_data="name=my-api-key&payload=secret_key_xxxxxx&scope[type]=account",
        )

    @pytest.mark.anyio
    async def test_apps_secrets_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/apps/secrets",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.apps.secrets.create_async(
            {
                "name": "my-api-key",
                "payload": "secret_key_xxxxxx",
                "scope": {"type": "account"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/apps/secrets",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=my-api-key&payload=secret_key_xxxxxx&scope[type]=account",
        )

    def test_balance_transactions_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.BalanceTransaction.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/balance_transactions",
            query_string="limit=3",
        )

    def test_balance_transactions_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/balance_transactions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.balance_transactions.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/balance_transactions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_balance_transactions_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.BalanceTransaction.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/balance_transactions",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_balance_transactions_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/balance_transactions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.balance_transactions.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/balance_transactions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_balance_transactions_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.BalanceTransaction.retrieve("txn_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/balance_transactions/txn_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_balance_transactions_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/balance_transactions/txn_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.balance_transactions.retrieve("txn_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/balance_transactions/txn_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_balance_transactions_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.BalanceTransaction.retrieve_async("txn_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/balance_transactions/txn_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_balance_transactions_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/balance_transactions/txn_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.balance_transactions.retrieve_async("txn_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/balance_transactions/txn_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_billing_portal_configurations_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.billing_portal.Configuration.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/billing_portal/configurations",
            query_string="limit=3",
        )

    def test_billing_portal_configurations_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/billing_portal/configurations",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.billing_portal.configurations.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/billing_portal/configurations",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_billing_portal_configurations_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.billing_portal.Configuration.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/billing_portal/configurations",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_billing_portal_configurations_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/billing_portal/configurations",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.billing_portal.configurations.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/billing_portal/configurations",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_billing_portal_configurations_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.billing_portal.Configuration.retrieve("bpc_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_billing_portal_configurations_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.billing_portal.configurations.retrieve("bpc_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_billing_portal_configurations_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.billing_portal.Configuration.retrieve_async(
            "bpc_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_billing_portal_configurations_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.billing_portal.configurations.retrieve_async(
            "bpc_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_billing_portal_configurations_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.billing_portal.Configuration.create(
            features={
                "customer_update": {
                    "allowed_updates": ["email", "tax_id"],
                    "enabled": True,
                },
                "invoice_history": {"enabled": True},
            },
            business_profile={
                "privacy_policy_url": "https://example.com/privacy",
                "terms_of_service_url": "https://example.com/terms",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/configurations",
            query_string="",
            post_data="features[customer_update][allowed_updates][0]=email&features[customer_update][allowed_updates][1]=tax_id&features[customer_update][enabled]=True&features[invoice_history][enabled]=True&business_profile[privacy_policy_url]=https%3A%2F%2Fexample.com%2Fprivacy&business_profile[terms_of_service_url]=https%3A%2F%2Fexample.com%2Fterms",
        )

    def test_billing_portal_configurations_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/billing_portal/configurations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.billing_portal.configurations.create(
            {
                "features": {
                    "customer_update": {
                        "allowed_updates": ["email", "tax_id"],
                        "enabled": True,
                    },
                    "invoice_history": {"enabled": True},
                },
                "business_profile": {
                    "privacy_policy_url": "https://example.com/privacy",
                    "terms_of_service_url": "https://example.com/terms",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/configurations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="features[customer_update][allowed_updates][0]=email&features[customer_update][allowed_updates][1]=tax_id&features[customer_update][enabled]=True&features[invoice_history][enabled]=True&business_profile[privacy_policy_url]=https%3A%2F%2Fexample.com%2Fprivacy&business_profile[terms_of_service_url]=https%3A%2F%2Fexample.com%2Fterms",
        )

    @pytest.mark.anyio
    async def test_billing_portal_configurations_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.billing_portal.Configuration.create_async(
            features={
                "customer_update": {
                    "allowed_updates": ["email", "tax_id"],
                    "enabled": True,
                },
                "invoice_history": {"enabled": True},
            },
            business_profile={
                "privacy_policy_url": "https://example.com/privacy",
                "terms_of_service_url": "https://example.com/terms",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/configurations",
            query_string="",
            post_data="features[customer_update][allowed_updates][0]=email&features[customer_update][allowed_updates][1]=tax_id&features[customer_update][enabled]=True&features[invoice_history][enabled]=True&business_profile[privacy_policy_url]=https%3A%2F%2Fexample.com%2Fprivacy&business_profile[terms_of_service_url]=https%3A%2F%2Fexample.com%2Fterms",
        )

    @pytest.mark.anyio
    async def test_billing_portal_configurations_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/billing_portal/configurations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.billing_portal.configurations.create_async(
            {
                "features": {
                    "customer_update": {
                        "allowed_updates": ["email", "tax_id"],
                        "enabled": True,
                    },
                    "invoice_history": {"enabled": True},
                },
                "business_profile": {
                    "privacy_policy_url": "https://example.com/privacy",
                    "terms_of_service_url": "https://example.com/terms",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/configurations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="features[customer_update][allowed_updates][0]=email&features[customer_update][allowed_updates][1]=tax_id&features[customer_update][enabled]=True&features[invoice_history][enabled]=True&business_profile[privacy_policy_url]=https%3A%2F%2Fexample.com%2Fprivacy&business_profile[terms_of_service_url]=https%3A%2F%2Fexample.com%2Fterms",
        )

    def test_billing_portal_configurations_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.billing_portal.Configuration.modify(
            "bpc_xxxxxxxxxxxxx",
            business_profile={
                "privacy_policy_url": "https://example.com/privacy",
                "terms_of_service_url": "https://example.com/terms",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
            query_string="",
            post_data="business_profile[privacy_policy_url]=https%3A%2F%2Fexample.com%2Fprivacy&business_profile[terms_of_service_url]=https%3A%2F%2Fexample.com%2Fterms",
        )

    def test_billing_portal_configurations_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.billing_portal.configurations.update(
            "bpc_xxxxxxxxxxxxx",
            {
                "business_profile": {
                    "privacy_policy_url": "https://example.com/privacy",
                    "terms_of_service_url": "https://example.com/terms",
                },
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="business_profile[privacy_policy_url]=https%3A%2F%2Fexample.com%2Fprivacy&business_profile[terms_of_service_url]=https%3A%2F%2Fexample.com%2Fterms",
        )

    @pytest.mark.anyio
    async def test_billing_portal_configurations_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.billing_portal.Configuration.modify_async(
            "bpc_xxxxxxxxxxxxx",
            business_profile={
                "privacy_policy_url": "https://example.com/privacy",
                "terms_of_service_url": "https://example.com/terms",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
            query_string="",
            post_data="business_profile[privacy_policy_url]=https%3A%2F%2Fexample.com%2Fprivacy&business_profile[terms_of_service_url]=https%3A%2F%2Fexample.com%2Fterms",
        )

    @pytest.mark.anyio
    async def test_billing_portal_configurations_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.billing_portal.configurations.update_async(
            "bpc_xxxxxxxxxxxxx",
            {
                "business_profile": {
                    "privacy_policy_url": "https://example.com/privacy",
                    "terms_of_service_url": "https://example.com/terms",
                },
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/configurations/bpc_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="business_profile[privacy_policy_url]=https%3A%2F%2Fexample.com%2Fprivacy&business_profile[terms_of_service_url]=https%3A%2F%2Fexample.com%2Fterms",
        )

    def test_billing_portal_sessions_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.billing_portal.Session.create(
            customer="cus_xxxxxxxxxxxxx",
            return_url="https://example.com/account",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/sessions",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx&return_url=https%3A%2F%2Fexample.com%2Faccount",
        )

    def test_billing_portal_sessions_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/billing_portal/sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.billing_portal.sessions.create(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "return_url": "https://example.com/account",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx&return_url=https%3A%2F%2Fexample.com%2Faccount",
        )

    @pytest.mark.anyio
    async def test_billing_portal_sessions_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.billing_portal.Session.create_async(
            customer="cus_xxxxxxxxxxxxx",
            return_url="https://example.com/account",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/sessions",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx&return_url=https%3A%2F%2Fexample.com%2Faccount",
        )

    @pytest.mark.anyio
    async def test_billing_portal_sessions_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/billing_portal/sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.billing_portal.sessions.create_async(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "return_url": "https://example.com/account",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/billing_portal/sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx&return_url=https%3A%2F%2Fexample.com%2Faccount",
        )

    def test_charges_capture_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Charge.capture("ch_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges/ch_xxxxxxxxxxxxx/capture",
            query_string="",
        )

    def test_charges_capture_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/charges/ch_xxxxxxxxxxxxx/capture",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.charges.capture("ch_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges/ch_xxxxxxxxxxxxx/capture",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_charges_capture_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Charge.capture_async("ch_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges/ch_xxxxxxxxxxxxx/capture",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_charges_capture_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/charges/ch_xxxxxxxxxxxxx/capture",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.charges.capture_async("ch_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges/ch_xxxxxxxxxxxxx/capture",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_charges_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Charge.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges",
            query_string="limit=3",
        )

    def test_charges_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/charges",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.charges.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_charges_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Charge.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_charges_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/charges",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.charges.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_charges_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Charge.retrieve("ch_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges/ch_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_charges_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/charges/ch_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.charges.retrieve("ch_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges/ch_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_charges_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Charge.retrieve_async("ch_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges/ch_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_charges_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/charges/ch_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.charges.retrieve_async("ch_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges/ch_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_charges_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Charge.create(
            amount=2000,
            currency="usd",
            source="tok_xxxx",
            description="My First Test Charge (created for API docs at https://www.stripe.com/docs/api)",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges",
            query_string="",
            post_data="amount=2000&currency=usd&source=tok_xxxx&description=My%20First%20Test%20Charge%20%28created%20for%20API%20docs%20at%20https%3A%2F%2Fwww.stripe.com%2Fdocs%2Fapi%29",
        )

    def test_charges_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/charges",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.charges.create(
            {
                "amount": 2000,
                "currency": "usd",
                "source": "tok_xxxx",
                "description": "My First Test Charge (created for API docs at https://www.stripe.com/docs/api)",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2000&currency=usd&source=tok_xxxx&description=My%20First%20Test%20Charge%20%28created%20for%20API%20docs%20at%20https%3A%2F%2Fwww.stripe.com%2Fdocs%2Fapi%29",
        )

    @pytest.mark.anyio
    async def test_charges_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Charge.create_async(
            amount=2000,
            currency="usd",
            source="tok_xxxx",
            description="My First Test Charge (created for API docs at https://www.stripe.com/docs/api)",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges",
            query_string="",
            post_data="amount=2000&currency=usd&source=tok_xxxx&description=My%20First%20Test%20Charge%20%28created%20for%20API%20docs%20at%20https%3A%2F%2Fwww.stripe.com%2Fdocs%2Fapi%29",
        )

    @pytest.mark.anyio
    async def test_charges_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/charges",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.charges.create_async(
            {
                "amount": 2000,
                "currency": "usd",
                "source": "tok_xxxx",
                "description": "My First Test Charge (created for API docs at https://www.stripe.com/docs/api)",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2000&currency=usd&source=tok_xxxx&description=My%20First%20Test%20Charge%20%28created%20for%20API%20docs%20at%20https%3A%2F%2Fwww.stripe.com%2Fdocs%2Fapi%29",
        )

    def test_charges_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Charge.modify(
            "ch_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges/ch_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_charges_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/charges/ch_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.charges.update(
            "ch_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges/ch_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_charges_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Charge.modify_async(
            "ch_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges/ch_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_charges_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/charges/ch_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.charges.update_async(
            "ch_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/charges/ch_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_charges_search_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Charge.search(
            query="amount>999 AND metadata['order_id']:'6735'"
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges/search",
            query_string="query=amount%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    def test_charges_search_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/charges/search",
            "query=amount%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.charges.search(
            {
                "query": "amount>999 AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges/search",
            query_string="query=amount%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_charges_search_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Charge.search_async(
            query="amount>999 AND metadata['order_id']:'6735'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges/search",
            query_string="query=amount%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    @pytest.mark.anyio
    async def test_charges_search_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/charges/search",
            "query=amount%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.charges.search_async(
            {
                "query": "amount>999 AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/charges/search",
            query_string="query=amount%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    def test_checkout_sessions_expire_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.checkout.Session.expire("sess_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions/sess_xyz/expire",
            query_string="",
        )

    def test_checkout_sessions_expire_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/checkout/sessions/sess_xyz/expire",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.checkout.sessions.expire("sess_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions/sess_xyz/expire",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_expire_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.checkout.Session.expire_async("sess_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions/sess_xyz/expire",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_expire_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/checkout/sessions/sess_xyz/expire",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.checkout.sessions.expire_async("sess_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions/sess_xyz/expire",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_checkout_sessions_expire_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.checkout.Session.expire("cs_test_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx/expire",
            query_string="",
        )

    def test_checkout_sessions_expire_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx/expire",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.checkout.sessions.expire("cs_test_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx/expire",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_expire_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.checkout.Session.expire_async("cs_test_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx/expire",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_expire_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx/expire",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.checkout.sessions.expire_async("cs_test_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx/expire",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_checkout_sessions_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.checkout.Session.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions",
            query_string="limit=3",
        )

    def test_checkout_sessions_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/checkout/sessions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.checkout.sessions.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.checkout.Session.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/checkout/sessions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.checkout.sessions.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_checkout_sessions_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.checkout.Session.retrieve("cs_test_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_checkout_sessions_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.checkout.sessions.retrieve("cs_test_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.checkout.Session.retrieve_async("cs_test_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.checkout.sessions.retrieve_async("cs_test_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions/cs_test_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_checkout_sessions_line_items_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.checkout.Session.list_line_items("sess_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions/sess_xyz/line_items",
            query_string="",
        )

    def test_checkout_sessions_line_items_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/checkout/sessions/sess_xyz/line_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.checkout.sessions.line_items.list("sess_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions/sess_xyz/line_items",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_line_items_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.checkout.Session.list_line_items_async("sess_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions/sess_xyz/line_items",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_line_items_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/checkout/sessions/sess_xyz/line_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.checkout.sessions.line_items.list_async("sess_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/checkout/sessions/sess_xyz/line_items",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_checkout_sessions_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.checkout.Session.create(
            success_url="https://example.com/success",
            cancel_url="https://example.com/cancel",
            mode="payment",
            shipping_options=[
                {"shipping_rate": "shr_standard"},
                {
                    "shipping_rate_data": {
                        "display_name": "Standard",
                        "delivery_estimate": {
                            "minimum": {"unit": "day", "value": 5},
                            "maximum": {"unit": "day", "value": 7},
                        },
                    },
                },
            ],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions",
            query_string="",
            post_data="success_url=https%3A%2F%2Fexample.com%2Fsuccess&cancel_url=https%3A%2F%2Fexample.com%2Fcancel&mode=payment&shipping_options[0][shipping_rate]=shr_standard&shipping_options[1][shipping_rate_data][display_name]=Standard&shipping_options[1][shipping_rate_data][delivery_estimate][minimum][unit]=day&shipping_options[1][shipping_rate_data][delivery_estimate][minimum][value]=5&shipping_options[1][shipping_rate_data][delivery_estimate][maximum][unit]=day&shipping_options[1][shipping_rate_data][delivery_estimate][maximum][value]=7",
        )

    def test_checkout_sessions_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/checkout/sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.checkout.sessions.create(
            {
                "success_url": "https://example.com/success",
                "cancel_url": "https://example.com/cancel",
                "mode": "payment",
                "shipping_options": [
                    {"shipping_rate": "shr_standard"},
                    {
                        "shipping_rate_data": {
                            "display_name": "Standard",
                            "delivery_estimate": {
                                "minimum": {"unit": "day", "value": 5},
                                "maximum": {"unit": "day", "value": 7},
                            },
                        },
                    },
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="success_url=https%3A%2F%2Fexample.com%2Fsuccess&cancel_url=https%3A%2F%2Fexample.com%2Fcancel&mode=payment&shipping_options[0][shipping_rate]=shr_standard&shipping_options[1][shipping_rate_data][display_name]=Standard&shipping_options[1][shipping_rate_data][delivery_estimate][minimum][unit]=day&shipping_options[1][shipping_rate_data][delivery_estimate][minimum][value]=5&shipping_options[1][shipping_rate_data][delivery_estimate][maximum][unit]=day&shipping_options[1][shipping_rate_data][delivery_estimate][maximum][value]=7",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.checkout.Session.create_async(
            success_url="https://example.com/success",
            cancel_url="https://example.com/cancel",
            mode="payment",
            shipping_options=[
                {"shipping_rate": "shr_standard"},
                {
                    "shipping_rate_data": {
                        "display_name": "Standard",
                        "delivery_estimate": {
                            "minimum": {"unit": "day", "value": 5},
                            "maximum": {"unit": "day", "value": 7},
                        },
                    },
                },
            ],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions",
            query_string="",
            post_data="success_url=https%3A%2F%2Fexample.com%2Fsuccess&cancel_url=https%3A%2F%2Fexample.com%2Fcancel&mode=payment&shipping_options[0][shipping_rate]=shr_standard&shipping_options[1][shipping_rate_data][display_name]=Standard&shipping_options[1][shipping_rate_data][delivery_estimate][minimum][unit]=day&shipping_options[1][shipping_rate_data][delivery_estimate][minimum][value]=5&shipping_options[1][shipping_rate_data][delivery_estimate][maximum][unit]=day&shipping_options[1][shipping_rate_data][delivery_estimate][maximum][value]=7",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/checkout/sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.checkout.sessions.create_async(
            {
                "success_url": "https://example.com/success",
                "cancel_url": "https://example.com/cancel",
                "mode": "payment",
                "shipping_options": [
                    {"shipping_rate": "shr_standard"},
                    {
                        "shipping_rate_data": {
                            "display_name": "Standard",
                            "delivery_estimate": {
                                "minimum": {"unit": "day", "value": 5},
                                "maximum": {"unit": "day", "value": 7},
                            },
                        },
                    },
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="success_url=https%3A%2F%2Fexample.com%2Fsuccess&cancel_url=https%3A%2F%2Fexample.com%2Fcancel&mode=payment&shipping_options[0][shipping_rate]=shr_standard&shipping_options[1][shipping_rate_data][display_name]=Standard&shipping_options[1][shipping_rate_data][delivery_estimate][minimum][unit]=day&shipping_options[1][shipping_rate_data][delivery_estimate][minimum][value]=5&shipping_options[1][shipping_rate_data][delivery_estimate][maximum][unit]=day&shipping_options[1][shipping_rate_data][delivery_estimate][maximum][value]=7",
        )

    def test_checkout_sessions_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.checkout.Session.create(
            success_url="https://example.com/success",
            line_items=[{"price": "price_xxxxxxxxxxxxx", "quantity": 2}],
            mode="payment",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions",
            query_string="",
            post_data="success_url=https%3A%2F%2Fexample.com%2Fsuccess&line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=2&mode=payment",
        )

    def test_checkout_sessions_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/checkout/sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.checkout.sessions.create(
            {
                "success_url": "https://example.com/success",
                "line_items": [
                    {"price": "price_xxxxxxxxxxxxx", "quantity": 2}
                ],
                "mode": "payment",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="success_url=https%3A%2F%2Fexample.com%2Fsuccess&line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=2&mode=payment",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.checkout.Session.create_async(
            success_url="https://example.com/success",
            line_items=[{"price": "price_xxxxxxxxxxxxx", "quantity": 2}],
            mode="payment",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions",
            query_string="",
            post_data="success_url=https%3A%2F%2Fexample.com%2Fsuccess&line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=2&mode=payment",
        )

    @pytest.mark.anyio
    async def test_checkout_sessions_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/checkout/sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.checkout.sessions.create_async(
            {
                "success_url": "https://example.com/success",
                "line_items": [
                    {"price": "price_xxxxxxxxxxxxx", "quantity": 2}
                ],
                "mode": "payment",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/checkout/sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="success_url=https%3A%2F%2Fexample.com%2Fsuccess&line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=2&mode=payment",
        )

    def test_core_events_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v2/core/events/ll_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.v2.core.events.retrieve("ll_123")
        http_client_mock.assert_requested(
            "get",
            path="/v2/core/events/ll_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_country_specs_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.CountrySpec.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/country_specs",
            query_string="limit=3",
        )

    def test_country_specs_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/country_specs",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.country_specs.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/country_specs",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_country_specs_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.CountrySpec.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/country_specs",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_country_specs_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/country_specs",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.country_specs.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/country_specs",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_country_specs_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.CountrySpec.retrieve("US")
        http_client_mock.assert_requested(
            "get",
            path="/v1/country_specs/US",
            query_string="",
        )

    def test_country_specs_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/country_specs/US",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.country_specs.retrieve("US")
        http_client_mock.assert_requested(
            "get",
            path="/v1/country_specs/US",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_country_specs_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.CountrySpec.retrieve_async("US")
        http_client_mock.assert_requested(
            "get",
            path="/v1/country_specs/US",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_country_specs_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/country_specs/US",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.country_specs.retrieve_async("US")
        http_client_mock.assert_requested(
            "get",
            path="/v1/country_specs/US",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_coupons_delete(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Coupon.delete("Z4OV52SU")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
        )

    def test_coupons_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/coupons/Z4OV52SU",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.coupons.delete("Z4OV52SU")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_coupons_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Coupon.delete_async("Z4OV52SU")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_coupons_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/coupons/Z4OV52SU",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.coupons.delete_async("Z4OV52SU")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_coupons_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Coupon.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/coupons",
            query_string="limit=3",
        )

    def test_coupons_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/coupons",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.coupons.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/coupons",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_coupons_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Coupon.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/coupons",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_coupons_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/coupons",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.coupons.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/coupons",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_coupons_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Coupon.retrieve("Z4OV52SU")
        http_client_mock.assert_requested(
            "get",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
        )

    def test_coupons_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/coupons/Z4OV52SU",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.coupons.retrieve("Z4OV52SU")
        http_client_mock.assert_requested(
            "get",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_coupons_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Coupon.retrieve_async("Z4OV52SU")
        http_client_mock.assert_requested(
            "get",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_coupons_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/coupons/Z4OV52SU",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.coupons.retrieve_async("Z4OV52SU")
        http_client_mock.assert_requested(
            "get",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_coupons_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Coupon.create(
            percent_off=25.5,
            duration="repeating",
            duration_in_months=3,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/coupons",
            query_string="",
            post_data="percent_off=25.5&duration=repeating&duration_in_months=3",
        )

    def test_coupons_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/coupons",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.coupons.create(
            {
                "percent_off": 25.5,
                "duration": "repeating",
                "duration_in_months": 3,
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/coupons",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="percent_off=25.5&duration=repeating&duration_in_months=3",
        )

    @pytest.mark.anyio
    async def test_coupons_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Coupon.create_async(
            percent_off=25.5,
            duration="repeating",
            duration_in_months=3,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/coupons",
            query_string="",
            post_data="percent_off=25.5&duration=repeating&duration_in_months=3",
        )

    @pytest.mark.anyio
    async def test_coupons_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/coupons",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.coupons.create_async(
            {
                "percent_off": 25.5,
                "duration": "repeating",
                "duration_in_months": 3,
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/coupons",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="percent_off=25.5&duration=repeating&duration_in_months=3",
        )

    def test_coupons_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Coupon.modify(
            "Z4OV52SU",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_coupons_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/coupons/Z4OV52SU",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.coupons.update(
            "Z4OV52SU",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_coupons_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Coupon.modify_async(
            "Z4OV52SU",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_coupons_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/coupons/Z4OV52SU",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.coupons.update_async(
            "Z4OV52SU",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/coupons/Z4OV52SU",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_credit_notes_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.CreditNote.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes",
            query_string="limit=3",
        )

    def test_credit_notes_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/credit_notes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.credit_notes.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_credit_notes_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.CreditNote.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_credit_notes_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/credit_notes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.credit_notes.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_credit_notes_lines_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.CreditNote.list_lines(
            "cn_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/cn_xxxxxxxxxxxxx/lines",
            query_string="limit=3",
        )

    def test_credit_notes_lines_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/credit_notes/cn_xxxxxxxxxxxxx/lines",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.credit_notes.line_items.list(
            "cn_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/cn_xxxxxxxxxxxxx/lines",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_credit_notes_lines_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.CreditNote.list_lines_async(
            "cn_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/cn_xxxxxxxxxxxxx/lines",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_credit_notes_lines_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/credit_notes/cn_xxxxxxxxxxxxx/lines",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.credit_notes.line_items.list_async(
            "cn_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/cn_xxxxxxxxxxxxx/lines",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_credit_notes_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.CreditNote.create(
            invoice="in_xxxxxxxxxxxxx",
            lines=[
                {
                    "type": "invoice_line_item",
                    "invoice_line_item": "il_xxxxxxxxxxxxx",
                    "quantity": 1,
                },
            ],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/credit_notes",
            query_string="",
            post_data="invoice=in_xxxxxxxxxxxxx&lines[0][type]=invoice_line_item&lines[0][invoice_line_item]=il_xxxxxxxxxxxxx&lines[0][quantity]=1",
        )

    def test_credit_notes_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/credit_notes",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.credit_notes.create(
            {
                "invoice": "in_xxxxxxxxxxxxx",
                "lines": [
                    {
                        "type": "invoice_line_item",
                        "invoice_line_item": "il_xxxxxxxxxxxxx",
                        "quantity": 1,
                    },
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/credit_notes",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="invoice=in_xxxxxxxxxxxxx&lines[0][type]=invoice_line_item&lines[0][invoice_line_item]=il_xxxxxxxxxxxxx&lines[0][quantity]=1",
        )

    @pytest.mark.anyio
    async def test_credit_notes_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.CreditNote.create_async(
            invoice="in_xxxxxxxxxxxxx",
            lines=[
                {
                    "type": "invoice_line_item",
                    "invoice_line_item": "il_xxxxxxxxxxxxx",
                    "quantity": 1,
                },
            ],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/credit_notes",
            query_string="",
            post_data="invoice=in_xxxxxxxxxxxxx&lines[0][type]=invoice_line_item&lines[0][invoice_line_item]=il_xxxxxxxxxxxxx&lines[0][quantity]=1",
        )

    @pytest.mark.anyio
    async def test_credit_notes_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/credit_notes",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.credit_notes.create_async(
            {
                "invoice": "in_xxxxxxxxxxxxx",
                "lines": [
                    {
                        "type": "invoice_line_item",
                        "invoice_line_item": "il_xxxxxxxxxxxxx",
                        "quantity": 1,
                    },
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/credit_notes",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="invoice=in_xxxxxxxxxxxxx&lines[0][type]=invoice_line_item&lines[0][invoice_line_item]=il_xxxxxxxxxxxxx&lines[0][quantity]=1",
        )

    def test_credit_notes_preview_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.CreditNote.preview(
            invoice="in_xxxxxxxxxxxxx",
            lines=[
                {
                    "type": "invoice_line_item",
                    "invoice_line_item": "il_xxxxxxxxxxxxx",
                    "quantity": 1,
                },
            ],
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/preview",
            query_string="invoice=in_xxxxxxxxxxxxx&lines[0][type]=invoice_line_item&lines[0][invoice_line_item]=il_xxxxxxxxxxxxx&lines[0][quantity]=1",
        )

    def test_credit_notes_preview_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/credit_notes/preview",
            "invoice=in_xxxxxxxxxxxxx&lines[0][type]=invoice_line_item&lines[0][invoice_line_item]=il_xxxxxxxxxxxxx&lines[0][quantity]=1",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.credit_notes.preview(
            {
                "invoice": "in_xxxxxxxxxxxxx",
                "lines": [
                    {
                        "type": "invoice_line_item",
                        "invoice_line_item": "il_xxxxxxxxxxxxx",
                        "quantity": 1,
                    },
                ],
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/preview",
            query_string="invoice=in_xxxxxxxxxxxxx&lines[0][type]=invoice_line_item&lines[0][invoice_line_item]=il_xxxxxxxxxxxxx&lines[0][quantity]=1",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_credit_notes_preview_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.CreditNote.preview_async(
            invoice="in_xxxxxxxxxxxxx",
            lines=[
                {
                    "type": "invoice_line_item",
                    "invoice_line_item": "il_xxxxxxxxxxxxx",
                    "quantity": 1,
                },
            ],
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/preview",
            query_string="invoice=in_xxxxxxxxxxxxx&lines[0][type]=invoice_line_item&lines[0][invoice_line_item]=il_xxxxxxxxxxxxx&lines[0][quantity]=1",
        )

    @pytest.mark.anyio
    async def test_credit_notes_preview_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/credit_notes/preview",
            "invoice=in_xxxxxxxxxxxxx&lines[0][type]=invoice_line_item&lines[0][invoice_line_item]=il_xxxxxxxxxxxxx&lines[0][quantity]=1",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.credit_notes.preview_async(
            {
                "invoice": "in_xxxxxxxxxxxxx",
                "lines": [
                    {
                        "type": "invoice_line_item",
                        "invoice_line_item": "il_xxxxxxxxxxxxx",
                        "quantity": 1,
                    },
                ],
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/preview",
            query_string="invoice=in_xxxxxxxxxxxxx&lines[0][type]=invoice_line_item&lines[0][invoice_line_item]=il_xxxxxxxxxxxxx&lines[0][quantity]=1",
            api_base="https://api.stripe.com",
        )

    def test_credit_notes_preview_lines_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.CreditNote.preview_lines(
            limit=3,
            invoice="in_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/preview/lines",
            query_string="limit=3&invoice=in_xxxxxxxxxxxxx",
        )

    def test_credit_notes_preview_lines_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/credit_notes/preview/lines",
            "limit=3&invoice=in_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.credit_notes.preview_lines.list(
            {
                "limit": 3,
                "invoice": "in_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/preview/lines",
            query_string="limit=3&invoice=in_xxxxxxxxxxxxx",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_credit_notes_preview_lines_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.CreditNote.preview_lines_async(
            limit=3,
            invoice="in_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/preview/lines",
            query_string="limit=3&invoice=in_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_credit_notes_preview_lines_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/credit_notes/preview/lines",
            "limit=3&invoice=in_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.credit_notes.preview_lines.list_async(
            {
                "limit": 3,
                "invoice": "in_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/credit_notes/preview/lines",
            query_string="limit=3&invoice=in_xxxxxxxxxxxxx",
            api_base="https://api.stripe.com",
        )

    def test_credit_notes_void_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.CreditNote.void_credit_note("cn_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/credit_notes/cn_xxxxxxxxxxxxx/void",
            query_string="",
        )

    def test_credit_notes_void_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/credit_notes/cn_xxxxxxxxxxxxx/void",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.credit_notes.void_credit_note("cn_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/credit_notes/cn_xxxxxxxxxxxxx/void",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_credit_notes_void_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.CreditNote.void_credit_note_async("cn_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/credit_notes/cn_xxxxxxxxxxxxx/void",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_credit_notes_void_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/credit_notes/cn_xxxxxxxxxxxxx/void",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.credit_notes.void_credit_note_async("cn_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/credit_notes/cn_xxxxxxxxxxxxx/void",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customer_sessions_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.CustomerSession.create(
            customer="cus_123",
            components={"buy_button": {"enabled": True}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customer_sessions",
            query_string="",
            post_data="customer=cus_123&components[buy_button][enabled]=True",
        )

    def test_customer_sessions_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customer_sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customer_sessions.create(
            {
                "customer": "cus_123",
                "components": {"buy_button": {"enabled": True}},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customer_sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_123&components[buy_button][enabled]=True",
        )

    @pytest.mark.anyio
    async def test_customer_sessions_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.CustomerSession.create_async(
            customer="cus_123",
            components={"buy_button": {"enabled": True}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customer_sessions",
            query_string="",
            post_data="customer=cus_123&components[buy_button][enabled]=True",
        )

    @pytest.mark.anyio
    async def test_customer_sessions_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customer_sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customer_sessions.create_async(
            {
                "customer": "cus_123",
                "components": {"buy_button": {"enabled": True}},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customer_sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_123&components[buy_button][enabled]=True",
        )

    def test_customers_balance_transactions_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.list_balance_transactions(
            "cus_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
            query_string="limit=3",
        )

    def test_customers_balance_transactions_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.balance_transactions.list(
            "cus_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_balance_transactions_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.list_balance_transactions_async(
            "cus_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_customers_balance_transactions_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.balance_transactions.list_async(
            "cus_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_customers_balance_transactions_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.retrieve_balance_transaction(
            "cus_xxxxxxxxxxxxx",
            "cbtxn_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_customers_balance_transactions_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.balance_transactions.retrieve(
            "cus_xxxxxxxxxxxxx",
            "cbtxn_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_balance_transactions_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.retrieve_balance_transaction_async(
            "cus_xxxxxxxxxxxxx",
            "cbtxn_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_customers_balance_transactions_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.balance_transactions.retrieve_async(
            "cus_xxxxxxxxxxxxx",
            "cbtxn_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customers_balance_transactions_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.create_balance_transaction(
            "cus_xxxxxxxxxxxxx",
            amount=-500,
            currency="usd",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
            query_string="",
            post_data="amount=-500&currency=usd",
        )

    def test_customers_balance_transactions_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.balance_transactions.create(
            "cus_xxxxxxxxxxxxx",
            {"amount": -500, "currency": "usd"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=-500&currency=usd",
        )

    @pytest.mark.anyio
    async def test_customers_balance_transactions_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.create_balance_transaction_async(
            "cus_xxxxxxxxxxxxx",
            amount=-500,
            currency="usd",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
            query_string="",
            post_data="amount=-500&currency=usd",
        )

    @pytest.mark.anyio
    async def test_customers_balance_transactions_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.balance_transactions.create_async(
            "cus_xxxxxxxxxxxxx",
            {"amount": -500, "currency": "usd"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=-500&currency=usd",
        )

    def test_customers_balance_transactions_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.modify_balance_transaction(
            "cus_xxxxxxxxxxxxx",
            "cbtxn_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_customers_balance_transactions_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.balance_transactions.update(
            "cus_xxxxxxxxxxxxx",
            "cbtxn_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_customers_balance_transactions_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.modify_balance_transaction_async(
            "cus_xxxxxxxxxxxxx",
            "cbtxn_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_customers_balance_transactions_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.balance_transactions.update_async(
            "cus_xxxxxxxxxxxxx",
            "cbtxn_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/balance_transactions/cbtxn_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_customers_cash_balance_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.retrieve_cash_balance("cus_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_123/cash_balance",
            query_string="",
        )

    def test_customers_cash_balance_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_123/cash_balance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.cash_balance.retrieve("cus_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_123/cash_balance",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_cash_balance_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.retrieve_cash_balance_async("cus_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_123/cash_balance",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_customers_cash_balance_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_123/cash_balance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.cash_balance.retrieve_async("cus_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_123/cash_balance",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customers_cash_balance_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.modify_cash_balance(
            "cus_123",
            settings={"reconciliation_mode": "manual"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/cash_balance",
            query_string="",
            post_data="settings[reconciliation_mode]=manual",
        )

    def test_customers_cash_balance_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_123/cash_balance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.cash_balance.update(
            "cus_123",
            {"settings": {"reconciliation_mode": "manual"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/cash_balance",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="settings[reconciliation_mode]=manual",
        )

    @pytest.mark.anyio
    async def test_customers_cash_balance_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.modify_cash_balance_async(
            "cus_123",
            settings={"reconciliation_mode": "manual"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/cash_balance",
            query_string="",
            post_data="settings[reconciliation_mode]=manual",
        )

    @pytest.mark.anyio
    async def test_customers_cash_balance_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_123/cash_balance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.cash_balance.update_async(
            "cus_123",
            {"settings": {"reconciliation_mode": "manual"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/cash_balance",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="settings[reconciliation_mode]=manual",
        )

    def test_customers_cash_balance_transactions_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.list_cash_balance_transactions(
            "cus_123",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_123/cash_balance_transactions",
            query_string="limit=3",
        )

    def test_customers_cash_balance_transactions_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_123/cash_balance_transactions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.cash_balance_transactions.list(
            "cus_123",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_123/cash_balance_transactions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_cash_balance_transactions_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.list_cash_balance_transactions_async(
            "cus_123",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_123/cash_balance_transactions",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_customers_cash_balance_transactions_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_123/cash_balance_transactions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.cash_balance_transactions.list_async(
            "cus_123",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_123/cash_balance_transactions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_customers_delete(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Customer.delete("cus_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_customers_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/customers/cus_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.delete("cus_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.delete_async("cus_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_customers_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/customers/cus_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.delete_async("cus_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customers_funding_instructions_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.create_funding_instructions(
            "cus_123",
            bank_transfer={
                "requested_address_types": ["zengin"],
                "type": "jp_bank_transfer",
            },
            currency="usd",
            funding_type="bank_transfer",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/funding_instructions",
            query_string="",
            post_data="bank_transfer[requested_address_types][0]=zengin&bank_transfer[type]=jp_bank_transfer&currency=usd&funding_type=bank_transfer",
        )

    def test_customers_funding_instructions_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_123/funding_instructions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.funding_instructions.create(
            "cus_123",
            {
                "bank_transfer": {
                    "requested_address_types": ["zengin"],
                    "type": "jp_bank_transfer",
                },
                "currency": "usd",
                "funding_type": "bank_transfer",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/funding_instructions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="bank_transfer[requested_address_types][0]=zengin&bank_transfer[type]=jp_bank_transfer&currency=usd&funding_type=bank_transfer",
        )

    @pytest.mark.anyio
    async def test_customers_funding_instructions_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.create_funding_instructions_async(
            "cus_123",
            bank_transfer={
                "requested_address_types": ["zengin"],
                "type": "jp_bank_transfer",
            },
            currency="usd",
            funding_type="bank_transfer",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/funding_instructions",
            query_string="",
            post_data="bank_transfer[requested_address_types][0]=zengin&bank_transfer[type]=jp_bank_transfer&currency=usd&funding_type=bank_transfer",
        )

    @pytest.mark.anyio
    async def test_customers_funding_instructions_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_123/funding_instructions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.funding_instructions.create_async(
            "cus_123",
            {
                "bank_transfer": {
                    "requested_address_types": ["zengin"],
                    "type": "jp_bank_transfer",
                },
                "currency": "usd",
                "funding_type": "bank_transfer",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/funding_instructions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="bank_transfer[requested_address_types][0]=zengin&bank_transfer[type]=jp_bank_transfer&currency=usd&funding_type=bank_transfer",
        )

    def test_customers_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Customer.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers",
            query_string="limit=3",
        )

    def test_customers_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_customers_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_customers_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Customer.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers",
            query_string="limit=3",
        )

    def test_customers_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_customers_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_customers_get_3(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Customer.retrieve("cus_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_customers_get_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.retrieve("cus_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_get_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.retrieve_async("cus_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_customers_get_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.retrieve_async("cus_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customers_payment_methods_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.list_payment_methods(
            "cus_xyz",
            type="card",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xyz/payment_methods",
            query_string="type=card",
        )

    def test_customers_payment_methods_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xyz/payment_methods",
            "type=card",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_methods.list(
            "cus_xyz",
            {"type": "card"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xyz/payment_methods",
            query_string="type=card",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_payment_methods_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.list_payment_methods_async(
            "cus_xyz",
            type="card",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xyz/payment_methods",
            query_string="type=card",
        )

    @pytest.mark.anyio
    async def test_customers_payment_methods_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xyz/payment_methods",
            "type=card",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_methods.list_async(
            "cus_xyz",
            {"type": "card"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xyz/payment_methods",
            query_string="type=card",
            api_base="https://api.stripe.com",
        )

    def test_customers_payment_methods_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.list_payment_methods(
            "cus_xxxxxxxxxxxxx",
            type="card",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/payment_methods",
            query_string="type=card",
        )

    def test_customers_payment_methods_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/payment_methods",
            "type=card",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_methods.list(
            "cus_xxxxxxxxxxxxx",
            {"type": "card"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/payment_methods",
            query_string="type=card",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_payment_methods_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.list_payment_methods_async(
            "cus_xxxxxxxxxxxxx",
            type="card",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/payment_methods",
            query_string="type=card",
        )

    @pytest.mark.anyio
    async def test_customers_payment_methods_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/payment_methods",
            "type=card",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_methods.list_async(
            "cus_xxxxxxxxxxxxx",
            {"type": "card"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/payment_methods",
            query_string="type=card",
            api_base="https://api.stripe.com",
        )

    def test_customers_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Customer.create(
            description="My First Test Customer (created for API docs at https://www.stripe.com/docs/api)",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers",
            query_string="",
            post_data="description=My%20First%20Test%20Customer%20%28created%20for%20API%20docs%20at%20https%3A%2F%2Fwww.stripe.com%2Fdocs%2Fapi%29",
        )

    def test_customers_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.create(
            {
                "description": "My First Test Customer (created for API docs at https://www.stripe.com/docs/api)",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="description=My%20First%20Test%20Customer%20%28created%20for%20API%20docs%20at%20https%3A%2F%2Fwww.stripe.com%2Fdocs%2Fapi%29",
        )

    @pytest.mark.anyio
    async def test_customers_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.create_async(
            description="My First Test Customer (created for API docs at https://www.stripe.com/docs/api)",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers",
            query_string="",
            post_data="description=My%20First%20Test%20Customer%20%28created%20for%20API%20docs%20at%20https%3A%2F%2Fwww.stripe.com%2Fdocs%2Fapi%29",
        )

    @pytest.mark.anyio
    async def test_customers_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.create_async(
            {
                "description": "My First Test Customer (created for API docs at https://www.stripe.com/docs/api)",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="description=My%20First%20Test%20Customer%20%28created%20for%20API%20docs%20at%20https%3A%2F%2Fwww.stripe.com%2Fdocs%2Fapi%29",
        )

    def test_customers_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Customer.modify(
            "cus_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_customers_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.update(
            "cus_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_customers_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.modify_async(
            "cus_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_customers_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.update_async(
            "cus_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_customers_search_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.search(
            query="name:'fakename' AND metadata['foo']:'bar'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/search",
            query_string="query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
        )

    def test_customers_search_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/search",
            "query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.search(
            {
                "query": "name:'fakename' AND metadata['foo']:'bar'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/search",
            query_string="query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_search_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.search_async(
            query="name:'fakename' AND metadata['foo']:'bar'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/search",
            query_string="query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
        )

    @pytest.mark.anyio
    async def test_customers_search_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/search",
            "query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.search_async(
            {
                "query": "name:'fakename' AND metadata['foo']:'bar'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/search",
            query_string="query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
            api_base="https://api.stripe.com",
        )

    def test_customers_search_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.search(
            query="name:'fakename' AND metadata['foo']:'bar'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/search",
            query_string="query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
        )

    def test_customers_search_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/search",
            "query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.search(
            {
                "query": "name:'fakename' AND metadata['foo']:'bar'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/search",
            query_string="query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_search_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.search_async(
            query="name:'fakename' AND metadata['foo']:'bar'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/search",
            query_string="query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
        )

    @pytest.mark.anyio
    async def test_customers_search_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/search",
            "query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.search_async(
            {
                "query": "name:'fakename' AND metadata['foo']:'bar'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/search",
            query_string="query=name%3A%27fakename%27%20AND%20metadata%5B%27foo%27%5D%3A%27bar%27",
            api_base="https://api.stripe.com",
        )

    def test_customers_sources_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.delete_source(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_customers_sources_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.sources.detach(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_sources_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.delete_source_async(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_customers_sources_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.sources.detach_async(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customers_sources_delete_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.delete_source(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_customers_sources_delete_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.sources.detach(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_sources_delete_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.delete_source_async(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_customers_sources_delete_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.sources.detach_async(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customers_sources_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.list_sources(
            "cus_xxxxxxxxxxxxx",
            object="bank_account",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="object=bank_account&limit=3",
        )

    def test_customers_sources_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources",
            "object=bank_account&limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_sources.list(
            "cus_xxxxxxxxxxxxx",
            {"object": "bank_account", "limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="object=bank_account&limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_sources_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.list_sources_async(
            "cus_xxxxxxxxxxxxx",
            object="bank_account",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="object=bank_account&limit=3",
        )

    @pytest.mark.anyio
    async def test_customers_sources_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources",
            "object=bank_account&limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_sources.list_async(
            "cus_xxxxxxxxxxxxx",
            {"object": "bank_account", "limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="object=bank_account&limit=3",
            api_base="https://api.stripe.com",
        )

    def test_customers_sources_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.list_sources(
            "cus_xxxxxxxxxxxxx",
            object="card",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="object=card&limit=3",
        )

    def test_customers_sources_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources",
            "object=card&limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_sources.list(
            "cus_xxxxxxxxxxxxx",
            {"object": "card", "limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="object=card&limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_sources_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.list_sources_async(
            "cus_xxxxxxxxxxxxx",
            object="card",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="object=card&limit=3",
        )

    @pytest.mark.anyio
    async def test_customers_sources_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources",
            "object=card&limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_sources.list_async(
            "cus_xxxxxxxxxxxxx",
            {"object": "card", "limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="object=card&limit=3",
            api_base="https://api.stripe.com",
        )

    def test_customers_sources_get_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.retrieve_source(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_customers_sources_get_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_sources.retrieve(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_sources_get_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.retrieve_source_async(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_customers_sources_get_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_sources.retrieve_async(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customers_sources_get_4(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.retrieve_source(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_customers_sources_get_4_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_sources.retrieve(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_sources_get_4_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.retrieve_source_async(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_customers_sources_get_4_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_sources.retrieve_async(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customers_sources_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.modify_source(
            "cus_123",
            "card_123",
            account_holder_name="Kamil",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/sources/card_123",
            query_string="",
            post_data="account_holder_name=Kamil",
        )

    def test_customers_sources_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_123/sources/card_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_sources.update(
            "cus_123",
            "card_123",
            {"account_holder_name": "Kamil"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/sources/card_123",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="account_holder_name=Kamil",
        )

    @pytest.mark.anyio
    async def test_customers_sources_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.modify_source_async(
            "cus_123",
            "card_123",
            account_holder_name="Kamil",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/sources/card_123",
            query_string="",
            post_data="account_holder_name=Kamil",
        )

    @pytest.mark.anyio
    async def test_customers_sources_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_123/sources/card_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_sources.update_async(
            "cus_123",
            "card_123",
            {"account_holder_name": "Kamil"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_123/sources/card_123",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="account_holder_name=Kamil",
        )

    def test_customers_sources_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.create_source(
            "cus_xxxxxxxxxxxxx",
            source="btok_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="",
            post_data="source=btok_xxxxxxxxxxxxx",
        )

    def test_customers_sources_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_sources.create(
            "cus_xxxxxxxxxxxxx",
            {"source": "btok_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="source=btok_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_customers_sources_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.create_source_async(
            "cus_xxxxxxxxxxxxx",
            source="btok_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="",
            post_data="source=btok_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_customers_sources_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_sources.create_async(
            "cus_xxxxxxxxxxxxx",
            {"source": "btok_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="source=btok_xxxxxxxxxxxxx",
        )

    def test_customers_sources_post_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.create_source(
            "cus_xxxxxxxxxxxxx",
            source="tok_xxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="",
            post_data="source=tok_xxxx",
        )

    def test_customers_sources_post_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_sources.create(
            "cus_xxxxxxxxxxxxx",
            {"source": "tok_xxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="source=tok_xxxx",
        )

    @pytest.mark.anyio
    async def test_customers_sources_post_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.create_source_async(
            "cus_xxxxxxxxxxxxx",
            source="tok_xxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="",
            post_data="source=tok_xxxx",
        )

    @pytest.mark.anyio
    async def test_customers_sources_post_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_sources.create_async(
            "cus_xxxxxxxxxxxxx",
            {"source": "tok_xxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="source=tok_xxxx",
        )

    def test_customers_sources_post_4(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.modify_source(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_customers_sources_post_4_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_sources.update(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_customers_sources_post_4_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.modify_source_async(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_customers_sources_post_4_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_sources.update_async(
            "cus_xxxxxxxxxxxxx",
            "ba_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/ba_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_customers_sources_post_5(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.modify_source(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
            name="Jenny Rosen",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
            post_data="name=Jenny%20Rosen",
        )

    def test_customers_sources_post_5_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.payment_sources.update(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
            {"name": "Jenny Rosen"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=Jenny%20Rosen",
        )

    @pytest.mark.anyio
    async def test_customers_sources_post_5_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.modify_source_async(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
            name="Jenny Rosen",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
            post_data="name=Jenny%20Rosen",
        )

    @pytest.mark.anyio
    async def test_customers_sources_post_5_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.payment_sources.update_async(
            "cus_xxxxxxxxxxxxx",
            "card_xxxxxxxxxxxxx",
            {"name": "Jenny Rosen"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/sources/card_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=Jenny%20Rosen",
        )

    def test_customers_tax_ids_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.delete_tax_id(
            "cus_xxxxxxxxxxxxx",
            "txi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_customers_tax_ids_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.tax_ids.delete(
            "cus_xxxxxxxxxxxxx",
            "txi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_tax_ids_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.delete_tax_id_async(
            "cus_xxxxxxxxxxxxx",
            "txi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_customers_tax_ids_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.tax_ids.delete_async(
            "cus_xxxxxxxxxxxxx",
            "txi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customers_tax_ids_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.list_tax_ids(
            "cus_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
            query_string="limit=3",
        )

    def test_customers_tax_ids_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.tax_ids.list(
            "cus_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_tax_ids_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.list_tax_ids_async(
            "cus_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_customers_tax_ids_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.tax_ids.list_async(
            "cus_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_customers_tax_ids_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.retrieve_tax_id(
            "cus_xxxxxxxxxxxxx",
            "txi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_customers_tax_ids_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.tax_ids.retrieve(
            "cus_xxxxxxxxxxxxx",
            "txi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_customers_tax_ids_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.retrieve_tax_id_async(
            "cus_xxxxxxxxxxxxx",
            "txi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_customers_tax_ids_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.tax_ids.retrieve_async(
            "cus_xxxxxxxxxxxxx",
            "txi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids/txi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_customers_tax_ids_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.create_tax_id(
            "cus_xxxxxxxxxxxxx",
            type="eu_vat",
            value="DE123456789",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
            query_string="",
            post_data="type=eu_vat&value=DE123456789",
        )

    def test_customers_tax_ids_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.customers.tax_ids.create(
            "cus_xxxxxxxxxxxxx",
            {"type": "eu_vat", "value": "DE123456789"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=eu_vat&value=DE123456789",
        )

    @pytest.mark.anyio
    async def test_customers_tax_ids_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.create_tax_id_async(
            "cus_xxxxxxxxxxxxx",
            type="eu_vat",
            value="DE123456789",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
            query_string="",
            post_data="type=eu_vat&value=DE123456789",
        )

    @pytest.mark.anyio
    async def test_customers_tax_ids_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.customers.tax_ids.create_async(
            "cus_xxxxxxxxxxxxx",
            {"type": "eu_vat", "value": "DE123456789"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/customers/cus_xxxxxxxxxxxxx/tax_ids",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=eu_vat&value=DE123456789",
        )

    def test_disputes_close_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Dispute.close("dp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/disputes/dp_xxxxxxxxxxxxx/close",
            query_string="",
        )

    def test_disputes_close_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/disputes/dp_xxxxxxxxxxxxx/close",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.disputes.close("dp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/disputes/dp_xxxxxxxxxxxxx/close",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_disputes_close_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Dispute.close_async("dp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/disputes/dp_xxxxxxxxxxxxx/close",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_disputes_close_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/disputes/dp_xxxxxxxxxxxxx/close",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.disputes.close_async("dp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/disputes/dp_xxxxxxxxxxxxx/close",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_disputes_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Dispute.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/disputes",
            query_string="limit=3",
        )

    def test_disputes_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/disputes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.disputes.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/disputes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_disputes_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Dispute.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/disputes",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_disputes_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/disputes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.disputes.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/disputes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_disputes_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Dispute.retrieve("dp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/disputes/dp_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_disputes_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/disputes/dp_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.disputes.retrieve("dp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/disputes/dp_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_disputes_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Dispute.retrieve_async("dp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/disputes/dp_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_disputes_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/disputes/dp_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.disputes.retrieve_async("dp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/disputes/dp_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_disputes_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Dispute.modify(
            "dp_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/disputes/dp_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_disputes_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/disputes/dp_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.disputes.update(
            "dp_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/disputes/dp_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_disputes_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Dispute.modify_async(
            "dp_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/disputes/dp_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_disputes_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/disputes/dp_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.disputes.update_async(
            "dp_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/disputes/dp_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_events_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Event.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/events",
            query_string="limit=3",
        )

    def test_events_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/events",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.events.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/events",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_events_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Event.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/events",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_events_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/events",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.events.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/events",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_events_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Event.retrieve("evt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/events/evt_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_events_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/events/evt_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.events.retrieve("evt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/events/evt_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_events_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Event.retrieve_async("evt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/events/evt_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_events_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/events/evt_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.events.retrieve_async("evt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/events/evt_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_file_links_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.FileLink.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/file_links",
            query_string="limit=3",
        )

    def test_file_links_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/file_links",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.file_links.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/file_links",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_file_links_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.FileLink.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/file_links",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_file_links_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/file_links",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.file_links.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/file_links",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_file_links_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.FileLink.retrieve("link_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/file_links/link_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_file_links_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/file_links/link_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.file_links.retrieve("link_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/file_links/link_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_file_links_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.FileLink.retrieve_async("link_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/file_links/link_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_file_links_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/file_links/link_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.file_links.retrieve_async("link_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/file_links/link_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_file_links_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.FileLink.create(file="file_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/file_links",
            query_string="",
            post_data="file=file_xxxxxxxxxxxxx",
        )

    def test_file_links_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/file_links",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.file_links.create({"file": "file_xxxxxxxxxxxxx"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/file_links",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="file=file_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_file_links_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.FileLink.create_async(file="file_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/file_links",
            query_string="",
            post_data="file=file_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_file_links_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/file_links",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.file_links.create_async({"file": "file_xxxxxxxxxxxxx"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/file_links",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="file=file_xxxxxxxxxxxxx",
        )

    def test_file_links_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.FileLink.modify(
            "link_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/file_links/link_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_file_links_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/file_links/link_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.file_links.update(
            "link_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/file_links/link_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_file_links_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.FileLink.modify_async(
            "link_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/file_links/link_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_file_links_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/file_links/link_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.file_links.update_async(
            "link_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/file_links/link_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_files_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.File.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/files",
            query_string="limit=3",
        )

    def test_files_get_service(self, http_client_mock: HTTPClientMock) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/files",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.files.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/files",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_files_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.File.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/files",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_files_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/files",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.files.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/files",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_files_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.File.retrieve("file_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/files/file_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_files_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/files/file_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.files.retrieve("file_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/files/file_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_files_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.File.retrieve_async("file_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/files/file_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_files_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/files/file_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.files.retrieve_async("file_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/files/file_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_files_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.File.create(
            purpose="account_requirement",
            file=io.StringIO("foo"),
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/files",
            query_string="",
        )

    def test_files_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/files",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.files.create(
            {
                "purpose": "account_requirement",
                "file": io.StringIO("foo"),
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/files",
            query_string="",
            api_base="https://files.stripe.com",
        )

    @pytest.mark.anyio
    async def test_files_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.File.create_async(
            purpose="account_requirement",
            file=io.StringIO("foo"),
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/files",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_files_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/files",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.files.create_async(
            {
                "purpose": "account_requirement",
                "file": io.StringIO("foo"),
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/files",
            query_string="",
            api_base="https://files.stripe.com",
        )

    def test_financial_connections_accounts_disconnect_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.disconnect("fca_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xyz/disconnect",
            query_string="",
        )

    def test_financial_connections_accounts_disconnect_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/accounts/fca_xyz/disconnect",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.disconnect("fca_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xyz/disconnect",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_disconnect_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.disconnect_async("fca_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xyz/disconnect",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_disconnect_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/accounts/fca_xyz/disconnect",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.disconnect_async("fca_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xyz/disconnect",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_accounts_disconnect_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.disconnect("fca_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/disconnect",
            query_string="",
        )

    def test_financial_connections_accounts_disconnect_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/disconnect",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.disconnect("fca_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/disconnect",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_disconnect_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.disconnect_async(
            "fca_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/disconnect",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_disconnect_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/disconnect",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.disconnect_async(
            "fca_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/disconnect",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_accounts_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts",
            query_string="",
        )

    def test_financial_connections_accounts_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_accounts_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.retrieve("fca_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xyz",
            query_string="",
        )

    def test_financial_connections_accounts_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts/fca_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.retrieve("fca_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.retrieve_async("fca_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xyz",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts/fca_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.retrieve_async("fca_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_accounts_get_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.list(
            account_holder={"customer": "cus_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts",
            query_string="account_holder[customer]=cus_xxxxxxxxxxxxx",
        )

    def test_financial_connections_accounts_get_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts",
            "account_holder[customer]=cus_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.list(
            {
                "account_holder": {"customer": "cus_xxxxxxxxxxxxx"},
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts",
            query_string="account_holder[customer]=cus_xxxxxxxxxxxxx",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_get_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.list_async(
            account_holder={"customer": "cus_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts",
            query_string="account_holder[customer]=cus_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_get_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts",
            "account_holder[customer]=cus_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.list_async(
            {
                "account_holder": {"customer": "cus_xxxxxxxxxxxxx"},
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts",
            query_string="account_holder[customer]=cus_xxxxxxxxxxxxx",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_accounts_get_4(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.retrieve("fca_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_financial_connections_accounts_get_4_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.retrieve("fca_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_get_4_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.retrieve_async(
            "fca_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_get_4_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.retrieve_async(
            "fca_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_accounts_owners_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.list_owners(
            "fca_xyz",
            ownership="fcaowns_xyz",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xyz/owners",
            query_string="ownership=fcaowns_xyz",
        )

    def test_financial_connections_accounts_owners_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts/fca_xyz/owners",
            "ownership=fcaowns_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.owners.list(
            "fca_xyz",
            {"ownership": "fcaowns_xyz"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xyz/owners",
            query_string="ownership=fcaowns_xyz",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_owners_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.list_owners_async(
            "fca_xyz",
            ownership="fcaowns_xyz",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xyz/owners",
            query_string="ownership=fcaowns_xyz",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_owners_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts/fca_xyz/owners",
            "ownership=fcaowns_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.owners.list_async(
            "fca_xyz",
            {"ownership": "fcaowns_xyz"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xyz/owners",
            query_string="ownership=fcaowns_xyz",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_accounts_owners_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.list_owners(
            "fca_xxxxxxxxxxxxx",
            limit=3,
            ownership="fcaowns_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/owners",
            query_string="limit=3&ownership=fcaowns_xxxxxxxxxxxxx",
        )

    def test_financial_connections_accounts_owners_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/owners",
            "limit=3&ownership=fcaowns_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.owners.list(
            "fca_xxxxxxxxxxxxx",
            {"limit": 3, "ownership": "fcaowns_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/owners",
            query_string="limit=3&ownership=fcaowns_xxxxxxxxxxxxx",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_owners_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.list_owners_async(
            "fca_xxxxxxxxxxxxx",
            limit=3,
            ownership="fcaowns_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/owners",
            query_string="limit=3&ownership=fcaowns_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_owners_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/owners",
            "limit=3&ownership=fcaowns_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.owners.list_async(
            "fca_xxxxxxxxxxxxx",
            {"limit": 3, "ownership": "fcaowns_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/accounts/fca_xxxxxxxxxxxxx/owners",
            query_string="limit=3&ownership=fcaowns_xxxxxxxxxxxxx",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_accounts_refresh_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.refresh_account(
            "fca_xyz",
            features=["balance"],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xyz/refresh",
            query_string="",
            post_data="features[0]=balance",
        )

    def test_financial_connections_accounts_refresh_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/accounts/fca_xyz/refresh",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.refresh(
            "fca_xyz",
            {"features": ["balance"]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xyz/refresh",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="features[0]=balance",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_refresh_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.refresh_account_async(
            "fca_xyz",
            features=["balance"],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xyz/refresh",
            query_string="",
            post_data="features[0]=balance",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_refresh_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/accounts/fca_xyz/refresh",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.refresh_async(
            "fca_xyz",
            {"features": ["balance"]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fca_xyz/refresh",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="features[0]=balance",
        )

    def test_financial_connections_accounts_subscribe_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.subscribe(
            "fa_123",
            features=["transactions"],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fa_123/subscribe",
            query_string="",
            post_data="features[0]=transactions",
        )

    def test_financial_connections_accounts_subscribe_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/accounts/fa_123/subscribe",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.subscribe(
            "fa_123",
            {"features": ["transactions"]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fa_123/subscribe",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="features[0]=transactions",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_subscribe_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.subscribe_async(
            "fa_123",
            features=["transactions"],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fa_123/subscribe",
            query_string="",
            post_data="features[0]=transactions",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_subscribe_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/accounts/fa_123/subscribe",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.subscribe_async(
            "fa_123",
            {"features": ["transactions"]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fa_123/subscribe",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="features[0]=transactions",
        )

    def test_financial_connections_accounts_unsubscribe_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Account.unsubscribe(
            "fa_123",
            features=["transactions"],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fa_123/unsubscribe",
            query_string="",
            post_data="features[0]=transactions",
        )

    def test_financial_connections_accounts_unsubscribe_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/accounts/fa_123/unsubscribe",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.accounts.unsubscribe(
            "fa_123",
            {"features": ["transactions"]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fa_123/unsubscribe",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="features[0]=transactions",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_unsubscribe_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Account.unsubscribe_async(
            "fa_123",
            features=["transactions"],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fa_123/unsubscribe",
            query_string="",
            post_data="features[0]=transactions",
        )

    @pytest.mark.anyio
    async def test_financial_connections_accounts_unsubscribe_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/accounts/fa_123/unsubscribe",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.accounts.unsubscribe_async(
            "fa_123",
            {"features": ["transactions"]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/accounts/fa_123/unsubscribe",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="features[0]=transactions",
        )

    def test_financial_connections_sessions_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Session.retrieve("fcsess_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/sessions/fcsess_xyz",
            query_string="",
        )

    def test_financial_connections_sessions_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/sessions/fcsess_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.sessions.retrieve("fcsess_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/sessions/fcsess_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_sessions_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Session.retrieve_async("fcsess_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/sessions/fcsess_xyz",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_financial_connections_sessions_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/sessions/fcsess_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.sessions.retrieve_async(
            "fcsess_xyz"
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/sessions/fcsess_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_sessions_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Session.retrieve("fcsess_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/sessions/fcsess_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_financial_connections_sessions_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/sessions/fcsess_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.sessions.retrieve("fcsess_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/sessions/fcsess_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_sessions_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Session.retrieve_async(
            "fcsess_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/sessions/fcsess_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_financial_connections_sessions_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/sessions/fcsess_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.sessions.retrieve_async(
            "fcsess_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/sessions/fcsess_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_sessions_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Session.create(
            account_holder={"type": "customer", "customer": "cus_123"},
            permissions=["balances"],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/sessions",
            query_string="",
            post_data="account_holder[type]=customer&account_holder[customer]=cus_123&permissions[0]=balances",
        )

    def test_financial_connections_sessions_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.sessions.create(
            {
                "account_holder": {"type": "customer", "customer": "cus_123"},
                "permissions": ["balances"],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="account_holder[type]=customer&account_holder[customer]=cus_123&permissions[0]=balances",
        )

    @pytest.mark.anyio
    async def test_financial_connections_sessions_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Session.create_async(
            account_holder={"type": "customer", "customer": "cus_123"},
            permissions=["balances"],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/sessions",
            query_string="",
            post_data="account_holder[type]=customer&account_holder[customer]=cus_123&permissions[0]=balances",
        )

    @pytest.mark.anyio
    async def test_financial_connections_sessions_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.sessions.create_async(
            {
                "account_holder": {"type": "customer", "customer": "cus_123"},
                "permissions": ["balances"],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="account_holder[type]=customer&account_holder[customer]=cus_123&permissions[0]=balances",
        )

    def test_financial_connections_sessions_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Session.create(
            account_holder={
                "type": "customer",
                "customer": "cus_xxxxxxxxxxxxx",
            },
            permissions=["payment_method", "balances"],
            filters={"countries": ["US"]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/sessions",
            query_string="",
            post_data="account_holder[type]=customer&account_holder[customer]=cus_xxxxxxxxxxxxx&permissions[0]=payment_method&permissions[1]=balances&filters[countries][0]=US",
        )

    def test_financial_connections_sessions_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.sessions.create(
            {
                "account_holder": {
                    "type": "customer",
                    "customer": "cus_xxxxxxxxxxxxx",
                },
                "permissions": ["payment_method", "balances"],
                "filters": {"countries": ["US"]},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="account_holder[type]=customer&account_holder[customer]=cus_xxxxxxxxxxxxx&permissions[0]=payment_method&permissions[1]=balances&filters[countries][0]=US",
        )

    @pytest.mark.anyio
    async def test_financial_connections_sessions_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Session.create_async(
            account_holder={
                "type": "customer",
                "customer": "cus_xxxxxxxxxxxxx",
            },
            permissions=["payment_method", "balances"],
            filters={"countries": ["US"]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/sessions",
            query_string="",
            post_data="account_holder[type]=customer&account_holder[customer]=cus_xxxxxxxxxxxxx&permissions[0]=payment_method&permissions[1]=balances&filters[countries][0]=US",
        )

    @pytest.mark.anyio
    async def test_financial_connections_sessions_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/financial_connections/sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.sessions.create_async(
            {
                "account_holder": {
                    "type": "customer",
                    "customer": "cus_xxxxxxxxxxxxx",
                },
                "permissions": ["payment_method", "balances"],
                "filters": {"countries": ["US"]},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/financial_connections/sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="account_holder[type]=customer&account_holder[customer]=cus_xxxxxxxxxxxxx&permissions[0]=payment_method&permissions[1]=balances&filters[countries][0]=US",
        )

    def test_financial_connections_transactions_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Transaction.retrieve("tr_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/transactions/tr_123",
            query_string="",
        )

    def test_financial_connections_transactions_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/transactions/tr_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.transactions.retrieve("tr_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/transactions/tr_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_transactions_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Transaction.retrieve_async("tr_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/transactions/tr_123",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_financial_connections_transactions_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/transactions/tr_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.transactions.retrieve_async(
            "tr_123"
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/transactions/tr_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_financial_connections_transactions_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.financial_connections.Transaction.list(account="fca_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/transactions",
            query_string="account=fca_xyz",
        )

    def test_financial_connections_transactions_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/transactions",
            "account=fca_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.financial_connections.transactions.list({"account": "fca_xyz"})
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/transactions",
            query_string="account=fca_xyz",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_financial_connections_transactions_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.financial_connections.Transaction.list_async(
            account="fca_xyz",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/transactions",
            query_string="account=fca_xyz",
        )

    @pytest.mark.anyio
    async def test_financial_connections_transactions_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/financial_connections/transactions",
            "account=fca_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.financial_connections.transactions.list_async(
            {
                "account": "fca_xyz",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/financial_connections/transactions",
            query_string="account=fca_xyz",
            api_base="https://api.stripe.com",
        )

    def test_identity_verification_reports_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.identity.VerificationReport.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_reports",
            query_string="limit=3",
        )

    def test_identity_verification_reports_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/identity/verification_reports",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.identity.verification_reports.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_reports",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_identity_verification_reports_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.identity.VerificationReport.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_reports",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_identity_verification_reports_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/identity/verification_reports",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.identity.verification_reports.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_reports",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_identity_verification_reports_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.identity.VerificationReport.retrieve("vr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_reports/vr_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_identity_verification_reports_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/identity/verification_reports/vr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.identity.verification_reports.retrieve("vr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_reports/vr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_identity_verification_reports_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.identity.VerificationReport.retrieve_async(
            "vr_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_reports/vr_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_identity_verification_reports_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/identity/verification_reports/vr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.identity.verification_reports.retrieve_async(
            "vr_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_reports/vr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_identity_verification_sessions_cancel_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.identity.VerificationSession.cancel("vs_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    def test_identity_verification_sessions_cancel_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.identity.verification_sessions.cancel("vs_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_cancel_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.identity.VerificationSession.cancel_async(
            "vs_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_cancel_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.identity.verification_sessions.cancel_async(
            "vs_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_identity_verification_sessions_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.identity.VerificationSession.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_sessions",
            query_string="limit=3",
        )

    def test_identity_verification_sessions_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/identity/verification_sessions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.identity.verification_sessions.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_sessions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.identity.VerificationSession.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_sessions",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/identity/verification_sessions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.identity.verification_sessions.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_sessions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_identity_verification_sessions_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.identity.VerificationSession.retrieve("vs_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_identity_verification_sessions_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.identity.verification_sessions.retrieve("vs_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.identity.VerificationSession.retrieve_async(
            "vs_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.identity.verification_sessions.retrieve_async(
            "vs_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_identity_verification_sessions_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.identity.VerificationSession.create(type="document")
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions",
            query_string="",
            post_data="type=document",
        )

    def test_identity_verification_sessions_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/identity/verification_sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.identity.verification_sessions.create({"type": "document"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=document",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.identity.VerificationSession.create_async(type="document")
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions",
            query_string="",
            post_data="type=document",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/identity/verification_sessions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.identity.verification_sessions.create_async(
            {
                "type": "document",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=document",
        )

    def test_identity_verification_sessions_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.identity.VerificationSession.modify(
            "vs_xxxxxxxxxxxxx",
            type="id_number",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
            query_string="",
            post_data="type=id_number",
        )

    def test_identity_verification_sessions_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.identity.verification_sessions.update(
            "vs_xxxxxxxxxxxxx",
            {"type": "id_number"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=id_number",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.identity.VerificationSession.modify_async(
            "vs_xxxxxxxxxxxxx",
            type="id_number",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
            query_string="",
            post_data="type=id_number",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.identity.verification_sessions.update_async(
            "vs_xxxxxxxxxxxxx",
            {"type": "id_number"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=id_number",
        )

    def test_identity_verification_sessions_redact_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.identity.VerificationSession.redact("vs_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/redact",
            query_string="",
        )

    def test_identity_verification_sessions_redact_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/redact",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.identity.verification_sessions.redact("vs_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/redact",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_redact_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.identity.VerificationSession.redact_async(
            "vs_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/redact",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_identity_verification_sessions_redact_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/redact",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.identity.verification_sessions.redact_async(
            "vs_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/identity/verification_sessions/vs_xxxxxxxxxxxxx/redact",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_invoiceitems_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.InvoiceItem.delete("ii_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_invoiceitems_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/invoiceitems/ii_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoice_items.delete("ii_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoiceitems_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.InvoiceItem.delete_async("ii_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_invoiceitems_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/invoiceitems/ii_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoice_items.delete_async("ii_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_invoiceitems_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.InvoiceItem.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoiceitems",
            query_string="limit=3",
        )

    def test_invoiceitems_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoiceitems",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoice_items.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoiceitems",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoiceitems_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.InvoiceItem.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoiceitems",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_invoiceitems_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoiceitems",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoice_items.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoiceitems",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_invoiceitems_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.InvoiceItem.retrieve("ii_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_invoiceitems_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoiceitems/ii_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoice_items.retrieve("ii_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoiceitems_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.InvoiceItem.retrieve_async("ii_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_invoiceitems_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoiceitems/ii_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoice_items.retrieve_async("ii_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_invoiceitems_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.InvoiceItem.create(
            customer="cus_xxxxxxxxxxxxx",
            price="price_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoiceitems",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx&price=price_xxxxxxxxxxxxx",
        )

    def test_invoiceitems_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoiceitems",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoice_items.create(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "price": "price_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoiceitems",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx&price=price_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_invoiceitems_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.InvoiceItem.create_async(
            customer="cus_xxxxxxxxxxxxx",
            price="price_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoiceitems",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx&price=price_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_invoiceitems_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoiceitems",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoice_items.create_async(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "price": "price_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoiceitems",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx&price=price_xxxxxxxxxxxxx",
        )

    def test_invoiceitems_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.InvoiceItem.modify(
            "ii_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_invoiceitems_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoiceitems/ii_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoice_items.update(
            "ii_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_invoiceitems_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.InvoiceItem.modify_async(
            "ii_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_invoiceitems_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoiceitems/ii_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoice_items.update_async(
            "ii_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoiceitems/ii_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_invoices_delete(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Invoice.delete("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_invoices_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/invoices/in_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.delete("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.delete_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_invoices_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/invoices/in_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.delete_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_invoices_finalize_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Invoice.finalize_invoice("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/finalize",
            query_string="",
        )

    def test_invoices_finalize_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx/finalize",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.finalize_invoice("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/finalize",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_finalize_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.finalize_invoice_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/finalize",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_invoices_finalize_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx/finalize",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.finalize_invoice_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/finalize",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_invoices_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Invoice.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices",
            query_string="limit=3",
        )

    def test_invoices_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoices",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_invoices_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoices",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_invoices_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Invoice.retrieve("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_invoices_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoices/in_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.retrieve("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.retrieve_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_invoices_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoices/in_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.retrieve_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_invoices_get_3(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Invoice.retrieve(
            "in_xxxxxxxxxxxxx",
            expand=["customer"],
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="expand[0]=customer",
        )

    def test_invoices_get_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoices/in_xxxxxxxxxxxxx",
            "expand[0]=customer",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.retrieve(
            "in_xxxxxxxxxxxxx",
            {"expand": ["customer"]},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="expand[0]=customer",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_get_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.retrieve_async(
            "in_xxxxxxxxxxxxx",
            expand=["customer"],
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="expand[0]=customer",
        )

    @pytest.mark.anyio
    async def test_invoices_get_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoices/in_xxxxxxxxxxxxx",
            "expand[0]=customer",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.retrieve_async(
            "in_xxxxxxxxxxxxx",
            {"expand": ["customer"]},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="expand[0]=customer",
            api_base="https://api.stripe.com",
        )

    def test_invoices_mark_uncollectible_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Invoice.mark_uncollectible("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/mark_uncollectible",
            query_string="",
        )

    def test_invoices_mark_uncollectible_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx/mark_uncollectible",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.mark_uncollectible("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/mark_uncollectible",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_mark_uncollectible_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.mark_uncollectible_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/mark_uncollectible",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_invoices_mark_uncollectible_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx/mark_uncollectible",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.mark_uncollectible_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/mark_uncollectible",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_invoices_pay_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Invoice.pay("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/pay",
            query_string="",
        )

    def test_invoices_pay_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx/pay",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.pay("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/pay",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_pay_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.pay_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/pay",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_invoices_pay_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx/pay",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.pay_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/pay",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_invoices_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Invoice.create(customer="cus_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx",
        )

    def test_invoices_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.create({"customer": "cus_xxxxxxxxxxxxx"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_invoices_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.create_async(customer="cus_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_invoices_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.create_async({"customer": "cus_xxxxxxxxxxxxx"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx",
        )

    def test_invoices_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Invoice.modify(
            "in_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_invoices_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.update(
            "in_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_invoices_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.modify_async(
            "in_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_invoices_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.update_async(
            "in_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_invoices_search_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Invoice.search(
            query="total>999 AND metadata['order_id']:'6735'"
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/search",
            query_string="query=total%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    def test_invoices_search_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoices/search",
            "query=total%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.search(
            {
                "query": "total>999 AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/search",
            query_string="query=total%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_search_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.search_async(
            query="total>999 AND metadata['order_id']:'6735'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/search",
            query_string="query=total%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    @pytest.mark.anyio
    async def test_invoices_search_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoices/search",
            "query=total%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.search_async(
            {
                "query": "total>999 AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/search",
            query_string="query=total%3E999%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    def test_invoices_send_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Invoice.send_invoice("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/send",
            query_string="",
        )

    def test_invoices_send_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx/send",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.send_invoice("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/send",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_send_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.send_invoice_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/send",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_invoices_send_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx/send",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.send_invoice_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/send",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_invoices_upcoming_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Invoice.upcoming(customer="cus_9utnxg47pWjV1e")
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/upcoming",
            query_string="customer=cus_9utnxg47pWjV1e",
        )

    def test_invoices_upcoming_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoices/upcoming",
            "customer=cus_9utnxg47pWjV1e",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.upcoming({"customer": "cus_9utnxg47pWjV1e"})
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/upcoming",
            query_string="customer=cus_9utnxg47pWjV1e",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_upcoming_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.upcoming_async(customer="cus_9utnxg47pWjV1e")
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/upcoming",
            query_string="customer=cus_9utnxg47pWjV1e",
        )

    @pytest.mark.anyio
    async def test_invoices_upcoming_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/invoices/upcoming",
            "customer=cus_9utnxg47pWjV1e",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.upcoming_async(
            {"customer": "cus_9utnxg47pWjV1e"}
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/invoices/upcoming",
            query_string="customer=cus_9utnxg47pWjV1e",
            api_base="https://api.stripe.com",
        )

    def test_invoices_void_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Invoice.void_invoice("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/void",
            query_string="",
        )

    def test_invoices_void_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx/void",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.invoices.void_invoice("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/void",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_invoices_void_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Invoice.void_invoice_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/void",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_invoices_void_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/invoices/in_xxxxxxxxxxxxx/void",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.invoices.void_invoice_async("in_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/invoices/in_xxxxxxxxxxxxx/void",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_authorizations_approve_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Authorization.approve("iauth_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/approve",
            query_string="",
        )

    def test_issuing_authorizations_approve_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/approve",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.authorizations.approve("iauth_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/approve",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_authorizations_approve_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Authorization.approve_async("iauth_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/approve",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_authorizations_approve_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/approve",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.authorizations.approve_async(
            "iauth_xxxxxxxxxxxxx"
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/approve",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_authorizations_decline_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Authorization.decline("iauth_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/decline",
            query_string="",
        )

    def test_issuing_authorizations_decline_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/decline",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.authorizations.decline("iauth_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/decline",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_authorizations_decline_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Authorization.decline_async("iauth_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/decline",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_authorizations_decline_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/decline",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.authorizations.decline_async(
            "iauth_xxxxxxxxxxxxx"
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx/decline",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_authorizations_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Authorization.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/authorizations",
            query_string="limit=3",
        )

    def test_issuing_authorizations_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/authorizations",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.authorizations.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/authorizations",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_authorizations_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Authorization.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/authorizations",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_issuing_authorizations_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/authorizations",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.authorizations.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/authorizations",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_issuing_authorizations_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Authorization.retrieve("iauth_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_issuing_authorizations_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.authorizations.retrieve("iauth_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_authorizations_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Authorization.retrieve_async(
            "iauth_xxxxxxxxxxxxx"
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_authorizations_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.authorizations.retrieve_async(
            "iauth_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_authorizations_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Authorization.modify(
            "iauth_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_issuing_authorizations_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.authorizations.update(
            "iauth_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_issuing_authorizations_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Authorization.modify_async(
            "iauth_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_issuing_authorizations_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.authorizations.update_async(
            "iauth_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/authorizations/iauth_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_issuing_cardholders_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Cardholder.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cardholders",
            query_string="limit=3",
        )

    def test_issuing_cardholders_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/cardholders",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.cardholders.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cardholders",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_cardholders_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Cardholder.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cardholders",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_issuing_cardholders_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/cardholders",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.cardholders.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cardholders",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_issuing_cardholders_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Cardholder.retrieve("ich_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_issuing_cardholders_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.cardholders.retrieve("ich_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_cardholders_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Cardholder.retrieve_async("ich_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_cardholders_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.cardholders.retrieve_async("ich_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_cardholders_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Cardholder.create(
            type="individual",
            name="Jenny Rosen",
            email="jenny.rosen@example.com",
            phone_number="+18888675309",
            billing={
                "address": {
                    "line1": "1234 Main Street",
                    "city": "San Francisco",
                    "state": "CA",
                    "country": "US",
                    "postal_code": "94111",
                },
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cardholders",
            query_string="",
            post_data="type=individual&name=Jenny%20Rosen&email=jenny.rosen%40example.com&phone_number=%2B18888675309&billing[address][line1]=1234%20Main%20Street&billing[address][city]=San%20Francisco&billing[address][state]=CA&billing[address][country]=US&billing[address][postal_code]=94111",
        )

    def test_issuing_cardholders_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/cardholders",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.cardholders.create(
            {
                "type": "individual",
                "name": "Jenny Rosen",
                "email": "jenny.rosen@example.com",
                "phone_number": "+18888675309",
                "billing": {
                    "address": {
                        "line1": "1234 Main Street",
                        "city": "San Francisco",
                        "state": "CA",
                        "country": "US",
                        "postal_code": "94111",
                    },
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cardholders",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=individual&name=Jenny%20Rosen&email=jenny.rosen%40example.com&phone_number=%2B18888675309&billing[address][line1]=1234%20Main%20Street&billing[address][city]=San%20Francisco&billing[address][state]=CA&billing[address][country]=US&billing[address][postal_code]=94111",
        )

    @pytest.mark.anyio
    async def test_issuing_cardholders_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Cardholder.create_async(
            type="individual",
            name="Jenny Rosen",
            email="jenny.rosen@example.com",
            phone_number="+18888675309",
            billing={
                "address": {
                    "line1": "1234 Main Street",
                    "city": "San Francisco",
                    "state": "CA",
                    "country": "US",
                    "postal_code": "94111",
                },
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cardholders",
            query_string="",
            post_data="type=individual&name=Jenny%20Rosen&email=jenny.rosen%40example.com&phone_number=%2B18888675309&billing[address][line1]=1234%20Main%20Street&billing[address][city]=San%20Francisco&billing[address][state]=CA&billing[address][country]=US&billing[address][postal_code]=94111",
        )

    @pytest.mark.anyio
    async def test_issuing_cardholders_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/cardholders",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.cardholders.create_async(
            {
                "type": "individual",
                "name": "Jenny Rosen",
                "email": "jenny.rosen@example.com",
                "phone_number": "+18888675309",
                "billing": {
                    "address": {
                        "line1": "1234 Main Street",
                        "city": "San Francisco",
                        "state": "CA",
                        "country": "US",
                        "postal_code": "94111",
                    },
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cardholders",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=individual&name=Jenny%20Rosen&email=jenny.rosen%40example.com&phone_number=%2B18888675309&billing[address][line1]=1234%20Main%20Street&billing[address][city]=San%20Francisco&billing[address][state]=CA&billing[address][country]=US&billing[address][postal_code]=94111",
        )

    def test_issuing_cardholders_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Cardholder.modify(
            "ich_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_issuing_cardholders_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.cardholders.update(
            "ich_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_issuing_cardholders_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Cardholder.modify_async(
            "ich_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_issuing_cardholders_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.cardholders.update_async(
            "ich_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cardholders/ich_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_issuing_cards_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.issuing.Card.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cards",
            query_string="limit=3",
        )

    def test_issuing_cards_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/cards",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.cards.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cards",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_cards_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Card.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cards",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_issuing_cards_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/cards",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.cards.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cards",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_issuing_cards_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Card.retrieve("ic_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cards/ic_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_issuing_cards_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/cards/ic_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.cards.retrieve("ic_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cards/ic_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_cards_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Card.retrieve_async("ic_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cards/ic_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_cards_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/cards/ic_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.cards.retrieve_async("ic_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/cards/ic_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_cards_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Card.create(
            cardholder="ich_xxxxxxxxxxxxx",
            currency="usd",
            type="virtual",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cards",
            query_string="",
            post_data="cardholder=ich_xxxxxxxxxxxxx&currency=usd&type=virtual",
        )

    def test_issuing_cards_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/cards",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.cards.create(
            {
                "cardholder": "ich_xxxxxxxxxxxxx",
                "currency": "usd",
                "type": "virtual",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cards",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="cardholder=ich_xxxxxxxxxxxxx&currency=usd&type=virtual",
        )

    @pytest.mark.anyio
    async def test_issuing_cards_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Card.create_async(
            cardholder="ich_xxxxxxxxxxxxx",
            currency="usd",
            type="virtual",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cards",
            query_string="",
            post_data="cardholder=ich_xxxxxxxxxxxxx&currency=usd&type=virtual",
        )

    @pytest.mark.anyio
    async def test_issuing_cards_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/cards",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.cards.create_async(
            {
                "cardholder": "ich_xxxxxxxxxxxxx",
                "currency": "usd",
                "type": "virtual",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cards",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="cardholder=ich_xxxxxxxxxxxxx&currency=usd&type=virtual",
        )

    def test_issuing_cards_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Card.modify(
            "ic_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cards/ic_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_issuing_cards_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/cards/ic_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.cards.update(
            "ic_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cards/ic_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_issuing_cards_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Card.modify_async(
            "ic_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cards/ic_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_issuing_cards_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/cards/ic_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.cards.update_async(
            "ic_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/cards/ic_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_issuing_disputes_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Dispute.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/disputes",
            query_string="limit=3",
        )

    def test_issuing_disputes_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/disputes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.disputes.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/disputes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_disputes_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Dispute.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/disputes",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_issuing_disputes_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/disputes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.disputes.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/disputes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_issuing_disputes_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Dispute.retrieve("idp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/disputes/idp_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_issuing_disputes_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/disputes/idp_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.disputes.retrieve("idp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/disputes/idp_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_disputes_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Dispute.retrieve_async("idp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/disputes/idp_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_disputes_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/disputes/idp_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.disputes.retrieve_async("idp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/disputes/idp_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_disputes_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Dispute.create(
            transaction="ipi_xxxxxxxxxxxxx",
            evidence={
                "reason": "fraudulent",
                "fraudulent": {"explanation": "Purchase was unrecognized."},
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/disputes",
            query_string="",
            post_data="transaction=ipi_xxxxxxxxxxxxx&evidence[reason]=fraudulent&evidence[fraudulent][explanation]=Purchase%20was%20unrecognized.",
        )

    def test_issuing_disputes_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/disputes",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.disputes.create(
            {
                "transaction": "ipi_xxxxxxxxxxxxx",
                "evidence": {
                    "reason": "fraudulent",
                    "fraudulent": {
                        "explanation": "Purchase was unrecognized."
                    },
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/disputes",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="transaction=ipi_xxxxxxxxxxxxx&evidence[reason]=fraudulent&evidence[fraudulent][explanation]=Purchase%20was%20unrecognized.",
        )

    @pytest.mark.anyio
    async def test_issuing_disputes_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Dispute.create_async(
            transaction="ipi_xxxxxxxxxxxxx",
            evidence={
                "reason": "fraudulent",
                "fraudulent": {"explanation": "Purchase was unrecognized."},
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/disputes",
            query_string="",
            post_data="transaction=ipi_xxxxxxxxxxxxx&evidence[reason]=fraudulent&evidence[fraudulent][explanation]=Purchase%20was%20unrecognized.",
        )

    @pytest.mark.anyio
    async def test_issuing_disputes_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/disputes",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.disputes.create_async(
            {
                "transaction": "ipi_xxxxxxxxxxxxx",
                "evidence": {
                    "reason": "fraudulent",
                    "fraudulent": {
                        "explanation": "Purchase was unrecognized."
                    },
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/disputes",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="transaction=ipi_xxxxxxxxxxxxx&evidence[reason]=fraudulent&evidence[fraudulent][explanation]=Purchase%20was%20unrecognized.",
        )

    def test_issuing_disputes_submit_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Dispute.submit("idp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/disputes/idp_xxxxxxxxxxxxx/submit",
            query_string="",
        )

    def test_issuing_disputes_submit_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/disputes/idp_xxxxxxxxxxxxx/submit",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.disputes.submit("idp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/disputes/idp_xxxxxxxxxxxxx/submit",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_disputes_submit_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Dispute.submit_async("idp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/disputes/idp_xxxxxxxxxxxxx/submit",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_disputes_submit_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/disputes/idp_xxxxxxxxxxxxx/submit",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.disputes.submit_async("idp_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/disputes/idp_xxxxxxxxxxxxx/submit",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_personalization_designs_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.PersonalizationDesign.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/personalization_designs",
            query_string="",
        )

    def test_issuing_personalization_designs_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/personalization_designs",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.personalization_designs.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/personalization_designs",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_personalization_designs_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.PersonalizationDesign.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/personalization_designs",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_personalization_designs_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/personalization_designs",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.personalization_designs.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/personalization_designs",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_personalization_designs_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.PersonalizationDesign.retrieve("pd_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/personalization_designs/pd_xyz",
            query_string="",
        )

    def test_issuing_personalization_designs_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/personalization_designs/pd_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.personalization_designs.retrieve("pd_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/personalization_designs/pd_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_personalization_designs_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.PersonalizationDesign.retrieve_async("pd_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/personalization_designs/pd_xyz",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_personalization_designs_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/personalization_designs/pd_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.personalization_designs.retrieve_async("pd_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/personalization_designs/pd_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_personalization_designs_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.PersonalizationDesign.create(physical_bundle="pb_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/personalization_designs",
            query_string="",
            post_data="physical_bundle=pb_xyz",
        )

    def test_issuing_personalization_designs_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/personalization_designs",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.personalization_designs.create(
            {
                "physical_bundle": "pb_xyz",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/personalization_designs",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="physical_bundle=pb_xyz",
        )

    @pytest.mark.anyio
    async def test_issuing_personalization_designs_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.PersonalizationDesign.create_async(
            physical_bundle="pb_xyz",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/personalization_designs",
            query_string="",
            post_data="physical_bundle=pb_xyz",
        )

    @pytest.mark.anyio
    async def test_issuing_personalization_designs_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/personalization_designs",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.personalization_designs.create_async(
            {
                "physical_bundle": "pb_xyz",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/personalization_designs",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="physical_bundle=pb_xyz",
        )

    def test_issuing_personalization_designs_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.PersonalizationDesign.modify("pd_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/personalization_designs/pd_xyz",
            query_string="",
        )

    def test_issuing_personalization_designs_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/personalization_designs/pd_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.personalization_designs.update("pd_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/personalization_designs/pd_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_personalization_designs_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.PersonalizationDesign.modify_async("pd_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/personalization_designs/pd_xyz",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_personalization_designs_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/personalization_designs/pd_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.personalization_designs.update_async("pd_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/personalization_designs/pd_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_physical_bundles_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.PhysicalBundle.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/physical_bundles",
            query_string="",
        )

    def test_issuing_physical_bundles_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/physical_bundles",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.physical_bundles.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/physical_bundles",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_physical_bundles_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.PhysicalBundle.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/physical_bundles",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_physical_bundles_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/physical_bundles",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.physical_bundles.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/physical_bundles",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_physical_bundles_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.PhysicalBundle.retrieve("pb_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/physical_bundles/pb_xyz",
            query_string="",
        )

    def test_issuing_physical_bundles_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/physical_bundles/pb_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.physical_bundles.retrieve("pb_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/physical_bundles/pb_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_physical_bundles_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.PhysicalBundle.retrieve_async("pb_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/physical_bundles/pb_xyz",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_physical_bundles_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/physical_bundles/pb_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.physical_bundles.retrieve_async("pb_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/physical_bundles/pb_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_transactions_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Transaction.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/transactions",
            query_string="limit=3",
        )

    def test_issuing_transactions_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/transactions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.transactions.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/transactions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_transactions_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Transaction.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/transactions",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_issuing_transactions_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/transactions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.transactions.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/transactions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_issuing_transactions_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Transaction.retrieve("ipi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_issuing_transactions_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.transactions.retrieve("ipi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_issuing_transactions_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Transaction.retrieve_async("ipi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_issuing_transactions_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.transactions.retrieve_async("ipi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_issuing_transactions_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Transaction.modify(
            "ipi_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_issuing_transactions_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.issuing.transactions.update(
            "ipi_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_issuing_transactions_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Transaction.modify_async(
            "ipi_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_issuing_transactions_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.issuing.transactions.update_async(
            "ipi_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/issuing/transactions/ipi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_mandates_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Mandate.retrieve("mandate_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/mandates/mandate_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_mandates_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/mandates/mandate_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.mandates.retrieve("mandate_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/mandates/mandate_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_mandates_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Mandate.retrieve_async("mandate_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/mandates/mandate_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_mandates_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/mandates/mandate_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.mandates.retrieve_async("mandate_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/mandates/mandate_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_intents_apply_customer_balance_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.apply_customer_balance("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/apply_customer_balance",
            query_string="",
        )

    def test_payment_intents_apply_customer_balance_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/apply_customer_balance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.apply_customer_balance("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/apply_customer_balance",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_intents_apply_customer_balance_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.apply_customer_balance_async(
            "pi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/apply_customer_balance",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_intents_apply_customer_balance_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/apply_customer_balance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.apply_customer_balance_async(
            "pi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/apply_customer_balance",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_intents_cancel_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.cancel("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    def test_payment_intents_cancel_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.cancel("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_intents_cancel_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.cancel_async("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_intents_cancel_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.cancel_async("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_intents_capture_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.capture("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/capture",
            query_string="",
        )

    def test_payment_intents_capture_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/capture",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.capture("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/capture",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_intents_capture_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.capture_async("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/capture",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_intents_capture_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/capture",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.capture_async("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/capture",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_intents_confirm_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.confirm(
            "pi_xxxxxxxxxxxxx",
            payment_method="pm_card_visa",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/confirm",
            query_string="",
            post_data="payment_method=pm_card_visa",
        )

    def test_payment_intents_confirm_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/confirm",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.confirm(
            "pi_xxxxxxxxxxxxx",
            {"payment_method": "pm_card_visa"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/confirm",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="payment_method=pm_card_visa",
        )

    @pytest.mark.anyio
    async def test_payment_intents_confirm_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.confirm_async(
            "pi_xxxxxxxxxxxxx",
            payment_method="pm_card_visa",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/confirm",
            query_string="",
            post_data="payment_method=pm_card_visa",
        )

    @pytest.mark.anyio
    async def test_payment_intents_confirm_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/confirm",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.confirm_async(
            "pi_xxxxxxxxxxxxx",
            {"payment_method": "pm_card_visa"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/confirm",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="payment_method=pm_card_visa",
        )

    def test_payment_intents_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents",
            query_string="limit=3",
        )

    def test_payment_intents_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_intents",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_intents_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_payment_intents_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_intents",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_payment_intents_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.retrieve("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_payment_intents_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.retrieve("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_intents_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.retrieve_async("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_intents_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.retrieve_async("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_intents_increment_authorization_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.increment_authorization(
            "pi_xxxxxxxxxxxxx",
            amount=2099,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/increment_authorization",
            query_string="",
            post_data="amount=2099",
        )

    def test_payment_intents_increment_authorization_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/increment_authorization",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.increment_authorization(
            "pi_xxxxxxxxxxxxx",
            {"amount": 2099},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/increment_authorization",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2099",
        )

    @pytest.mark.anyio
    async def test_payment_intents_increment_authorization_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.increment_authorization_async(
            "pi_xxxxxxxxxxxxx",
            amount=2099,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/increment_authorization",
            query_string="",
            post_data="amount=2099",
        )

    @pytest.mark.anyio
    async def test_payment_intents_increment_authorization_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/increment_authorization",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.increment_authorization_async(
            "pi_xxxxxxxxxxxxx",
            {"amount": 2099},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/increment_authorization",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2099",
        )

    def test_payment_intents_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.create(
            amount=1099,
            currency="eur",
            automatic_payment_methods={"enabled": True},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            post_data="amount=1099&currency=eur&automatic_payment_methods[enabled]=True",
        )

    def test_payment_intents_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.create(
            {
                "amount": 1099,
                "currency": "eur",
                "automatic_payment_methods": {"enabled": True},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=1099&currency=eur&automatic_payment_methods[enabled]=True",
        )

    @pytest.mark.anyio
    async def test_payment_intents_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.create_async(
            amount=1099,
            currency="eur",
            automatic_payment_methods={"enabled": True},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            post_data="amount=1099&currency=eur&automatic_payment_methods[enabled]=True",
        )

    @pytest.mark.anyio
    async def test_payment_intents_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.create_async(
            {
                "amount": 1099,
                "currency": "eur",
                "automatic_payment_methods": {"enabled": True},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=1099&currency=eur&automatic_payment_methods[enabled]=True",
        )

    def test_payment_intents_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.create(
            amount=2000,
            currency="usd",
            automatic_payment_methods={"enabled": True},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            post_data="amount=2000&currency=usd&automatic_payment_methods[enabled]=True",
        )

    def test_payment_intents_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.create(
            {
                "amount": 2000,
                "currency": "usd",
                "automatic_payment_methods": {"enabled": True},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2000&currency=usd&automatic_payment_methods[enabled]=True",
        )

    @pytest.mark.anyio
    async def test_payment_intents_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.create_async(
            amount=2000,
            currency="usd",
            automatic_payment_methods={"enabled": True},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            post_data="amount=2000&currency=usd&automatic_payment_methods[enabled]=True",
        )

    @pytest.mark.anyio
    async def test_payment_intents_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.create_async(
            {
                "amount": 2000,
                "currency": "usd",
                "automatic_payment_methods": {"enabled": True},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2000&currency=usd&automatic_payment_methods[enabled]=True",
        )

    def test_payment_intents_post_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.modify(
            "pi_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_payment_intents_post_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.update(
            "pi_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_payment_intents_post_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.modify_async(
            "pi_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_payment_intents_post_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.update_async(
            "pi_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_payment_intents_post_4(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.create(
            amount=200,
            currency="usd",
            payment_method_data={"type": "p24", "p24": {"bank": "blik"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            post_data="amount=200&currency=usd&payment_method_data[type]=p24&payment_method_data[p24][bank]=blik",
        )

    def test_payment_intents_post_4_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.create(
            {
                "amount": 200,
                "currency": "usd",
                "payment_method_data": {
                    "type": "p24",
                    "p24": {"bank": "blik"},
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=200&currency=usd&payment_method_data[type]=p24&payment_method_data[p24][bank]=blik",
        )

    @pytest.mark.anyio
    async def test_payment_intents_post_4_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.create_async(
            amount=200,
            currency="usd",
            payment_method_data={"type": "p24", "p24": {"bank": "blik"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            post_data="amount=200&currency=usd&payment_method_data[type]=p24&payment_method_data[p24][bank]=blik",
        )

    @pytest.mark.anyio
    async def test_payment_intents_post_4_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.create_async(
            {
                "amount": 200,
                "currency": "usd",
                "payment_method_data": {
                    "type": "p24",
                    "p24": {"bank": "blik"},
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=200&currency=usd&payment_method_data[type]=p24&payment_method_data[p24][bank]=blik",
        )

    def test_payment_intents_search_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.search(
            query="status:'succeeded' AND metadata['order_id']:'6735'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents/search",
            query_string="query=status%3A%27succeeded%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    def test_payment_intents_search_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_intents/search",
            "query=status%3A%27succeeded%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.search(
            {
                "query": "status:'succeeded' AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents/search",
            query_string="query=status%3A%27succeeded%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_intents_search_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.search_async(
            query="status:'succeeded' AND metadata['order_id']:'6735'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents/search",
            query_string="query=status%3A%27succeeded%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    @pytest.mark.anyio
    async def test_payment_intents_search_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_intents/search",
            "query=status%3A%27succeeded%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.search_async(
            {
                "query": "status:'succeeded' AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_intents/search",
            query_string="query=status%3A%27succeeded%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    def test_payment_intents_verify_microdeposits_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.verify_microdeposits("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
        )

    def test_payment_intents_verify_microdeposits_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.verify_microdeposits("pi_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_intents_verify_microdeposits_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.verify_microdeposits_async(
            "pi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_intents_verify_microdeposits_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.verify_microdeposits_async(
            "pi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_intents_verify_microdeposits_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentIntent.verify_microdeposits(
            "pi_xxxxxxxxxxxxx",
            amounts=[32, 45],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            post_data="amounts[0]=32&amounts[1]=45",
        )

    def test_payment_intents_verify_microdeposits_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_intents.verify_microdeposits(
            "pi_xxxxxxxxxxxxx",
            {"amounts": [32, 45]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amounts[0]=32&amounts[1]=45",
        )

    @pytest.mark.anyio
    async def test_payment_intents_verify_microdeposits_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentIntent.verify_microdeposits_async(
            "pi_xxxxxxxxxxxxx",
            amounts=[32, 45],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            post_data="amounts[0]=32&amounts[1]=45",
        )

    @pytest.mark.anyio
    async def test_payment_intents_verify_microdeposits_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_intents.verify_microdeposits_async(
            "pi_xxxxxxxxxxxxx",
            {"amounts": [32, 45]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_intents/pi_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amounts[0]=32&amounts[1]=45",
        )

    def test_payment_links_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.PaymentLink.retrieve("pl_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/pl_xyz",
            query_string="",
        )

    def test_payment_links_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_links/pl_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_links.retrieve("pl_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/pl_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_links_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentLink.retrieve_async("pl_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/pl_xyz",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_links_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_links/pl_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_links.retrieve_async("pl_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/pl_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_links_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentLink.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links",
            query_string="limit=3",
        )

    def test_payment_links_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_links",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_links.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_links_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentLink.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_payment_links_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_links",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_links.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_payment_links_get_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentLink.retrieve("plink_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/plink_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_payment_links_get_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_links/plink_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_links.retrieve("plink_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/plink_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_links_get_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentLink.retrieve_async("plink_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/plink_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_links_get_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_links/plink_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_links.retrieve_async("plink_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/plink_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_links_line_items_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentLink.list_line_items("pl_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/pl_xyz/line_items",
            query_string="",
        )

    def test_payment_links_line_items_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_links/pl_xyz/line_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_links.line_items.list("pl_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/pl_xyz/line_items",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_links_line_items_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentLink.list_line_items_async("pl_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/pl_xyz/line_items",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_links_line_items_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_links/pl_xyz/line_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_links.line_items.list_async("pl_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_links/pl_xyz/line_items",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_links_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentLink.create(
            line_items=[{"price": "price_xxxxxxxxxxxxx", "quantity": 1}],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links",
            query_string="",
            post_data="line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=1",
        )

    def test_payment_links_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_links",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_links.create(
            {
                "line_items": [
                    {"price": "price_xxxxxxxxxxxxx", "quantity": 1}
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=1",
        )

    @pytest.mark.anyio
    async def test_payment_links_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentLink.create_async(
            line_items=[{"price": "price_xxxxxxxxxxxxx", "quantity": 1}],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links",
            query_string="",
            post_data="line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=1",
        )

    @pytest.mark.anyio
    async def test_payment_links_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_links",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_links.create_async(
            {
                "line_items": [
                    {"price": "price_xxxxxxxxxxxxx", "quantity": 1}
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=1",
        )

    def test_payment_links_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentLink.create(
            line_items=[{"price": "price_xxxxxxxxxxxxx", "quantity": 1}],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links",
            query_string="",
            post_data="line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=1",
        )

    def test_payment_links_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_links",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_links.create(
            {
                "line_items": [
                    {"price": "price_xxxxxxxxxxxxx", "quantity": 1}
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=1",
        )

    @pytest.mark.anyio
    async def test_payment_links_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentLink.create_async(
            line_items=[{"price": "price_xxxxxxxxxxxxx", "quantity": 1}],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links",
            query_string="",
            post_data="line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=1",
        )

    @pytest.mark.anyio
    async def test_payment_links_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_links",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_links.create_async(
            {
                "line_items": [
                    {"price": "price_xxxxxxxxxxxxx", "quantity": 1}
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=1",
        )

    def test_payment_links_post_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentLink.modify(
            "plink_xxxxxxxxxxxxx",
            active=False,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links/plink_xxxxxxxxxxxxx",
            query_string="",
            post_data="active=False",
        )

    def test_payment_links_post_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_links/plink_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_links.update(
            "plink_xxxxxxxxxxxxx",
            {"active": False},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links/plink_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="active=False",
        )

    @pytest.mark.anyio
    async def test_payment_links_post_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentLink.modify_async(
            "plink_xxxxxxxxxxxxx",
            active=False,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links/plink_xxxxxxxxxxxxx",
            query_string="",
            post_data="active=False",
        )

    @pytest.mark.anyio
    async def test_payment_links_post_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_links/plink_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_links.update_async(
            "plink_xxxxxxxxxxxxx",
            {"active": False},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_links/plink_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="active=False",
        )

    def test_payment_method_configurations_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentMethodConfiguration.list(application="foo")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_method_configurations",
            query_string="application=foo",
        )

    def test_payment_method_configurations_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_method_configurations",
            "application=foo",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_method_configurations.list({"application": "foo"})
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_method_configurations",
            query_string="application=foo",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_method_configurations_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentMethodConfiguration.list_async(application="foo")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_method_configurations",
            query_string="application=foo",
        )

    @pytest.mark.anyio
    async def test_payment_method_configurations_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_method_configurations",
            "application=foo",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_method_configurations.list_async(
            {
                "application": "foo",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_method_configurations",
            query_string="application=foo",
            api_base="https://api.stripe.com",
        )

    def test_payment_method_configurations_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentMethodConfiguration.retrieve("foo")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_method_configurations/foo",
            query_string="",
        )

    def test_payment_method_configurations_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_method_configurations/foo",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_method_configurations.retrieve("foo")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_method_configurations/foo",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_method_configurations_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentMethodConfiguration.retrieve_async("foo")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_method_configurations/foo",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_method_configurations_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_method_configurations/foo",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_method_configurations.retrieve_async("foo")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_method_configurations/foo",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_method_configurations_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentMethodConfiguration.create(
            acss_debit={"display_preference": {"preference": "none"}},
            affirm={"display_preference": {"preference": "none"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_method_configurations",
            query_string="",
            post_data="acss_debit[display_preference][preference]=none&affirm[display_preference][preference]=none",
        )

    def test_payment_method_configurations_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_method_configurations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_method_configurations.create(
            {
                "acss_debit": {"display_preference": {"preference": "none"}},
                "affirm": {"display_preference": {"preference": "none"}},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_method_configurations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="acss_debit[display_preference][preference]=none&affirm[display_preference][preference]=none",
        )

    @pytest.mark.anyio
    async def test_payment_method_configurations_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentMethodConfiguration.create_async(
            acss_debit={"display_preference": {"preference": "none"}},
            affirm={"display_preference": {"preference": "none"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_method_configurations",
            query_string="",
            post_data="acss_debit[display_preference][preference]=none&affirm[display_preference][preference]=none",
        )

    @pytest.mark.anyio
    async def test_payment_method_configurations_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_method_configurations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_method_configurations.create_async(
            {
                "acss_debit": {"display_preference": {"preference": "none"}},
                "affirm": {"display_preference": {"preference": "none"}},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_method_configurations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="acss_debit[display_preference][preference]=none&affirm[display_preference][preference]=none",
        )

    def test_payment_method_configurations_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentMethodConfiguration.modify(
            "foo",
            acss_debit={"display_preference": {"preference": "on"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_method_configurations/foo",
            query_string="",
            post_data="acss_debit[display_preference][preference]=on",
        )

    def test_payment_method_configurations_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_method_configurations/foo",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_method_configurations.update(
            "foo",
            {"acss_debit": {"display_preference": {"preference": "on"}}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_method_configurations/foo",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="acss_debit[display_preference][preference]=on",
        )

    @pytest.mark.anyio
    async def test_payment_method_configurations_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentMethodConfiguration.modify_async(
            "foo",
            acss_debit={"display_preference": {"preference": "on"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_method_configurations/foo",
            query_string="",
            post_data="acss_debit[display_preference][preference]=on",
        )

    @pytest.mark.anyio
    async def test_payment_method_configurations_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_method_configurations/foo",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_method_configurations.update_async(
            "foo",
            {"acss_debit": {"display_preference": {"preference": "on"}}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_method_configurations/foo",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="acss_debit[display_preference][preference]=on",
        )

    def test_payment_methods_attach_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentMethod.attach(
            "pm_xxxxxxxxxxxxx",
            customer="cus_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx/attach",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx",
        )

    def test_payment_methods_attach_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_methods/pm_xxxxxxxxxxxxx/attach",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_methods.attach(
            "pm_xxxxxxxxxxxxx",
            {"customer": "cus_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx/attach",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_payment_methods_attach_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentMethod.attach_async(
            "pm_xxxxxxxxxxxxx",
            customer="cus_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx/attach",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_payment_methods_attach_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_methods/pm_xxxxxxxxxxxxx/attach",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_methods.attach_async(
            "pm_xxxxxxxxxxxxx",
            {"customer": "cus_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx/attach",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx",
        )

    def test_payment_methods_detach_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentMethod.detach("pm_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx/detach",
            query_string="",
        )

    def test_payment_methods_detach_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_methods/pm_xxxxxxxxxxxxx/detach",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_methods.detach("pm_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx/detach",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_methods_detach_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentMethod.detach_async("pm_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx/detach",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_methods_detach_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_methods/pm_xxxxxxxxxxxxx/detach",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_methods.detach_async("pm_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx/detach",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_methods_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentMethod.list(
            customer="cus_xxxxxxxxxxxxx",
            type="card",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_methods",
            query_string="customer=cus_xxxxxxxxxxxxx&type=card",
        )

    def test_payment_methods_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_methods",
            "customer=cus_xxxxxxxxxxxxx&type=card",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_methods.list(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "type": "card",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_methods",
            query_string="customer=cus_xxxxxxxxxxxxx&type=card",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_methods_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentMethod.list_async(
            customer="cus_xxxxxxxxxxxxx",
            type="card",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_methods",
            query_string="customer=cus_xxxxxxxxxxxxx&type=card",
        )

    @pytest.mark.anyio
    async def test_payment_methods_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_methods",
            "customer=cus_xxxxxxxxxxxxx&type=card",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_methods.list_async(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "type": "card",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_methods",
            query_string="customer=cus_xxxxxxxxxxxxx&type=card",
            api_base="https://api.stripe.com",
        )

    def test_payment_methods_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentMethod.retrieve("pm_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_payment_methods_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_methods/pm_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_methods.retrieve("pm_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payment_methods_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentMethod.retrieve_async("pm_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payment_methods_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payment_methods/pm_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_methods.retrieve_async("pm_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payment_methods_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentMethod.create(
            type="card",
            card={
                "number": "4242424242424242",
                "exp_month": 8,
                "exp_year": 2024,
                "cvc": "314",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods",
            query_string="",
            post_data="type=card&card[number]=4242424242424242&card[exp_month]=8&card[exp_year]=2024&card[cvc]=314",
        )

    def test_payment_methods_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_methods",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_methods.create(
            {
                "type": "card",
                "card": {
                    "number": "4242424242424242",
                    "exp_month": 8,
                    "exp_year": 2024,
                    "cvc": "314",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=card&card[number]=4242424242424242&card[exp_month]=8&card[exp_year]=2024&card[cvc]=314",
        )

    @pytest.mark.anyio
    async def test_payment_methods_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentMethod.create_async(
            type="card",
            card={
                "number": "4242424242424242",
                "exp_month": 8,
                "exp_year": 2024,
                "cvc": "314",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods",
            query_string="",
            post_data="type=card&card[number]=4242424242424242&card[exp_month]=8&card[exp_year]=2024&card[cvc]=314",
        )

    @pytest.mark.anyio
    async def test_payment_methods_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_methods",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_methods.create_async(
            {
                "type": "card",
                "card": {
                    "number": "4242424242424242",
                    "exp_month": 8,
                    "exp_year": 2024,
                    "cvc": "314",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=card&card[number]=4242424242424242&card[exp_month]=8&card[exp_year]=2024&card[cvc]=314",
        )

    def test_payment_methods_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PaymentMethod.modify(
            "pm_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_payment_methods_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_methods/pm_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payment_methods.update(
            "pm_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_payment_methods_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PaymentMethod.modify_async(
            "pm_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_payment_methods_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payment_methods/pm_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payment_methods.update_async(
            "pm_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payment_methods/pm_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_payouts_cancel_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Payout.cancel("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    def test_payouts_cancel_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payouts/po_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payouts.cancel("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payouts_cancel_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Payout.cancel_async("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payouts_cancel_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payouts/po_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payouts.cancel_async("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payouts_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Payout.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/payouts",
            query_string="limit=3",
        )

    def test_payouts_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payouts",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payouts.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/payouts",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payouts_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Payout.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/payouts",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_payouts_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payouts",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payouts.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/payouts",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_payouts_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Payout.retrieve("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payouts/po_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_payouts_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payouts/po_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payouts.retrieve("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payouts/po_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payouts_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Payout.retrieve_async("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payouts/po_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payouts_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/payouts/po_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payouts.retrieve_async("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/payouts/po_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_payouts_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Payout.create(
            amount=1100,
            currency="usd",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts",
            query_string="",
            post_data="amount=1100&currency=usd",
        )

    def test_payouts_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payouts",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payouts.create({"amount": 1100, "currency": "usd"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=1100&currency=usd",
        )

    @pytest.mark.anyio
    async def test_payouts_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Payout.create_async(
            amount=1100,
            currency="usd",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts",
            query_string="",
            post_data="amount=1100&currency=usd",
        )

    @pytest.mark.anyio
    async def test_payouts_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payouts",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payouts.create_async({"amount": 1100, "currency": "usd"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=1100&currency=usd",
        )

    def test_payouts_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Payout.modify(
            "po_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_payouts_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payouts/po_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payouts.update(
            "po_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_payouts_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Payout.modify_async(
            "po_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_payouts_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payouts/po_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payouts.update_async(
            "po_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_payouts_reverse_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Payout.reverse("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx/reverse",
            query_string="",
        )

    def test_payouts_reverse_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payouts/po_xxxxxxxxxxxxx/reverse",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.payouts.reverse("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx/reverse",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_payouts_reverse_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Payout.reverse_async("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx/reverse",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_payouts_reverse_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/payouts/po_xxxxxxxxxxxxx/reverse",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.payouts.reverse_async("po_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/payouts/po_xxxxxxxxxxxxx/reverse",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_plans_delete(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Plan.delete("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_plans_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/plans/price_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.plans.delete("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_plans_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Plan.delete_async("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_plans_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/plans/price_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.plans.delete_async("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_plans_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Plan.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/plans",
            query_string="limit=3",
        )

    def test_plans_get_service(self, http_client_mock: HTTPClientMock) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/plans",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.plans.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/plans",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_plans_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Plan.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/plans",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_plans_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/plans",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.plans.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/plans",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_plans_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Plan.retrieve("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_plans_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/plans/price_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.plans.retrieve("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_plans_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Plan.retrieve_async("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_plans_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/plans/price_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.plans.retrieve_async("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_plans_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Plan.create(
            amount=2000,
            currency="usd",
            interval="month",
            product="prod_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans",
            query_string="",
            post_data="amount=2000&currency=usd&interval=month&product=prod_xxxxxxxxxxxxx",
        )

    def test_plans_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/plans",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.plans.create(
            {
                "amount": 2000,
                "currency": "usd",
                "interval": "month",
                "product": "prod_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2000&currency=usd&interval=month&product=prod_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_plans_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Plan.create_async(
            amount=2000,
            currency="usd",
            interval="month",
            product="prod_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans",
            query_string="",
            post_data="amount=2000&currency=usd&interval=month&product=prod_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_plans_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/plans",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.plans.create_async(
            {
                "amount": 2000,
                "currency": "usd",
                "interval": "month",
                "product": "prod_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2000&currency=usd&interval=month&product=prod_xxxxxxxxxxxxx",
        )

    def test_plans_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Plan.create(
            amount=2000,
            currency="usd",
            interval="month",
            product={"name": "My product"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans",
            query_string="",
            post_data="amount=2000&currency=usd&interval=month&product[name]=My%20product",
        )

    def test_plans_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/plans",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.plans.create(
            {
                "amount": 2000,
                "currency": "usd",
                "interval": "month",
                "product": {"name": "My product"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2000&currency=usd&interval=month&product[name]=My%20product",
        )

    @pytest.mark.anyio
    async def test_plans_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Plan.create_async(
            amount=2000,
            currency="usd",
            interval="month",
            product={"name": "My product"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans",
            query_string="",
            post_data="amount=2000&currency=usd&interval=month&product[name]=My%20product",
        )

    @pytest.mark.anyio
    async def test_plans_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/plans",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.plans.create_async(
            {
                "amount": 2000,
                "currency": "usd",
                "interval": "month",
                "product": {"name": "My product"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2000&currency=usd&interval=month&product[name]=My%20product",
        )

    def test_plans_post_3(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Plan.modify(
            "price_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_plans_post_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/plans/price_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.plans.update(
            "price_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_plans_post_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Plan.modify_async(
            "price_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_plans_post_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/plans/price_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.plans.update_async(
            "price_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/plans/price_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_prices_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Price.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices",
            query_string="limit=3",
        )

    def test_prices_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/prices",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.prices.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_prices_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Price.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_prices_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/prices",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.prices.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_prices_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Price.retrieve("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices/price_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_prices_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/prices/price_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.prices.retrieve("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices/price_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_prices_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Price.retrieve_async("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices/price_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_prices_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/prices/price_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.prices.retrieve_async("price_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices/price_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_prices_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Price.create(
            unit_amount=2000,
            currency="usd",
            currency_options={
                "uah": {"unit_amount": 5000},
                "eur": {"unit_amount": 1800},
            },
            recurring={"interval": "month"},
            product="prod_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices",
            query_string="",
            post_data="unit_amount=2000&currency=usd&currency_options[uah][unit_amount]=5000&currency_options[eur][unit_amount]=1800&recurring[interval]=month&product=prod_xxxxxxxxxxxxx",
        )

    def test_prices_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/prices",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.prices.create(
            {
                "unit_amount": 2000,
                "currency": "usd",
                "currency_options": {
                    "uah": {"unit_amount": 5000},
                    "eur": {"unit_amount": 1800},
                },
                "recurring": {"interval": "month"},
                "product": "prod_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="unit_amount=2000&currency=usd&currency_options[uah][unit_amount]=5000&currency_options[eur][unit_amount]=1800&recurring[interval]=month&product=prod_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_prices_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Price.create_async(
            unit_amount=2000,
            currency="usd",
            currency_options={
                "uah": {"unit_amount": 5000},
                "eur": {"unit_amount": 1800},
            },
            recurring={"interval": "month"},
            product="prod_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices",
            query_string="",
            post_data="unit_amount=2000&currency=usd&currency_options[uah][unit_amount]=5000&currency_options[eur][unit_amount]=1800&recurring[interval]=month&product=prod_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_prices_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/prices",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.prices.create_async(
            {
                "unit_amount": 2000,
                "currency": "usd",
                "currency_options": {
                    "uah": {"unit_amount": 5000},
                    "eur": {"unit_amount": 1800},
                },
                "recurring": {"interval": "month"},
                "product": "prod_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="unit_amount=2000&currency=usd&currency_options[uah][unit_amount]=5000&currency_options[eur][unit_amount]=1800&recurring[interval]=month&product=prod_xxxxxxxxxxxxx",
        )

    def test_prices_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Price.create(
            unit_amount=2000,
            currency="usd",
            recurring={"interval": "month"},
            product="prod_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices",
            query_string="",
            post_data="unit_amount=2000&currency=usd&recurring[interval]=month&product=prod_xxxxxxxxxxxxx",
        )

    def test_prices_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/prices",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.prices.create(
            {
                "unit_amount": 2000,
                "currency": "usd",
                "recurring": {"interval": "month"},
                "product": "prod_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="unit_amount=2000&currency=usd&recurring[interval]=month&product=prod_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_prices_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Price.create_async(
            unit_amount=2000,
            currency="usd",
            recurring={"interval": "month"},
            product="prod_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices",
            query_string="",
            post_data="unit_amount=2000&currency=usd&recurring[interval]=month&product=prod_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_prices_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/prices",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.prices.create_async(
            {
                "unit_amount": 2000,
                "currency": "usd",
                "recurring": {"interval": "month"},
                "product": "prod_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="unit_amount=2000&currency=usd&recurring[interval]=month&product=prod_xxxxxxxxxxxxx",
        )

    def test_prices_post_3(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Price.modify(
            "price_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices/price_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_prices_post_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/prices/price_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.prices.update(
            "price_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices/price_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_prices_post_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Price.modify_async(
            "price_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices/price_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_prices_post_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/prices/price_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.prices.update_async(
            "price_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/prices/price_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_prices_search_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Price.search(
            query="active:'true' AND metadata['order_id']:'6735'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices/search",
            query_string="query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    def test_prices_search_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/prices/search",
            "query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.prices.search(
            {
                "query": "active:'true' AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices/search",
            query_string="query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_prices_search_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Price.search_async(
            query="active:'true' AND metadata['order_id']:'6735'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices/search",
            query_string="query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    @pytest.mark.anyio
    async def test_prices_search_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/prices/search",
            "query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.prices.search_async(
            {
                "query": "active:'true' AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/prices/search",
            query_string="query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    def test_products_delete(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Product.delete("prod_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_products_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/products/prod_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.products.delete("prod_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_products_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Product.delete_async("prod_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_products_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/products/prod_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.products.delete_async("prod_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_products_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Product.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/products",
            query_string="limit=3",
        )

    def test_products_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/products",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.products.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/products",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_products_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Product.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/products",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_products_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/products",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.products.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/products",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_products_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Product.retrieve("prod_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_products_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/products/prod_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.products.retrieve("prod_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_products_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Product.retrieve_async("prod_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_products_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/products/prod_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.products.retrieve_async("prod_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_products_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Product.create(name="Gold Special")
        http_client_mock.assert_requested(
            "post",
            path="/v1/products",
            query_string="",
            post_data="name=Gold%20Special",
        )

    def test_products_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/products",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.products.create({"name": "Gold Special"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/products",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=Gold%20Special",
        )

    @pytest.mark.anyio
    async def test_products_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Product.create_async(name="Gold Special")
        http_client_mock.assert_requested(
            "post",
            path="/v1/products",
            query_string="",
            post_data="name=Gold%20Special",
        )

    @pytest.mark.anyio
    async def test_products_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/products",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.products.create_async({"name": "Gold Special"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/products",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=Gold%20Special",
        )

    def test_products_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Product.modify(
            "prod_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_products_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/products/prod_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.products.update(
            "prod_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_products_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Product.modify_async(
            "prod_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_products_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/products/prod_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.products.update_async(
            "prod_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/products/prod_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_products_search_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Product.search(
            query="active:'true' AND metadata['order_id']:'6735'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/products/search",
            query_string="query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    def test_products_search_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/products/search",
            "query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.products.search(
            {
                "query": "active:'true' AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/products/search",
            query_string="query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_products_search_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Product.search_async(
            query="active:'true' AND metadata['order_id']:'6735'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/products/search",
            query_string="query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    @pytest.mark.anyio
    async def test_products_search_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/products/search",
            "query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.products.search_async(
            {
                "query": "active:'true' AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/products/search",
            query_string="query=active%3A%27true%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    def test_promotion_codes_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PromotionCode.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/promotion_codes",
            query_string="limit=3",
        )

    def test_promotion_codes_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/promotion_codes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.promotion_codes.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/promotion_codes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_promotion_codes_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PromotionCode.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/promotion_codes",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_promotion_codes_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/promotion_codes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.promotion_codes.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/promotion_codes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_promotion_codes_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PromotionCode.retrieve("promo_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/promotion_codes/promo_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_promotion_codes_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/promotion_codes/promo_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.promotion_codes.retrieve("promo_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/promotion_codes/promo_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_promotion_codes_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PromotionCode.retrieve_async("promo_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/promotion_codes/promo_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_promotion_codes_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/promotion_codes/promo_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.promotion_codes.retrieve_async("promo_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/promotion_codes/promo_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_promotion_codes_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PromotionCode.create(coupon="Z4OV52SU")
        http_client_mock.assert_requested(
            "post",
            path="/v1/promotion_codes",
            query_string="",
            post_data="coupon=Z4OV52SU",
        )

    def test_promotion_codes_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/promotion_codes",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.promotion_codes.create({"coupon": "Z4OV52SU"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/promotion_codes",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="coupon=Z4OV52SU",
        )

    @pytest.mark.anyio
    async def test_promotion_codes_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PromotionCode.create_async(coupon="Z4OV52SU")
        http_client_mock.assert_requested(
            "post",
            path="/v1/promotion_codes",
            query_string="",
            post_data="coupon=Z4OV52SU",
        )

    @pytest.mark.anyio
    async def test_promotion_codes_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/promotion_codes",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.promotion_codes.create_async({"coupon": "Z4OV52SU"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/promotion_codes",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="coupon=Z4OV52SU",
        )

    def test_promotion_codes_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.PromotionCode.modify(
            "promo_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/promotion_codes/promo_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_promotion_codes_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/promotion_codes/promo_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.promotion_codes.update(
            "promo_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/promotion_codes/promo_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_promotion_codes_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.PromotionCode.modify_async(
            "promo_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/promotion_codes/promo_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_promotion_codes_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/promotion_codes/promo_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.promotion_codes.update_async(
            "promo_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/promotion_codes/promo_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_quotes_accept_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Quote.accept("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/accept",
            query_string="",
        )

    def test_quotes_accept_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/quotes/qt_xxxxxxxxxxxxx/accept",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.quotes.accept("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/accept",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_quotes_accept_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Quote.accept_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/accept",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_quotes_accept_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/quotes/qt_xxxxxxxxxxxxx/accept",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.quotes.accept_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/accept",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_quotes_cancel_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Quote.cancel("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    def test_quotes_cancel_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/quotes/qt_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.quotes.cancel("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_quotes_cancel_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Quote.cancel_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_quotes_cancel_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/quotes/qt_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.quotes.cancel_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_quotes_finalize_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Quote.finalize_quote("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/finalize",
            query_string="",
        )

    def test_quotes_finalize_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/quotes/qt_xxxxxxxxxxxxx/finalize",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.quotes.finalize_quote("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/finalize",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_quotes_finalize_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Quote.finalize_quote_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/finalize",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_quotes_finalize_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/quotes/qt_xxxxxxxxxxxxx/finalize",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.quotes.finalize_quote_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/finalize",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_quotes_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Quote.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes",
            query_string="limit=3",
        )

    def test_quotes_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/quotes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.quotes.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_quotes_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Quote.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_quotes_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/quotes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.quotes.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_quotes_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Quote.retrieve("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_quotes_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/quotes/qt_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.quotes.retrieve("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_quotes_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Quote.retrieve_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_quotes_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/quotes/qt_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.quotes.retrieve_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_quotes_line_items_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Quote.list_line_items("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/line_items",
            query_string="",
        )

    def test_quotes_line_items_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/quotes/qt_xxxxxxxxxxxxx/line_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.quotes.line_items.list("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/line_items",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_quotes_line_items_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Quote.list_line_items_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/line_items",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_quotes_line_items_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/quotes/qt_xxxxxxxxxxxxx/line_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.quotes.line_items.list_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/line_items",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_quotes_pdf_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Quote.pdf("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/pdf",
            query_string="",
        )

    def test_quotes_pdf_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/quotes/qt_xxxxxxxxxxxxx/pdf",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.quotes.pdf("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/pdf",
            query_string="",
            api_base="https://files.stripe.com",
        )

    @pytest.mark.anyio
    async def test_quotes_pdf_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Quote.pdf_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/pdf",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_quotes_pdf_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/quotes/qt_xxxxxxxxxxxxx/pdf",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.quotes.pdf_async("qt_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xxxxxxxxxxxxx/pdf",
            query_string="",
            api_base="https://files.stripe.com",
        )

    def test_quotes_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Quote.create(
            customer="cus_xxxxxxxxxxxxx",
            line_items=[{"price": "price_xxxxxxxxxxxxx", "quantity": 2}],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx&line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=2",
        )

    def test_quotes_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/quotes",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.quotes.create(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "line_items": [
                    {"price": "price_xxxxxxxxxxxxx", "quantity": 2}
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx&line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=2",
        )

    @pytest.mark.anyio
    async def test_quotes_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Quote.create_async(
            customer="cus_xxxxxxxxxxxxx",
            line_items=[{"price": "price_xxxxxxxxxxxxx", "quantity": 2}],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx&line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=2",
        )

    @pytest.mark.anyio
    async def test_quotes_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/quotes",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.quotes.create_async(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "line_items": [
                    {"price": "price_xxxxxxxxxxxxx", "quantity": 2}
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx&line_items[0][price]=price_xxxxxxxxxxxxx&line_items[0][quantity]=2",
        )

    def test_quotes_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Quote.modify(
            "qt_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_quotes_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/quotes/qt_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.quotes.update(
            "qt_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_quotes_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Quote.modify_async(
            "qt_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_quotes_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/quotes/qt_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.quotes.update_async(
            "qt_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/quotes/qt_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_quotes_preview_invoices_lines_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Quote.list_preview_invoice_lines(
            "qt_xyz",
            "in_xyz",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xyz/preview_invoices/in_xyz/lines",
            query_string="",
        )

    def test_quotes_preview_invoices_lines_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/quotes/qt_xyz/preview_invoices/in_xyz/lines",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.quotes.list_preview_invoice_lines(
            "qt_xyz",
            "in_xyz",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xyz/preview_invoices/in_xyz/lines",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_quotes_preview_invoices_lines_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Quote.list_preview_invoice_lines_async(
            "qt_xyz",
            "in_xyz",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xyz/preview_invoices/in_xyz/lines",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_quotes_preview_invoices_lines_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/quotes/qt_xyz/preview_invoices/in_xyz/lines",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.quotes.list_preview_invoice_lines_async(
            "qt_xyz",
            "in_xyz",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/quotes/qt_xyz/preview_invoices/in_xyz/lines",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_radar_early_fraud_warnings_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.EarlyFraudWarning.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/early_fraud_warnings",
            query_string="limit=3",
        )

    def test_radar_early_fraud_warnings_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/early_fraud_warnings",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.early_fraud_warnings.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/early_fraud_warnings",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_radar_early_fraud_warnings_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.EarlyFraudWarning.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/early_fraud_warnings",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_radar_early_fraud_warnings_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/early_fraud_warnings",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.early_fraud_warnings.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/early_fraud_warnings",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_radar_early_fraud_warnings_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.EarlyFraudWarning.retrieve("issfr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/early_fraud_warnings/issfr_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_radar_early_fraud_warnings_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/early_fraud_warnings/issfr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.early_fraud_warnings.retrieve("issfr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/early_fraud_warnings/issfr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_radar_early_fraud_warnings_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.EarlyFraudWarning.retrieve_async(
            "issfr_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/early_fraud_warnings/issfr_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_radar_early_fraud_warnings_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/early_fraud_warnings/issfr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.early_fraud_warnings.retrieve_async(
            "issfr_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/early_fraud_warnings/issfr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_radar_value_list_items_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.ValueListItem.delete("rsli_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_radar_value_list_items_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.value_list_items.delete("rsli_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_radar_value_list_items_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.ValueListItem.delete_async("rsli_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_radar_value_list_items_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.value_list_items.delete_async("rsli_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_radar_value_list_items_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.ValueListItem.list(
            limit=3,
            value_list="rsl_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_list_items",
            query_string="limit=3&value_list=rsl_xxxxxxxxxxxxx",
        )

    def test_radar_value_list_items_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/value_list_items",
            "limit=3&value_list=rsl_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.value_list_items.list(
            {
                "limit": 3,
                "value_list": "rsl_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_list_items",
            query_string="limit=3&value_list=rsl_xxxxxxxxxxxxx",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_radar_value_list_items_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.ValueListItem.list_async(
            limit=3,
            value_list="rsl_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_list_items",
            query_string="limit=3&value_list=rsl_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_radar_value_list_items_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/value_list_items",
            "limit=3&value_list=rsl_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.value_list_items.list_async(
            {
                "limit": 3,
                "value_list": "rsl_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_list_items",
            query_string="limit=3&value_list=rsl_xxxxxxxxxxxxx",
            api_base="https://api.stripe.com",
        )

    def test_radar_value_list_items_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.ValueListItem.retrieve("rsli_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_radar_value_list_items_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.value_list_items.retrieve("rsli_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_radar_value_list_items_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.ValueListItem.retrieve_async("rsli_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_radar_value_list_items_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.value_list_items.retrieve_async(
            "rsli_xxxxxxxxxxxxx"
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_list_items/rsli_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_radar_value_list_items_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.ValueListItem.create(
            value_list="rsl_xxxxxxxxxxxxx",
            value="1.2.3.4",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_list_items",
            query_string="",
            post_data="value_list=rsl_xxxxxxxxxxxxx&value=1.2.3.4",
        )

    def test_radar_value_list_items_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/radar/value_list_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.value_list_items.create(
            {
                "value_list": "rsl_xxxxxxxxxxxxx",
                "value": "1.2.3.4",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_list_items",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="value_list=rsl_xxxxxxxxxxxxx&value=1.2.3.4",
        )

    @pytest.mark.anyio
    async def test_radar_value_list_items_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.ValueListItem.create_async(
            value_list="rsl_xxxxxxxxxxxxx",
            value="1.2.3.4",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_list_items",
            query_string="",
            post_data="value_list=rsl_xxxxxxxxxxxxx&value=1.2.3.4",
        )

    @pytest.mark.anyio
    async def test_radar_value_list_items_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/radar/value_list_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.value_list_items.create_async(
            {
                "value_list": "rsl_xxxxxxxxxxxxx",
                "value": "1.2.3.4",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_list_items",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="value_list=rsl_xxxxxxxxxxxxx&value=1.2.3.4",
        )

    def test_radar_value_lists_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.ValueList.delete("rsl_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_radar_value_lists_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.value_lists.delete("rsl_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_radar_value_lists_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.ValueList.delete_async("rsl_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_radar_value_lists_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.value_lists.delete_async("rsl_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_radar_value_lists_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.ValueList.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_lists",
            query_string="limit=3",
        )

    def test_radar_value_lists_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/value_lists",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.value_lists.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_lists",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_radar_value_lists_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.ValueList.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_lists",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_radar_value_lists_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/value_lists",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.value_lists.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_lists",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_radar_value_lists_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.ValueList.retrieve("rsl_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_radar_value_lists_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.value_lists.retrieve("rsl_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_radar_value_lists_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.ValueList.retrieve_async("rsl_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_radar_value_lists_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.value_lists.retrieve_async("rsl_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_radar_value_lists_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.ValueList.create(
            alias="custom_ip_xxxxxxxxxxxxx",
            name="Custom IP Blocklist",
            item_type="ip_address",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_lists",
            query_string="",
            post_data="alias=custom_ip_xxxxxxxxxxxxx&name=Custom%20IP%20Blocklist&item_type=ip_address",
        )

    def test_radar_value_lists_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/radar/value_lists",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.value_lists.create(
            {
                "alias": "custom_ip_xxxxxxxxxxxxx",
                "name": "Custom IP Blocklist",
                "item_type": "ip_address",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_lists",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="alias=custom_ip_xxxxxxxxxxxxx&name=Custom%20IP%20Blocklist&item_type=ip_address",
        )

    @pytest.mark.anyio
    async def test_radar_value_lists_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.ValueList.create_async(
            alias="custom_ip_xxxxxxxxxxxxx",
            name="Custom IP Blocklist",
            item_type="ip_address",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_lists",
            query_string="",
            post_data="alias=custom_ip_xxxxxxxxxxxxx&name=Custom%20IP%20Blocklist&item_type=ip_address",
        )

    @pytest.mark.anyio
    async def test_radar_value_lists_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/radar/value_lists",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.value_lists.create_async(
            {
                "alias": "custom_ip_xxxxxxxxxxxxx",
                "name": "Custom IP Blocklist",
                "item_type": "ip_address",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_lists",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="alias=custom_ip_xxxxxxxxxxxxx&name=Custom%20IP%20Blocklist&item_type=ip_address",
        )

    def test_radar_value_lists_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.radar.ValueList.modify(
            "rsl_xxxxxxxxxxxxx",
            name="Updated IP Block List",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
            post_data="name=Updated%20IP%20Block%20List",
        )

    def test_radar_value_lists_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.radar.value_lists.update(
            "rsl_xxxxxxxxxxxxx",
            {"name": "Updated IP Block List"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=Updated%20IP%20Block%20List",
        )

    @pytest.mark.anyio
    async def test_radar_value_lists_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.radar.ValueList.modify_async(
            "rsl_xxxxxxxxxxxxx",
            name="Updated IP Block List",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
            post_data="name=Updated%20IP%20Block%20List",
        )

    @pytest.mark.anyio
    async def test_radar_value_lists_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.radar.value_lists.update_async(
            "rsl_xxxxxxxxxxxxx",
            {"name": "Updated IP Block List"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/radar/value_lists/rsl_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="name=Updated%20IP%20Block%20List",
        )

    def test_refunds_cancel_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Refund.cancel("re_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds/re_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    def test_refunds_cancel_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/refunds/re_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.refunds.cancel("re_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds/re_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_refunds_cancel_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Refund.cancel_async("re_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds/re_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_refunds_cancel_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/refunds/re_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.refunds.cancel_async("re_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds/re_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_refunds_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Refund.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/refunds",
            query_string="limit=3",
        )

    def test_refunds_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/refunds",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.refunds.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/refunds",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_refunds_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Refund.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/refunds",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_refunds_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/refunds",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.refunds.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/refunds",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_refunds_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Refund.retrieve("re_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/refunds/re_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_refunds_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/refunds/re_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.refunds.retrieve("re_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/refunds/re_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_refunds_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Refund.retrieve_async("re_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/refunds/re_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_refunds_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/refunds/re_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.refunds.retrieve_async("re_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/refunds/re_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_refunds_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Refund.create(charge="ch_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds",
            query_string="",
            post_data="charge=ch_xxxxxxxxxxxxx",
        )

    def test_refunds_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/refunds",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.refunds.create({"charge": "ch_xxxxxxxxxxxxx"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="charge=ch_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_refunds_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Refund.create_async(charge="ch_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds",
            query_string="",
            post_data="charge=ch_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_refunds_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/refunds",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.refunds.create_async({"charge": "ch_xxxxxxxxxxxxx"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="charge=ch_xxxxxxxxxxxxx",
        )

    def test_refunds_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Refund.modify(
            "re_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds/re_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_refunds_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/refunds/re_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.refunds.update(
            "re_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds/re_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_refunds_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Refund.modify_async(
            "re_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds/re_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_refunds_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/refunds/re_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.refunds.update_async(
            "re_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/refunds/re_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_reporting_report_runs_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.reporting.ReportRun.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_runs",
            query_string="limit=3",
        )

    def test_reporting_report_runs_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reporting/report_runs",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.reporting.report_runs.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_runs",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_reporting_report_runs_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.reporting.ReportRun.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_runs",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_reporting_report_runs_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reporting/report_runs",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.reporting.report_runs.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_runs",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_reporting_report_runs_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.reporting.ReportRun.retrieve("frr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_runs/frr_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_reporting_report_runs_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reporting/report_runs/frr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.reporting.report_runs.retrieve("frr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_runs/frr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_reporting_report_runs_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.reporting.ReportRun.retrieve_async("frr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_runs/frr_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_reporting_report_runs_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reporting/report_runs/frr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.reporting.report_runs.retrieve_async("frr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_runs/frr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_reporting_report_runs_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.reporting.ReportRun.create(
            report_type="balance.summary.1",
            parameters={
                "interval_start": 1522540800,
                "interval_end": 1525132800,
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/reporting/report_runs",
            query_string="",
            post_data="report_type=balance.summary.1&parameters[interval_start]=1522540800&parameters[interval_end]=1525132800",
        )

    def test_reporting_report_runs_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/reporting/report_runs",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.reporting.report_runs.create(
            {
                "report_type": "balance.summary.1",
                "parameters": {
                    "interval_start": 1522540800,
                    "interval_end": 1525132800,
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/reporting/report_runs",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="report_type=balance.summary.1&parameters[interval_start]=1522540800&parameters[interval_end]=1525132800",
        )

    @pytest.mark.anyio
    async def test_reporting_report_runs_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.reporting.ReportRun.create_async(
            report_type="balance.summary.1",
            parameters={
                "interval_start": 1522540800,
                "interval_end": 1525132800,
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/reporting/report_runs",
            query_string="",
            post_data="report_type=balance.summary.1&parameters[interval_start]=1522540800&parameters[interval_end]=1525132800",
        )

    @pytest.mark.anyio
    async def test_reporting_report_runs_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/reporting/report_runs",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.reporting.report_runs.create_async(
            {
                "report_type": "balance.summary.1",
                "parameters": {
                    "interval_start": 1522540800,
                    "interval_end": 1525132800,
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/reporting/report_runs",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="report_type=balance.summary.1&parameters[interval_start]=1522540800&parameters[interval_end]=1525132800",
        )

    def test_reporting_report_types_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.reporting.ReportType.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_types",
            query_string="",
        )

    def test_reporting_report_types_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reporting/report_types",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.reporting.report_types.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_types",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_reporting_report_types_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.reporting.ReportType.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_types",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_reporting_report_types_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reporting/report_types",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.reporting.report_types.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_types",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_reporting_report_types_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.reporting.ReportType.retrieve("balance.summary.1")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_types/balance.summary.1",
            query_string="",
        )

    def test_reporting_report_types_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reporting/report_types/balance.summary.1",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.reporting.report_types.retrieve("balance.summary.1")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_types/balance.summary.1",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_reporting_report_types_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.reporting.ReportType.retrieve_async("balance.summary.1")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_types/balance.summary.1",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_reporting_report_types_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reporting/report_types/balance.summary.1",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.reporting.report_types.retrieve_async("balance.summary.1")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reporting/report_types/balance.summary.1",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_reviews_approve_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Review.approve("prv_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/reviews/prv_xxxxxxxxxxxxx/approve",
            query_string="",
        )

    def test_reviews_approve_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/reviews/prv_xxxxxxxxxxxxx/approve",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.reviews.approve("prv_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/reviews/prv_xxxxxxxxxxxxx/approve",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_reviews_approve_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Review.approve_async("prv_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/reviews/prv_xxxxxxxxxxxxx/approve",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_reviews_approve_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/reviews/prv_xxxxxxxxxxxxx/approve",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.reviews.approve_async("prv_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/reviews/prv_xxxxxxxxxxxxx/approve",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_reviews_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Review.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/reviews",
            query_string="limit=3",
        )

    def test_reviews_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reviews",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.reviews.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/reviews",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_reviews_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Review.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/reviews",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_reviews_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reviews",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.reviews.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/reviews",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_reviews_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Review.retrieve("prv_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reviews/prv_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_reviews_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reviews/prv_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.reviews.retrieve("prv_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reviews/prv_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_reviews_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Review.retrieve_async("prv_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reviews/prv_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_reviews_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/reviews/prv_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.reviews.retrieve_async("prv_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/reviews/prv_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_setup_attempts_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SetupAttempt.list(
            limit=3,
            setup_intent="si_xyz",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_attempts",
            query_string="limit=3&setup_intent=si_xyz",
        )

    def test_setup_attempts_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/setup_attempts",
            "limit=3&setup_intent=si_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.setup_attempts.list({"limit": 3, "setup_intent": "si_xyz"})
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_attempts",
            query_string="limit=3&setup_intent=si_xyz",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_setup_attempts_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SetupAttempt.list_async(
            limit=3,
            setup_intent="si_xyz",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_attempts",
            query_string="limit=3&setup_intent=si_xyz",
        )

    @pytest.mark.anyio
    async def test_setup_attempts_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/setup_attempts",
            "limit=3&setup_intent=si_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.setup_attempts.list_async(
            {
                "limit": 3,
                "setup_intent": "si_xyz",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_attempts",
            query_string="limit=3&setup_intent=si_xyz",
            api_base="https://api.stripe.com",
        )

    def test_setup_intents_cancel_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SetupIntent.cancel("seti_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    def test_setup_intents_cancel_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.setup_intents.cancel("seti_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_setup_intents_cancel_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SetupIntent.cancel_async("seti_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_setup_intents_cancel_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.setup_intents.cancel_async("seti_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_setup_intents_confirm_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SetupIntent.confirm(
            "seti_xxxxxxxxxxxxx",
            payment_method="pm_card_visa",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/confirm",
            query_string="",
            post_data="payment_method=pm_card_visa",
        )

    def test_setup_intents_confirm_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx/confirm",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.setup_intents.confirm(
            "seti_xxxxxxxxxxxxx",
            {"payment_method": "pm_card_visa"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/confirm",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="payment_method=pm_card_visa",
        )

    @pytest.mark.anyio
    async def test_setup_intents_confirm_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SetupIntent.confirm_async(
            "seti_xxxxxxxxxxxxx",
            payment_method="pm_card_visa",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/confirm",
            query_string="",
            post_data="payment_method=pm_card_visa",
        )

    @pytest.mark.anyio
    async def test_setup_intents_confirm_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx/confirm",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.setup_intents.confirm_async(
            "seti_xxxxxxxxxxxxx",
            {"payment_method": "pm_card_visa"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/confirm",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="payment_method=pm_card_visa",
        )

    def test_setup_intents_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.SetupIntent.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_intents",
            query_string="limit=3",
        )

    def test_setup_intents_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/setup_intents",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.setup_intents.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_intents",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_setup_intents_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SetupIntent.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_intents",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_setup_intents_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/setup_intents",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.setup_intents.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_intents",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_setup_intents_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SetupIntent.retrieve("seti_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_setup_intents_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.setup_intents.retrieve("seti_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_setup_intents_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SetupIntent.retrieve_async("seti_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_setup_intents_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.setup_intents.retrieve_async("seti_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_setup_intents_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SetupIntent.create(payment_method_types=["card"])
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents",
            query_string="",
            post_data="payment_method_types[0]=card",
        )

    def test_setup_intents_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.setup_intents.create({"payment_method_types": ["card"]})
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="payment_method_types[0]=card",
        )

    @pytest.mark.anyio
    async def test_setup_intents_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SetupIntent.create_async(payment_method_types=["card"])
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents",
            query_string="",
            post_data="payment_method_types[0]=card",
        )

    @pytest.mark.anyio
    async def test_setup_intents_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.setup_intents.create_async(
            {
                "payment_method_types": ["card"],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="payment_method_types[0]=card",
        )

    def test_setup_intents_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SetupIntent.modify(
            "seti_xxxxxxxxxxxxx",
            metadata={"user_id": "3435453"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[user_id]=3435453",
        )

    def test_setup_intents_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.setup_intents.update(
            "seti_xxxxxxxxxxxxx",
            {"metadata": {"user_id": "3435453"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[user_id]=3435453",
        )

    @pytest.mark.anyio
    async def test_setup_intents_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SetupIntent.modify_async(
            "seti_xxxxxxxxxxxxx",
            metadata={"user_id": "3435453"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[user_id]=3435453",
        )

    @pytest.mark.anyio
    async def test_setup_intents_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.setup_intents.update_async(
            "seti_xxxxxxxxxxxxx",
            {"metadata": {"user_id": "3435453"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[user_id]=3435453",
        )

    def test_setup_intents_verify_microdeposits_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SetupIntent.verify_microdeposits("seti_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
        )

    def test_setup_intents_verify_microdeposits_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.setup_intents.verify_microdeposits("seti_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_setup_intents_verify_microdeposits_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SetupIntent.verify_microdeposits_async(
            "seti_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_setup_intents_verify_microdeposits_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.setup_intents.verify_microdeposits_async(
            "seti_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_setup_intents_verify_microdeposits_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SetupIntent.verify_microdeposits(
            "seti_xxxxxxxxxxxxx",
            amounts=[32, 45],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            post_data="amounts[0]=32&amounts[1]=45",
        )

    def test_setup_intents_verify_microdeposits_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.setup_intents.verify_microdeposits(
            "seti_xxxxxxxxxxxxx",
            {"amounts": [32, 45]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amounts[0]=32&amounts[1]=45",
        )

    @pytest.mark.anyio
    async def test_setup_intents_verify_microdeposits_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SetupIntent.verify_microdeposits_async(
            "seti_xxxxxxxxxxxxx",
            amounts=[32, 45],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            post_data="amounts[0]=32&amounts[1]=45",
        )

    @pytest.mark.anyio
    async def test_setup_intents_verify_microdeposits_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.setup_intents.verify_microdeposits_async(
            "seti_xxxxxxxxxxxxx",
            {"amounts": [32, 45]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/setup_intents/seti_xxxxxxxxxxxxx/verify_microdeposits",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amounts[0]=32&amounts[1]=45",
        )

    def test_shipping_rates_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ShippingRate.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates",
            query_string="",
        )

    def test_shipping_rates_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/shipping_rates",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.shipping_rates.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ShippingRate.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/shipping_rates",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.shipping_rates.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_shipping_rates_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ShippingRate.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates",
            query_string="limit=3",
        )

    def test_shipping_rates_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/shipping_rates",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.shipping_rates.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ShippingRate.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/shipping_rates",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.shipping_rates.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_shipping_rates_get_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ShippingRate.retrieve("shr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates/shr_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_shipping_rates_get_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/shipping_rates/shr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.shipping_rates.retrieve("shr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates/shr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_get_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ShippingRate.retrieve_async("shr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates/shr_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_get_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/shipping_rates/shr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.shipping_rates.retrieve_async("shr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/shipping_rates/shr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_shipping_rates_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ShippingRate.create(
            display_name="Sample Shipper",
            fixed_amount={"currency": "usd", "amount": 400},
            type="fixed_amount",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates",
            query_string="",
            post_data="display_name=Sample%20Shipper&fixed_amount[currency]=usd&fixed_amount[amount]=400&type=fixed_amount",
        )

    def test_shipping_rates_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/shipping_rates",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.shipping_rates.create(
            {
                "display_name": "Sample Shipper",
                "fixed_amount": {"currency": "usd", "amount": 400},
                "type": "fixed_amount",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="display_name=Sample%20Shipper&fixed_amount[currency]=usd&fixed_amount[amount]=400&type=fixed_amount",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ShippingRate.create_async(
            display_name="Sample Shipper",
            fixed_amount={"currency": "usd", "amount": 400},
            type="fixed_amount",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates",
            query_string="",
            post_data="display_name=Sample%20Shipper&fixed_amount[currency]=usd&fixed_amount[amount]=400&type=fixed_amount",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/shipping_rates",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.shipping_rates.create_async(
            {
                "display_name": "Sample Shipper",
                "fixed_amount": {"currency": "usd", "amount": 400},
                "type": "fixed_amount",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="display_name=Sample%20Shipper&fixed_amount[currency]=usd&fixed_amount[amount]=400&type=fixed_amount",
        )

    def test_shipping_rates_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ShippingRate.create(
            display_name="Ground shipping",
            type="fixed_amount",
            fixed_amount={"amount": 500, "currency": "usd"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates",
            query_string="",
            post_data="display_name=Ground%20shipping&type=fixed_amount&fixed_amount[amount]=500&fixed_amount[currency]=usd",
        )

    def test_shipping_rates_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/shipping_rates",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.shipping_rates.create(
            {
                "display_name": "Ground shipping",
                "type": "fixed_amount",
                "fixed_amount": {"amount": 500, "currency": "usd"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="display_name=Ground%20shipping&type=fixed_amount&fixed_amount[amount]=500&fixed_amount[currency]=usd",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ShippingRate.create_async(
            display_name="Ground shipping",
            type="fixed_amount",
            fixed_amount={"amount": 500, "currency": "usd"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates",
            query_string="",
            post_data="display_name=Ground%20shipping&type=fixed_amount&fixed_amount[amount]=500&fixed_amount[currency]=usd",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/shipping_rates",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.shipping_rates.create_async(
            {
                "display_name": "Ground shipping",
                "type": "fixed_amount",
                "fixed_amount": {"amount": 500, "currency": "usd"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="display_name=Ground%20shipping&type=fixed_amount&fixed_amount[amount]=500&fixed_amount[currency]=usd",
        )

    def test_shipping_rates_post_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.ShippingRate.modify(
            "shr_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates/shr_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_shipping_rates_post_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/shipping_rates/shr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.shipping_rates.update(
            "shr_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates/shr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_post_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.ShippingRate.modify_async(
            "shr_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates/shr_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_shipping_rates_post_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/shipping_rates/shr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.shipping_rates.update_async(
            "shr_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/shipping_rates/shr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_sigma_scheduled_query_runs_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.sigma.ScheduledQueryRun.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/sigma/scheduled_query_runs",
            query_string="limit=3",
        )

    def test_sigma_scheduled_query_runs_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/sigma/scheduled_query_runs",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.sigma.scheduled_query_runs.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/sigma/scheduled_query_runs",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_sigma_scheduled_query_runs_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.sigma.ScheduledQueryRun.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/sigma/scheduled_query_runs",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_sigma_scheduled_query_runs_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/sigma/scheduled_query_runs",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.sigma.scheduled_query_runs.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/sigma/scheduled_query_runs",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_sigma_scheduled_query_runs_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.sigma.ScheduledQueryRun.retrieve("sqr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/sigma/scheduled_query_runs/sqr_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_sigma_scheduled_query_runs_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/sigma/scheduled_query_runs/sqr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.sigma.scheduled_query_runs.retrieve("sqr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/sigma/scheduled_query_runs/sqr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_sigma_scheduled_query_runs_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.sigma.ScheduledQueryRun.retrieve_async(
            "sqr_xxxxxxxxxxxxx"
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/sigma/scheduled_query_runs/sqr_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_sigma_scheduled_query_runs_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/sigma/scheduled_query_runs/sqr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.sigma.scheduled_query_runs.retrieve_async(
            "sqr_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/sigma/scheduled_query_runs/sqr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_sources_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Source.retrieve("src_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_sources_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/sources/src_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.sources.retrieve("src_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_sources_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Source.retrieve_async("src_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_sources_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/sources/src_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.sources.retrieve_async("src_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_sources_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Source.retrieve("src_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_sources_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/sources/src_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.sources.retrieve("src_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_sources_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Source.retrieve_async("src_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_sources_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/sources/src_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.sources.retrieve_async("src_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_sources_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Source.modify(
            "src_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_sources_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/sources/src_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.sources.update(
            "src_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_sources_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Source.modify_async(
            "src_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_sources_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/sources/src_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.sources.update_async(
            "src_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/sources/src_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_subscription_items_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionItem.delete("si_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_subscription_items_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/subscription_items/si_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_items.delete("si_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscription_items_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionItem.delete_async("si_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_subscription_items_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/subscription_items/si_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_items.delete_async("si_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_subscription_items_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionItem.list(subscription="sub_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items",
            query_string="subscription=sub_xxxxxxxxxxxxx",
        )

    def test_subscription_items_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscription_items",
            "subscription=sub_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_items.list({"subscription": "sub_xxxxxxxxxxxxx"})
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items",
            query_string="subscription=sub_xxxxxxxxxxxxx",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscription_items_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionItem.list_async(
            subscription="sub_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items",
            query_string="subscription=sub_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_subscription_items_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscription_items",
            "subscription=sub_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_items.list_async(
            {
                "subscription": "sub_xxxxxxxxxxxxx",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items",
            query_string="subscription=sub_xxxxxxxxxxxxx",
            api_base="https://api.stripe.com",
        )

    def test_subscription_items_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionItem.retrieve("si_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_subscription_items_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscription_items/si_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_items.retrieve("si_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscription_items_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionItem.retrieve_async("si_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_subscription_items_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscription_items/si_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_items.retrieve_async("si_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_subscription_items_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionItem.create(
            subscription="sub_xxxxxxxxxxxxx",
            price="price_xxxxxxxxxxxxx",
            quantity=2,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items",
            query_string="",
            post_data="subscription=sub_xxxxxxxxxxxxx&price=price_xxxxxxxxxxxxx&quantity=2",
        )

    def test_subscription_items_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_items.create(
            {
                "subscription": "sub_xxxxxxxxxxxxx",
                "price": "price_xxxxxxxxxxxxx",
                "quantity": 2,
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="subscription=sub_xxxxxxxxxxxxx&price=price_xxxxxxxxxxxxx&quantity=2",
        )

    @pytest.mark.anyio
    async def test_subscription_items_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionItem.create_async(
            subscription="sub_xxxxxxxxxxxxx",
            price="price_xxxxxxxxxxxxx",
            quantity=2,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items",
            query_string="",
            post_data="subscription=sub_xxxxxxxxxxxxx&price=price_xxxxxxxxxxxxx&quantity=2",
        )

    @pytest.mark.anyio
    async def test_subscription_items_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_items.create_async(
            {
                "subscription": "sub_xxxxxxxxxxxxx",
                "price": "price_xxxxxxxxxxxxx",
                "quantity": 2,
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="subscription=sub_xxxxxxxxxxxxx&price=price_xxxxxxxxxxxxx&quantity=2",
        )

    def test_subscription_items_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionItem.modify(
            "si_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_subscription_items_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_items/si_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_items.update(
            "si_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_subscription_items_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionItem.modify_async(
            "si_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_subscription_items_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_items/si_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_items.update_async(
            "si_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_subscription_items_usage_record_summaries_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionItem.list_usage_record_summaries(
            "si_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx/usage_record_summaries",
            query_string="limit=3",
        )

    def test_subscription_items_usage_record_summaries_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscription_items/si_xxxxxxxxxxxxx/usage_record_summaries",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_items.usage_record_summaries.list(
            "si_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx/usage_record_summaries",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscription_items_usage_record_summaries_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionItem.list_usage_record_summaries_async(
            "si_xxxxxxxxxxxxx",
            limit=3,
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx/usage_record_summaries",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_subscription_items_usage_record_summaries_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscription_items/si_xxxxxxxxxxxxx/usage_record_summaries",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_items.usage_record_summaries.list_async(
            "si_xxxxxxxxxxxxx",
            {"limit": 3},
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx/usage_record_summaries",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_subscription_items_usage_records_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionItem.create_usage_record(
            "si_xxxxxxxxxxxxx",
            quantity=100,
            timestamp=1571252444,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx/usage_records",
            query_string="",
            post_data="quantity=100&timestamp=1571252444",
        )

    def test_subscription_items_usage_records_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_items/si_xxxxxxxxxxxxx/usage_records",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_items.usage_records.create(
            "si_xxxxxxxxxxxxx",
            {"quantity": 100, "timestamp": 1571252444},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx/usage_records",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="quantity=100&timestamp=1571252444",
        )

    @pytest.mark.anyio
    async def test_subscription_items_usage_records_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionItem.create_usage_record_async(
            "si_xxxxxxxxxxxxx",
            quantity=100,
            timestamp=1571252444,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx/usage_records",
            query_string="",
            post_data="quantity=100&timestamp=1571252444",
        )

    @pytest.mark.anyio
    async def test_subscription_items_usage_records_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_items/si_xxxxxxxxxxxxx/usage_records",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_items.usage_records.create_async(
            "si_xxxxxxxxxxxxx",
            {"quantity": 100, "timestamp": 1571252444},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_items/si_xxxxxxxxxxxxx/usage_records",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="quantity=100&timestamp=1571252444",
        )

    def test_subscription_schedules_cancel_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionSchedule.cancel("sub_sched_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    def test_subscription_schedules_cancel_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_schedules.cancel("sub_sched_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_cancel_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionSchedule.cancel_async(
            "sub_sched_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_cancel_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_schedules.cancel_async(
            "sub_sched_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_subscription_schedules_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionSchedule.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_schedules",
            query_string="limit=3",
        )

    def test_subscription_schedules_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscription_schedules",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_schedules.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_schedules",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionSchedule.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_schedules",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscription_schedules",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_schedules.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_schedules",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_subscription_schedules_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionSchedule.retrieve("sub_sched_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_subscription_schedules_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_schedules.retrieve("sub_sched_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionSchedule.retrieve_async(
            "sub_sched_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_schedules.retrieve_async(
            "sub_sched_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_subscription_schedules_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionSchedule.create(
            customer="cus_xxxxxxxxxxxxx",
            start_date=1676070661,
            end_behavior="release",
            phases=[
                {
                    "items": [{"price": "price_xxxxxxxxxxxxx", "quantity": 1}],
                    "iterations": 12,
                },
            ],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx&start_date=1676070661&end_behavior=release&phases[0][items][0][price]=price_xxxxxxxxxxxxx&phases[0][items][0][quantity]=1&phases[0][iterations]=12",
        )

    def test_subscription_schedules_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_schedules",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_schedules.create(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "start_date": 1676070661,
                "end_behavior": "release",
                "phases": [
                    {
                        "items": [
                            {"price": "price_xxxxxxxxxxxxx", "quantity": 1}
                        ],
                        "iterations": 12,
                    },
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx&start_date=1676070661&end_behavior=release&phases[0][items][0][price]=price_xxxxxxxxxxxxx&phases[0][items][0][quantity]=1&phases[0][iterations]=12",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionSchedule.create_async(
            customer="cus_xxxxxxxxxxxxx",
            start_date=1676070661,
            end_behavior="release",
            phases=[
                {
                    "items": [{"price": "price_xxxxxxxxxxxxx", "quantity": 1}],
                    "iterations": 12,
                },
            ],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx&start_date=1676070661&end_behavior=release&phases[0][items][0][price]=price_xxxxxxxxxxxxx&phases[0][items][0][quantity]=1&phases[0][iterations]=12",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_schedules",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_schedules.create_async(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "start_date": 1676070661,
                "end_behavior": "release",
                "phases": [
                    {
                        "items": [
                            {"price": "price_xxxxxxxxxxxxx", "quantity": 1}
                        ],
                        "iterations": 12,
                    },
                ],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx&start_date=1676070661&end_behavior=release&phases[0][items][0][price]=price_xxxxxxxxxxxxx&phases[0][items][0][quantity]=1&phases[0][iterations]=12",
        )

    def test_subscription_schedules_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionSchedule.modify(
            "sub_sched_xxxxxxxxxxxxx",
            end_behavior="release",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
            query_string="",
            post_data="end_behavior=release",
        )

    def test_subscription_schedules_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_schedules.update(
            "sub_sched_xxxxxxxxxxxxx",
            {"end_behavior": "release"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="end_behavior=release",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionSchedule.modify_async(
            "sub_sched_xxxxxxxxxxxxx",
            end_behavior="release",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
            query_string="",
            post_data="end_behavior=release",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_schedules.update_async(
            "sub_sched_xxxxxxxxxxxxx",
            {"end_behavior": "release"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="end_behavior=release",
        )

    def test_subscription_schedules_release_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.SubscriptionSchedule.release("sub_sched_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/release",
            query_string="",
        )

    def test_subscription_schedules_release_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/release",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscription_schedules.release("sub_sched_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/release",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_release_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.SubscriptionSchedule.release_async(
            "sub_sched_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/release",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_subscription_schedules_release_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/release",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscription_schedules.release_async(
            "sub_sched_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscription_schedules/sub_sched_xxxxxxxxxxxxx/release",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_subscriptions_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Subscription.cancel("sub_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_subscriptions_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/subscriptions/sub_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscriptions.cancel("sub_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscriptions_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Subscription.cancel_async("sub_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_subscriptions_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/subscriptions/sub_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscriptions.cancel_async("sub_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_subscriptions_discount_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Subscription.delete_discount("sub_xyz")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscriptions/sub_xyz/discount",
            query_string="",
        )

    def test_subscriptions_discount_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/subscriptions/sub_xyz/discount",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscriptions.delete_discount("sub_xyz")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscriptions/sub_xyz/discount",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscriptions_discount_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Subscription.delete_discount_async("sub_xyz")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscriptions/sub_xyz/discount",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_subscriptions_discount_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/subscriptions/sub_xyz/discount",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscriptions.delete_discount_async("sub_xyz")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/subscriptions/sub_xyz/discount",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_subscriptions_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Subscription.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions",
            query_string="limit=3",
        )

    def test_subscriptions_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscriptions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscriptions.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscriptions_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Subscription.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_subscriptions_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscriptions",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscriptions.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_subscriptions_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Subscription.retrieve("sub_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_subscriptions_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscriptions/sub_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscriptions.retrieve("sub_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscriptions_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Subscription.retrieve_async("sub_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_subscriptions_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscriptions/sub_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscriptions.retrieve_async("sub_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_subscriptions_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Subscription.create(
            customer="cus_xxxxxxxxxxxxx",
            items=[{"price": "price_xxxxxxxxxxxxx"}],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscriptions",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx&items[0][price]=price_xxxxxxxxxxxxx",
        )

    def test_subscriptions_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscriptions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscriptions.create(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "items": [{"price": "price_xxxxxxxxxxxxx"}],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscriptions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx&items[0][price]=price_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_subscriptions_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Subscription.create_async(
            customer="cus_xxxxxxxxxxxxx",
            items=[{"price": "price_xxxxxxxxxxxxx"}],
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscriptions",
            query_string="",
            post_data="customer=cus_xxxxxxxxxxxxx&items[0][price]=price_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_subscriptions_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscriptions",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscriptions.create_async(
            {
                "customer": "cus_xxxxxxxxxxxxx",
                "items": [{"price": "price_xxxxxxxxxxxxx"}],
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscriptions",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="customer=cus_xxxxxxxxxxxxx&items[0][price]=price_xxxxxxxxxxxxx",
        )

    def test_subscriptions_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Subscription.modify(
            "sub_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_subscriptions_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscriptions/sub_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscriptions.update(
            "sub_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_subscriptions_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Subscription.modify_async(
            "sub_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_subscriptions_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/subscriptions/sub_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscriptions.update_async(
            "sub_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/subscriptions/sub_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    def test_subscriptions_search_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Subscription.search(
            query="status:'active' AND metadata['order_id']:'6735'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions/search",
            query_string="query=status%3A%27active%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    def test_subscriptions_search_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscriptions/search",
            "query=status%3A%27active%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.subscriptions.search(
            {
                "query": "status:'active' AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions/search",
            query_string="query=status%3A%27active%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_subscriptions_search_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Subscription.search_async(
            query="status:'active' AND metadata['order_id']:'6735'",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions/search",
            query_string="query=status%3A%27active%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )

    @pytest.mark.anyio
    async def test_subscriptions_search_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/subscriptions/search",
            "query=status%3A%27active%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.subscriptions.search_async(
            {
                "query": "status:'active' AND metadata['order_id']:'6735'",
            }
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/subscriptions/search",
            query_string="query=status%3A%27active%27%20AND%20metadata%5B%27order_id%27%5D%3A%276735%27",
            api_base="https://api.stripe.com",
        )

    def test_tax_calculations_line_items_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.tax.Calculation.list_line_items("xxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/calculations/xxx/line_items",
            query_string="",
        )

    def test_tax_calculations_line_items_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax/calculations/xxx/line_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax.calculations.line_items.list("xxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/calculations/xxx/line_items",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_calculations_line_items_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.tax.Calculation.list_line_items_async("xxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/calculations/xxx/line_items",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_tax_calculations_line_items_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax/calculations/xxx/line_items",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax.calculations.line_items.list_async("xxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/calculations/xxx/line_items",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_tax_calculations_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.tax.Calculation.create(
            currency="usd",
            line_items=[{"amount": 1000, "reference": "L1"}],
            customer_details={
                "address": {
                    "line1": "354 Oyster Point Blvd",
                    "city": "South San Francisco",
                    "state": "CA",
                    "postal_code": "94080",
                    "country": "US",
                },
                "address_source": "shipping",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/calculations",
            query_string="",
            post_data="currency=usd&line_items[0][amount]=1000&line_items[0][reference]=L1&customer_details[address][line1]=354%20Oyster%20Point%20Blvd&customer_details[address][city]=South%20San%20Francisco&customer_details[address][state]=CA&customer_details[address][postal_code]=94080&customer_details[address][country]=US&customer_details[address_source]=shipping",
        )

    def test_tax_calculations_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax/calculations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax.calculations.create(
            {
                "currency": "usd",
                "line_items": [{"amount": 1000, "reference": "L1"}],
                "customer_details": {
                    "address": {
                        "line1": "354 Oyster Point Blvd",
                        "city": "South San Francisco",
                        "state": "CA",
                        "postal_code": "94080",
                        "country": "US",
                    },
                    "address_source": "shipping",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/calculations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="currency=usd&line_items[0][amount]=1000&line_items[0][reference]=L1&customer_details[address][line1]=354%20Oyster%20Point%20Blvd&customer_details[address][city]=South%20San%20Francisco&customer_details[address][state]=CA&customer_details[address][postal_code]=94080&customer_details[address][country]=US&customer_details[address_source]=shipping",
        )

    @pytest.mark.anyio
    async def test_tax_calculations_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.tax.Calculation.create_async(
            currency="usd",
            line_items=[{"amount": 1000, "reference": "L1"}],
            customer_details={
                "address": {
                    "line1": "354 Oyster Point Blvd",
                    "city": "South San Francisco",
                    "state": "CA",
                    "postal_code": "94080",
                    "country": "US",
                },
                "address_source": "shipping",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/calculations",
            query_string="",
            post_data="currency=usd&line_items[0][amount]=1000&line_items[0][reference]=L1&customer_details[address][line1]=354%20Oyster%20Point%20Blvd&customer_details[address][city]=South%20San%20Francisco&customer_details[address][state]=CA&customer_details[address][postal_code]=94080&customer_details[address][country]=US&customer_details[address_source]=shipping",
        )

    @pytest.mark.anyio
    async def test_tax_calculations_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax/calculations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax.calculations.create_async(
            {
                "currency": "usd",
                "line_items": [{"amount": 1000, "reference": "L1"}],
                "customer_details": {
                    "address": {
                        "line1": "354 Oyster Point Blvd",
                        "city": "South San Francisco",
                        "state": "CA",
                        "postal_code": "94080",
                        "country": "US",
                    },
                    "address_source": "shipping",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/calculations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="currency=usd&line_items[0][amount]=1000&line_items[0][reference]=L1&customer_details[address][line1]=354%20Oyster%20Point%20Blvd&customer_details[address][city]=South%20San%20Francisco&customer_details[address][state]=CA&customer_details[address][postal_code]=94080&customer_details[address][country]=US&customer_details[address_source]=shipping",
        )

    def test_tax_codes_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.TaxCode.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_codes",
            query_string="limit=3",
        )

    def test_tax_codes_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_codes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax_codes.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_codes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_codes_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.TaxCode.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_codes",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_tax_codes_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_codes",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax_codes.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_codes",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_tax_codes_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.TaxCode.retrieve("txcd_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_codes/txcd_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_tax_codes_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_codes/txcd_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax_codes.retrieve("txcd_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_codes/txcd_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_codes_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.TaxCode.retrieve_async("txcd_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_codes/txcd_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_tax_codes_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_codes/txcd_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax_codes.retrieve_async("txcd_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_codes/txcd_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_tax_forms_pdf_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.tax.Form.pdf("form_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/forms/form_xxxxxxxxxxxxx/pdf",
            query_string="",
        )

    def test_tax_forms_pdf_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax/forms/form_xxxxxxxxxxxxx/pdf",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax.forms.pdf("form_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/forms/form_xxxxxxxxxxxxx/pdf",
            query_string="",
            api_base="https://files.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_forms_pdf_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.tax.Form.pdf_async("form_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/forms/form_xxxxxxxxxxxxx/pdf",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_tax_forms_pdf_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax/forms/form_xxxxxxxxxxxxx/pdf",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax.forms.pdf_async("form_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/forms/form_xxxxxxxxxxxxx/pdf",
            query_string="",
            api_base="https://files.stripe.com",
        )

    def test_tax_ids_delete(self, http_client_mock: HTTPClientMock) -> None:
        stripe.TaxId.delete("taxid_123")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/tax_ids/taxid_123",
            query_string="",
        )

    def test_tax_ids_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/tax_ids/taxid_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax_ids.delete("taxid_123")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/tax_ids/taxid_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_ids_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.TaxId.delete_async("taxid_123")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/tax_ids/taxid_123",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_tax_ids_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/tax_ids/taxid_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax_ids.delete_async("taxid_123")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/tax_ids/taxid_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_tax_ids_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.TaxId.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_ids",
            query_string="",
        )

    def test_tax_ids_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_ids",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax_ids.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_ids",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_ids_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.TaxId.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_ids",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_tax_ids_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_ids",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax_ids.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_ids",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_tax_ids_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.TaxId.retrieve("taxid_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_ids/taxid_123",
            query_string="",
        )

    def test_tax_ids_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_ids/taxid_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax_ids.retrieve("taxid_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_ids/taxid_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_ids_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.TaxId.retrieve_async("taxid_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_ids/taxid_123",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_tax_ids_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_ids/taxid_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax_ids.retrieve_async("taxid_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_ids/taxid_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_tax_ids_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.TaxId.create(
            type="eu_vat",
            value="123",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_ids",
            query_string="",
            post_data="type=eu_vat&value=123",
        )

    def test_tax_ids_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax_ids",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax_ids.create({"type": "eu_vat", "value": "123"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_ids",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=eu_vat&value=123",
        )

    @pytest.mark.anyio
    async def test_tax_ids_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.TaxId.create_async(
            type="eu_vat",
            value="123",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_ids",
            query_string="",
            post_data="type=eu_vat&value=123",
        )

    @pytest.mark.anyio
    async def test_tax_ids_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax_ids",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax_ids.create_async({"type": "eu_vat", "value": "123"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_ids",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="type=eu_vat&value=123",
        )

    def test_tax_rates_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.TaxRate.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_rates",
            query_string="limit=3",
        )

    def test_tax_rates_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_rates",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax_rates.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_rates",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_rates_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.TaxRate.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_rates",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_tax_rates_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_rates",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax_rates.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_rates",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_tax_rates_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.TaxRate.retrieve("txr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_rates/txr_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_tax_rates_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_rates/txr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax_rates.retrieve("txr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_rates/txr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_rates_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.TaxRate.retrieve_async("txr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_rates/txr_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_tax_rates_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax_rates/txr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax_rates.retrieve_async("txr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax_rates/txr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_tax_rates_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.TaxRate.create(
            display_name="VAT",
            description="VAT Germany",
            jurisdiction="DE",
            percentage=16,
            inclusive=False,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_rates",
            query_string="",
            post_data="display_name=VAT&description=VAT%20Germany&jurisdiction=DE&percentage=16&inclusive=False",
        )

    def test_tax_rates_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax_rates",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax_rates.create(
            {
                "display_name": "VAT",
                "description": "VAT Germany",
                "jurisdiction": "DE",
                "percentage": 16,
                "inclusive": False,
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_rates",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="display_name=VAT&description=VAT%20Germany&jurisdiction=DE&percentage=16&inclusive=False",
        )

    @pytest.mark.anyio
    async def test_tax_rates_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.TaxRate.create_async(
            display_name="VAT",
            description="VAT Germany",
            jurisdiction="DE",
            percentage=16,
            inclusive=False,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_rates",
            query_string="",
            post_data="display_name=VAT&description=VAT%20Germany&jurisdiction=DE&percentage=16&inclusive=False",
        )

    @pytest.mark.anyio
    async def test_tax_rates_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax_rates",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax_rates.create_async(
            {
                "display_name": "VAT",
                "description": "VAT Germany",
                "jurisdiction": "DE",
                "percentage": 16,
                "inclusive": False,
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_rates",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="display_name=VAT&description=VAT%20Germany&jurisdiction=DE&percentage=16&inclusive=False",
        )

    def test_tax_rates_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.TaxRate.modify(
            "txr_xxxxxxxxxxxxx",
            active=False,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_rates/txr_xxxxxxxxxxxxx",
            query_string="",
            post_data="active=False",
        )

    def test_tax_rates_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax_rates/txr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax_rates.update(
            "txr_xxxxxxxxxxxxx",
            {"active": False},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_rates/txr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="active=False",
        )

    @pytest.mark.anyio
    async def test_tax_rates_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.TaxRate.modify_async(
            "txr_xxxxxxxxxxxxx",
            active=False,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_rates/txr_xxxxxxxxxxxxx",
            query_string="",
            post_data="active=False",
        )

    @pytest.mark.anyio
    async def test_tax_rates_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax_rates/txr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax_rates.update_async(
            "txr_xxxxxxxxxxxxx",
            {"active": False},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax_rates/txr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="active=False",
        )

    def test_tax_registrations_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.tax.Registration.list(status="all")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/registrations",
            query_string="status=all",
        )

    def test_tax_registrations_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax/registrations",
            "status=all",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax.registrations.list({"status": "all"})
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/registrations",
            query_string="status=all",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_registrations_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.tax.Registration.list_async(status="all")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/registrations",
            query_string="status=all",
        )

    @pytest.mark.anyio
    async def test_tax_registrations_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax/registrations",
            "status=all",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax.registrations.list_async({"status": "all"})
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/registrations",
            query_string="status=all",
            api_base="https://api.stripe.com",
        )

    def test_tax_registrations_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.tax.Registration.create(
            country="IE",
            country_options={"ie": {"type": "oss_union"}},
            active_from="now",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/registrations",
            query_string="",
            post_data="country=IE&country_options[ie][type]=oss_union&active_from=now",
        )

    def test_tax_registrations_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax/registrations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax.registrations.create(
            {
                "country": "IE",
                "country_options": {"ie": {"type": "oss_union"}},
                "active_from": "now",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/registrations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="country=IE&country_options[ie][type]=oss_union&active_from=now",
        )

    @pytest.mark.anyio
    async def test_tax_registrations_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.tax.Registration.create_async(
            country="IE",
            country_options={"ie": {"type": "oss_union"}},
            active_from="now",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/registrations",
            query_string="",
            post_data="country=IE&country_options[ie][type]=oss_union&active_from=now",
        )

    @pytest.mark.anyio
    async def test_tax_registrations_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax/registrations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax.registrations.create_async(
            {
                "country": "IE",
                "country_options": {"ie": {"type": "oss_union"}},
                "active_from": "now",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/registrations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="country=IE&country_options[ie][type]=oss_union&active_from=now",
        )

    def test_tax_registrations_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.tax.Registration.modify(
            "taxreg_xxxxxxxxxxxxx",
            expires_at="now",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/registrations/taxreg_xxxxxxxxxxxxx",
            query_string="",
            post_data="expires_at=now",
        )

    def test_tax_registrations_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax/registrations/taxreg_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax.registrations.update(
            "taxreg_xxxxxxxxxxxxx",
            {"expires_at": "now"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/registrations/taxreg_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="expires_at=now",
        )

    @pytest.mark.anyio
    async def test_tax_registrations_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.tax.Registration.modify_async(
            "taxreg_xxxxxxxxxxxxx",
            expires_at="now",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/registrations/taxreg_xxxxxxxxxxxxx",
            query_string="",
            post_data="expires_at=now",
        )

    @pytest.mark.anyio
    async def test_tax_registrations_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax/registrations/taxreg_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax.registrations.update_async(
            "taxreg_xxxxxxxxxxxxx",
            {"expires_at": "now"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/registrations/taxreg_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="expires_at=now",
        )

    def test_tax_settings_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.tax.Settings.retrieve()
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/settings",
            query_string="",
        )

    def test_tax_settings_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax/settings",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax.settings.retrieve()
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/settings",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tax_settings_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.tax.Settings.retrieve_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/settings",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_tax_settings_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tax/settings",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax.settings.retrieve_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/tax/settings",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_tax_settings_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.tax.Settings.modify(defaults={"tax_code": "txcd_10000000"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/settings",
            query_string="",
            post_data="defaults[tax_code]=txcd_10000000",
        )

    def test_tax_settings_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax/settings",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax.settings.update({"defaults": {"tax_code": "txcd_10000000"}})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/settings",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="defaults[tax_code]=txcd_10000000",
        )

    @pytest.mark.anyio
    async def test_tax_settings_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.tax.Settings.modify_async(
            defaults={"tax_code": "txcd_10000000"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/settings",
            query_string="",
            post_data="defaults[tax_code]=txcd_10000000",
        )

    @pytest.mark.anyio
    async def test_tax_settings_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax/settings",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax.settings.update_async(
            {
                "defaults": {"tax_code": "txcd_10000000"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/settings",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="defaults[tax_code]=txcd_10000000",
        )

    def test_tax_transactions_create_from_calculation_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.tax.Transaction.create_from_calculation(
            calculation="xxx",
            reference="yyy",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/transactions/create_from_calculation",
            query_string="",
            post_data="calculation=xxx&reference=yyy",
        )

    def test_tax_transactions_create_from_calculation_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax/transactions/create_from_calculation",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tax.transactions.create_from_calculation(
            {
                "calculation": "xxx",
                "reference": "yyy",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/transactions/create_from_calculation",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="calculation=xxx&reference=yyy",
        )

    @pytest.mark.anyio
    async def test_tax_transactions_create_from_calculation_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.tax.Transaction.create_from_calculation_async(
            calculation="xxx",
            reference="yyy",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/transactions/create_from_calculation",
            query_string="",
            post_data="calculation=xxx&reference=yyy",
        )

    @pytest.mark.anyio
    async def test_tax_transactions_create_from_calculation_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tax/transactions/create_from_calculation",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tax.transactions.create_from_calculation_async(
            {
                "calculation": "xxx",
                "reference": "yyy",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tax/transactions/create_from_calculation",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="calculation=xxx&reference=yyy",
        )

    def test_terminal_configurations_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Configuration.delete("uc_123")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
        )

    def test_terminal_configurations_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/terminal/configurations/uc_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.configurations.delete("uc_123")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Configuration.delete_async("uc_123")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/terminal/configurations/uc_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.configurations.delete_async("uc_123")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_configurations_delete_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Configuration.delete("tmc_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_terminal_configurations_delete_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.configurations.delete("tmc_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_delete_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Configuration.delete_async("tmc_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_delete_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.configurations.delete_async("tmc_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_configurations_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Configuration.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations",
            query_string="",
        )

    def test_terminal_configurations_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/configurations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.configurations.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Configuration.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/configurations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.configurations.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_configurations_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Configuration.retrieve("uc_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
        )

    def test_terminal_configurations_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/configurations/uc_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.configurations.retrieve("uc_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Configuration.retrieve_async("uc_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/configurations/uc_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.configurations.retrieve_async("uc_123")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_configurations_get_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Configuration.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations",
            query_string="limit=3",
        )

    def test_terminal_configurations_get_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/configurations",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.configurations.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_get_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Configuration.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_get_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/configurations",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.configurations.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_terminal_configurations_get_4(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Configuration.retrieve("tmc_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_terminal_configurations_get_4_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.configurations.retrieve("tmc_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_get_4_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Configuration.retrieve_async("tmc_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_get_4_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.configurations.retrieve_async(
            "tmc_xxxxxxxxxxxxx"
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_configurations_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Configuration.create()
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations",
            query_string="",
        )

    def test_terminal_configurations_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/configurations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.configurations.create()
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Configuration.create_async()
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/configurations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.configurations.create_async()
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_configurations_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Configuration.modify(
            "uc_123",
            tipping={"usd": {"fixed_amounts": [10]}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
            post_data="tipping[usd][fixed_amounts][0]=10",
        )

    def test_terminal_configurations_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/configurations/uc_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.configurations.update(
            "uc_123",
            {"tipping": {"usd": {"fixed_amounts": [10]}}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="tipping[usd][fixed_amounts][0]=10",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Configuration.modify_async(
            "uc_123",
            tipping={"usd": {"fixed_amounts": [10]}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
            post_data="tipping[usd][fixed_amounts][0]=10",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/configurations/uc_123",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.configurations.update_async(
            "uc_123",
            {"tipping": {"usd": {"fixed_amounts": [10]}}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations/uc_123",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="tipping[usd][fixed_amounts][0]=10",
        )

    def test_terminal_configurations_post_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Configuration.create(
            bbpos_wisepos_e={"splashscreen": "file_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations",
            query_string="",
            post_data="bbpos_wisepos_e[splashscreen]=file_xxxxxxxxxxxxx",
        )

    def test_terminal_configurations_post_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/configurations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.configurations.create(
            {
                "bbpos_wisepos_e": {"splashscreen": "file_xxxxxxxxxxxxx"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="bbpos_wisepos_e[splashscreen]=file_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_post_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Configuration.create_async(
            bbpos_wisepos_e={"splashscreen": "file_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations",
            query_string="",
            post_data="bbpos_wisepos_e[splashscreen]=file_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_post_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/configurations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.configurations.create_async(
            {
                "bbpos_wisepos_e": {"splashscreen": "file_xxxxxxxxxxxxx"},
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="bbpos_wisepos_e[splashscreen]=file_xxxxxxxxxxxxx",
        )

    def test_terminal_configurations_post_4(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Configuration.modify(
            "tmc_xxxxxxxxxxxxx",
            bbpos_wisepos_e={"splashscreen": "file_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
            post_data="bbpos_wisepos_e[splashscreen]=file_xxxxxxxxxxxxx",
        )

    def test_terminal_configurations_post_4_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.configurations.update(
            "tmc_xxxxxxxxxxxxx",
            {"bbpos_wisepos_e": {"splashscreen": "file_xxxxxxxxxxxxx"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="bbpos_wisepos_e[splashscreen]=file_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_post_4_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Configuration.modify_async(
            "tmc_xxxxxxxxxxxxx",
            bbpos_wisepos_e={"splashscreen": "file_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
            post_data="bbpos_wisepos_e[splashscreen]=file_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_terminal_configurations_post_4_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.configurations.update_async(
            "tmc_xxxxxxxxxxxxx",
            {"bbpos_wisepos_e": {"splashscreen": "file_xxxxxxxxxxxxx"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/configurations/tmc_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="bbpos_wisepos_e[splashscreen]=file_xxxxxxxxxxxxx",
        )

    def test_terminal_connection_tokens_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.ConnectionToken.create()
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/connection_tokens",
            query_string="",
        )

    def test_terminal_connection_tokens_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/connection_tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.connection_tokens.create()
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/connection_tokens",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_connection_tokens_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.ConnectionToken.create_async()
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/connection_tokens",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_connection_tokens_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/connection_tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.connection_tokens.create_async()
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/connection_tokens",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_locations_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Location.delete("tml_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_terminal_locations_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/terminal/locations/tml_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.locations.delete("tml_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_locations_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Location.delete_async("tml_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_locations_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/terminal/locations/tml_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.locations.delete_async("tml_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_locations_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Location.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/locations",
            query_string="limit=3",
        )

    def test_terminal_locations_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/locations",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.locations.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/locations",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_locations_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Location.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/locations",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_terminal_locations_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/locations",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.locations.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/locations",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_terminal_locations_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Location.retrieve("tml_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_terminal_locations_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/locations/tml_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.locations.retrieve("tml_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_locations_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Location.retrieve_async("tml_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_locations_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/locations/tml_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.locations.retrieve_async("tml_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_locations_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Location.create(
            display_name="My First Store",
            address={
                "line1": "1234 Main Street",
                "city": "San Francisco",
                "postal_code": "94111",
                "state": "CA",
                "country": "US",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/locations",
            query_string="",
            post_data="display_name=My%20First%20Store&address[line1]=1234%20Main%20Street&address[city]=San%20Francisco&address[postal_code]=94111&address[state]=CA&address[country]=US",
        )

    def test_terminal_locations_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/locations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.locations.create(
            {
                "display_name": "My First Store",
                "address": {
                    "line1": "1234 Main Street",
                    "city": "San Francisco",
                    "postal_code": "94111",
                    "state": "CA",
                    "country": "US",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/locations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="display_name=My%20First%20Store&address[line1]=1234%20Main%20Street&address[city]=San%20Francisco&address[postal_code]=94111&address[state]=CA&address[country]=US",
        )

    @pytest.mark.anyio
    async def test_terminal_locations_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Location.create_async(
            display_name="My First Store",
            address={
                "line1": "1234 Main Street",
                "city": "San Francisco",
                "postal_code": "94111",
                "state": "CA",
                "country": "US",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/locations",
            query_string="",
            post_data="display_name=My%20First%20Store&address[line1]=1234%20Main%20Street&address[city]=San%20Francisco&address[postal_code]=94111&address[state]=CA&address[country]=US",
        )

    @pytest.mark.anyio
    async def test_terminal_locations_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/locations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.locations.create_async(
            {
                "display_name": "My First Store",
                "address": {
                    "line1": "1234 Main Street",
                    "city": "San Francisco",
                    "postal_code": "94111",
                    "state": "CA",
                    "country": "US",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/locations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="display_name=My%20First%20Store&address[line1]=1234%20Main%20Street&address[city]=San%20Francisco&address[postal_code]=94111&address[state]=CA&address[country]=US",
        )

    def test_terminal_locations_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Location.modify(
            "tml_xxxxxxxxxxxxx",
            display_name="My First Store",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
            post_data="display_name=My%20First%20Store",
        )

    def test_terminal_locations_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/locations/tml_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.locations.update(
            "tml_xxxxxxxxxxxxx",
            {"display_name": "My First Store"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="display_name=My%20First%20Store",
        )

    @pytest.mark.anyio
    async def test_terminal_locations_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Location.modify_async(
            "tml_xxxxxxxxxxxxx",
            display_name="My First Store",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
            post_data="display_name=My%20First%20Store",
        )

    @pytest.mark.anyio
    async def test_terminal_locations_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/locations/tml_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.locations.update_async(
            "tml_xxxxxxxxxxxxx",
            {"display_name": "My First Store"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/locations/tml_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="display_name=My%20First%20Store",
        )

    def test_terminal_readers_cancel_action_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Reader.cancel_action("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx/cancel_action",
            query_string="",
        )

    def test_terminal_readers_cancel_action_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/readers/tmr_xxxxxxxxxxxxx/cancel_action",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.readers.cancel_action("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx/cancel_action",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_cancel_action_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Reader.cancel_action_async("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx/cancel_action",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_cancel_action_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/readers/tmr_xxxxxxxxxxxxx/cancel_action",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.readers.cancel_action_async("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx/cancel_action",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_readers_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Reader.delete("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_terminal_readers_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.readers.delete("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Reader.delete_async("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.readers.delete_async("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_readers_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Reader.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/readers",
            query_string="limit=3",
        )

    def test_terminal_readers_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/readers",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.readers.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/readers",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Reader.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/readers",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/readers",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.readers.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/readers",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_terminal_readers_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Reader.retrieve("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_terminal_readers_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.readers.retrieve("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Reader.retrieve_async("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.readers.retrieve_async("tmr_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_terminal_readers_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Reader.create(
            registration_code="puppies-plug-could",
            label="Blue Rabbit",
            location="tml_1234",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers",
            query_string="",
            post_data="registration_code=puppies-plug-could&label=Blue%20Rabbit&location=tml_1234",
        )

    def test_terminal_readers_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/readers",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.readers.create(
            {
                "registration_code": "puppies-plug-could",
                "label": "Blue Rabbit",
                "location": "tml_1234",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="registration_code=puppies-plug-could&label=Blue%20Rabbit&location=tml_1234",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Reader.create_async(
            registration_code="puppies-plug-could",
            label="Blue Rabbit",
            location="tml_1234",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers",
            query_string="",
            post_data="registration_code=puppies-plug-could&label=Blue%20Rabbit&location=tml_1234",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/readers",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.readers.create_async(
            {
                "registration_code": "puppies-plug-could",
                "label": "Blue Rabbit",
                "location": "tml_1234",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="registration_code=puppies-plug-could&label=Blue%20Rabbit&location=tml_1234",
        )

    def test_terminal_readers_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Reader.modify(
            "tmr_xxxxxxxxxxxxx",
            label="Blue Rabbit",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
            post_data="label=Blue%20Rabbit",
        )

    def test_terminal_readers_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.readers.update(
            "tmr_xxxxxxxxxxxxx",
            {"label": "Blue Rabbit"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="label=Blue%20Rabbit",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Reader.modify_async(
            "tmr_xxxxxxxxxxxxx",
            label="Blue Rabbit",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
            post_data="label=Blue%20Rabbit",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.readers.update_async(
            "tmr_xxxxxxxxxxxxx",
            {"label": "Blue Rabbit"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="label=Blue%20Rabbit",
        )

    def test_terminal_readers_process_payment_intent_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.terminal.Reader.process_payment_intent(
            "tmr_xxxxxxxxxxxxx",
            payment_intent="pi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx/process_payment_intent",
            query_string="",
            post_data="payment_intent=pi_xxxxxxxxxxxxx",
        )

    def test_terminal_readers_process_payment_intent_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/readers/tmr_xxxxxxxxxxxxx/process_payment_intent",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.terminal.readers.process_payment_intent(
            "tmr_xxxxxxxxxxxxx",
            {"payment_intent": "pi_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx/process_payment_intent",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="payment_intent=pi_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_process_payment_intent_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.terminal.Reader.process_payment_intent_async(
            "tmr_xxxxxxxxxxxxx",
            payment_intent="pi_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx/process_payment_intent",
            query_string="",
            post_data="payment_intent=pi_xxxxxxxxxxxxx",
        )

    @pytest.mark.anyio
    async def test_terminal_readers_process_payment_intent_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/terminal/readers/tmr_xxxxxxxxxxxxx/process_payment_intent",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.terminal.readers.process_payment_intent_async(
            "tmr_xxxxxxxxxxxxx",
            {"payment_intent": "pi_xxxxxxxxxxxxx"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/terminal/readers/tmr_xxxxxxxxxxxxx/process_payment_intent",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="payment_intent=pi_xxxxxxxxxxxxx",
        )

    def test_test_helpers_customers_fund_cash_balance_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Customer.TestHelpers.fund_cash_balance(
            "cus_123",
            amount=30,
            currency="eur",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/customers/cus_123/fund_cash_balance",
            query_string="",
            post_data="amount=30&currency=eur",
        )

    def test_test_helpers_customers_fund_cash_balance_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/customers/cus_123/fund_cash_balance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.customers.fund_cash_balance(
            "cus_123",
            {"amount": 30, "currency": "eur"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/customers/cus_123/fund_cash_balance",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=30&currency=eur",
        )

    @pytest.mark.anyio
    async def test_test_helpers_customers_fund_cash_balance_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Customer.TestHelpers.fund_cash_balance_async(
            "cus_123",
            amount=30,
            currency="eur",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/customers/cus_123/fund_cash_balance",
            query_string="",
            post_data="amount=30&currency=eur",
        )

    @pytest.mark.anyio
    async def test_test_helpers_customers_fund_cash_balance_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/customers/cus_123/fund_cash_balance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.customers.fund_cash_balance_async(
            "cus_123",
            {"amount": 30, "currency": "eur"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/customers/cus_123/fund_cash_balance",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=30&currency=eur",
        )

    def test_test_helpers_issuing_authorizations_capture_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Authorization.TestHelpers.capture(
            "example_authorization",
            capture_amount=100,
            close_authorization=True,
            purchase_details={
                "flight": {
                    "departure_at": 1633651200,
                    "passenger_name": "John Doe",
                    "refundable": True,
                    "segments": [
                        {
                            "arrival_airport_code": "SFO",
                            "carrier": "Delta",
                            "departure_airport_code": "LAX",
                            "flight_number": "DL100",
                            "service_class": "Economy",
                            "stopover_allowed": True,
                        },
                    ],
                    "travel_agency": "Orbitz",
                },
                "fuel": {
                    "type": "diesel",
                    "unit": "liter",
                    "unit_cost_decimal": "3.5",
                    "quantity_decimal": "10",
                },
                "lodging": {"check_in_at": 1633651200, "nights": 2},
                "receipt": [
                    {
                        "description": "Room charge",
                        "quantity": "1",
                        "total": 200,
                        "unit_cost": 200,
                    },
                ],
                "reference": "foo",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/capture",
            query_string="",
            post_data="capture_amount=100&close_authorization=True&purchase_details[flight][departure_at]=1633651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1633651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    def test_test_helpers_issuing_authorizations_capture_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/authorizations/example_authorization/capture",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.authorizations.capture(
            "example_authorization",
            {
                "capture_amount": 100,
                "close_authorization": True,
                "purchase_details": {
                    "flight": {
                        "departure_at": 1633651200,
                        "passenger_name": "John Doe",
                        "refundable": True,
                        "segments": [
                            {
                                "arrival_airport_code": "SFO",
                                "carrier": "Delta",
                                "departure_airport_code": "LAX",
                                "flight_number": "DL100",
                                "service_class": "Economy",
                                "stopover_allowed": True,
                            },
                        ],
                        "travel_agency": "Orbitz",
                    },
                    "fuel": {
                        "type": "diesel",
                        "unit": "liter",
                        "unit_cost_decimal": "3.5",
                        "quantity_decimal": "10",
                    },
                    "lodging": {"check_in_at": 1633651200, "nights": 2},
                    "receipt": [
                        {
                            "description": "Room charge",
                            "quantity": "1",
                            "total": 200,
                            "unit_cost": 200,
                        },
                    ],
                    "reference": "foo",
                },
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/capture",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="capture_amount=100&close_authorization=True&purchase_details[flight][departure_at]=1633651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1633651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_authorizations_capture_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Authorization.TestHelpers.capture_async(
            "example_authorization",
            capture_amount=100,
            close_authorization=True,
            purchase_details={
                "flight": {
                    "departure_at": 1633651200,
                    "passenger_name": "John Doe",
                    "refundable": True,
                    "segments": [
                        {
                            "arrival_airport_code": "SFO",
                            "carrier": "Delta",
                            "departure_airport_code": "LAX",
                            "flight_number": "DL100",
                            "service_class": "Economy",
                            "stopover_allowed": True,
                        },
                    ],
                    "travel_agency": "Orbitz",
                },
                "fuel": {
                    "type": "diesel",
                    "unit": "liter",
                    "unit_cost_decimal": "3.5",
                    "quantity_decimal": "10",
                },
                "lodging": {"check_in_at": 1633651200, "nights": 2},
                "receipt": [
                    {
                        "description": "Room charge",
                        "quantity": "1",
                        "total": 200,
                        "unit_cost": 200,
                    },
                ],
                "reference": "foo",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/capture",
            query_string="",
            post_data="capture_amount=100&close_authorization=True&purchase_details[flight][departure_at]=1633651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1633651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_authorizations_capture_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/authorizations/example_authorization/capture",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.authorizations.capture_async(
            "example_authorization",
            {
                "capture_amount": 100,
                "close_authorization": True,
                "purchase_details": {
                    "flight": {
                        "departure_at": 1633651200,
                        "passenger_name": "John Doe",
                        "refundable": True,
                        "segments": [
                            {
                                "arrival_airport_code": "SFO",
                                "carrier": "Delta",
                                "departure_airport_code": "LAX",
                                "flight_number": "DL100",
                                "service_class": "Economy",
                                "stopover_allowed": True,
                            },
                        ],
                        "travel_agency": "Orbitz",
                    },
                    "fuel": {
                        "type": "diesel",
                        "unit": "liter",
                        "unit_cost_decimal": "3.5",
                        "quantity_decimal": "10",
                    },
                    "lodging": {"check_in_at": 1633651200, "nights": 2},
                    "receipt": [
                        {
                            "description": "Room charge",
                            "quantity": "1",
                            "total": 200,
                            "unit_cost": 200,
                        },
                    ],
                    "reference": "foo",
                },
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/capture",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="capture_amount=100&close_authorization=True&purchase_details[flight][departure_at]=1633651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1633651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    def test_test_helpers_issuing_authorizations_expire_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Authorization.TestHelpers.expire(
            "example_authorization"
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/expire",
            query_string="",
        )

    def test_test_helpers_issuing_authorizations_expire_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/authorizations/example_authorization/expire",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.authorizations.expire(
            "example_authorization",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/expire",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_authorizations_expire_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Authorization.TestHelpers.expire_async(
            "example_authorization",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/expire",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_authorizations_expire_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/authorizations/example_authorization/expire",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.authorizations.expire_async(
            "example_authorization",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/expire",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_issuing_authorizations_increment_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Authorization.TestHelpers.increment(
            "example_authorization",
            increment_amount=50,
            is_amount_controllable=True,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/increment",
            query_string="",
            post_data="increment_amount=50&is_amount_controllable=True",
        )

    def test_test_helpers_issuing_authorizations_increment_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/authorizations/example_authorization/increment",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.authorizations.increment(
            "example_authorization",
            {"increment_amount": 50, "is_amount_controllable": True},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/increment",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="increment_amount=50&is_amount_controllable=True",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_authorizations_increment_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Authorization.TestHelpers.increment_async(
            "example_authorization",
            increment_amount=50,
            is_amount_controllable=True,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/increment",
            query_string="",
            post_data="increment_amount=50&is_amount_controllable=True",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_authorizations_increment_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/authorizations/example_authorization/increment",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.authorizations.increment_async(
            "example_authorization",
            {"increment_amount": 50, "is_amount_controllable": True},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/increment",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="increment_amount=50&is_amount_controllable=True",
        )

    def test_test_helpers_issuing_authorizations_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Authorization.TestHelpers.create(
            amount=100,
            amount_details={"atm_fee": 10, "cashback_amount": 5},
            authorization_method="chip",
            card="foo",
            currency="usd",
            is_amount_controllable=True,
            merchant_data={
                "category": "ac_refrigeration_repair",
                "city": "foo",
                "country": "bar",
                "name": "foo",
                "network_id": "bar",
                "postal_code": "foo",
                "state": "bar",
                "terminal_id": "foo",
            },
            network_data={"acquiring_institution_id": "foo"},
            verification_data={
                "address_line1_check": "mismatch",
                "address_postal_code_check": "match",
                "cvc_check": "match",
                "expiry_check": "mismatch",
            },
            wallet="apple_pay",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations",
            query_string="",
            post_data="amount=100&amount_details[atm_fee]=10&amount_details[cashback_amount]=5&authorization_method=chip&card=foo&currency=usd&is_amount_controllable=True&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=bar&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=foo&merchant_data[state]=bar&merchant_data[terminal_id]=foo&network_data[acquiring_institution_id]=foo&verification_data[address_line1_check]=mismatch&verification_data[address_postal_code_check]=match&verification_data[cvc_check]=match&verification_data[expiry_check]=mismatch&wallet=apple_pay",
        )

    def test_test_helpers_issuing_authorizations_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/authorizations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.authorizations.create(
            {
                "amount": 100,
                "amount_details": {"atm_fee": 10, "cashback_amount": 5},
                "authorization_method": "chip",
                "card": "foo",
                "currency": "usd",
                "is_amount_controllable": True,
                "merchant_data": {
                    "category": "ac_refrigeration_repair",
                    "city": "foo",
                    "country": "bar",
                    "name": "foo",
                    "network_id": "bar",
                    "postal_code": "foo",
                    "state": "bar",
                    "terminal_id": "foo",
                },
                "network_data": {"acquiring_institution_id": "foo"},
                "verification_data": {
                    "address_line1_check": "mismatch",
                    "address_postal_code_check": "match",
                    "cvc_check": "match",
                    "expiry_check": "mismatch",
                },
                "wallet": "apple_pay",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=100&amount_details[atm_fee]=10&amount_details[cashback_amount]=5&authorization_method=chip&card=foo&currency=usd&is_amount_controllable=True&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=bar&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=foo&merchant_data[state]=bar&merchant_data[terminal_id]=foo&network_data[acquiring_institution_id]=foo&verification_data[address_line1_check]=mismatch&verification_data[address_postal_code_check]=match&verification_data[cvc_check]=match&verification_data[expiry_check]=mismatch&wallet=apple_pay",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_authorizations_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Authorization.TestHelpers.create_async(
            amount=100,
            amount_details={"atm_fee": 10, "cashback_amount": 5},
            authorization_method="chip",
            card="foo",
            currency="usd",
            is_amount_controllable=True,
            merchant_data={
                "category": "ac_refrigeration_repair",
                "city": "foo",
                "country": "bar",
                "name": "foo",
                "network_id": "bar",
                "postal_code": "foo",
                "state": "bar",
                "terminal_id": "foo",
            },
            network_data={"acquiring_institution_id": "foo"},
            verification_data={
                "address_line1_check": "mismatch",
                "address_postal_code_check": "match",
                "cvc_check": "match",
                "expiry_check": "mismatch",
            },
            wallet="apple_pay",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations",
            query_string="",
            post_data="amount=100&amount_details[atm_fee]=10&amount_details[cashback_amount]=5&authorization_method=chip&card=foo&currency=usd&is_amount_controllable=True&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=bar&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=foo&merchant_data[state]=bar&merchant_data[terminal_id]=foo&network_data[acquiring_institution_id]=foo&verification_data[address_line1_check]=mismatch&verification_data[address_postal_code_check]=match&verification_data[cvc_check]=match&verification_data[expiry_check]=mismatch&wallet=apple_pay",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_authorizations_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/authorizations",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.authorizations.create_async(
            {
                "amount": 100,
                "amount_details": {"atm_fee": 10, "cashback_amount": 5},
                "authorization_method": "chip",
                "card": "foo",
                "currency": "usd",
                "is_amount_controllable": True,
                "merchant_data": {
                    "category": "ac_refrigeration_repair",
                    "city": "foo",
                    "country": "bar",
                    "name": "foo",
                    "network_id": "bar",
                    "postal_code": "foo",
                    "state": "bar",
                    "terminal_id": "foo",
                },
                "network_data": {"acquiring_institution_id": "foo"},
                "verification_data": {
                    "address_line1_check": "mismatch",
                    "address_postal_code_check": "match",
                    "cvc_check": "match",
                    "expiry_check": "mismatch",
                },
                "wallet": "apple_pay",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=100&amount_details[atm_fee]=10&amount_details[cashback_amount]=5&authorization_method=chip&card=foo&currency=usd&is_amount_controllable=True&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=bar&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=foo&merchant_data[state]=bar&merchant_data[terminal_id]=foo&network_data[acquiring_institution_id]=foo&verification_data[address_line1_check]=mismatch&verification_data[address_postal_code_check]=match&verification_data[cvc_check]=match&verification_data[expiry_check]=mismatch&wallet=apple_pay",
        )

    def test_test_helpers_issuing_authorizations_reverse_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Authorization.TestHelpers.reverse(
            "example_authorization",
            reverse_amount=20,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/reverse",
            query_string="",
            post_data="reverse_amount=20",
        )

    def test_test_helpers_issuing_authorizations_reverse_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/authorizations/example_authorization/reverse",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.authorizations.reverse(
            "example_authorization",
            {"reverse_amount": 20},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/reverse",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="reverse_amount=20",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_authorizations_reverse_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Authorization.TestHelpers.reverse_async(
            "example_authorization",
            reverse_amount=20,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/reverse",
            query_string="",
            post_data="reverse_amount=20",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_authorizations_reverse_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/authorizations/example_authorization/reverse",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.authorizations.reverse_async(
            "example_authorization",
            {"reverse_amount": 20},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/authorizations/example_authorization/reverse",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="reverse_amount=20",
        )

    def test_test_helpers_issuing_cards_shipping_deliver_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Card.TestHelpers.deliver_card("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/deliver",
            query_string="",
        )

    def test_test_helpers_issuing_cards_shipping_deliver_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/cards/card_123/shipping/deliver",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.cards.deliver_card("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/deliver",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_cards_shipping_deliver_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Card.TestHelpers.deliver_card_async("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/deliver",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_cards_shipping_deliver_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/cards/card_123/shipping/deliver",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.cards.deliver_card_async("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/deliver",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_issuing_cards_shipping_fail_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Card.TestHelpers.fail_card("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/fail",
            query_string="",
        )

    def test_test_helpers_issuing_cards_shipping_fail_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/cards/card_123/shipping/fail",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.cards.fail_card("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/fail",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_cards_shipping_fail_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Card.TestHelpers.fail_card_async("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/fail",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_cards_shipping_fail_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/cards/card_123/shipping/fail",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.cards.fail_card_async("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/fail",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_issuing_cards_shipping_return_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Card.TestHelpers.return_card("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/return",
            query_string="",
        )

    def test_test_helpers_issuing_cards_shipping_return_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/cards/card_123/shipping/return",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.cards.return_card("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/return",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_cards_shipping_return_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Card.TestHelpers.return_card_async("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/return",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_cards_shipping_return_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/cards/card_123/shipping/return",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.cards.return_card_async("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/return",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_issuing_cards_shipping_ship_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Card.TestHelpers.ship_card("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/ship",
            query_string="",
        )

    def test_test_helpers_issuing_cards_shipping_ship_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/cards/card_123/shipping/ship",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.cards.ship_card("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/ship",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_cards_shipping_ship_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Card.TestHelpers.ship_card_async("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/ship",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_cards_shipping_ship_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/cards/card_123/shipping/ship",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.cards.ship_card_async("card_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/cards/card_123/shipping/ship",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_issuing_personalization_designs_activate_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.PersonalizationDesign.TestHelpers.activate("pd_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/activate",
            query_string="",
        )

    def test_test_helpers_issuing_personalization_designs_activate_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/personalization_designs/pd_xyz/activate",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.personalization_designs.activate("pd_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/activate",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_personalization_designs_activate_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.PersonalizationDesign.TestHelpers.activate_async(
            "pd_xyz",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/activate",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_personalization_designs_activate_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/personalization_designs/pd_xyz/activate",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await (
            client.test_helpers.issuing.personalization_designs.activate_async(
                "pd_xyz"
            )
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/activate",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_issuing_personalization_designs_deactivate_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.PersonalizationDesign.TestHelpers.deactivate("pd_xyz")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/deactivate",
            query_string="",
        )

    def test_test_helpers_issuing_personalization_designs_deactivate_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/personalization_designs/pd_xyz/deactivate",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.personalization_designs.deactivate(
            "pd_xyz"
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/deactivate",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_personalization_designs_deactivate_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await (
            stripe.issuing.PersonalizationDesign.TestHelpers.deactivate_async(
                "pd_xyz",
            )
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/deactivate",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_personalization_designs_deactivate_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/personalization_designs/pd_xyz/deactivate",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.personalization_designs.deactivate_async(
            "pd_xyz"
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/deactivate",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_issuing_personalization_designs_reject_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.PersonalizationDesign.TestHelpers.reject(
            "pd_xyz",
            rejection_reasons={"card_logo": ["geographic_location"]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/reject",
            query_string="",
            post_data="rejection_reasons[card_logo][0]=geographic_location",
        )

    def test_test_helpers_issuing_personalization_designs_reject_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/personalization_designs/pd_xyz/reject",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.personalization_designs.reject(
            "pd_xyz",
            {"rejection_reasons": {"card_logo": ["geographic_location"]}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/reject",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="rejection_reasons[card_logo][0]=geographic_location",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_personalization_designs_reject_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.PersonalizationDesign.TestHelpers.reject_async(
            "pd_xyz",
            rejection_reasons={"card_logo": ["geographic_location"]},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/reject",
            query_string="",
            post_data="rejection_reasons[card_logo][0]=geographic_location",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_personalization_designs_reject_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/personalization_designs/pd_xyz/reject",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.personalization_designs.reject_async(
            "pd_xyz",
            {"rejection_reasons": {"card_logo": ["geographic_location"]}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/personalization_designs/pd_xyz/reject",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="rejection_reasons[card_logo][0]=geographic_location",
        )

    def test_test_helpers_issuing_transactions_create_force_capture_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Transaction.TestHelpers.create_force_capture(
            amount=100,
            card="foo",
            currency="usd",
            merchant_data={
                "category": "ac_refrigeration_repair",
                "city": "foo",
                "country": "US",
                "name": "foo",
                "network_id": "bar",
                "postal_code": "10001",
                "state": "NY",
                "terminal_id": "foo",
            },
            purchase_details={
                "flight": {
                    "departure_at": 1633651200,
                    "passenger_name": "John Doe",
                    "refundable": True,
                    "segments": [
                        {
                            "arrival_airport_code": "SFO",
                            "carrier": "Delta",
                            "departure_airport_code": "LAX",
                            "flight_number": "DL100",
                            "service_class": "Economy",
                            "stopover_allowed": True,
                        },
                    ],
                    "travel_agency": "Orbitz",
                },
                "fuel": {
                    "type": "diesel",
                    "unit": "liter",
                    "unit_cost_decimal": "3.5",
                    "quantity_decimal": "10",
                },
                "lodging": {"check_in_at": 1533651200, "nights": 2},
                "receipt": [
                    {
                        "description": "Room charge",
                        "quantity": "1",
                        "total": 200,
                        "unit_cost": 200,
                    },
                ],
                "reference": "foo",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/create_force_capture",
            query_string="",
            post_data="amount=100&card=foo&currency=usd&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=US&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=10001&merchant_data[state]=NY&merchant_data[terminal_id]=foo&purchase_details[flight][departure_at]=1633651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1533651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    def test_test_helpers_issuing_transactions_create_force_capture_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/transactions/create_force_capture",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.transactions.create_force_capture(
            {
                "amount": 100,
                "card": "foo",
                "currency": "usd",
                "merchant_data": {
                    "category": "ac_refrigeration_repair",
                    "city": "foo",
                    "country": "US",
                    "name": "foo",
                    "network_id": "bar",
                    "postal_code": "10001",
                    "state": "NY",
                    "terminal_id": "foo",
                },
                "purchase_details": {
                    "flight": {
                        "departure_at": 1633651200,
                        "passenger_name": "John Doe",
                        "refundable": True,
                        "segments": [
                            {
                                "arrival_airport_code": "SFO",
                                "carrier": "Delta",
                                "departure_airport_code": "LAX",
                                "flight_number": "DL100",
                                "service_class": "Economy",
                                "stopover_allowed": True,
                            },
                        ],
                        "travel_agency": "Orbitz",
                    },
                    "fuel": {
                        "type": "diesel",
                        "unit": "liter",
                        "unit_cost_decimal": "3.5",
                        "quantity_decimal": "10",
                    },
                    "lodging": {"check_in_at": 1533651200, "nights": 2},
                    "receipt": [
                        {
                            "description": "Room charge",
                            "quantity": "1",
                            "total": 200,
                            "unit_cost": 200,
                        },
                    ],
                    "reference": "foo",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/create_force_capture",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=100&card=foo&currency=usd&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=US&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=10001&merchant_data[state]=NY&merchant_data[terminal_id]=foo&purchase_details[flight][departure_at]=1633651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1533651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_transactions_create_force_capture_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await (
            stripe.issuing.Transaction.TestHelpers.create_force_capture_async(
                amount=100,
                card="foo",
                currency="usd",
                merchant_data={
                    "category": "ac_refrigeration_repair",
                    "city": "foo",
                    "country": "US",
                    "name": "foo",
                    "network_id": "bar",
                    "postal_code": "10001",
                    "state": "NY",
                    "terminal_id": "foo",
                },
                purchase_details={
                    "flight": {
                        "departure_at": 1633651200,
                        "passenger_name": "John Doe",
                        "refundable": True,
                        "segments": [
                            {
                                "arrival_airport_code": "SFO",
                                "carrier": "Delta",
                                "departure_airport_code": "LAX",
                                "flight_number": "DL100",
                                "service_class": "Economy",
                                "stopover_allowed": True,
                            },
                        ],
                        "travel_agency": "Orbitz",
                    },
                    "fuel": {
                        "type": "diesel",
                        "unit": "liter",
                        "unit_cost_decimal": "3.5",
                        "quantity_decimal": "10",
                    },
                    "lodging": {"check_in_at": 1533651200, "nights": 2},
                    "receipt": [
                        {
                            "description": "Room charge",
                            "quantity": "1",
                            "total": 200,
                            "unit_cost": 200,
                        },
                    ],
                    "reference": "foo",
                },
            )
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/create_force_capture",
            query_string="",
            post_data="amount=100&card=foo&currency=usd&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=US&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=10001&merchant_data[state]=NY&merchant_data[terminal_id]=foo&purchase_details[flight][departure_at]=1633651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1533651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_transactions_create_force_capture_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/transactions/create_force_capture",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.transactions.create_force_capture_async(
            {
                "amount": 100,
                "card": "foo",
                "currency": "usd",
                "merchant_data": {
                    "category": "ac_refrigeration_repair",
                    "city": "foo",
                    "country": "US",
                    "name": "foo",
                    "network_id": "bar",
                    "postal_code": "10001",
                    "state": "NY",
                    "terminal_id": "foo",
                },
                "purchase_details": {
                    "flight": {
                        "departure_at": 1633651200,
                        "passenger_name": "John Doe",
                        "refundable": True,
                        "segments": [
                            {
                                "arrival_airport_code": "SFO",
                                "carrier": "Delta",
                                "departure_airport_code": "LAX",
                                "flight_number": "DL100",
                                "service_class": "Economy",
                                "stopover_allowed": True,
                            },
                        ],
                        "travel_agency": "Orbitz",
                    },
                    "fuel": {
                        "type": "diesel",
                        "unit": "liter",
                        "unit_cost_decimal": "3.5",
                        "quantity_decimal": "10",
                    },
                    "lodging": {"check_in_at": 1533651200, "nights": 2},
                    "receipt": [
                        {
                            "description": "Room charge",
                            "quantity": "1",
                            "total": 200,
                            "unit_cost": 200,
                        },
                    ],
                    "reference": "foo",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/create_force_capture",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=100&card=foo&currency=usd&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=US&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=10001&merchant_data[state]=NY&merchant_data[terminal_id]=foo&purchase_details[flight][departure_at]=1633651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1533651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    def test_test_helpers_issuing_transactions_create_unlinked_refund_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Transaction.TestHelpers.create_unlinked_refund(
            amount=100,
            card="foo",
            currency="usd",
            merchant_data={
                "category": "ac_refrigeration_repair",
                "city": "foo",
                "country": "bar",
                "name": "foo",
                "network_id": "bar",
                "postal_code": "foo",
                "state": "bar",
                "terminal_id": "foo",
            },
            purchase_details={
                "flight": {
                    "departure_at": 1533651200,
                    "passenger_name": "John Doe",
                    "refundable": True,
                    "segments": [
                        {
                            "arrival_airport_code": "SFO",
                            "carrier": "Delta",
                            "departure_airport_code": "LAX",
                            "flight_number": "DL100",
                            "service_class": "Economy",
                            "stopover_allowed": True,
                        },
                    ],
                    "travel_agency": "Orbitz",
                },
                "fuel": {
                    "type": "diesel",
                    "unit": "liter",
                    "unit_cost_decimal": "3.5",
                    "quantity_decimal": "10",
                },
                "lodging": {"check_in_at": 1533651200, "nights": 2},
                "receipt": [
                    {
                        "description": "Room charge",
                        "quantity": "1",
                        "total": 200,
                        "unit_cost": 200,
                    },
                ],
                "reference": "foo",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/create_unlinked_refund",
            query_string="",
            post_data="amount=100&card=foo&currency=usd&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=bar&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=foo&merchant_data[state]=bar&merchant_data[terminal_id]=foo&purchase_details[flight][departure_at]=1533651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1533651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    def test_test_helpers_issuing_transactions_create_unlinked_refund_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/transactions/create_unlinked_refund",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.transactions.create_unlinked_refund(
            {
                "amount": 100,
                "card": "foo",
                "currency": "usd",
                "merchant_data": {
                    "category": "ac_refrigeration_repair",
                    "city": "foo",
                    "country": "bar",
                    "name": "foo",
                    "network_id": "bar",
                    "postal_code": "foo",
                    "state": "bar",
                    "terminal_id": "foo",
                },
                "purchase_details": {
                    "flight": {
                        "departure_at": 1533651200,
                        "passenger_name": "John Doe",
                        "refundable": True,
                        "segments": [
                            {
                                "arrival_airport_code": "SFO",
                                "carrier": "Delta",
                                "departure_airport_code": "LAX",
                                "flight_number": "DL100",
                                "service_class": "Economy",
                                "stopover_allowed": True,
                            },
                        ],
                        "travel_agency": "Orbitz",
                    },
                    "fuel": {
                        "type": "diesel",
                        "unit": "liter",
                        "unit_cost_decimal": "3.5",
                        "quantity_decimal": "10",
                    },
                    "lodging": {"check_in_at": 1533651200, "nights": 2},
                    "receipt": [
                        {
                            "description": "Room charge",
                            "quantity": "1",
                            "total": 200,
                            "unit_cost": 200,
                        },
                    ],
                    "reference": "foo",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/create_unlinked_refund",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=100&card=foo&currency=usd&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=bar&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=foo&merchant_data[state]=bar&merchant_data[terminal_id]=foo&purchase_details[flight][departure_at]=1533651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1533651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_transactions_create_unlinked_refund_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Transaction.TestHelpers.create_unlinked_refund_async(
            amount=100,
            card="foo",
            currency="usd",
            merchant_data={
                "category": "ac_refrigeration_repair",
                "city": "foo",
                "country": "bar",
                "name": "foo",
                "network_id": "bar",
                "postal_code": "foo",
                "state": "bar",
                "terminal_id": "foo",
            },
            purchase_details={
                "flight": {
                    "departure_at": 1533651200,
                    "passenger_name": "John Doe",
                    "refundable": True,
                    "segments": [
                        {
                            "arrival_airport_code": "SFO",
                            "carrier": "Delta",
                            "departure_airport_code": "LAX",
                            "flight_number": "DL100",
                            "service_class": "Economy",
                            "stopover_allowed": True,
                        },
                    ],
                    "travel_agency": "Orbitz",
                },
                "fuel": {
                    "type": "diesel",
                    "unit": "liter",
                    "unit_cost_decimal": "3.5",
                    "quantity_decimal": "10",
                },
                "lodging": {"check_in_at": 1533651200, "nights": 2},
                "receipt": [
                    {
                        "description": "Room charge",
                        "quantity": "1",
                        "total": 200,
                        "unit_cost": 200,
                    },
                ],
                "reference": "foo",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/create_unlinked_refund",
            query_string="",
            post_data="amount=100&card=foo&currency=usd&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=bar&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=foo&merchant_data[state]=bar&merchant_data[terminal_id]=foo&purchase_details[flight][departure_at]=1533651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1533651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_transactions_create_unlinked_refund_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/transactions/create_unlinked_refund",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.transactions.create_unlinked_refund_async(
            {
                "amount": 100,
                "card": "foo",
                "currency": "usd",
                "merchant_data": {
                    "category": "ac_refrigeration_repair",
                    "city": "foo",
                    "country": "bar",
                    "name": "foo",
                    "network_id": "bar",
                    "postal_code": "foo",
                    "state": "bar",
                    "terminal_id": "foo",
                },
                "purchase_details": {
                    "flight": {
                        "departure_at": 1533651200,
                        "passenger_name": "John Doe",
                        "refundable": True,
                        "segments": [
                            {
                                "arrival_airport_code": "SFO",
                                "carrier": "Delta",
                                "departure_airport_code": "LAX",
                                "flight_number": "DL100",
                                "service_class": "Economy",
                                "stopover_allowed": True,
                            },
                        ],
                        "travel_agency": "Orbitz",
                    },
                    "fuel": {
                        "type": "diesel",
                        "unit": "liter",
                        "unit_cost_decimal": "3.5",
                        "quantity_decimal": "10",
                    },
                    "lodging": {"check_in_at": 1533651200, "nights": 2},
                    "receipt": [
                        {
                            "description": "Room charge",
                            "quantity": "1",
                            "total": 200,
                            "unit_cost": 200,
                        },
                    ],
                    "reference": "foo",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/create_unlinked_refund",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=100&card=foo&currency=usd&merchant_data[category]=ac_refrigeration_repair&merchant_data[city]=foo&merchant_data[country]=bar&merchant_data[name]=foo&merchant_data[network_id]=bar&merchant_data[postal_code]=foo&merchant_data[state]=bar&merchant_data[terminal_id]=foo&purchase_details[flight][departure_at]=1533651200&purchase_details[flight][passenger_name]=John%20Doe&purchase_details[flight][refundable]=True&purchase_details[flight][segments][0][arrival_airport_code]=SFO&purchase_details[flight][segments][0][carrier]=Delta&purchase_details[flight][segments][0][departure_airport_code]=LAX&purchase_details[flight][segments][0][flight_number]=DL100&purchase_details[flight][segments][0][service_class]=Economy&purchase_details[flight][segments][0][stopover_allowed]=True&purchase_details[flight][travel_agency]=Orbitz&purchase_details[fuel][type]=diesel&purchase_details[fuel][unit]=liter&purchase_details[fuel][unit_cost_decimal]=3.5&purchase_details[fuel][quantity_decimal]=10&purchase_details[lodging][check_in_at]=1533651200&purchase_details[lodging][nights]=2&purchase_details[receipt][0][description]=Room%20charge&purchase_details[receipt][0][quantity]=1&purchase_details[receipt][0][total]=200&purchase_details[receipt][0][unit_cost]=200&purchase_details[reference]=foo",
        )

    def test_test_helpers_issuing_transactions_refund_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.issuing.Transaction.TestHelpers.refund(
            "example_transaction",
            refund_amount=50,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/example_transaction/refund",
            query_string="",
            post_data="refund_amount=50",
        )

    def test_test_helpers_issuing_transactions_refund_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/transactions/example_transaction/refund",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.issuing.transactions.refund(
            "example_transaction",
            {"refund_amount": 50},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/example_transaction/refund",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="refund_amount=50",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_transactions_refund_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.issuing.Transaction.TestHelpers.refund_async(
            "example_transaction",
            refund_amount=50,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/example_transaction/refund",
            query_string="",
            post_data="refund_amount=50",
        )

    @pytest.mark.anyio
    async def test_test_helpers_issuing_transactions_refund_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/issuing/transactions/example_transaction/refund",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.issuing.transactions.refund_async(
            "example_transaction",
            {"refund_amount": 50},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/issuing/transactions/example_transaction/refund",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="refund_amount=50",
        )

    def test_test_helpers_refunds_expire_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Refund.TestHelpers.expire("re_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/refunds/re_123/expire",
            query_string="",
        )

    def test_test_helpers_refunds_expire_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/refunds/re_123/expire",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.refunds.expire("re_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/refunds/re_123/expire",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_refunds_expire_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Refund.TestHelpers.expire_async("re_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/refunds/re_123/expire",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_refunds_expire_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/refunds/re_123/expire",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.refunds.expire_async("re_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/refunds/re_123/expire",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_test_clocks_advance_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.test_helpers.TestClock.advance(
            "clock_xyz",
            frozen_time=142,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks/clock_xyz/advance",
            query_string="",
            post_data="frozen_time=142",
        )

    def test_test_helpers_test_clocks_advance_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/test_clocks/clock_xyz/advance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.test_clocks.advance(
            "clock_xyz",
            {"frozen_time": 142},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks/clock_xyz/advance",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="frozen_time=142",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_advance_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.test_helpers.TestClock.advance_async(
            "clock_xyz",
            frozen_time=142,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks/clock_xyz/advance",
            query_string="",
            post_data="frozen_time=142",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_advance_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/test_clocks/clock_xyz/advance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.test_clocks.advance_async(
            "clock_xyz",
            {"frozen_time": 142},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks/clock_xyz/advance",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="frozen_time=142",
        )

    def test_test_helpers_test_clocks_advance_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.test_helpers.TestClock.advance(
            "clock_xxxxxxxxxxxxx",
            frozen_time=1675552261,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx/advance",
            query_string="",
            post_data="frozen_time=1675552261",
        )

    def test_test_helpers_test_clocks_advance_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx/advance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.test_clocks.advance(
            "clock_xxxxxxxxxxxxx",
            {"frozen_time": 1675552261},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx/advance",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="frozen_time=1675552261",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_advance_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.test_helpers.TestClock.advance_async(
            "clock_xxxxxxxxxxxxx",
            frozen_time=1675552261,
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx/advance",
            query_string="",
            post_data="frozen_time=1675552261",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_advance_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx/advance",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.test_clocks.advance_async(
            "clock_xxxxxxxxxxxxx",
            {"frozen_time": 1675552261},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx/advance",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="frozen_time=1675552261",
        )

    def test_test_helpers_test_clocks_delete(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.test_helpers.TestClock.delete("clock_xyz")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/test_helpers/test_clocks/clock_xyz",
            query_string="",
        )

    def test_test_helpers_test_clocks_delete_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/test_helpers/test_clocks/clock_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.test_clocks.delete("clock_xyz")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/test_helpers/test_clocks/clock_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_delete_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.test_helpers.TestClock.delete_async("clock_xyz")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/test_helpers/test_clocks/clock_xyz",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_delete_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/test_helpers/test_clocks/clock_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.test_clocks.delete_async("clock_xyz")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/test_helpers/test_clocks/clock_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_test_clocks_delete_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.test_helpers.TestClock.delete("clock_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_test_helpers_test_clocks_delete_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.test_clocks.delete("clock_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_delete_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.test_helpers.TestClock.delete_async("clock_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "delete",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_delete_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "delete",
            "/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.test_clocks.delete_async(
            "clock_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "delete",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_test_clocks_get(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.test_helpers.TestClock.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks",
            query_string="",
        )

    def test_test_helpers_test_clocks_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/test_helpers/test_clocks",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.test_clocks.list()
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.test_helpers.TestClock.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/test_helpers/test_clocks",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.test_clocks.list_async()
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_test_clocks_get_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.test_helpers.TestClock.retrieve("clock_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks/clock_xyz",
            query_string="",
        )

    def test_test_helpers_test_clocks_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/test_helpers/test_clocks/clock_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.test_clocks.retrieve("clock_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks/clock_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.test_helpers.TestClock.retrieve_async("clock_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks/clock_xyz",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/test_helpers/test_clocks/clock_xyz",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.test_clocks.retrieve_async("clock_xyz")
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks/clock_xyz",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_test_clocks_get_3(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.test_helpers.TestClock.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks",
            query_string="limit=3",
        )

    def test_test_helpers_test_clocks_get_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/test_helpers/test_clocks",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.test_clocks.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_get_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.test_helpers.TestClock.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_get_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/test_helpers/test_clocks",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.test_clocks.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_test_clocks_get_4(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.test_helpers.TestClock.retrieve("clock_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_test_helpers_test_clocks_get_4_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.test_clocks.retrieve("clock_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_get_4_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.test_helpers.TestClock.retrieve_async(
            "clock_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_get_4_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.test_clocks.retrieve_async(
            "clock_xxxxxxxxxxxxx",
        )
        http_client_mock.assert_requested(
            "get",
            path="/v1/test_helpers/test_clocks/clock_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_test_clocks_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.test_helpers.TestClock.create(
            frozen_time=123,
            name="cogsworth",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks",
            query_string="",
            post_data="frozen_time=123&name=cogsworth",
        )

    def test_test_helpers_test_clocks_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/test_clocks",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.test_clocks.create(
            {
                "frozen_time": 123,
                "name": "cogsworth",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="frozen_time=123&name=cogsworth",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.test_helpers.TestClock.create_async(
            frozen_time=123,
            name="cogsworth",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks",
            query_string="",
            post_data="frozen_time=123&name=cogsworth",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/test_clocks",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.test_clocks.create_async(
            {
                "frozen_time": 123,
                "name": "cogsworth",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="frozen_time=123&name=cogsworth",
        )

    def test_test_helpers_test_clocks_post_2(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.test_helpers.TestClock.create(frozen_time=1577836800)
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks",
            query_string="",
            post_data="frozen_time=1577836800",
        )

    def test_test_helpers_test_clocks_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/test_clocks",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.test_clocks.create({"frozen_time": 1577836800})
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="frozen_time=1577836800",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.test_helpers.TestClock.create_async(
            frozen_time=1577836800
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks",
            query_string="",
            post_data="frozen_time=1577836800",
        )

    @pytest.mark.anyio
    async def test_test_helpers_test_clocks_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/test_clocks",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.test_clocks.create_async(
            {
                "frozen_time": 1577836800,
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/test_clocks",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="frozen_time=1577836800",
        )

    def test_test_helpers_treasury_inbound_transfers_fail_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.treasury.InboundTransfer.TestHelpers.fail(
            "ibt_123",
            failure_details={"code": "account_closed"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/fail",
            query_string="",
            post_data="failure_details[code]=account_closed",
        )

    def test_test_helpers_treasury_inbound_transfers_fail_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/inbound_transfers/ibt_123/fail",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.treasury.inbound_transfers.fail(
            "ibt_123",
            {"failure_details": {"code": "account_closed"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/fail",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="failure_details[code]=account_closed",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_inbound_transfers_fail_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.treasury.InboundTransfer.TestHelpers.fail_async(
            "ibt_123",
            failure_details={"code": "account_closed"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/fail",
            query_string="",
            post_data="failure_details[code]=account_closed",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_inbound_transfers_fail_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/inbound_transfers/ibt_123/fail",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.treasury.inbound_transfers.fail_async(
            "ibt_123",
            {"failure_details": {"code": "account_closed"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/fail",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="failure_details[code]=account_closed",
        )

    def test_test_helpers_treasury_inbound_transfers_return_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.treasury.InboundTransfer.TestHelpers.return_inbound_transfer(
            "ibt_123",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/return",
            query_string="",
        )

    def test_test_helpers_treasury_inbound_transfers_return_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/inbound_transfers/ibt_123/return",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.treasury.inbound_transfers.return_inbound_transfer(
            "ibt_123",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/return",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_inbound_transfers_return_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.treasury.InboundTransfer.TestHelpers.return_inbound_transfer_async(
            "ibt_123",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/return",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_inbound_transfers_return_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/inbound_transfers/ibt_123/return",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.treasury.inbound_transfers.return_inbound_transfer_async(
            "ibt_123"
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/return",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_treasury_inbound_transfers_succeed_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.treasury.InboundTransfer.TestHelpers.succeed("ibt_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/succeed",
            query_string="",
        )

    def test_test_helpers_treasury_inbound_transfers_succeed_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/inbound_transfers/ibt_123/succeed",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.treasury.inbound_transfers.succeed("ibt_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/succeed",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_inbound_transfers_succeed_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.treasury.InboundTransfer.TestHelpers.succeed_async(
            "ibt_123",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/succeed",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_inbound_transfers_succeed_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/inbound_transfers/ibt_123/succeed",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.treasury.inbound_transfers.succeed_async(
            "ibt_123",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/inbound_transfers/ibt_123/succeed",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_treasury_outbound_transfers_fail_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.treasury.OutboundTransfer.TestHelpers.fail("obt_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/fail",
            query_string="",
        )

    def test_test_helpers_treasury_outbound_transfers_fail_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/outbound_transfers/obt_123/fail",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.treasury.outbound_transfers.fail("obt_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/fail",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_outbound_transfers_fail_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.treasury.OutboundTransfer.TestHelpers.fail_async(
            "obt_123"
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/fail",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_outbound_transfers_fail_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/outbound_transfers/obt_123/fail",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.treasury.outbound_transfers.fail_async(
            "obt_123",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/fail",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_treasury_outbound_transfers_post_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.treasury.OutboundTransfer.TestHelpers.post("obt_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/post",
            query_string="",
        )

    def test_test_helpers_treasury_outbound_transfers_post_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/outbound_transfers/obt_123/post",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.treasury.outbound_transfers.post("obt_123")
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/post",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_outbound_transfers_post_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.treasury.OutboundTransfer.TestHelpers.post_async(
            "obt_123"
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/post",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_outbound_transfers_post_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/outbound_transfers/obt_123/post",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.treasury.outbound_transfers.post_async(
            "obt_123",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/post",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_test_helpers_treasury_outbound_transfers_return_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.treasury.OutboundTransfer.TestHelpers.return_outbound_transfer(
            "obt_123",
            returned_details={"code": "account_closed"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/return",
            query_string="",
            post_data="returned_details[code]=account_closed",
        )

    def test_test_helpers_treasury_outbound_transfers_return_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/outbound_transfers/obt_123/return",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.treasury.outbound_transfers.return_outbound_transfer(
            "obt_123",
            {"returned_details": {"code": "account_closed"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/return",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="returned_details[code]=account_closed",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_outbound_transfers_return_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.treasury.OutboundTransfer.TestHelpers.return_outbound_transfer_async(
            "obt_123",
            returned_details={"code": "account_closed"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/return",
            query_string="",
            post_data="returned_details[code]=account_closed",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_outbound_transfers_return_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/outbound_transfers/obt_123/return",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.treasury.outbound_transfers.return_outbound_transfer_async(
            "obt_123",
            {"returned_details": {"code": "account_closed"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/outbound_transfers/obt_123/return",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="returned_details[code]=account_closed",
        )

    def test_test_helpers_treasury_received_credits_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.treasury.ReceivedCredit.TestHelpers.create(
            financial_account="fa_123",
            network="ach",
            amount=1234,
            currency="usd",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/received_credits",
            query_string="",
            post_data="financial_account=fa_123&network=ach&amount=1234&currency=usd",
        )

    def test_test_helpers_treasury_received_credits_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/received_credits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.treasury.received_credits.create(
            {
                "financial_account": "fa_123",
                "network": "ach",
                "amount": 1234,
                "currency": "usd",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/received_credits",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="financial_account=fa_123&network=ach&amount=1234&currency=usd",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_received_credits_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.treasury.ReceivedCredit.TestHelpers.create_async(
            financial_account="fa_123",
            network="ach",
            amount=1234,
            currency="usd",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/received_credits",
            query_string="",
            post_data="financial_account=fa_123&network=ach&amount=1234&currency=usd",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_received_credits_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/received_credits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.treasury.received_credits.create_async(
            {
                "financial_account": "fa_123",
                "network": "ach",
                "amount": 1234,
                "currency": "usd",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/received_credits",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="financial_account=fa_123&network=ach&amount=1234&currency=usd",
        )

    def test_test_helpers_treasury_received_debits_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.treasury.ReceivedDebit.TestHelpers.create(
            financial_account="fa_123",
            network="ach",
            amount=1234,
            currency="usd",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/received_debits",
            query_string="",
            post_data="financial_account=fa_123&network=ach&amount=1234&currency=usd",
        )

    def test_test_helpers_treasury_received_debits_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/received_debits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.test_helpers.treasury.received_debits.create(
            {
                "financial_account": "fa_123",
                "network": "ach",
                "amount": 1234,
                "currency": "usd",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/received_debits",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="financial_account=fa_123&network=ach&amount=1234&currency=usd",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_received_debits_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.treasury.ReceivedDebit.TestHelpers.create_async(
            financial_account="fa_123",
            network="ach",
            amount=1234,
            currency="usd",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/received_debits",
            query_string="",
            post_data="financial_account=fa_123&network=ach&amount=1234&currency=usd",
        )

    @pytest.mark.anyio
    async def test_test_helpers_treasury_received_debits_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/test_helpers/treasury/received_debits",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.test_helpers.treasury.received_debits.create_async(
            {
                "financial_account": "fa_123",
                "network": "ach",
                "amount": 1234,
                "currency": "usd",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/test_helpers/treasury/received_debits",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="financial_account=fa_123&network=ach&amount=1234&currency=usd",
        )

    def test_tokens_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Token.retrieve("tok_xxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tokens/tok_xxxx",
            query_string="",
        )

    def test_tokens_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tokens/tok_xxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tokens.retrieve("tok_xxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tokens/tok_xxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_tokens_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Token.retrieve_async("tok_xxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tokens/tok_xxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_tokens_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/tokens/tok_xxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tokens.retrieve_async("tok_xxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/tokens/tok_xxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_tokens_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Token.create(
            card={
                "number": "4242424242424242",
                "exp_month": "5",
                "exp_year": "2023",
                "cvc": "314",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="card[number]=4242424242424242&card[exp_month]=5&card[exp_year]=2023&card[cvc]=314",
        )

    def test_tokens_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tokens.create(
            {
                "card": {
                    "number": "4242424242424242",
                    "exp_month": "5",
                    "exp_year": "2023",
                    "cvc": "314",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="card[number]=4242424242424242&card[exp_month]=5&card[exp_year]=2023&card[cvc]=314",
        )

    @pytest.mark.anyio
    async def test_tokens_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Token.create_async(
            card={
                "number": "4242424242424242",
                "exp_month": "5",
                "exp_year": "2023",
                "cvc": "314",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="card[number]=4242424242424242&card[exp_month]=5&card[exp_year]=2023&card[cvc]=314",
        )

    @pytest.mark.anyio
    async def test_tokens_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tokens.create_async(
            {
                "card": {
                    "number": "4242424242424242",
                    "exp_month": "5",
                    "exp_year": "2023",
                    "cvc": "314",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="card[number]=4242424242424242&card[exp_month]=5&card[exp_year]=2023&card[cvc]=314",
        )

    def test_tokens_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Token.create(
            bank_account={
                "country": "US",
                "currency": "usd",
                "account_holder_name": "Jenny Rosen",
                "account_holder_type": "individual",
                "routing_number": "110000000",
                "account_number": "000123456789",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="bank_account[country]=US&bank_account[currency]=usd&bank_account[account_holder_name]=Jenny%20Rosen&bank_account[account_holder_type]=individual&bank_account[routing_number]=110000000&bank_account[account_number]=000123456789",
        )

    def test_tokens_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tokens.create(
            {
                "bank_account": {
                    "country": "US",
                    "currency": "usd",
                    "account_holder_name": "Jenny Rosen",
                    "account_holder_type": "individual",
                    "routing_number": "110000000",
                    "account_number": "000123456789",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="bank_account[country]=US&bank_account[currency]=usd&bank_account[account_holder_name]=Jenny%20Rosen&bank_account[account_holder_type]=individual&bank_account[routing_number]=110000000&bank_account[account_number]=000123456789",
        )

    @pytest.mark.anyio
    async def test_tokens_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Token.create_async(
            bank_account={
                "country": "US",
                "currency": "usd",
                "account_holder_name": "Jenny Rosen",
                "account_holder_type": "individual",
                "routing_number": "110000000",
                "account_number": "000123456789",
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="bank_account[country]=US&bank_account[currency]=usd&bank_account[account_holder_name]=Jenny%20Rosen&bank_account[account_holder_type]=individual&bank_account[routing_number]=110000000&bank_account[account_number]=000123456789",
        )

    @pytest.mark.anyio
    async def test_tokens_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tokens.create_async(
            {
                "bank_account": {
                    "country": "US",
                    "currency": "usd",
                    "account_holder_name": "Jenny Rosen",
                    "account_holder_type": "individual",
                    "routing_number": "110000000",
                    "account_number": "000123456789",
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="bank_account[country]=US&bank_account[currency]=usd&bank_account[account_holder_name]=Jenny%20Rosen&bank_account[account_holder_type]=individual&bank_account[routing_number]=110000000&bank_account[account_number]=000123456789",
        )

    def test_tokens_post_3(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Token.create(pii={"id_number": "000000000"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="pii[id_number]=000000000",
        )

    def test_tokens_post_3_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tokens.create({"pii": {"id_number": "000000000"}})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="pii[id_number]=000000000",
        )

    @pytest.mark.anyio
    async def test_tokens_post_3_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Token.create_async(pii={"id_number": "000000000"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="pii[id_number]=000000000",
        )

    @pytest.mark.anyio
    async def test_tokens_post_3_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tokens.create_async({"pii": {"id_number": "000000000"}})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="pii[id_number]=000000000",
        )

    def test_tokens_post_4(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Token.create(
            account={
                "individual": {"first_name": "Jane", "last_name": "Doe"},
                "tos_shown_and_accepted": True,
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="account[individual][first_name]=Jane&account[individual][last_name]=Doe&account[tos_shown_and_accepted]=True",
        )

    def test_tokens_post_4_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tokens.create(
            {
                "account": {
                    "individual": {"first_name": "Jane", "last_name": "Doe"},
                    "tos_shown_and_accepted": True,
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="account[individual][first_name]=Jane&account[individual][last_name]=Doe&account[tos_shown_and_accepted]=True",
        )

    @pytest.mark.anyio
    async def test_tokens_post_4_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Token.create_async(
            account={
                "individual": {"first_name": "Jane", "last_name": "Doe"},
                "tos_shown_and_accepted": True,
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="account[individual][first_name]=Jane&account[individual][last_name]=Doe&account[tos_shown_and_accepted]=True",
        )

    @pytest.mark.anyio
    async def test_tokens_post_4_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tokens.create_async(
            {
                "account": {
                    "individual": {"first_name": "Jane", "last_name": "Doe"},
                    "tos_shown_and_accepted": True,
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="account[individual][first_name]=Jane&account[individual][last_name]=Doe&account[tos_shown_and_accepted]=True",
        )

    def test_tokens_post_5(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Token.create(
            person={
                "first_name": "Jane",
                "last_name": "Doe",
                "relationship": {"owner": True},
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="person[first_name]=Jane&person[last_name]=Doe&person[relationship][owner]=True",
        )

    def test_tokens_post_5_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tokens.create(
            {
                "person": {
                    "first_name": "Jane",
                    "last_name": "Doe",
                    "relationship": {"owner": True},
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="person[first_name]=Jane&person[last_name]=Doe&person[relationship][owner]=True",
        )

    @pytest.mark.anyio
    async def test_tokens_post_5_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Token.create_async(
            person={
                "first_name": "Jane",
                "last_name": "Doe",
                "relationship": {"owner": True},
            },
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="person[first_name]=Jane&person[last_name]=Doe&person[relationship][owner]=True",
        )

    @pytest.mark.anyio
    async def test_tokens_post_5_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tokens.create_async(
            {
                "person": {
                    "first_name": "Jane",
                    "last_name": "Doe",
                    "relationship": {"owner": True},
                },
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="person[first_name]=Jane&person[last_name]=Doe&person[relationship][owner]=True",
        )

    def test_tokens_post_6(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Token.create(cvc_update={"cvc": "123"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="cvc_update[cvc]=123",
        )

    def test_tokens_post_6_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.tokens.create({"cvc_update": {"cvc": "123"}})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="cvc_update[cvc]=123",
        )

    @pytest.mark.anyio
    async def test_tokens_post_6_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Token.create_async(cvc_update={"cvc": "123"})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            post_data="cvc_update[cvc]=123",
        )

    @pytest.mark.anyio
    async def test_tokens_post_6_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/tokens",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.tokens.create_async({"cvc_update": {"cvc": "123"}})
        http_client_mock.assert_requested(
            "post",
            path="/v1/tokens",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="cvc_update[cvc]=123",
        )

    def test_topups_cancel_post(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        stripe.Topup.cancel("tu_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups/tu_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    def test_topups_cancel_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/topups/tu_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.topups.cancel("tu_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups/tu_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_topups_cancel_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Topup.cancel_async("tu_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups/tu_xxxxxxxxxxxxx/cancel",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_topups_cancel_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/topups/tu_xxxxxxxxxxxxx/cancel",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.topups.cancel_async("tu_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups/tu_xxxxxxxxxxxxx/cancel",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_topups_get(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Topup.list(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/topups",
            query_string="limit=3",
        )

    def test_topups_get_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/topups",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.topups.list({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/topups",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_topups_get_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Topup.list_async(limit=3)
        http_client_mock.assert_requested(
            "get",
            path="/v1/topups",
            query_string="limit=3",
        )

    @pytest.mark.anyio
    async def test_topups_get_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/topups",
            "limit=3",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.topups.list_async({"limit": 3})
        http_client_mock.assert_requested(
            "get",
            path="/v1/topups",
            query_string="limit=3",
            api_base="https://api.stripe.com",
        )

    def test_topups_get_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Topup.retrieve("tu_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/topups/tu_xxxxxxxxxxxxx",
            query_string="",
        )

    def test_topups_get_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/topups/tu_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.topups.retrieve("tu_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/topups/tu_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    @pytest.mark.anyio
    async def test_topups_get_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Topup.retrieve_async("tu_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/topups/tu_xxxxxxxxxxxxx",
            query_string="",
        )

    @pytest.mark.anyio
    async def test_topups_get_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "get",
            "/v1/topups/tu_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.topups.retrieve_async("tu_xxxxxxxxxxxxx")
        http_client_mock.assert_requested(
            "get",
            path="/v1/topups/tu_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
        )

    def test_topups_post(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Topup.create(
            amount=2000,
            currency="usd",
            description="Top-up for Jenny Rosen",
            statement_descriptor="Top-up",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups",
            query_string="",
            post_data="amount=2000&currency=usd&description=Top-up%20for%20Jenny%20Rosen&statement_descriptor=Top-up",
        )

    def test_topups_post_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/topups",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.topups.create(
            {
                "amount": 2000,
                "currency": "usd",
                "description": "Top-up for Jenny Rosen",
                "statement_descriptor": "Top-up",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2000&currency=usd&description=Top-up%20for%20Jenny%20Rosen&statement_descriptor=Top-up",
        )

    @pytest.mark.anyio
    async def test_topups_post_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Topup.create_async(
            amount=2000,
            currency="usd",
            description="Top-up for Jenny Rosen",
            statement_descriptor="Top-up",
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups",
            query_string="",
            post_data="amount=2000&currency=usd&description=Top-up%20for%20Jenny%20Rosen&statement_descriptor=Top-up",
        )

    @pytest.mark.anyio
    async def test_topups_post_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/topups",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        await client.topups.create_async(
            {
                "amount": 2000,
                "currency": "usd",
                "description": "Top-up for Jenny Rosen",
                "statement_descriptor": "Top-up",
            }
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="amount=2000&currency=usd&description=Top-up%20for%20Jenny%20Rosen&statement_descriptor=Top-up",
        )

    def test_topups_post_2(self, http_client_mock: HTTPClientMock) -> None:
        stripe.Topup.modify(
            "tu_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups/tu_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    def test_topups_post_2_service(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/topups/tu_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_client_mock.get_mock_http_client(),
        )

        client.topups.update(
            "tu_xxxxxxxxxxxxx",
            {"metadata": {"order_id": "6735"}},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups/tu_xxxxxxxxxxxxx",
            query_string="",
            api_base="https://api.stripe.com",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_topups_post_2_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        await stripe.Topup.modify_async(
            "tu_xxxxxxxxxxxxx",
            metadata={"order_id": "6735"},
        )
        http_client_mock.assert_requested(
            "post",
            path="/v1/topups/tu_xxxxxxxxxxxxx",
            query_string="",
            post_data="metadata[order_id]=6735",
        )

    @pytest.mark.anyio
    async def test_topups_post_2_service_async(
        self, http_client_mock: HTTPClientMock
    ) -> None:
        http_client_mock.stub_request(
            "post",
            "/v1/topups/tu_xxxxxxxxxxxxx",
        )
        client = StripeClient(
            "sk_test_123",
            http_client=http_cl