# VERSION: 2021.5.x
# THIS FILE IS AUTOGENERATED FROM FLEX DOCUMENTATION.


from typing import List


class NewAccountProperty:
	keys: List[str] = ["key", "value"]

	def __init__(self, key: str, value: str):
		self.key = key
		self.value = value


class AccountPropertyUpdate:
	keys: List[str] = ["key", "value"]

	def __init__(self, key: str, value: str):
		self.key = key
		self.value = value


class NewAccount:
	keys: List[str] = ["account", "description", "metadataDefinition", "name", "variant"]

	def __init__(self, account: dict, description: str, metadataDefinition: dict, name: str, variant: str):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.metadataDefinitionId = metadataDefinition.get('id') if metadataDefinition else None
		self.name = name
		self.variant = variant


class AccountUpdate:
	keys: List[str] = ["description", "metadataDefinition", "name", "variant"]

	def __init__(self, description: str, metadataDefinition: dict, name: str, variant: str):
		self.description = description
		self.metadataDefinitionId = metadataDefinition.get('id') if metadataDefinition else None
		self.name = name
		self.variant = variant


class NewAction:
	keys: List[str] = ["account", "allowedAutoRetryAttempts", "autoRetryInterval", "concurrentJobsLimit", "description", "name", "pluginClass", "pluginUuid", "redoAction", "runRuleExpression", "supportsAutoRetry", "timeout", "type", "undoAction", "visibility"]

	def __init__(self, account: dict, allowedAutoRetryAttempts: str, autoRetryInterval: str, concurrentJobsLimit: int, description: str, name: str, pluginClass: str, pluginUuid: str, redoAction: dict, runRuleExpression: str, supportsAutoRetry: bool, timeout: int, type: str, undoAction: dict, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.allowedAutoRetryAttempts = allowedAutoRetryAttempts
		self.autoRetryInterval = autoRetryInterval
		self.concurrentJobsLimit = concurrentJobsLimit
		self.description = description
		self.name = name
		self.pluginClass = pluginClass
		self.pluginUuid = pluginUuid
		self.redoActionId = redoAction.get('id') if redoAction else None
		self.runRuleExpression = runRuleExpression
		self.supportsAutoRetry = supportsAutoRetry
		self.timeout = timeout
		self.type = type
		self.undoActionId = undoAction.get('id') if undoAction else None
		self.visibilityIds = [v['id'] for v in visibility]


class ActionUpdate:
	keys: List[str] = ["account", "allowedAutoRetryAttempts", "autoRetryInterval", "concurrentJobsLimit", "description", "name", "redoAction", "runRuleExpression", "supportsAutoRetry", "timeout", "undoAction", "visibility"]

	def __init__(self, account: dict, allowedAutoRetryAttempts: str, autoRetryInterval: str, concurrentJobsLimit: int, description: str, name: str, redoAction: int, runRuleExpression: str, supportsAutoRetry: bool, timeout: int, undoAction: int, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.allowedAutoRetryAttempts = allowedAutoRetryAttempts
		self.autoRetryInterval = autoRetryInterval
		self.concurrentJobsLimit = concurrentJobsLimit
		self.description = description
		self.name = name
		self.redoAction = redoAction
		self.runRuleExpression = runRuleExpression
		self.supportsAutoRetry = supportsAutoRetry
		self.timeout = timeout
		self.undoAction = undoAction
		self.visibilityIds = [v['id'] for v in visibility]


class NewAssetPlaceholder:
	keys: List[str] = ["account", "description", "fileUuid", "flexSiteUuid", "live", "mediaRegion", "metadataDefinition", "name", "parentGroupAsset", "parent", "parentMemberContainerAsset", "placedMediaRegions", "segmentedFileLocation", "type", "uuid", "variant", "workspace"]

	def __init__(self, account: dict, description: str, fileUuid: str, flexSiteUuid: str, live: bool, mediaRegion: dict, metadataDefinition: dict, name: str, parentGroupAsset: dict, parent: dict, parentMemberContainerAsset: dict, placedMediaRegions: List[int], segmentedFileLocation: dict, type: str, uuid: str, variant: str, workspace: dict):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.fileUuid = fileUuid
		self.flexSiteUuid = flexSiteUuid
		self.live = live
		self.mediaRegion = mediaRegion
		self.metadataDefinitionId = metadataDefinition.get('id') if metadataDefinition else None
		self.name = name
		self.parentGroupAssetId = parentGroupAsset.get('id') if parentGroupAsset else None
		self.parentId = parent.get('id') if parent else None
		self.parentMemberContainerAssetId = parentMemberContainerAsset.get('id') if parentMemberContainerAsset else None
		self.placedMediaRegions = placedMediaRegions
		self.segmentedFileLocation = segmentedFileLocation
		self.type = type
		self.uuid = uuid
		self.variant = variant
		self.workspaceId = workspace.get('id') if workspace else None


class AssetUpdate:
	keys: List[str] = ["allowActionOnArchived", "archived", "assetOrigin", "description", "fileDetails", "live", "metadataDefinition", "name", "referenceName", "restored", "uuid", "variant"]

	def __init__(self, allowActionOnArchived: bool, archived: bool, assetOrigin: str, description: str, fileDetails: dict, live: bool, metadataDefinition: dict, name: str, referenceName: str, restored: bool, uuid: str, variant: str):
		self.allowActionOnArchived = allowActionOnArchived
		self.archived = archived
		self.assetOrigin = assetOrigin
		self.description = description
		self.fileDetails = fileDetails
		self.live = live
		self.metadataDefinitionId = metadataDefinition.get('id') if metadataDefinition else None
		self.name = name
		self.referenceName = referenceName
		self.restored = restored
		self.uuid = uuid
		self.variant = variant


class CreateCollectionRequest:
	keys: List[str] = ["fql", "metadata", "metadataDefinitionEntity", "name", "parent", "parentUuid", "sharing", "type", "variant"]

	def __init__(self, fql: str, metadata: dict, metadataDefinitionEntity: dict, name: str, parent: dict, parentUuid: str, sharing: dict, type: str, variant: dict):
		self.fql = fql
		self.metadata = metadata
		self.metadataDefinitionEntityId = metadataDefinitionEntity.get('id') if metadataDefinitionEntity else None
		self.name = name
		self.parentId = parent.get('id') if parent else None
		self.parentUuid = parentUuid
		self.sharing = sharing
		self.type = type
		self.variantId = variant.get('id') if variant else None


class UpdateCollection:
	keys: List[str] = ["fql", "metadataDefinitionEntity", "name", "sharing", "type", "variant"]

	def __init__(self, fql: str, metadataDefinitionEntity: dict, name: str, sharing: dict, type: str, variant: dict):
		self.fql = fql
		self.metadataDefinitionEntityId = metadataDefinitionEntity.get('id') if metadataDefinitionEntity else None
		self.name = name
		self.sharing = sharing
		self.type = type
		self.variantId = variant.get('id') if variant else None


class NewEventHandler:
	keys: List[str] = ["account", "description", "filter", "name", "pluginClass", "pluginUuid", "visibility"]

	def __init__(self, account: dict, description: str, filter: str, name: str, pluginClass: str, pluginUuid: str, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.filter = filter
		self.name = name
		self.pluginClass = pluginClass
		self.pluginUuid = pluginUuid
		self.visibilityIds = [v['id'] for v in visibility]


class EventHandlerUpdate:
	keys: List[str] = ["account", "description", "filter", "name", "visibility"]

	def __init__(self, account: dict, description: str, filter: str, name: str, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.filter = filter
		self.name = name
		self.visibilityIds = [v['id'] for v in visibility]


class NewEvent:
	keys: List[str] = ["eventDataMap", "eventType", "exception", "message", "object"]

	def __init__(self, eventDataMap: dict, eventType: str, exception: str, message: str, object: dict):
		self.eventDataMap = eventDataMap
		self.eventType = eventType
		self.exception = exception
		self.message = message
		self.objectId = object.get('id') if object else None


class NewGroup:
	keys: List[str] = ["account", "description", "metadataDefinition", "name", "privateGroup", "role", "variant"]

	def __init__(self, account: dict, description: str, metadataDefinition: dict, name: str, privateGroup: bool, role: dict, variant: str):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.metadataDefinitionId = metadataDefinition.get('id') if metadataDefinition else None
		self.name = name
		self.privateGroup = privateGroup
		self.roleId = role.get('id') if role else None
		self.variant = variant


class GroupUpdate:
	keys: List[str] = ["description", "metadataDefinition", "name", "privateGroup", "role", "variant"]

	def __init__(self, description: str, metadataDefinition: dict, name: str, privateGroup: bool, role: dict, variant: str):
		self.description = description
		self.metadataDefinitionId = metadataDefinition.get('id') if metadataDefinition else None
		self.name = name
		self.privateGroup = privateGroup
		self.roleId = role.get('id') if role else None
		self.variant = variant


class NewJob:
	keys: List[str] = ["account", "actionConfig", "action", "actionUuid", "asset", "assetUuid", "contextExpression", "dateVariables", "event", "jobConfiguration", "mioObject", "mioObjectUuid", "objectVariables", "priority", "releaseLockOnFailure", "scheduleDate", "scheduleJob", "stringVariables", "user", "workspace"]

	def __init__(self, account: dict, actionConfig: dict, action: dict, actionUuid: str, asset: dict, assetUuid: str, contextExpression: str, dateVariables: dict, event: dict, jobConfiguration: str, mioObject: dict, mioObjectUuid: str, objectVariables: dict, priority: str, releaseLockOnFailure: bool, scheduleDate: str, scheduleJob: bool, stringVariables: dict, user: dict, workspace: dict):
		self.accountId = account.get('id') if account else None
		self.actionConfigId = actionConfig.get('id') if actionConfig else None
		self.actionId = action.get('id') if action else None
		self.actionUuid = actionUuid
		self.assetId = asset.get('id') if asset else None
		self.assetUuid = assetUuid
		self.contextExpression = contextExpression
		self.dateVariables = dateVariables
		self.eventId = event.get('id') if event else None
		self.jobConfiguration = jobConfiguration
		self.mioObjectId = mioObject.get('id') if mioObject else None
		self.mioObjectUuid = mioObjectUuid
		self.objectVariables = objectVariables
		self.priority = priority
		self.releaseLockOnFailure = releaseLockOnFailure
		self.scheduleDate = scheduleDate
		self.scheduleJob = scheduleJob
		self.stringVariables = stringVariables
		self.userId = user.get('id') if user else None
		self.workspaceId = workspace.get('id') if workspace else None


class NewMessageTemplate:
	keys: List[str] = ["account", "description", "name", "priority", "subject", "visibility"]

	def __init__(self, account: dict, description: str, name: str, priority: str, subject: str, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.priority = priority
		self.subject = subject
		self.visibilityIds = [v['id'] for v in visibility]


class MessageTemplateUpdate:
	keys: List[str] = ["account", "description", "name", "priority", "subject", "visibility"]

	def __init__(self, account: dict, description: str, name: str, priority: str, subject: str, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.priority = priority
		self.subject = subject
		self.visibilityIds = [v['id'] for v in visibility]


class NewMetadataDefinition:
	keys: List[str] = ["account", "description", "name", "systemMetadata", "visibility"]

	def __init__(self, account: dict, description: str, name: str, systemMetadata: bool, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.systemMetadata = systemMetadata
		self.visibilityIds = [v['id'] for v in visibility]


class MetadataDefinitionUpdate:
	keys: List[str] = ["account", "description", "name", "systemMetadata", "visibility"]

	def __init__(self, account: dict, description: str, name: str, systemMetadata: bool, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.systemMetadata = systemMetadata
		self.visibilityIds = [v['id'] for v in visibility]


class NewProfile:
	keys: List[str] = ["account", "description", "name", "type", "visibility"]

	def __init__(self, account: dict, description: str, name: str, type: str, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.type = type
		self.visibilityIds = [v['id'] for v in visibility]


class ProfileUpdate:
	keys: List[str] = ["account", "description", "name", "visibility"]

	def __init__(self, account: dict, description: str, name: str, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.visibilityIds = [v['id'] for v in visibility]


class NewQuota:
	keys: List[str] = ["account", "assignment", "description", "name", "pluginClass", "resources", "timeout"]

	def __init__(self, account: dict, assignment: int, description: str, name: str, pluginClass: str, resources: List[int], timeout: str):
		self.accountId = account.get('id') if account else None
		self.assignment = assignment
		self.description = description
		self.name = name
		self.pluginClass = pluginClass
		self.resources = resources
		self.timeout = timeout


class QuotaUpdate:
	keys: List[str] = ["assignment", "description", "name", "resources", "timeout"]

	def __init__(self, assignment: int, description: str, name: str, resources: List[int], timeout: str):
		self.assignment = assignment
		self.description = description
		self.name = name
		self.resources = resources
		self.timeout = timeout


class NewResource:
	keys: List[str] = ["account", "description", "name", "pluginClass", "pluginUuid", "pollingInterval", "runRuleExpression", "visibility"]

	def __init__(self, account: dict, description: str, name: str, pluginClass: str, pluginUuid: str, pollingInterval: int, runRuleExpression: str, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.pluginClass = pluginClass
		self.pluginUuid = pluginUuid
		self.pollingInterval = pollingInterval
		self.runRuleExpression = runRuleExpression
		self.visibilityIds = [v['id'] for v in visibility]


class ResourceUpdate:
	keys: List[str] = ["account", "description", "name", "pollingInterval", "runRuleExpression", "visibility"]

	def __init__(self, account: dict, description: str, name: str, pollingInterval: int, runRuleExpression: str, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.pollingInterval = pollingInterval
		self.runRuleExpression = runRuleExpression
		self.visibilityIds = [v['id'] for v in visibility]


class NewRole:
	keys: List[str] = ["account", "description", "name", "permissions", "privileged", "visibility"]

	def __init__(self, account: dict, description: str, name: str, permissions: List[int], privileged: bool, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.permissions = permissions
		self.privileged = privileged
		self.visibilityIds = [v['id'] for v in visibility]


class RoleUpdate:
	keys: List[str] = ["account", "description", "name", "permissions", "privileged", "privilegedSet", "visibility"]

	def __init__(self, account: dict, description: str, name: str, permissions: List[int], privileged: bool, privilegedSet: bool, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.permissions = permissions
		self.privileged = privileged
		self.privilegedSet = privilegedSet
		self.visibilityIds = [v['id'] for v in visibility]


class NewTaskDefinition:
	keys: List[str] = ["account", "assignment", "contextObject", "description", "expressionAssignment", "name", "taskType", "visibility", "wizard"]

	def __init__(self, account: dict, assignment: List[int], contextObject: str, description: str, expressionAssignment: str, name: str, taskType: str, visibility: List[dict], wizard: dict):
		self.accountId = account.get('id') if account else None
		self.assignment = assignment
		self.contextObject = contextObject
		self.description = description
		self.expressionAssignment = expressionAssignment
		self.name = name
		self.taskType = taskType
		self.visibilityIds = [v['id'] for v in visibility]
		self.wizardId = wizard.get('id') if wizard else None


class TaskDefinitionUpdate:
	keys: List[str] = ["account", "assignment", "contextObject", "description", "expressionAssignment", "name", "taskType", "visibility", "wizard"]

	def __init__(self, account: dict, assignment: List[int], contextObject: str, description: str, expressionAssignment: str, name: str, taskType: str, visibility: List[dict], wizard: dict):
		self.accountId = account.get('id') if account else None
		self.assignment = assignment
		self.contextObject = contextObject
		self.description = description
		self.expressionAssignment = expressionAssignment
		self.name = name
		self.taskType = taskType
		self.visibilityIds = [v['id'] for v in visibility]
		self.wizardId = wizard.get('id') if wizard else None


class NewTimedAction:
	keys: List[str] = ["account", "description", "interval", "name", "pluginClass", "pluginUuid"]

	def __init__(self, account: dict, description: str, interval: int, name: str, pluginClass: str, pluginUuid: str):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.interval = interval
		self.name = name
		self.pluginClass = pluginClass
		self.pluginUuid = pluginUuid


class TimedActionUpdate:
	keys: List[str] = ["description", "interval", "name", "pluginClass"]

	def __init__(self, description: str, interval: int, name: str, pluginClass: str):
		self.description = description
		self.interval = interval
		self.name = name
		self.pluginClass = pluginClass


class NewUserDefinedObjectType:
	keys: List[str] = ["account", "approvalSupported", "attachmentsSupported", "commentsSupported", "dataDefinition", "description", "destroySupported", "displayName", "duplicateChildNameSupported", "duplicateNameSupported", "lockSupported", "name", "panelSupported", "panelUrl", "pluralName", "rootOfObjectTypeRelationshipHierarchy", "runRuleExpression", "workspaceSupported"]

	def __init__(self, account: dict, approvalSupported: bool, attachmentsSupported: bool, commentsSupported: bool, dataDefinition: dict, description: str, destroySupported: bool, displayName: str, duplicateChildNameSupported: bool, duplicateNameSupported: bool, lockSupported: bool, name: str, panelSupported: bool, panelUrl: str, pluralName: str, rootOfObjectTypeRelationshipHierarchy: bool, runRuleExpression: str, workspaceSupported: bool):
		self.accountId = account.get('id') if account else None
		self.approvalSupported = approvalSupported
		self.attachmentsSupported = attachmentsSupported
		self.commentsSupported = commentsSupported
		self.dataDefinitionId = dataDefinition.get('id') if dataDefinition else None
		self.description = description
		self.destroySupported = destroySupported
		self.displayName = displayName
		self.duplicateChildNameSupported = duplicateChildNameSupported
		self.duplicateNameSupported = duplicateNameSupported
		self.lockSupported = lockSupported
		self.name = name
		self.panelSupported = panelSupported
		self.panelUrl = panelUrl
		self.pluralName = pluralName
		self.rootOfObjectTypeRelationshipHierarchy = rootOfObjectTypeRelationshipHierarchy
		self.runRuleExpression = runRuleExpression
		self.workspaceSupported = workspaceSupported


class UserDefinedObjectTypeUpdate:
	keys: List[str] = ["approvalSupported", "attachmentsSupported", "commentsSupported", "dataDefinition", "dataSupported", "description", "displayName", "duplicateChildNameSupported", "duplicateNameSupported", "lockSupported", "name", "panelSupported", "panelUrl", "pluralName", "rootOfObjectTypeRelationshipHierarchy", "runRuleExpression", "workspaceSupported"]

	def __init__(self, approvalSupported: bool, attachmentsSupported: bool, commentsSupported: bool, dataDefinition: dict, dataSupported: bool, description: str, displayName: str, duplicateChildNameSupported: bool, duplicateNameSupported: bool, lockSupported: bool, name: str, panelSupported: bool, panelUrl: str, pluralName: str, rootOfObjectTypeRelationshipHierarchy: bool, runRuleExpression: str, workspaceSupported: bool):
		self.approvalSupported = approvalSupported
		self.attachmentsSupported = attachmentsSupported
		self.commentsSupported = commentsSupported
		self.dataDefinitionId = dataDefinition.get('id') if dataDefinition else None
		self.dataSupported = dataSupported
		self.description = description
		self.displayName = displayName
		self.duplicateChildNameSupported = duplicateChildNameSupported
		self.duplicateNameSupported = duplicateNameSupported
		self.lockSupported = lockSupported
		self.name = name
		self.panelSupported = panelSupported
		self.panelUrl = panelUrl
		self.pluralName = pluralName
		self.rootOfObjectTypeRelationshipHierarchy = rootOfObjectTypeRelationshipHierarchy
		self.runRuleExpression = runRuleExpression
		self.workspaceSupported = workspaceSupported


class NewUser:
	keys: List[str] = ["accountExpiryDate", "account", "addressLine1", "addressLine2", "addressLine3", "authenticationProvider", "company", "description", "email", "emailNotificationError", "emailNotificationInfo", "emailNotificationWarning", "externalReference", "firstName", "lastName", "locale", "metadataDefinition", "name", "phoneNumber", "quote", "role", "smsNotificationError", "smsNotificationInfo", "smsNotificationWarning", "timezone", "userType", "variant"]

	def __init__(self, accountExpiryDate: str, account: dict, addressLine1: str, addressLine2: str, addressLine3: str, authenticationProvider: str, company: str, description: str, email: str, emailNotificationError: bool, emailNotificationInfo: bool, emailNotificationWarning: bool, externalReference: str, firstName: str, lastName: str, locale: str, metadataDefinition: dict, name: str, phoneNumber: str, quote: str, role: dict, smsNotificationError: bool, smsNotificationInfo: bool, smsNotificationWarning: bool, timezone: str, userType: str, variant: str):
		self.accountExpiryDate = accountExpiryDate
		self.accountId = account.get('id') if account else None
		self.addressLine1 = addressLine1
		self.addressLine2 = addressLine2
		self.addressLine3 = addressLine3
		self.authenticationProvider = authenticationProvider
		self.company = company
		self.description = description
		self.email = email
		self.emailNotificationError = emailNotificationError
		self.emailNotificationInfo = emailNotificationInfo
		self.emailNotificationWarning = emailNotificationWarning
		self.externalReference = externalReference
		self.firstName = firstName
		self.lastName = lastName
		self.locale = locale
		self.metadataDefinitionId = metadataDefinition.get('id') if metadataDefinition else None
		self.name = name
		self.phoneNumber = phoneNumber
		self.quote = quote
		self.roleId = role.get('id') if role else None
		self.smsNotificationError = smsNotificationError
		self.smsNotificationInfo = smsNotificationInfo
		self.smsNotificationWarning = smsNotificationWarning
		self.timezone = timezone
		self.userType = userType
		self.variant = variant


class UserUpdate:
	keys: List[str] = ["accountExpiryDate", "addressLine1", "addressLine2", "addressLine3", "company", "description", "email", "emailNotificationError", "emailNotificationErrorSet", "emailNotificationInfo", "emailNotificationInfoSet", "emailNotificationWarning", "emailNotificationWarningSet", "firstName", "lastName", "locale", "metadataDefinition", "name", "phoneNumber", "quote", "role", "smsNotificationError", "smsNotificationErrorSet", "smsNotificationInfo", "smsNotificationInfoSet", "smsNotificationWarning", "smsNotificationWarningSet", "timezone", "variant"]

	def __init__(self, accountExpiryDate: str, addressLine1: str, addressLine2: str, addressLine3: str, company: str, description: str, email: str, emailNotificationError: bool, emailNotificationErrorSet: bool, emailNotificationInfo: bool, emailNotificationInfoSet: bool, emailNotificationWarning: bool, emailNotificationWarningSet: bool, firstName: str, lastName: str, locale: str, metadataDefinition: dict, name: str, phoneNumber: str, quote: str, role: dict, smsNotificationError: bool, smsNotificationErrorSet: bool, smsNotificationInfo: bool, smsNotificationInfoSet: bool, smsNotificationWarning: bool, smsNotificationWarningSet: bool, timezone: str, variant: str):
		self.accountExpiryDate = accountExpiryDate
		self.addressLine1 = addressLine1
		self.addressLine2 = addressLine2
		self.addressLine3 = addressLine3
		self.company = company
		self.description = description
		self.email = email
		self.emailNotificationError = emailNotificationError
		self.emailNotificationErrorSet = emailNotificationErrorSet
		self.emailNotificationInfo = emailNotificationInfo
		self.emailNotificationInfoSet = emailNotificationInfoSet
		self.emailNotificationWarning = emailNotificationWarning
		self.emailNotificationWarningSet = emailNotificationWarningSet
		self.firstName = firstName
		self.lastName = lastName
		self.locale = locale
		self.metadataDefinitionId = metadataDefinition.get('id') if metadataDefinition else None
		self.name = name
		self.phoneNumber = phoneNumber
		self.quote = quote
		self.roleId = role.get('id') if role else None
		self.smsNotificationError = smsNotificationError
		self.smsNotificationErrorSet = smsNotificationErrorSet
		self.smsNotificationInfo = smsNotificationInfo
		self.smsNotificationInfoSet = smsNotificationInfoSet
		self.smsNotificationWarning = smsNotificationWarning
		self.smsNotificationWarningSet = smsNotificationWarningSet
		self.timezone = timezone
		self.variant = variant


class NewVariant:
	keys: List[str] = ["defaultMetadataDefinition", "defaultVariant", "external", "metadataDefinition", "name", "objectType", "staticMetadatas", "timeline", "visibility"]

	def __init__(self, defaultMetadataDefinition: int, defaultVariant: bool, external: bool, metadataDefinition: List[dict], name: str, objectType: dict, staticMetadatas: List[int], timeline: List[dict], visibility: List[dict]):
		self.defaultMetadataDefinition = defaultMetadataDefinition
		self.defaultVariant = defaultVariant
		self.external = external
		self.metadataDefinitionIds = [v['id'] for v in metadataDefinition]
		self.name = name
		self.objectTypeId = objectType.get('id') if objectType else None
		self.staticMetadatas = staticMetadatas
		self.timelineIds = [v['id'] for v in timeline]
		self.visibilityIds = [v['id'] for v in visibility]


class VariantUpdate:
	keys: List[str] = ["defaultMetadataDefinition", "defaultVariant", "external", "metadataDefinition", "name", "staticMetadatas", "timeline", "visibility"]

	def __init__(self, defaultMetadataDefinition: int, defaultVariant: bool, external: bool, metadataDefinition: List[dict], name: str, staticMetadatas: List[int], timeline: List[dict], visibility: List[dict]):
		self.defaultMetadataDefinition = defaultMetadataDefinition
		self.defaultVariant = defaultVariant
		self.external = external
		self.metadataDefinitionIds = [v['id'] for v in metadataDefinition]
		self.name = name
		self.staticMetadatas = staticMetadatas
		self.timelineIds = [v['id'] for v in timeline]
		self.visibilityIds = [v['id'] for v in visibility]


class NewWizard:
	keys: List[str] = ["account", "description", "name", "pluginClass", "runRuleExpression", "standAloneWizard", "taskWizard", "toolbarWizard", "visibility", "wizardPages"]

	def __init__(self, account: dict, description: str, name: str, pluginClass: str, runRuleExpression: str, standAloneWizard: bool, taskWizard: bool, toolbarWizard: bool, visibility: List[dict], wizardPages: List[int]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.pluginClass = pluginClass
		self.runRuleExpression = runRuleExpression
		self.standAloneWizard = standAloneWizard
		self.taskWizard = taskWizard
		self.toolbarWizard = toolbarWizard
		self.visibilityIds = [v['id'] for v in visibility]
		self.wizardPages = wizardPages


class WizardUpdate:
	keys: List[str] = ["account", "description", "name", "pluginClass", "runRuleExpression", "standAloneWizard", "taskWizard", "toolbarWizard", "visibility", "wizardPages"]

	def __init__(self, account: dict, description: str, name: str, pluginClass: str, runRuleExpression: str, standAloneWizard: bool, taskWizard: bool, toolbarWizard: bool, visibility: List[dict], wizardPages: List[int]):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.name = name
		self.pluginClass = pluginClass
		self.runRuleExpression = runRuleExpression
		self.standAloneWizard = standAloneWizard
		self.taskWizard = taskWizard
		self.toolbarWizard = toolbarWizard
		self.visibilityIds = [v['id'] for v in visibility]
		self.wizardPages = wizardPages


class NewWorkflowDefinition:
	keys: List[str] = ["account", "concurrentWorkflowLimit", "description", "name", "visibility"]

	def __init__(self, account: dict, concurrentWorkflowLimit: int, description: str, name: str, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.concurrentWorkflowLimit = concurrentWorkflowLimit
		self.description = description
		self.name = name
		self.visibilityIds = [v['id'] for v in visibility]


class WorkflowDefinitionUpdate:
	keys: List[str] = ["account", "concurrentWorkflowLimit", "description", "name", "visibility"]

	def __init__(self, account: dict, concurrentWorkflowLimit: int, description: str, name: str, visibility: List[dict]):
		self.accountId = account.get('id') if account else None
		self.concurrentWorkflowLimit = concurrentWorkflowLimit
		self.description = description
		self.name = name
		self.visibilityIds = [v['id'] for v in visibility]


class NewWorkflow:
	keys: List[str] = ["account", "asset", "dateListVariables", "dateVariables", "definition", "definitionUUID", "mioObject", "mioObjectUuid", "objectListVariables", "objectVariables", "priority", "stringListVariables", "stringVariables", "workflowGroup", "workspace"]

	def __init__(self, account: dict, asset: dict, dateListVariables: dict, dateVariables: dict, definition: dict, definitionUUID: str, mioObject: dict, mioObjectUuid: str, objectListVariables: dict, objectVariables: dict, priority: str, stringListVariables: dict, stringVariables: dict, workflowGroup: dict, workspace: dict):
		self.accountId = account.get('id') if account else None
		self.assetId = asset.get('id') if asset else None
		self.dateListVariables = dateListVariables
		self.dateVariables = dateVariables
		self.definitionId = definition.get('id') if definition else None
		self.definitionUUID = definitionUUID
		self.mioObjectId = mioObject.get('id') if mioObject else None
		self.mioObjectUuid = mioObjectUuid
		self.objectListVariables = objectListVariables
		self.objectVariables = objectVariables
		self.priority = priority
		self.stringListVariables = stringListVariables
		self.stringVariables = stringVariables
		self.workflowGroupId = workflowGroup.get('id') if workflowGroup else None
		self.workspaceId = workspace.get('id') if workspace else None


class NewWorkspace:
	keys: List[str] = ["account", "description", "metadataDefinition", "name", "variant"]

	def __init__(self, account: dict, description: str, metadataDefinition: dict, name: str, variant: str):
		self.accountId = account.get('id') if account else None
		self.description = description
		self.metadataDefinitionId = metadataDefinition.get('id') if metadataDefinition else None
		self.name = name
		self.variant = variant


class WorkspaceUpdate:
	keys: List[str] = ["description", "metadataDefinition", "name", "variant"]

	def __init__(self, description: str, metadataDefinition: dict, name: str, variant: str):
		self.description = description
		self.metadataDefinitionId = metadataDefinition.get('id') if metadataDefinition else None
		self.name = name
		self.variant = variant


