"""

    PROJECT: flex_toolbox
    FILENAME: variables.py
    AUTHOR: David NAISSE
    DATE: August 5th, 2024

    DESCRIPTION: variables for the module
"""

from enum import Enum


class AssertOptions(Enum):
    ACCOUNT_PROPERTIES = "accountProperties"
    ACCOUNTS = "accounts"
    ACTIONS = "actions"
    ASSETS = "assets"
    COLLECTIONS = "collections"
    EVENT_HANDLERS = "eventHandlers"
    EVENTS = "events"
    GROUPS = "groups"
    JOBS = "jobs"
    MESSAGE_TEMPLATES = "messageTemplates"
    METADATA_DEFINITIONS = "metadataDefinitions"
    OBJECT_TYPES = "objectTypes"
    PROFILES = "profiles"
    QUOTAS = "quotas"
    RESOURCES = "resources"
    ROLES = "roles"
    TAG_COLLECTIONS = "tagCollections"
    TASK_DEFINITIONS = "taskDefinitions"
    TASKS = "tasks"
    TAXONOMIES = "taxonomies"
    TIMED_ACTIONS = "timedActions"
    USER_DEFINED_OBJECT_TYPES = "userDefinedObjectTypes"
    USERS = "users"
    VARIANTS = "variants"
    WIZARDS = "wizards"
    WORKFLOW_DEFINITIONS = "workflowDefinitions"
    WORKFLOWS = "workflows"
    WORKSPACES = "workspaces"


class CompareOptions(Enum):
    ACCOUNT_PROPERTIES = "accountProperties"
    ACCOUNTS = "accounts"
    ACTIONS = "actions"
    # ASSETS = "assets"
    # COLLECTIONS = "collections"
    EVENT_HANDLERS = "eventHandlers"
    # EVENTS = "events"
    GROUPS = "groups"
    # JOBS = "jobs"
    MESSAGE_TEMPLATES = "messageTemplates"
    METADATA_DEFINITIONS = "metadataDefinitions"
    OBJECT_TYPES = "objectTypes"
    PROFILES = "profiles"
    QUOTAS = "quotas"
    RESOURCES = "resources"
    ROLES = "roles"
    TAG_COLLECTIONS = "tagCollections"
    TASK_DEFINITIONS = "taskDefinitions"
    # TASKS = "tasks"
    TAXONOMIES = "taxonomies"
    TIMED_ACTIONS = "timedActions"
    USER_DEFINED_OBJECT_TYPES = "userDefinedObjectTypes"
    USERS = "users"
    VARIANTS = "variants"
    WIZARDS = "wizards"
    WORKFLOW_DEFINITIONS = "workflowDefinitions"
    # WORKFLOWS = "workflows"
    WORKSPACES = "workspaces"


class CreateOptions(Enum):
    ACCOUNT_PROPERTIES = "accountProperties"
    ACCOUNTS = "accounts"
    ACTIONS = "actions"
    # ASSETS = "assets"
    # COLLECTIONS = "collections"
    # EVENT_HANDLERS = "eventHandlers"
    # EVENTS = "events"
    # GROUPS = "groups"
    # JOBS = "jobs"
    # MESSAGE_TEMPLATES = "messageTemplates"
    # METADATA_DEFINITIONS = "metadataDefinitions"
    # OBJECT_TYPES = "objectTypes"
    # PROFILES = "profiles"
    # QUOTAS = "quotas"
    # RESOURCES = "resources"
    # ROLES = "roles"
    # TAG_COLLECTIONS = "tagCollections"
    # TASK_DEFINITIONS = "taskDefinitions"
    # TASKS = "tasks"
    # TAXONOMIES = "taxonomies"
    # TIMED_ACTIONS = "timedActions"
    # USER_DEFINED_OBJECT_TYPES = "userDefinedObjectTypes"
    # USERS = "users"
    # VARIANTS = "variants"
    WIZARDS = "wizards"
    WORKFLOW_DEFINITIONS = "workflowDefinitions"
    # WORKFLOWS = "workflows"
    WORKSPACES = "workspaces"


class CreatePlugins(Enum):
    DEFAULT = "default"
    DECISION = "decision"
    SCRIPT = "script"
    LAUNCH_WORKFLOW = "launchWorkflow"


class FailOptions(Enum):
    JOBS = "jobs"


class LaunchOptions(Enum):
    # ACCOUNT_PROPERTIES = "accountProperties"
    # ACCOUNTS = "accounts"
    # ACTIONS = "actions"
    # ASSETS = "assets"
    # COLLECTIONS = "collections"
    # EVENT_HANDLERS = "eventHandlers"
    # EVENTS = "events"
    # GROUPS = "groups"
    JOBS = "jobs"
    # MESSAGE_TEMPLATES = "messageTemplates"
    # METADATA_DEFINITIONS = "metadataDefinitions"
    # OBJECT_TYPES = "objectTypes"
    # PROFILES = "profiles"
    # QUOTAS = "quotas"
    # RESOURCES = "resources"
    # ROLES = "roles"
    # TAG_COLLECTIONS = "tagCollections"
    # TASK_DEFINITIONS = "taskDefinitions"
    # TASKS = "tasks"
    # TAXONOMIES = "taxonomies"
    # TIMED_ACTIONS = "timedActions"
    # USER_DEFINED_OBJECT_TYPES = "userDefinedObjectTypes"
    # USERS = "users"
    # VARIANTS = "variants"
    # WIZARDS = "wizards"
    # WORKFLOW_DEFINITIONS = "workflowDefinitions"
    WORKFLOWS = "workflows"
    # WORKSPACES = "workspaces"


class ListOptions(Enum):
    ACCOUNT_PROPERTIES = "accountProperties"
    ACCOUNTS = "accounts"
    ACTIONS = "actions"
    ASSETS = "assets"
    COLLECTIONS = "collections"
    EVENT_HANDLERS = "eventHandlers"
    EVENTS = "events"
    GROUPS = "groups"
    JOBS = "jobs"
    MESSAGE_TEMPLATES = "messageTemplates"
    METADATA_DEFINITIONS = "metadataDefinitions"
    OBJECT_TYPES = "objectTypes"
    PROFILES = "profiles"
    QUOTAS = "quotas"
    RESOURCES = "resources"
    ROLES = "roles"
    TAG_COLLECTIONS = "tagCollections"
    TASK_DEFINITIONS = "taskDefinitions"
    TASKS = "tasks"
    TAXONOMIES = "taxonomies"
    TIMED_ACTIONS = "timedActions"
    USER_DEFINED_OBJECT_TYPES = "userDefinedObjectTypes"
    USERS = "users"
    VARIANTS = "variants"
    WIZARDS = "wizards"
    WORKFLOW_DEFINITIONS = "workflowDefinitions"
    WORKFLOWS = "workflows"
    WORKSPACES = "workspaces"


class QueryOptions(Enum):
    GET = "GET"
    PATCH = "PATCH"
    POST = "POST"
    PUT = "PUT"
    DELETED = "DELETE"

class CancelOptions(Enum):
    JOBS = "jobs"
    WORKFLOWS = "workflows"

class PullOptions(Enum):
    ALL = "all"
    ACCOUNT_PROPERTIES = "accountProperties"
    ACCOUNTS = "accounts"
    ACTIONS = "actions"
    ASSETS = "assets"
    COLLECTIONS = "collections"
    EVENT_HANDLERS = "eventHandlers"
    EVENTS = "events"
    GROUPS = "groups"
    JOBS = "jobs"
    MESSAGE_TEMPLATES = "messageTemplates"
    METADATA_DEFINITIONS = "metadataDefinitions"
    OBJECT_TYPES = "objectTypes"
    PROFILES = "profiles"
    QUOTAS = "quotas"
    RESOURCES = "resources"
    ROLES = "roles"
    TAG_COLLECTIONS = "tagCollections"
    TASK_DEFINITIONS = "taskDefinitions"
    TASKS = "tasks"
    TAXONOMIES = "taxonomies"
    TIMED_ACTIONS = "timedActions"
    USER_DEFINED_OBJECT_TYPES = "userDefinedObjectTypes"
    USERS = "users"
    VARIANTS = "variants"
    WIZARDS = "wizards"
    WORKFLOW_DEFINITIONS = "workflowDefinitions"
    WORKFLOWS = "workflows"
    WORKSPACES = "workspaces"


class PushOptions(Enum):
    ACCOUNT_PROPERTIES = "accountProperties"
    ACCOUNTS = "accounts"
    ACTIONS = "actions"
    ASSETS = "assets"
    # COLLECTIONS = "collections"
    EVENT_HANDLERS = "eventHandlers"
    # EVENTS = "events"
    GROUPS = "groups"
    JOBS = "jobs"
    MESSAGE_TEMPLATES = "messageTemplates"
    METADATA_DEFINITIONS = "metadataDefinitions"
    # OBJECT_TYPES = "objectTypes"
    PROFILES = "profiles"
    QUOTAS = "quotas"
    RESOURCES = "resources"
    ROLES = "roles"
    # TAG_COLLECTIONS = "tagCollections"
    TASK_DEFINITIONS = "taskDefinitions"
    TASKS = "tasks"
    # TAXONOMIES = "taxonomies" # TODO
    TIMED_ACTIONS = "timedActions"
    USER_DEFINED_OBJECT_TYPES = "userDefinedObjectTypes"
    USERS = "users"
    VARIANTS = "variants"
    WIZARDS = "wizards"
    WORKFLOW_DEFINITIONS = "workflowDefinitions"
    WORKFLOWS = "workflows"
    WORKSPACES = "workspaces"


class RestoreOptions(Enum):
    ACCOUNT_PROPERTIES = "accountProperties"
    ACCOUNTS = "accounts"
    ACTIONS = "actions"
    ASSETS = "assets"
    # COLLECTIONS = "collections"
    EVENT_HANDLERS = "eventHandlers"
    # EVENTS = "events"
    GROUPS = "groups"
    JOBS = "jobs"
    MESSAGE_TEMPLATES = "messageTemplates"
    METADATA_DEFINITIONS = "metadataDefinitions"
    # OBJECT_TYPES = "objectTypes"
    PROFILES = "profiles"
    QUOTAS = "quotas"
    RESOURCES = "resources"
    ROLES = "roles"
    # TAG_COLLECTIONS = "tagCollections"
    TASK_DEFINITIONS = "taskDefinitions"
    TASKS = "tasks"
    # TAXONOMIES = "taxonomies" # TODO
    TIMED_ACTIONS = "timedActions"
    USER_DEFINED_OBJECT_TYPES = "userDefinedObjectTypes"
    USERS = "users"
    VARIANTS = "variants"
    WIZARDS = "wizards"
    # WORKFLOW_DEFINITIONS = "workflowDefinitions" # TODO
    WORKFLOWS = "workflows"
    WORKSPACES = "workspaces"


class RetryOptions(Enum):
    # ACCOUNT_PROPERTIES = "accountProperties"
    # ACCOUNTS = "accounts"
    # ACTIONS = "actions"
    # ASSETS = "assets"
    # COLLECTIONS = "collections"
    # EVENT_HANDLERS = "eventHandlers"
    # EVENTS = "events"
    # GROUPS = "groups"
    JOBS = "jobs"
    # MESSAGE_TEMPLATES = "messageTemplates"
    # METADATA_DEFINITIONS = "metadataDefinitions"
    # OBJECT_TYPES = "objectTypes"
    # PROFILES = "profiles"
    # QUOTAS = "quotas"
    # RESOURCES = "resources"
    # ROLES = "roles"
    # TAG_COLLECTIONS = "tagCollections"
    # TASK_DEFINITIONS = "taskDefinitions"
    # TASKS = "tasks"
    # TAXONOMIES = "taxonomies"
    # TIMED_ACTIONS = "timedActions"
    # USER_DEFINED_OBJECT_TYPES = "userDefinedObjectTypes"
    # USERS = "users"
    # VARIANTS = "variants"
    # WIZARDS = "wizards"
    # WORKFLOW_DEFINITIONS = "workflowDefinitions"
    WORKFLOWS = "workflows"
    # WORKSPACES = "workspaces"
