# All-Pakistan Learning Trip — Weekly Schedule & Call for Participation

We’re launching a national, hands-on learning tour focused on **Spec-Driven Development (SDD)**—also known as **AI Pair Programming**, **Prompt-First Agent Development (PFAD)**, or “**Vibe Coding in a Suit**” if you like your buzzwords with a tie 😄.

### Reference materials:

https://github.com/panaversity/learn-agentic-ai/tree/main/06_prompt_driven_development


## Learning Format

I will not be lecturing; **you will be teaching me** by demonstrating concepts live on your machines, answering my questions, and walking me through your PR builds (role reversal is fun—think of it as academic karaoke 🎤).

**Important:** I won’t answer questions—I’ll only ask them and request live demos from you (yes, the tables have turned like a well-timed plot twist 🍿).

Expectations

Please come fully prepared; otherwise it may be awkward for you (and memorable for all the wrong reasons—let’s avoid viral blooper reels 😅).

You’ll explain concepts, field questions, and **teach by building**; the best way to learn is to ship, and shipping is cooler than slides anyway 🚀.


First Build: End-to-End Chatbot (Prompt-First, No Hand-Coding)

Your first project will be an **end-to-end chatbot** using:

* **OpenAI Agents SDK**, **Google Gemini**, **Chainlit**, **Docker**, and **Kubernetes** (yes, we’re going full-stack—like a sundae with extra toppings 🍨).
* **Deployment:** any Kubernetes cloud of your choice (multicloud bragging rights encouraged 🏷️).
* **Methodology:** **PFAD**—you’ll write **prompts**, not code; the agent does the typing while you do the thinking 🧠.

## Weekly Itinerary (repeats every week)

* Next Week — Starting from Sept 26–28, 2025
  **Peshawar (Fri)**, **Islamabad (Sat)**, **Lahore (Sun)** 

* Following Week — Starting from Oct 3–5, 2025
  **Peshawar (Fri)**, **Islamabad (Sat)**, **Faisalabad (Sun)**

* Week Three — Starting from Oct 11–12, 2025
  **Karachi (Sat & Sun)** at **Sindh Boys Scout Auditorium** (scout’s honor: ship something cool ✋).

* Every Tuesday — Starting from Oct 14, 2025
  **Sindh Governor House Marquee, 7:00–10:00 p.m.** with **Zeeshan Hanif, Daniyal, Imran, and me** (a weekly study jam—no DJ, just GPUs 🎶➡️🖥️).


## Dev Environments

Pick one (or both) playbooks and come ready:

* Cursor Playbook: 

https://github.com/panaversity/learn-agentic-ai/tree/main/06_prompt_driven_development/14_cursor_playbook

* Codex Playbook: 

https://github.com/panaversity/learn-agentic-ai/tree/main/06_prompt_driven_development/15_codex_playbook

## Opportunities

Outstanding contributors will be **immediately considered for our core team** as **Faculty** and/or **co-founding partners** in our startups.

## Closing

**Get ready—Daniyal, Zeeshan Hanif, Imran, and I are coming to learn from you.** Bring your best prompts, sharp explanations, and production-worthy demos (and maybe a victory selfie backdrop 📸).

