from typing import Union, final

ByteString = Union[bytes, bytearray, memoryview]

@final
class ChaCha20:
    def __init__(self, key: bytes, nonce: bytes, counter: int) -> None: ...
    def work_bytes(self, input_bytes: ByteString) -> bytes: ...

@final
class ManifestDataBinary:
    def __init__(self) -> None: ...
    def init_binary(self, file_path: str) -> bool: ...
    def save_to_json_file(self, output_path: str) -> bool: ...

@final
class ChaChaDecryptor:
    common_chacha_key_bs: bytes

    def __init__(self) -> None: ...
    def decrypt(self, file_bytes: ByteString, iv_seed: int) -> bytes: ...
    @staticmethod
    def key_decrypt(data: ByteString, key: str) -> bytes: ...

def decompress_buffer(
    decompress_bytes: ByteString, uncompressed_size: int
) -> bytes: ...
def miki_decrypt(encrypted_bytes: ByteString) -> bytes: ...
def miki_decrypt_old(encrypted_bytes: ByteString) -> bytes: ...
def miki_decrypt_and_decompress(
    encrypted_bytes: ByteString, uncompressed_size: int
) -> bytes: ...
def miki_decrypt_old_and_decompress(
    encrypted_bytes: ByteString, uncompressed_size: int
) -> bytes: ...
