# Generated by Django 4.1.9 on 2023-07-05 14:26

from decimal import Decimal

import django.contrib.postgres.constraints
import django.contrib.postgres.fields.ranges
import django.db.models.deletion
import wbcommission.models.rebate
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("wbcrm", "0005_account_accountrole_accountroletype_and_more"),
        ("wbcommission", "0001_initial"),
        ("directory", "0004_entry_is_draft_entry"),
    ]

    operations = [
        migrations.RenameModel(old_name="Commission", new_name="OldCommission"),
        migrations.DeleteModel(name="rebate"),
        migrations.CreateModel(
            name="CommissionType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=256, verbose_name="Name")),
                ("key", models.CharField(max_length=256, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="Commission",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "portfolio_role_recipient",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("MANAGER", "Manager"),
                            ("RISK_MANAGER", "Risk Manager"),
                            ("PORTFOLIO_MANAGER", "Portfolio Manager"),
                            ("ANALYST", "Analyst"),
                        ],
                        max_length=32,
                        null=True,
                        verbose_name="Recipient Role",
                    ),
                ),
                ("order", models.IntegerField()),
                ("net_commission", models.BooleanField(default=True, verbose_name="Net Commission Rule")),
                (
                    "commission_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="commissions",
                        to="wbcommission.commissiontype",
                        verbose_name="Commission Type",
                    ),
                ),
                (
                    "is_hidden",
                    models.BooleanField(
                        default=True,
                        help_text="If False, this commission rule can be seen by anoyone that can access the related account. Otherwise, only an explicit role will grant access",
                        verbose_name="Public Commission Rule",
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(
                        limit_choices_to=models.Q(("is_terminal_account", True)),
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="account_commissions",
                        to="wbcrm.account",
                        verbose_name="Account",
                    ),
                ),
                (
                    "account_role_type_recipient",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="recipient_commissions",
                        to="wbcrm.accountroletype",
                        verbose_name="Account Role Type Recipient",
                    ),
                ),
                (
                    "crm_recipient",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="recipient_commissions",
                        to="directory.entry",
                        verbose_name="Recipient",
                    ),
                ),
            ],
            options={
                "verbose_name": "Commission",
                "verbose_name_plural": "Commissions",
            },
        ),
        migrations.AddConstraint(
            model_name="commission",
            constraint=models.UniqueConstraint(
                fields=("commission_type", "account", "crm_recipient"), name="unique_crm_recipient_account"
            ),
        ),
        migrations.AddConstraint(
            model_name="commission",
            constraint=models.UniqueConstraint(
                fields=("commission_type", "account", "portfolio_role_recipient"),
                name="unique_portfolio_role_recipient_account",
            ),
        ),
        migrations.AddConstraint(
            model_name="commission",
            constraint=models.UniqueConstraint(
                fields=("commission_type", "account", "account_role_type_recipient"),
                name="unique_account_role_type_recipient_account",
            ),
        ),
        migrations.AddConstraint(
            model_name="commission",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        ("account_role_type_recipient__isnull", True),
                        ("crm_recipient__isnull", False),
                        ("portfolio_role_recipient__isnull", True),
                    ),
                    models.Q(
                        ("account_role_type_recipient__isnull", True),
                        ("crm_recipient__isnull", True),
                        ("portfolio_role_recipient__isnull", False),
                    ),
                    models.Q(
                        ("account_role_type_recipient__isnull", False),
                        ("crm_recipient__isnull", True),
                        ("portfolio_role_recipient__isnull", True),
                    ),
                    _connector="OR",
                ),
                name="Only one recipient type set",
            ),
        ),
        migrations.CreateModel(
            name="CommissionRole",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                (
                    "commission",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="roles",
                        to="wbcommission.commission",
                        verbose_name="Commission Line",
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="rebates_account_roles",
                        to="directory.person",
                        verbose_name="Person",
                    ),
                ),
            ],
            options={
                "verbose_name": "Commission Role",
                "verbose_name_plural": "Commission Roles",
            },
        ),
        migrations.CreateModel(
            name="CommissionRule",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                ("timespan", django.contrib.postgres.fields.ranges.DateRangeField(verbose_name="Timespan")),
                (
                    "assets_under_management_range",
                    django.contrib.postgres.fields.ranges.DecimalRangeField(verbose_name="AUM Range"),
                ),
                ("percent", models.FloatField(default=0, verbose_name="Percent")),
            ],
        ),
        migrations.AddField(
            model_name="commissionrule",
            name="commission",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="rules",
                to="wbcommission.commission",
                verbose_name="Commission Line",
            ),
        ),
        migrations.AddConstraint(
            model_name="commissionrule",
            constraint=django.contrib.postgres.constraints.ExclusionConstraint(
                expressions=[("timespan", "&&"), ("assets_under_management_range", "&&"), ("commission", "=")],
                name="exclude_overlapping_rules",
            ),
        ),
        migrations.CreateModel(
            name="CommissionExclusionRule",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("timespan", django.contrib.postgres.fields.ranges.DateRangeField(verbose_name="Timespan")),
                (
                    "overriding_percent",
                    models.DecimalField(decimal_places=3, max_digits=4, verbose_name="Overriding Percent"),
                ),
                (
                    "overriding_net_or_gross_commission",
                    models.CharField(
                        choices=[("NET", "Net"), ("GROSS", "Gross"), ("DEFAULT", "Default")],
                        default="DEFAULT",
                        max_length=16,
                        verbose_name="Overriding Net or Gross Commission Rule",
                    ),
                ),
                (
                    "account_role_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="wbcrm.accountroletype",
                        verbose_name="Account Role Type Recipient",
                    ),
                ),
                (
                    "commission_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="commission_exclusion_rules",
                        to="wbcommission.commissiontype",
                        verbose_name="Commission Type",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="wbportfolio.product", verbose_name="Product"
                    ),
                ),
            ],
            options={
                "verbose_name": "Commission Exclusion Rule",
                "verbose_name_plural": "Commissions Exclusion Rules",
            },
        ),
        migrations.AddConstraint(
            model_name="commissionexclusionrule",
            constraint=django.contrib.postgres.constraints.ExclusionConstraint(
                expressions=[
                    ("timespan", "&&"),
                    ("product", "="),
                    ("commission_type", "="),
                    ("account_role_type", "="),
                ],
                name="exclude_overlapping_exclusion_rules",
            ),
        ),
        migrations.AddField(
            model_name="commission",
            name="exclusion_rule_account_role_type",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="wbcrm.accountroletype",
                verbose_name="Account Role to decide with exclusion rule applies",
            ),
        ),
        migrations.CreateModel(
            name="Rebate",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField(verbose_name="Date")),
                (
                    "value",
                    models.DecimalField(decimal_places=4, default=Decimal(0.0), max_digits=16, verbose_name="Value"),
                ),
                (
                    "account",
                    models.ForeignKey(
                        limit_choices_to=models.Q(("is_terminal_account", True)),
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rebates",
                        to="wbcrm.account",
                        verbose_name="Account",
                    ),
                ),
                (
                    "commission",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="rebates",
                        to="wbcommission.commission",
                        verbose_name="Commission Line",
                    ),
                ),
                (
                    "commission_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="rebates",
                        to="wbcommission.commissiontype",
                        verbose_name="Commission Type",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rebates",
                        to="wbportfolio.product",
                        verbose_name="Product",
                    ),
                ),
                (
                    "recipient",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="recipient_rebates",
                        to="directory.entry",
                        verbose_name="Recipient",
                    ),
                ),
            ],
            options={
                "verbose_name": "Rebate",
                "verbose_name_plural": "Rebates",
                "unique_together": {("date", "recipient", "account", "product", "commission_type")},
                "index_together": {("commission_type", "date", "recipient", "product", "account")},
            },
            bases=(wbcommission.models.rebate.BookingEntryCalculatedValueMixin, models.Model),
        ),
        migrations.RemoveField(
            model_name="accountcustomer",
            name="account",
        ),
        migrations.RemoveField(
            model_name="accountcustomer",
            name="entry",
        ),
        migrations.RemoveField(
            model_name="accountcustomercommissionconstraint",
            name="customer",
        ),
        migrations.RemoveField(
            model_name="accountcustomercommissionconstraint",
            name="products",
        ),
        migrations.DeleteModel(
            name="AccountCustomer",
        ),
        migrations.DeleteModel(
            name="AccountCustomerCommissionConstraint",
        ),
        migrations.DeleteModel(
            name="OldCommission",
        ),
        migrations.DeleteModel(
            name="CommissionAccountRole",
        ),
        migrations.AlterField(
            model_name="commission",
            name="is_hidden",
            field=models.BooleanField(
                default=True,
                help_text="If False, this commission rule can be seen by anoyone that can access the related account. Otherwise, only an explicit role will grant access",
                verbose_name="Hidden Commission Rule",
            ),
        ),
        migrations.AlterField(
            model_name="commissionrule",
            name="percent",
            field=models.DecimalField(decimal_places=3, default=Decimal("0"), max_digits=4, verbose_name="Percent"),
        ),
        migrations.AlterModelOptions(
            name="commission",
            options={
                "permissions": (("administrate_commission", "Can administrate Commission"),),
                "verbose_name": "Commission",
                "verbose_name_plural": "Commissions",
            },
        ),
    ]
