# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class FunctionAnalysisThreatScoreData(BaseModel):
    """
    FunctionAnalysisThreatScoreData
    """ # noqa: E501
    min: Union[StrictFloat, StrictInt] = Field(description="The minimum value for the analysis score")
    max: Union[StrictFloat, StrictInt] = Field(description="The maximum value for the analysis score")
    average: Union[StrictFloat, StrictInt] = Field(description="The average value for the analysis score")
    upper: Union[StrictFloat, StrictInt] = Field(description="The upper limit for the analysis score")
    lower: Union[StrictFloat, StrictInt] = Field(description="The lower limit for the analysis score")
    malware_count: StrictInt = Field(description="Number of malware binaries used in threat score calculation")
    benign_count: StrictInt = Field(description="Number of benign binaries used in threat score calculation")
    __properties: ClassVar[List[str]] = ["min", "max", "average", "upper", "lower", "malware_count", "benign_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionAnalysisThreatScoreData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionAnalysisThreatScoreData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "min": obj.get("min"),
            "max": obj.get("max"),
            "average": obj.get("average"),
            "upper": obj.get("upper"),
            "lower": obj.get("lower"),
            "malware_count": obj.get("malware_count"),
            "benign_count": obj.get("benign_count")
        })
        return _obj


