# Cell Parameter List

In Breathe Design, these parameters accelerate battery development via virtual-cell simulation. Use them to define a cell’s structure, chemistry, and operating window.

## Adjustable Cell Design Parameters

| Name | Unit | Description| Minimum Value | Maximum Value |
|:--|:--:|:--|:--|:--|
| Anode | – | Anode material | – | – |
| Cathode | – | Cathode material | – | – |
| NPratio | – | Anode to cathode capacity ratio | 0.7 | 3.0 |
| Vmin_V | V | Minimum operational cell voltage | 2.0 | 3.5 |
| Vmax_V | V | Maximum operational cell voltage | 3.6 | 4.65 |
| anodePorosity | – | Anode porosity | 0.1 | 0.9 |
| cathodePorosity | – | Cathode porosity | 0.1 | 0.9 |
| anodeThickness_um | &micro;m | Negative electrode thickness  | 5 | 150 |
| cathodeThickness_um | &micro;m | Positive electrode thickness | 5 | 150 |
| copperThickness_um | &micro;m | Negative electrode sheet thickness | 5 | 50 |
| aluminumThickness_um | &micro;m | Positive electrode sheet thickness | 5 | 50 |
| separatorThickness_um | &micro;m | Separator thickness | 5 | 50 |
| format | mm | Cell format, height/width/length/diameter/inner diameter  | 1/1/1/1 | – |
| electrolyte | – | Electrolyte | – | – |
| electrolyteBuffer_rel | – | Amount of extra electrolyte relative to the pore volume | -0.1 | 10 |
| lamne | % | Loss of active material negative electrode | 0 | 0.3 |
| lampe | % | Loss of active material positive electrode  | 0 | 0.3 |
| lli | % | loss of lithium inventory | 0 | 0.3 |
