# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from bandwidth.models.callback_method_enum import CallbackMethodEnum
from bandwidth.models.machine_detection_configuration import MachineDetectionConfiguration
from typing import Optional, Set
from typing_extensions import Self

class CreateCall(BaseModel):
    """
    CreateCall
    """ # noqa: E501
    to: StrictStr = Field(description="The destination to call (must be an E.164 formatted number (e.g. `+15555551212`) or a SIP URI (e.g. `sip:user@server.example`)).")
    var_from: StrictStr = Field(description="A Bandwidth phone number on your account the call should come from (must be in E.164 format, like `+15555551212`) even if `privacy` is set to true.", alias="from")
    privacy: Optional[StrictBool] = Field(default=None, description="Hide the calling number. The `displayName` field can be used to customize the displayed name.")
    display_name: Optional[Annotated[str, Field(strict=True, max_length=256)]] = Field(default=None, description="The caller display name to use when the call is created.  May not exceed 256 characters nor contain control characters such as new lines. If `privacy` is true, only the following values are valid: `Restricted`, `Anonymous`, `Private`, or `Unavailable`.", alias="displayName")
    uui: Optional[StrictStr] = Field(default=None, description="A comma-separated list of 'User-To-User' headers to be sent in the INVITE when calling a SIP URI. Each value must end with an 'encoding' parameter as described in <a href='https://tools.ietf.org/html/rfc7433'>RFC 7433</a>. Only 'jwt', 'base64' and 'hex' encodings are allowed. The entire value cannot exceed 350 characters, including parameters and separators.")
    application_id: StrictStr = Field(description="The id of the application associated with the `from` number.", alias="applicationId")
    answer_url: Annotated[str, Field(strict=True, max_length=2048)] = Field(description="The full URL to send the <a href='/docs/voice/webhooks/answer'>Answer</a> event to when the called party answers. This endpoint should return the first <a href='/docs/voice/bxml'>BXML document</a> to be executed in the call.  Must use `https` if specifying `username` and `password`.", alias="answerUrl")
    answer_method: Optional[CallbackMethodEnum] = Field(default=CallbackMethodEnum.POST, alias="answerMethod")
    username: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = Field(default=None, description="Basic auth username.")
    password: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = Field(default=None, description="Basic auth password.")
    answer_fallback_url: Optional[Annotated[str, Field(strict=True, max_length=2048)]] = Field(default=None, description="A fallback url which, if provided, will be used to retry the `answer` webhook delivery in case `answerUrl` fails to respond  Must use `https` if specifying `fallbackUsername` and `fallbackPassword`.", alias="answerFallbackUrl")
    answer_fallback_method: Optional[CallbackMethodEnum] = Field(default=CallbackMethodEnum.POST, alias="answerFallbackMethod")
    fallback_username: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = Field(default=None, description="Basic auth username.", alias="fallbackUsername")
    fallback_password: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = Field(default=None, description="Basic auth password.", alias="fallbackPassword")
    disconnect_url: Optional[Annotated[str, Field(strict=True, max_length=2048)]] = Field(default=None, description="The URL to send the <a href='/docs/voice/webhooks/disconnect'>Disconnect</a> event to when the call ends. This event does not expect a BXML response.", alias="disconnectUrl")
    disconnect_method: Optional[CallbackMethodEnum] = Field(default=CallbackMethodEnum.POST, alias="disconnectMethod")
    call_timeout: Optional[Union[Annotated[float, Field(le=300, strict=True, ge=1)], Annotated[int, Field(le=300, strict=True, ge=1)]]] = Field(default=30, description="The timeout (in seconds) for the callee to answer the call after it starts ringing. If the call does not start ringing within 30s, the call will be cancelled regardless of this value.  Can be any numeric value (including decimals) between 1 and 300.", alias="callTimeout")
    callback_timeout: Optional[Union[Annotated[float, Field(le=25, strict=True, ge=1)], Annotated[int, Field(le=25, strict=True, ge=1)]]] = Field(default=15, description="This is the timeout (in seconds) to use when delivering webhooks for the call. Can be any numeric value (including decimals) between 1 and 25.", alias="callbackTimeout")
    machine_detection: Optional[MachineDetectionConfiguration] = Field(default=None, alias="machineDetection")
    priority: Optional[Annotated[int, Field(le=5, strict=True, ge=1)]] = Field(default=5, description="The priority of this call over other calls from your account. For example, if during a call your application needs to place a new call and bridge it with the current call, you might want to create the call with priority 1 so that it will be the next call picked off your queue, ahead of other less time sensitive calls. A lower value means higher priority, so a priority 1 call takes precedence over a priority 2 call.")
    tag: Optional[Annotated[str, Field(strict=True, max_length=256)]] = Field(default=None, description="A custom string that will be sent with all webhooks for this call unless overwritten by a future <a href='/docs/voice/bxml/tag'>`<Tag>`</a> verb or `tag` attribute on another verb, or cleared.  May be cleared by setting `tag=\"\"`  Max length 256 characters.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["to", "from", "privacy", "displayName", "uui", "applicationId", "answerUrl", "answerMethod", "username", "password", "answerFallbackUrl", "answerFallbackMethod", "fallbackUsername", "fallbackPassword", "disconnectUrl", "disconnectMethod", "callTimeout", "callbackTimeout", "machineDetection", "priority", "tag"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateCall from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of machine_detection
        if self.machine_detection:
            _dict['machineDetection'] = self.machine_detection.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if privacy (nullable) is None
        # and model_fields_set contains the field
        if self.privacy is None and "privacy" in self.model_fields_set:
            _dict['privacy'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['displayName'] = None

        # set to None if uui (nullable) is None
        # and model_fields_set contains the field
        if self.uui is None and "uui" in self.model_fields_set:
            _dict['uui'] = None

        # set to None if answer_method (nullable) is None
        # and model_fields_set contains the field
        if self.answer_method is None and "answer_method" in self.model_fields_set:
            _dict['answerMethod'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict['password'] = None

        # set to None if answer_fallback_url (nullable) is None
        # and model_fields_set contains the field
        if self.answer_fallback_url is None and "answer_fallback_url" in self.model_fields_set:
            _dict['answerFallbackUrl'] = None

        # set to None if answer_fallback_method (nullable) is None
        # and model_fields_set contains the field
        if self.answer_fallback_method is None and "answer_fallback_method" in self.model_fields_set:
            _dict['answerFallbackMethod'] = None

        # set to None if fallback_username (nullable) is None
        # and model_fields_set contains the field
        if self.fallback_username is None and "fallback_username" in self.model_fields_set:
            _dict['fallbackUsername'] = None

        # set to None if fallback_password (nullable) is None
        # and model_fields_set contains the field
        if self.fallback_password is None and "fallback_password" in self.model_fields_set:
            _dict['fallbackPassword'] = None

        # set to None if disconnect_url (nullable) is None
        # and model_fields_set contains the field
        if self.disconnect_url is None and "disconnect_url" in self.model_fields_set:
            _dict['disconnectUrl'] = None

        # set to None if disconnect_method (nullable) is None
        # and model_fields_set contains the field
        if self.disconnect_method is None and "disconnect_method" in self.model_fields_set:
            _dict['disconnectMethod'] = None

        # set to None if call_timeout (nullable) is None
        # and model_fields_set contains the field
        if self.call_timeout is None and "call_timeout" in self.model_fields_set:
            _dict['callTimeout'] = None

        # set to None if callback_timeout (nullable) is None
        # and model_fields_set contains the field
        if self.callback_timeout is None and "callback_timeout" in self.model_fields_set:
            _dict['callbackTimeout'] = None

        # set to None if priority (nullable) is None
        # and model_fields_set contains the field
        if self.priority is None and "priority" in self.model_fields_set:
            _dict['priority'] = None

        # set to None if tag (nullable) is None
        # and model_fields_set contains the field
        if self.tag is None and "tag" in self.model_fields_set:
            _dict['tag'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateCall from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "to": obj.get("to"),
            "from": obj.get("from"),
            "privacy": obj.get("privacy"),
            "displayName": obj.get("displayName"),
            "uui": obj.get("uui"),
            "applicationId": obj.get("applicationId"),
            "answerUrl": obj.get("answerUrl"),
            "answerMethod": obj.get("answerMethod") if obj.get("answerMethod") is not None else CallbackMethodEnum.POST,
            "username": obj.get("username"),
            "password": obj.get("password"),
            "answerFallbackUrl": obj.get("answerFallbackUrl"),
            "answerFallbackMethod": obj.get("answerFallbackMethod") if obj.get("answerFallbackMethod") is not None else CallbackMethodEnum.POST,
            "fallbackUsername": obj.get("fallbackUsername"),
            "fallbackPassword": obj.get("fallbackPassword"),
            "disconnectUrl": obj.get("disconnectUrl"),
            "disconnectMethod": obj.get("disconnectMethod") if obj.get("disconnectMethod") is not None else CallbackMethodEnum.POST,
            "callTimeout": obj.get("callTimeout") if obj.get("callTimeout") is not None else 30,
            "callbackTimeout": obj.get("callbackTimeout") if obj.get("callbackTimeout") is not None else 15,
            "machineDetection": MachineDetectionConfiguration.from_dict(obj["machineDetection"]) if obj.get("machineDetection") is not None else None,
            "priority": obj.get("priority") if obj.get("priority") is not None else 5,
            "tag": obj.get("tag")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


