# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from bandwidth.models.deactivation_event_enum import DeactivationEventEnum
from bandwidth.models.latest_message_delivery_status_enum import LatestMessageDeliveryStatusEnum
from bandwidth.models.line_type_enum import LineTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class LookupResult(BaseModel):
    """
    Carrier information results for the specified telephone number.
    """ # noqa: E501
    phone_number: Optional[StrictStr] = Field(default=None, description="The telephone number in E.164 format.", alias="phoneNumber")
    line_type: Optional[LineTypeEnum] = Field(default=None, alias="lineType")
    messaging_provider: Optional[StrictStr] = Field(default=None, description="The messaging service provider of the telephone number.", alias="messagingProvider")
    voice_provider: Optional[StrictStr] = Field(default=None, description="The voice service provider of the telephone number.", alias="voiceProvider")
    country_code_a3: Optional[StrictStr] = Field(default=None, description="The country code of the telephone number in ISO 3166-1 alpha-3 format.", alias="countryCodeA3")
    deactivation_reporter: Optional[StrictStr] = Field(default=None, description="[DNI-Only](#section/DNI-Only). The carrier that reported a deactivation event for this phone number. ", alias="deactivationReporter")
    deactivation_date: Optional[StrictStr] = Field(default=None, description="[DNI-Only](#section/DNI-Only). The datetime the carrier reported a deactivation event.", alias="deactivationDate")
    deactivation_event: Optional[DeactivationEventEnum] = Field(default=None, alias="deactivationEvent")
    latest_message_delivery_status: Optional[LatestMessageDeliveryStatusEnum] = Field(default=None, alias="latestMessageDeliveryStatus")
    initial_message_delivery_status_date: Optional[date] = Field(default=None, description="[DNI-Only](#section/DNI-Only). The date the phone number entered the status described in `latestMessageDeliveryStatus`.  Think of this as the \"start time\" for that status. Value resets every time the `latestMessageDeliveryStatus` changes.", alias="initialMessageDeliveryStatusDate")
    latest_message_delivery_status_date: Optional[date] = Field(default=None, description="[DNI-Only](#section/DNI-Only). The date bandwidth last received delivery status information for this phone number.  Use this field to understand how up-to-date the `latestMessageDeliveryStatus` is. Value resets every time the `latestMessageDeliveryStatus` changes.", alias="latestMessageDeliveryStatusDate")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["phoneNumber", "lineType", "messagingProvider", "voiceProvider", "countryCodeA3", "deactivationReporter", "deactivationDate", "deactivationEvent", "latestMessageDeliveryStatus", "initialMessageDeliveryStatusDate", "latestMessageDeliveryStatusDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LookupResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LookupResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "phoneNumber": obj.get("phoneNumber"),
            "lineType": obj.get("lineType"),
            "messagingProvider": obj.get("messagingProvider"),
            "voiceProvider": obj.get("voiceProvider"),
            "countryCodeA3": obj.get("countryCodeA3"),
            "deactivationReporter": obj.get("deactivationReporter"),
            "deactivationDate": obj.get("deactivationDate"),
            "deactivationEvent": obj.get("deactivationEvent"),
            "latestMessageDeliveryStatus": obj.get("latestMessageDeliveryStatus"),
            "initialMessageDeliveryStatusDate": obj.get("initialMessageDeliveryStatusDate"),
            "latestMessageDeliveryStatusDate": obj.get("latestMessageDeliveryStatusDate")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


