# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from bandwidth.models.message_direction_enum import MessageDirectionEnum
from bandwidth.models.priority_enum import PriorityEnum
from typing import Optional, Set
from typing_extensions import Self

class Message(BaseModel):
    """
    Message
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The id of the message.")
    owner: Optional[StrictStr] = Field(default=None, description="The Bandwidth phone number associated with the message.")
    application_id: Optional[StrictStr] = Field(default=None, description="The ID of the Application your from number or senderId is associated with in the Bandwidth Phone Number Dashboard.", alias="applicationId")
    time: Optional[datetime] = Field(default=None, description="The datetime stamp of the message in ISO 8601")
    segment_count: Optional[StrictInt] = Field(default=None, description="The number of segments the user's message is broken into before sending over carrier networks.", alias="segmentCount")
    direction: Optional[MessageDirectionEnum] = None
    to: Optional[List[StrictStr]] = Field(default=None, description="The phone number recipients of the message.")
    var_from: Optional[StrictStr] = Field(default=None, description="The phone number the message was sent from.", alias="from")
    media: Optional[List[StrictStr]] = Field(default=None, description="The list of media URLs sent in the message. Including a `filename` field in the `Content-Disposition` header of the media linked with a URL will set the displayed file name. This is a best practice to ensure that your media has a readable file name.")
    text: Optional[StrictStr] = Field(default=None, description="The contents of the message.")
    tag: Optional[StrictStr] = Field(default=None, description="A custom string that will be included in callback events of the message. Max 1024 characters.")
    priority: Optional[PriorityEnum] = None
    expiration: Optional[datetime] = Field(default=None, description="A string with the date/time value that the message will automatically expire by. This must be a valid RFC-3339 value, e.g., 2021-03-14T01:59:26Z or 2021-03-13T20:59:26-05:00. Must be a date-time in the future.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "owner", "applicationId", "time", "segmentCount", "direction", "to", "from", "media", "text", "tag", "priority", "expiration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Message from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Message from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "owner": obj.get("owner"),
            "applicationId": obj.get("applicationId"),
            "time": obj.get("time"),
            "segmentCount": obj.get("segmentCount"),
            "direction": obj.get("direction"),
            "to": obj.get("to"),
            "from": obj.get("from"),
            "media": obj.get("media"),
            "text": obj.get("text"),
            "tag": obj.get("tag"),
            "priority": obj.get("priority"),
            "expiration": obj.get("expiration")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


