# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from bandwidth.models.multi_channel_action_calendar_event import MultiChannelActionCalendarEvent
from bandwidth.models.rbm_action_base import RbmActionBase
from bandwidth.models.rbm_action_dial import RbmActionDial
from bandwidth.models.rbm_action_open_url import RbmActionOpenUrl
from bandwidth.models.rbm_action_view_location import RbmActionViewLocation
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

MULTICHANNELACTION_ANY_OF_SCHEMAS = ["MultiChannelActionCalendarEvent", "RbmActionBase", "RbmActionDial", "RbmActionOpenUrl", "RbmActionViewLocation"]

class MultiChannelAction(BaseModel):
    """
    MultiChannelAction
    """

    # data type: RbmActionBase
    anyof_schema_1_validator: Optional[RbmActionBase] = None
    # data type: RbmActionDial
    anyof_schema_2_validator: Optional[RbmActionDial] = None
    # data type: RbmActionViewLocation
    anyof_schema_3_validator: Optional[RbmActionViewLocation] = None
    # data type: MultiChannelActionCalendarEvent
    anyof_schema_4_validator: Optional[MultiChannelActionCalendarEvent] = None
    # data type: RbmActionOpenUrl
    anyof_schema_5_validator: Optional[RbmActionOpenUrl] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[MultiChannelActionCalendarEvent, RbmActionBase, RbmActionDial, RbmActionOpenUrl, RbmActionViewLocation]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "MultiChannelActionCalendarEvent", "RbmActionBase", "RbmActionDial", "RbmActionOpenUrl", "RbmActionViewLocation" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = MultiChannelAction.model_construct()
        error_messages = []
        # validate data type: RbmActionBase
        if not isinstance(v, RbmActionBase):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmActionBase`")
        else:
            return v

        # validate data type: RbmActionDial
        if not isinstance(v, RbmActionDial):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmActionDial`")
        else:
            return v

        # validate data type: RbmActionViewLocation
        if not isinstance(v, RbmActionViewLocation):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmActionViewLocation`")
        else:
            return v

        # validate data type: MultiChannelActionCalendarEvent
        if not isinstance(v, MultiChannelActionCalendarEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MultiChannelActionCalendarEvent`")
        else:
            return v

        # validate data type: RbmActionOpenUrl
        if not isinstance(v, RbmActionOpenUrl):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RbmActionOpenUrl`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in MultiChannelAction with anyOf schemas: MultiChannelActionCalendarEvent, RbmActionBase, RbmActionDial, RbmActionOpenUrl, RbmActionViewLocation. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[RbmActionBase] = None
        try:
            instance.actual_instance = RbmActionBase.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[RbmActionDial] = None
        try:
            instance.actual_instance = RbmActionDial.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[RbmActionViewLocation] = None
        try:
            instance.actual_instance = RbmActionViewLocation.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[MultiChannelActionCalendarEvent] = None
        try:
            instance.actual_instance = MultiChannelActionCalendarEvent.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[RbmActionOpenUrl] = None
        try:
            instance.actual_instance = RbmActionOpenUrl.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into MultiChannelAction with anyOf schemas: MultiChannelActionCalendarEvent, RbmActionBase, RbmActionDial, RbmActionOpenUrl, RbmActionViewLocation. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], MultiChannelActionCalendarEvent, RbmActionBase, RbmActionDial, RbmActionOpenUrl, RbmActionViewLocation]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


