# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from bandwidth.models.tfv_status_enum import TfvStatusEnum
from bandwidth.models.tfv_submission_info import TfvSubmissionInfo
from typing import Optional, Set
from typing_extensions import Self

class TfvStatus(BaseModel):
    """
    TfvStatus
    """ # noqa: E501
    phone_number: Optional[Annotated[str, Field(min_length=12, strict=True, max_length=12)]] = Field(default=None, description="Toll-free telephone number in E.164 format.", alias="phoneNumber")
    status: Optional[TfvStatusEnum] = None
    internal_ticket_number: Optional[UUID] = Field(default=None, description="Unique identifier (UUID) generated by Bandwidth to assist in tracking the verification status of a toll-free number - included in all webhook payloads.", alias="internalTicketNumber")
    decline_reason_description: Optional[StrictStr] = Field(default=None, description="Explanation for why a verification request was declined.", alias="declineReasonDescription")
    resubmit_allowed: Optional[StrictBool] = Field(default=None, description="Whether a Toll-Free Verification request qualifies for resubmission via PUT.", alias="resubmitAllowed")
    created_date_time: Optional[datetime] = Field(default=None, description="Date and time the verification request was created.", alias="createdDateTime")
    modified_date_time: Optional[datetime] = Field(default=None, description="Date and time the verification request was last modified.", alias="modifiedDateTime")
    submission: Optional[TfvSubmissionInfo] = None
    blocked: Optional[StrictBool] = Field(default=None, description="Whether a Toll-Free Verification is blocked. This attribute will only be defined when the number is blocked.")
    blocked_reason: Optional[StrictStr] = Field(default=None, description="The reason why the Toll-Free Verification is blocked. This attribute will only be defined when the number is blocked.", alias="blockedReason")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["phoneNumber", "status", "internalTicketNumber", "declineReasonDescription", "resubmitAllowed", "createdDateTime", "modifiedDateTime", "submission", "blocked", "blockedReason"]

    @field_validator('phone_number')
    def phone_number_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\+1(800|833|844|855|866|877|888)[2-9]\d{6}$", value):
            raise ValueError(r"must validate the regular expression /^\+1(800|833|844|855|866|877|888)[2-9]\d{6}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TfvStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of submission
        if self.submission:
            _dict['submission'] = self.submission.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TfvStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "phoneNumber": obj.get("phoneNumber"),
            "status": obj.get("status"),
            "internalTicketNumber": obj.get("internalTicketNumber"),
            "declineReasonDescription": obj.get("declineReasonDescription"),
            "resubmitAllowed": obj.get("resubmitAllowed"),
            "createdDateTime": obj.get("createdDateTime"),
            "modifiedDateTime": obj.get("modifiedDateTime"),
            "submission": TfvSubmissionInfo.from_dict(obj["submission"]) if obj.get("submission") is not None else None,
            "blocked": obj.get("blocked"),
            "blockedReason": obj.get("blockedReason")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


