# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from hamcrest import *
from test.utils.env_variables import *
from bandwidth import ApiClient, Configuration
from bandwidth.api.media_api import MediaApi
from bandwidth.models.media import Media


class TestMediaApi(unittest.TestCase):
    """MediaApi unit test stubs"""

    def setUp(self) -> None:
        configuration = Configuration(
            username=BW_USERNAME,
            password=BW_PASSWORD,
            host='http://127.0.0.1:4010',
            ignore_operation_servers=True
        )
        api_client = ApiClient(configuration)
        self.media_api_instance = MediaApi(api_client)

    def test_upload_media(self) -> None:
        """Test case for upload_media

        Upload Media
        """
        file = open("./test/fixtures/python_cat.jpeg", "rb")
        response = self.media_api_instance.upload_media_with_http_info(
            account_id=BW_ACCOUNT_ID,
            media_id='media_name.jpeg',
            body=bytes(file.read()), 
            _content_type='image/jpeg',
            cache_control='no-cache'
        )

        assert_that(response.status_code, equal_to(204))

    def test_list_media(self) -> None:
        """Test case for list_media

        List Media
        """
        response = self.media_api_instance.list_media_with_http_info(BW_ACCOUNT_ID)

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(list))
        assert_that(response.data[0], instance_of(Media))
        assert_that(response.data[0].content, instance_of(str))
        assert_that(response.data[0].content_length, instance_of(int))
        assert_that(response.data[0].media_name, instance_of(str))

    def test_get_media(self) -> None:
        """Test case for get_media

        Get Media
        """
        response = self.media_api_instance.get_media_with_http_info(
            BW_ACCOUNT_ID, 'media_name.jpeg', _headers={'Accept': 'application/octet-stream'})

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(bytes))

    def test_delete_media(self) -> None:
        """Test case for delete_media

        Delete Media
        """
        response = self.media_api_instance.delete_media_with_http_info(BW_ACCOUNT_ID, 'media_name.jpeg')

        assert_that(response.status_code, equal_to(204))


if __name__ == '__main__':
    unittest.main()
