# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
from datetime import datetime

from hamcrest import *
from test.utils.env_variables import *
from bandwidth import ApiClient, Configuration
from bandwidth.api.messages_api import MessagesApi
from bandwidth.models.message_request import MessageRequest
from bandwidth.models.message import Message
from bandwidth.models.messages_list import MessagesList
from bandwidth.models.message_direction_enum import MessageDirectionEnum
from bandwidth.models.priority_enum import PriorityEnum
from bandwidth.models.message_status_enum import MessageStatusEnum
from bandwidth.models.list_message_direction_enum import ListMessageDirectionEnum
from bandwidth.models.message_type_enum import MessageTypeEnum
from bandwidth.models.page_info import PageInfo


class TestMessagesApi(unittest.TestCase):
    """MessagesApi unit test stubs"""

    def setUp(self) -> None:
        configuration = Configuration(
            username=BW_USERNAME,
            password=BW_PASSWORD,
            host='http://127.0.0.1:4010',
            ignore_operation_servers=True
        )
        api_client = ApiClient(configuration)
        self.messages_api_instance = MessagesApi(api_client)

    def test_create_message(self) -> None:
        """Test case for create_message

        Create Message
        """
        message_request = MessageRequest(
            application_id=BW_MESSAGING_APPLICATION_ID,
            to=[USER_NUMBER],
            var_from=BW_NUMBER,
            text="Hello from Bandwidth"
        )
        response = self.messages_api_instance.create_message_with_http_info(BW_ACCOUNT_ID, message_request)

        assert_that(response.status_code, equal_to(202))
        assert_that(response.data, instance_of(Message))
        assert_that(response.data.id, has_length(29))
        assert_that(response.data.owner, has_length(12))
        assert_that(response.data.application_id, has_length(36))
        assert_that(response.data.time, instance_of(datetime))
        assert_that(response.data.segment_count, instance_of(int))
        assert_that(response.data.direction, is_in(MessageDirectionEnum))
        assert_that(response.data.to, instance_of(list))
        assert_that(response.data.to[0], has_length(12))
        assert_that(response.data.var_from, has_length(12))
        assert_that(response.data.media, instance_of(list))
        assert_that(response.data.media[0], starts_with('http'))
        assert_that(response.data.text, instance_of(str))
        assert_that(response.data.tag, instance_of(str))
        assert_that(response.data.priority, is_in(PriorityEnum))
        assert_that(response.data.expiration, instance_of(datetime))

    def test_list_messages(self) -> None:
        """Test case for list_messages

        List Messages
        """
        response = self.messages_api_instance.list_messages_with_http_info(BW_ACCOUNT_ID)

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(MessagesList))
        assert_that(response.data.total_count, instance_of(int))
        assert_that(response.data.page_info, instance_of(PageInfo))
        assert_that(response.data.page_info.prev_page, starts_with('http'))
        assert_that(response.data.page_info.next_page, starts_with('http'))
        assert_that(response.data.page_info.prev_page_token, instance_of(str))
        assert_that(response.data.page_info.next_page_token, instance_of(str))
        assert_that(response.data.messages, instance_of(list))
        assert_that(response.data.messages[0].message_id, has_length(29))
        assert_that(response.data.messages[0].account_id, has_length(7))
        assert_that(response.data.messages[0].source_tn, has_length(12))
        assert_that(response.data.messages[0].destination_tn, has_length(12))
        assert_that(response.data.messages[0].message_status, is_in(MessageStatusEnum))
        assert_that(response.data.messages[0].message_direction, is_in(ListMessageDirectionEnum))
        assert_that(response.data.messages[0].message_type, is_in(MessageTypeEnum))
        assert_that(response.data.messages[0].segment_count, instance_of(int))
        assert_that(response.data.messages[0].error_code, instance_of(int))
        assert_that(response.data.messages[0].receive_time, instance_of(datetime))
        assert_that(response.data.messages[0].carrier_name, instance_of(str))
        assert_that(response.data.messages[0].message_size, instance_of(int))
        assert_that(response.data.messages[0].message_length, instance_of(int))
        assert_that(response.data.messages[0].attachment_count, instance_of(int))
        assert_that(response.data.messages[0].recipient_count, instance_of(int))
        assert_that(response.data.messages[0].campaign_class, instance_of(str))
        assert_that(response.data.messages[0].campaign_id, instance_of(str))
        assert_that(response.data.messages[0].bw_latency, instance_of(int))
        assert_that(response.data.messages[0].calling_number_country_a3, instance_of(str))
        assert_that(response.data.messages[0].called_number_country_a3, instance_of(str))
        assert_that(response.data.messages[0].product, instance_of(str))
        assert_that(response.data.messages[0].location, instance_of(str))


if __name__ == '__main__':
    unittest.main()
