# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the manually.
"""  # noqa: E501


import unittest
from datetime import date
from uuid import UUID

from hamcrest import *
from bandwidth import ApiClient, Configuration
from bandwidth.api.phone_number_lookup_api import PhoneNumberLookupApi
from bandwidth.models.async_lookup_request import AsyncLookupRequest
from bandwidth.models.create_async_bulk_lookup_response import CreateAsyncBulkLookupResponse
from bandwidth.models.link_schema import LinkSchema
from bandwidth.models.create_async_bulk_lookup_response_data import CreateAsyncBulkLookupResponseData
from bandwidth.models.in_progress_lookup_status_enum import InProgressLookupStatusEnum
from bandwidth.models.sync_lookup_request import SyncLookupRequest
from bandwidth.models.create_sync_lookup_response import CreateSyncLookupResponse
from bandwidth.models.completed_lookup_status_enum import CompletedLookupStatusEnum
from bandwidth.models.lookup_result import LookupResult
from bandwidth.models.line_type_enum import LineTypeEnum
from bandwidth.models.latest_message_delivery_status_enum import LatestMessageDeliveryStatusEnum
from bandwidth.models.get_async_bulk_lookup_response import GetAsyncBulkLookupResponse

from test.utils.env_variables import *

class TestPhoneNumberLookupApi(unittest.TestCase):
    """PhoneNumberLookupApi unit test stubs"""

    def setUp(self) -> None:
        configuration = Configuration(
            username=BW_USERNAME,
            password=BW_PASSWORD,
            host='http://127.0.0.1:4010',
            ignore_operation_servers=True
        )
        api_client = ApiClient(configuration)
        self.api = PhoneNumberLookupApi(api_client)

    def tearDown(self) -> None:
        pass

    def test_create_async_bulk_lookup(self) -> None:
        """Test case for create_async_bulk_lookup

        Create Asynchronous Bulk Number Lookup
        """
        request = AsyncLookupRequest(
            phone_numbers = [USER_NUMBER, BW_NUMBER],
        )

        response = self.api.create_async_bulk_lookup_with_http_info(BW_ACCOUNT_ID, request)
        assert_that(response, is_not(none()))
        assert_that(response.status_code, equal_to(202))
        assert_that(response.data, is_not(none()))
        assert_that(response.data, instance_of(CreateAsyncBulkLookupResponse))
        assert_that(response.data.links, is_not(none()))
        assert_that(response.data.links[0], instance_of(LinkSchema))
        assert_that(response.data.links[0].rel, instance_of(str))
        assert_that(response.data.links[0].href, instance_of(str))
        assert_that(response.data.links[0].method, instance_of(str))
        assert_that(response.data.data, is_not(none()))
        assert_that(response.data.data, instance_of(CreateAsyncBulkLookupResponseData))
        assert_that(response.data.data.request_id, instance_of(UUID))
        assert_that(response.data.data.status, equal_to(InProgressLookupStatusEnum('IN_PROGRESS')))
        assert_that(response.data.errors, is_not(none()))
        assert_that(response.data.errors, instance_of(list))

    def test_create_sync_lookup(self) -> None:
        """Test case for create_sync_lookup

        Create Synchronous Number Lookup
        """
        request = SyncLookupRequest(
            phone_numbers = [USER_NUMBER, BW_NUMBER],
        )

        response = self.api.create_sync_lookup_with_http_info(BW_ACCOUNT_ID, request)
        assert_that(response, is_not(none()))
        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, is_not(none()))
        assert_that(response.data, instance_of(CreateSyncLookupResponse))
        assert_that(response.data.links, is_not(none()))
        assert_that(response.data.links[0], instance_of(LinkSchema))
        assert_that(response.data.links[0].rel, instance_of(str))
        assert_that(response.data.links[0].href, instance_of(str))
        assert_that(response.data.links[0].method, instance_of(str))
        assert_that(response.data.data, is_not(none()))
        assert_that(response.data.data.request_id, instance_of(UUID))
        assert_that(response.data.data.status, instance_of(CompletedLookupStatusEnum))
        assert_that(response.data.data.status, equal_to(CompletedLookupStatusEnum('COMPLETE')))
        assert_that(response.data.data.results, instance_of(list))
        assert_that(response.data.data.results[0], instance_of(LookupResult))
        assert_that(response.data.data.results[0].phone_number, instance_of(str))
        assert_that(response.data.data.results[0].line_type, instance_of(LineTypeEnum))
        assert_that(response.data.data.results[0].line_type, equal_to(LineTypeEnum('MOBILE')))
        assert_that(response.data.data.results[0].messaging_provider, instance_of(str))
        assert_that(response.data.data.results[0].voice_provider, instance_of(str))
        assert_that(response.data.data.results[0].country_code_a3, instance_of(str))
        assert_that(response.data.data.results[0].latest_message_delivery_status, instance_of(LatestMessageDeliveryStatusEnum))
        assert_that(response.data.data.results[0].latest_message_delivery_status, equal_to(LatestMessageDeliveryStatusEnum('ACTIVE')))
        assert_that(response.data.data.results[0].initial_message_delivery_status_date, instance_of(date))
        assert_that(response.data.data.results[0].latest_message_delivery_status_date, instance_of(date))
        assert_that(response.data.errors, instance_of(list))


    def test_get_async_bulk_lookup(self) -> None:
        """Test case for get_async_bulk_lookup

        Get Asynchronous Bulk Number Lookup
        """
        request_id = UUID('123e4567-e89b-12d3-a456-426614174000')

        response = self.api.get_async_bulk_lookup_with_http_info(BW_ACCOUNT_ID, request_id)
        assert_that(response, is_not(none()))
        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, is_not(none()))
        assert_that(response.data, instance_of(GetAsyncBulkLookupResponse))
        assert_that(response.data.links, is_not(none()))
        assert_that(response.data.links[0], instance_of(LinkSchema))
        assert_that(response.data.links[0].rel, instance_of(str))
        assert_that(response.data.links[0].href, instance_of(str))
        assert_that(response.data.links[0].method, instance_of(str))
        assert_that(response.data.data, is_not(none()))
        assert_that(response.data.data.request_id, instance_of(UUID))
        assert_that(response.data.data.status, instance_of(InProgressLookupStatusEnum))
        assert_that(response.data.data.status, equal_to(InProgressLookupStatusEnum('COMPLETE')))
        assert_that(response.data.data.results, instance_of(list))
        assert_that(response.data.data.results[0], instance_of(LookupResult))
        assert_that(response.data.data.results[0].phone_number, instance_of(str))
        assert_that(response.data.data.results[0].line_type, instance_of(LineTypeEnum))
        assert_that(response.data.data.results[0].messaging_provider, instance_of(str))
        assert_that(response.data.data.results[0].voice_provider, instance_of(str))
        assert_that(response.data.data.results[0].country_code_a3, instance_of(str))
        assert_that(response.data.data.results[0].latest_message_delivery_status, instance_of(LatestMessageDeliveryStatusEnum))
        assert_that(response.data.data.results[0].latest_message_delivery_status, equal_to(LatestMessageDeliveryStatusEnum('ACTIVE')))
        assert_that(response.data.data.results[0].initial_message_delivery_status_date, instance_of(date))
        assert_that(response.data.data.results[0].latest_message_delivery_status_date, instance_of(date))
        assert_that(response.data.errors, instance_of(list))

if __name__ == '__main__':
    unittest.main()
