# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
from datetime import datetime

from hamcrest import *
from test.utils.env_variables import *
from bandwidth import ApiClient, Configuration
from bandwidth.api.recordings_api import RecordingsApi
from bandwidth.models.update_call_recording import UpdateCallRecording
from bandwidth.models.recording_state_enum import RecordingStateEnum
from bandwidth.models.call_recording_metadata import CallRecordingMetadata
from bandwidth.models.call_direction_enum import CallDirectionEnum
from bandwidth.models.file_format_enum import FileFormatEnum
from bandwidth.models.recording_transcription_metadata import RecordingTranscriptionMetadata
from bandwidth.models.recording_transcriptions import RecordingTranscriptions
from bandwidth.models.transcription import Transcription
from bandwidth.models.transcribe_recording import TranscribeRecording


class TestRecordingsApi(unittest.TestCase):
    """RecordingsApi unit test stubs"""

    def setUp(self) -> None:
        configuration = Configuration(
            username=BW_USERNAME,
            password=BW_PASSWORD,
            host='http://127.0.0.1:4010',
            ignore_operation_servers=True
        )
        api_client = ApiClient(configuration)
        self.recordings_api_instance = RecordingsApi(api_client)

        self.call_id = "c-1234"
        self.recording_id = "r-1234"

    def test_update_call_recording_state(self) -> None:
        """Test case for update_call_recording_state

        Update Recording
        """
        update_call_recording = UpdateCallRecording(
            state=RecordingStateEnum("paused")
        )

        response = self.recordings_api_instance.update_call_recording_state_with_http_info(
            BW_ACCOUNT_ID, self.call_id, update_call_recording)

        assert_that(response.status_code, equal_to(200))

    def test_list_account_call_recordings(self) -> None:
        """Test case for list_account_call_recordings

        Get Call Recordings
        """
        response = self.recordings_api_instance.list_account_call_recordings_with_http_info(BW_ACCOUNT_ID)

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(list))
        assert_that(response.data[0], instance_of(CallRecordingMetadata))
        assert_that(response.data[0].application_id, has_length(36))
        assert_that(response.data[0].account_id, has_length(7))
        assert_that(response.data[0].call_id, has_length(47))
        assert_that(response.data[0].parent_call_id, has_length(47))
        assert_that(response.data[0].recording_id, has_length(47))
        assert_that(response.data[0].to, has_length(12))
        assert_that(response.data[0].var_from, has_length(12))
        assert_that(response.data[0].transfer_caller_id, has_length(12))
        assert_that(response.data[0].transfer_to, has_length(12))
        assert_that(response.data[0].duration, starts_with('PT'))
        assert_that(response.data[0].direction, is_in(CallDirectionEnum))
        assert_that(response.data[0].channels, instance_of(int))
        assert_that(response.data[0].start_time, instance_of(datetime))
        assert_that(response.data[0].end_time, instance_of(datetime))
        assert_that(response.data[0].file_format, is_in(FileFormatEnum))
        assert_that(response.data[0].status, instance_of(str))
        assert_that(response.data[0].media_url, starts_with('http'))
        assert_that(response.data[0].transcription, instance_of(RecordingTranscriptionMetadata))
        assert_that(response.data[0].transcription.id, has_length(38))
        assert_that(response.data[0].transcription.status, instance_of(str))
        assert_that(response.data[0].transcription.completed_time, instance_of(datetime))
        assert_that(response.data[0].transcription.url, starts_with('http'))
        assert_that(response.data[0].recording_name, instance_of(str))

    def test_list_call_recordings(self) -> None:
        """Test case for list_call_recordings

        List Call Recordings
        """
        response = self.recordings_api_instance.list_call_recordings_with_http_info(BW_ACCOUNT_ID, self.call_id)

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(list))
        assert_that(response.data[0], instance_of(CallRecordingMetadata))
        assert_that(response.data[0].application_id, has_length(36))
        assert_that(response.data[0].account_id, has_length(7))
        assert_that(response.data[0].call_id, has_length(47))
        assert_that(response.data[0].parent_call_id, has_length(47))
        assert_that(response.data[0].recording_id, has_length(47))
        assert_that(response.data[0].to, has_length(12))
        assert_that(response.data[0].var_from, has_length(12))
        assert_that(response.data[0].transfer_caller_id, has_length(12))
        assert_that(response.data[0].transfer_to, has_length(12))
        assert_that(response.data[0].duration, starts_with('PT'))
        assert_that(response.data[0].direction, is_in(CallDirectionEnum))
        assert_that(response.data[0].channels, instance_of(int))
        assert_that(response.data[0].start_time, instance_of(datetime))
        assert_that(response.data[0].end_time, instance_of(datetime))
        assert_that(response.data[0].file_format, is_in(FileFormatEnum))
        assert_that(response.data[0].status, instance_of(str))
        assert_that(response.data[0].media_url, starts_with('http'))
        assert_that(response.data[0].transcription, instance_of(RecordingTranscriptionMetadata))
        assert_that(response.data[0].transcription.id, has_length(38))
        assert_that(response.data[0].transcription.status, instance_of(str))
        assert_that(response.data[0].transcription.completed_time, instance_of(datetime))
        assert_that(response.data[0].transcription.url, starts_with('http'))
        assert_that(response.data[0].recording_name, instance_of(str))

    @unittest.skip("skip due to prism error")
    def test_get_call_recording(self) -> None:
        """Test case for get_call_recording

        Get Call Recording
        """
        response = self.recordings_api_instance.get_call_recording_with_http_info(
            BW_ACCOUNT_ID, self.call_id, self.recording_id)

        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(CallRecordingMetadata))
        assert_that(response.data.application_id, has_length(36))
        assert_that(response.data.account_id, has_length(7))
        assert_that(response.data.call_id, has_length(47))
        assert_that(response.data.parent_call_id, has_length(47))
        assert_that(response.data.recording_id, has_length(47))
        assert_that(response.data.to, has_length(12))
        assert_that(response.data.var_from, has_length(12))
        assert_that(response.data.transfer_caller_id, has_length(12))
        assert_that(response.data.transfer_to, has_length(12))
        assert_that(response.data.duration, starts_with('PT'))
        assert_that(response.data.direction, is_in(CallDirectionEnum))
        assert_that(response.data.channels, instance_of(int))
        assert_that(response.data.start_time, instance_of(datetime))
        assert_that(response.data.end_time, instance_of(datetime))
        assert_that(response.data.file_format, is_in(FileFormatEnum))
        assert_that(response.data.status, instance_of(str))
        assert_that(response.data.media_url, starts_with('http'))
        assert_that(response.data.transcription, instance_of(RecordingTranscriptionMetadata))
        assert_that(response.data.transcription.id, has_length(38))
        assert_that(response.data.transcription.status, instance_of(str))
        assert_that(response.data.transcription.completed_time, instance_of(datetime))
        assert_that(response.data.transcription.url, starts_with('http'))
        assert_that(response.data.recording_name, instance_of(str))

    def test_download_call_recording(self) -> None:
        """Test case for download_call_recording

        Download Recording
        """
        response = self.recordings_api_instance.download_call_recording_with_http_info(
            BW_ACCOUNT_ID, self.call_id, self.recording_id, _headers={'Accept': 'audio/vnd.wave'})
        
        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(bytes))

    def test_transcribe_call_recording(self) -> None:
        """Test case for transcribe_call_recording

        Create Transcription Request
        """
        transcribe_recording = TranscribeRecording(
            callback_url="http://callback.url",
            tag="tag"
        )

        response = self.recordings_api_instance.transcribe_call_recording_with_http_info(
            BW_ACCOUNT_ID, self.call_id, self.recording_id, transcribe_recording)

        assert_that(response.status_code, equal_to(204))

    def test_get_recording_transcription(self) -> None:
        """Test case for get_recording_transcription

        Get Transcription
        """
        response = self.recordings_api_instance.get_recording_transcription_with_http_info(
            BW_ACCOUNT_ID, self.call_id, self.recording_id)
        
        assert_that(response.status_code, equal_to(200))
        assert_that(response.data, instance_of(RecordingTranscriptions))
        assert_that(response.data.transcripts, instance_of(list))
        assert_that(response.data.transcripts[0], instance_of(Transcription))
        assert_that(response.data.transcripts[0].text, instance_of(str))
        assert_that(response.data.transcripts[0].confidence, instance_of(float))

    def test_delete_recording_transcription(self) -> None:
        """Test case for delete_recording_transcription

        Delete Transcription
        """
        response = self.recordings_api_instance.delete_recording_transcription_with_http_info(
            BW_ACCOUNT_ID, self.call_id, self.recording_id)

        assert_that(response.status_code, equal_to(204))

    def test_delete_recording_media(self) -> None:
        """Test case for delete_recording_media

        Delete Recording Media
        """
        response = self.recordings_api_instance.delete_recording_media_with_http_info(
            BW_ACCOUNT_ID, self.call_id, self.recording_id)

        assert_that(response.status_code, equal_to(204))

    def test_delete_recording(self) -> None:
        """Test case for delete_recording

        Delete Recording
        """
        response = self.recordings_api_instance.delete_recording_with_http_info(
            BW_ACCOUNT_ID, self.call_id, self.recording_id)

        assert_that(response.status_code, equal_to(204))


if __name__ == '__main__':
    unittest.main()
