# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
from uuid import UUID

from bandwidth.models.create_async_bulk_lookup_response import CreateAsyncBulkLookupResponse
from bandwidth.models.create_async_bulk_lookup_response_data import CreateAsyncBulkLookupResponseData
from bandwidth.models.link_schema import LinkSchema
from bandwidth.models.lookup_error_schema import LookupErrorSchema
from bandwidth.models.lookup_error_schema_meta import LookupErrorSchemaMeta
from bandwidth.models.in_progress_lookup_status_enum import InProgressLookupStatusEnum

class TestCreateAsyncBulkLookupResponse(unittest.TestCase):
    """CreateAsyncBulkLookupResponse unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> CreateAsyncBulkLookupResponse:
        """Test CreateAsyncBulkLookupResponse
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        if include_optional:
            return CreateAsyncBulkLookupResponse(
                links = [
                    LinkSchema(
                        href = '/relative/uri', 
                        rel = 'aRelatedResource', 
                        method = 'GET', )
                    ],
                data = CreateAsyncBulkLookupResponseData(
                    request_id = UUID('004223a0-8b17-41b1-bf81-20732adf5590'), 
                    status = InProgressLookupStatusEnum('COMPLETE'), ),
                errors = [
                    LookupErrorSchema(
                        code = 'NO-MATCH', 
                        description = 'Example error description', 
                        type = 'NumberInventory', 
                        meta = LookupErrorSchemaMeta(
                            phone_numbers = ["+13992077164","+19196104424"], 
                            message = 'Invalid TNs', 
                            code = 1001, ), )
                    ]
            )
        else:
            return CreateAsyncBulkLookupResponse(
        )

    def testCreateAsyncBulkLookupResponse(self):
        """Test CreateAsyncBulkLookupResponse"""
        instance = self.make_instance(True)
        assert instance is not None
        assert isinstance(instance, CreateAsyncBulkLookupResponse)
        assert instance.links is not None
        assert isinstance(instance.links[0], LinkSchema)
        assert instance.links[0].href == '/relative/uri'
        assert instance.links[0].rel == 'aRelatedResource'
        assert instance.links[0].method == 'GET'
        assert instance.data is not None
        assert isinstance(instance.data, CreateAsyncBulkLookupResponseData)
        assert instance.data.request_id == UUID('004223a0-8b17-41b1-bf81-20732adf5590')
        assert instance.data.status == InProgressLookupStatusEnum('COMPLETE')
        assert instance.errors is not None
        assert isinstance(instance.errors[0], LookupErrorSchema)
        assert instance.errors[0].code == 'NO-MATCH'
        assert instance.errors[0].description == 'Example error description'
        assert instance.errors[0].type == 'NumberInventory'
        assert instance.errors[0].meta is not None
        assert isinstance(instance.errors[0].meta, LookupErrorSchemaMeta)
        assert instance.errors[0].meta.phone_numbers == ["+13992077164","+19196104424"]
        assert instance.errors[0].meta.message == 'Invalid TNs'
        assert instance.errors[0].meta.code == 1001

if __name__ == '__main__':
    unittest.main()
