# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
from datetime import date
from uuid import UUID

from bandwidth.models.get_async_bulk_lookup_response import GetAsyncBulkLookupResponse
from bandwidth.models.get_async_bulk_lookup_response_data import GetAsyncBulkLookupResponseData
from bandwidth.models.lookup_error_schema import LookupErrorSchema
from bandwidth.models.lookup_error_schema_meta import LookupErrorSchemaMeta
from bandwidth.models.lookup_result import LookupResult

class TestGetAsyncBulkLookupResponse(unittest.TestCase):
    """GetAsyncBulkLookupResponse unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> GetAsyncBulkLookupResponse:
        """Test GetAsyncBulkLookupResponse
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        if include_optional:
            return GetAsyncBulkLookupResponse(
                links = [],
                data = GetAsyncBulkLookupResponseData(
                    request_id = UUID('004223a0-8b17-41b1-bf81-20732adf5590'), 
                    status = 'COMPLETE', 
                    results = [
                        LookupResult(
                            phone_number = '+10072904498', 
                            line_type = 'MOBILE', 
                            messaging_provider = 'Verizon Wireless', 
                            voice_provider = 'Verizon Wireless', 
                            country_code_a3 = 'USA', 
                            deactivation_reporter = '', 
                            deactivation_date = '2025-06-20 18:35', 
                            deactivation_event = 'DEACTIVATED', 
                            latest_message_delivery_status = 'ACTIVE', 
                            initial_message_delivery_status_date = '2025-06-20', 
                            latest_message_delivery_status_date = '2025-06-20', )
                        ], ),
                errors = [
                    LookupErrorSchema(
                        code = 'NO-MATCH', 
                        description = 'Example error description', 
                        type = 'NumberInventory', 
                        meta = LookupErrorSchemaMeta(
                            phone_numbers = ["+13992077164","+19196104424"], 
                            message = 'Invalid TNs', 
                            code = 1001, ), )
                    ]
            )
        else:
            return GetAsyncBulkLookupResponse(
        )

    def testGetAsyncBulkLookupResponse(self):
        """Test GetAsyncBulkLookupResponse"""
        instance = self.make_instance(True)
        assert instance is not None
        assert isinstance(instance, GetAsyncBulkLookupResponse)
        assert instance.data is not None
        assert isinstance(instance.data, GetAsyncBulkLookupResponseData)
        assert instance.data.request_id == UUID('004223a0-8b17-41b1-bf81-20732adf5590')
        assert instance.data.status == 'COMPLETE'
        assert len(instance.data.results) == 1
        result = instance.data.results[0]
        assert result.phone_number == '+10072904498'
        assert result.line_type == 'MOBILE'
        assert result.messaging_provider == 'Verizon Wireless'
        assert result.voice_provider == 'Verizon Wireless'
        assert result.country_code_a3 == 'USA'
        assert result.deactivation_reporter == ''
        assert result.deactivation_date == '2025-06-20 18:35'
        assert result.deactivation_event == 'DEACTIVATED'
        assert result.latest_message_delivery_status == 'ACTIVE'
        assert isinstance(result.initial_message_delivery_status_date, date)
        assert isinstance(result.latest_message_delivery_status_date, date)
        assert instance.errors is not None
        assert isinstance(instance.errors[0], LookupErrorSchema)
        assert instance.errors[0].code == 'NO-MATCH'
        assert instance.errors[0].description == 'Example error description'
        assert instance.errors[0].type == 'NumberInventory'
        assert instance.errors[0].meta is not None
        assert isinstance(instance.errors[0].meta, LookupErrorSchemaMeta)
        assert instance.errors[0].meta.phone_numbers == ["+13992077164","+19196104424"]
        assert instance.errors[0].meta.message == 'Invalid TNs'
        assert instance.errors[0].meta.code == 1001

if __name__ == '__main__':
    unittest.main()
