# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
from datetime import date
from uuid import UUID

from bandwidth.models.get_async_bulk_lookup_response_data import GetAsyncBulkLookupResponseData
from bandwidth.models.lookup_result import LookupResult

class TestGetAsyncBulkLookupResponseData(unittest.TestCase):
    """GetAsyncBulkLookupResponseData unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> GetAsyncBulkLookupResponseData:
        """Test GetAsyncBulkLookupResponseData
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        if include_optional:
            return GetAsyncBulkLookupResponseData(
                request_id = UUID('004223a0-8b17-41b1-bf81-20732adf5590'),
                status = 'COMPLETE',
                results = [
                    LookupResult(
                        phone_number = '+10072904498', 
                        line_type = 'MOBILE', 
                        messaging_provider = 'Verizon Wireless', 
                        voice_provider = 'Verizon Wireless', 
                        country_code_a3 = 'USA', 
                        deactivation_reporter = '', 
                        deactivation_date = '2025-06-20 18:35', 
                        deactivation_event = 'DEACTIVATED', 
                        latest_message_delivery_status = 'ACTIVE', 
                        initial_message_delivery_status_date = '2025-06-20', 
                        latest_message_delivery_status_date = '2025-06-20', )
                    ]
            )
        else:
            return GetAsyncBulkLookupResponseData(
        )

    def testGetAsyncBulkLookupResponseData(self):
        """Test GetAsyncBulkLookupResponseData"""
        instance = self.make_instance(True)
        assert instance is not None
        assert isinstance(instance, GetAsyncBulkLookupResponseData)
        assert instance.request_id == UUID('004223a0-8b17-41b1-bf81-20732adf5590')
        assert instance.status == 'COMPLETE'
        assert len(instance.results) == 1
        result = instance.results[0]
        assert result.phone_number == '+10072904498'
        assert result.line_type == 'MOBILE'
        assert result.messaging_provider == 'Verizon Wireless'
        assert result.voice_provider == 'Verizon Wireless'
        assert result.country_code_a3 == 'USA'
        assert result.deactivation_reporter == ''
        assert result.deactivation_date == '2025-06-20 18:35'
        assert result.deactivation_event == 'DEACTIVATED'
        assert result.latest_message_delivery_status == 'ACTIVE'
        assert isinstance(result.initial_message_delivery_status_date, date)
        assert isinstance(result.latest_message_delivery_status_date, date)

if __name__ == '__main__':
    unittest.main()
