# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
from datetime import datetime

from bandwidth.models.inbound_callback_message import InboundCallbackMessage
from bandwidth.models.multi_channel_message_content import MultiChannelMessageContent
from bandwidth.models.rbm_location_response import RbmLocationResponse
from bandwidth.models.rbm_suggestion_response import RbmSuggestionResponse
from bandwidth.models.rbm_message_content_file import RbmMessageContentFile

class TestInboundCallbackMessage(unittest.TestCase):
    """InboundCallbackMessage unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> InboundCallbackMessage:
        """Test InboundCallbackMessage
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        if include_optional:
            return InboundCallbackMessage(
                id = '1661365814859loidf7mcwd4qacn7',
                owner = '+15553332222',
                application_id = '93de2206-9669-4e07-948d-329f4b722ee2',
                time = '2024-12-02T20:15:57.666Z',
                segment_count = 1,
                direction = 'in',
                to = ['+15552223333'],
                var_from = '+15553332222',
                text = 'Hello world',
                tag = 'custom string',
                media = ['https://dev.bandwidth.com/images/bandwidth-logo.png', 'https://dev.bandwidth.com/images/github_logo.png'],
                priority = 'default',
                channel = 'RBM',
                content = MultiChannelMessageContent(
                    text = '', 
                    media = RbmMessageContentFile(
                        file_url = 'https://dev.bandwidth.com/images/bandwidth-logo.png', 
                        thumbnail_url = 'https://dev.bandwidth.com/images/bandwidth-logo.png', ), ),
                suggestion_response = RbmSuggestionResponse(
                    text = 'Yes, I would like to proceed', 
                    postback_data = '[B@5d4a34ff', ),
                location_response = RbmLocationResponse(
                    latitude = '37.7749', 
                    longitude = '-122.4194', )
            )
        else:
            return InboundCallbackMessage(
                id = '1661365814859loidf7mcwd4qacn7',
                owner = '+15553332222',
                application_id = '93de2206-9669-4e07-948d-329f4b722ee2',
                time = '2024-12-02T20:15:57.666Z',
                segment_count = 1,
                direction = 'in',
                to = ['+15552223333'],
                var_from = '+15553332222',
        )

    def testInboundCallbackMessage(self):
        """Test InboundCallbackMessage"""
        instance = self.make_instance(True)
        assert instance is not None
        assert isinstance(instance, InboundCallbackMessage)
        assert instance.id == '1661365814859loidf7mcwd4qacn7'
        assert instance.owner == '+15553332222'
        assert instance.application_id == '93de2206-9669-4e07-948d-329f4b722ee2'
        assert isinstance(instance.time, datetime)
        assert instance.segment_count == 1
        assert instance.direction == 'in'
        assert instance.to == ['+15552223333']
        assert instance.var_from == '+15553332222'
        assert instance.text == 'Hello world'
        assert instance.tag == 'custom string'
        assert isinstance(instance.media, list)
        assert len(instance.media) > 0
        assert isinstance(instance.content, MultiChannelMessageContent)
        assert isinstance(instance.suggestion_response, RbmSuggestionResponse)
        assert isinstance(instance.location_response, RbmLocationResponse)

if __name__ == '__main__':
    unittest.main()
