# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from bandwidth.models.lookup_error_response import LookupErrorResponse
from bandwidth.models.lookup_error_schema import LookupErrorSchema
from bandwidth.models.lookup_error_schema_meta import LookupErrorSchemaMeta

class TestLookupErrorResponse(unittest.TestCase):
    """LookupErrorResponse unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> LookupErrorResponse:
        """Test LookupErrorResponse
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        if include_optional:
            return LookupErrorResponse(
                links = [],
                data = None,
                errors = [
                    LookupErrorSchema(
                        code = 'NO-MATCH', 
                        description = 'Example error description', 
                        type = 'NumberInventory', 
                        meta = LookupErrorSchemaMeta(
                            phone_numbers = ["+13992077164","+19196104424"], 
                            message = 'Invalid TNs', 
                            code = 1001, ), )
                    ]
            )
        else:
            return LookupErrorResponse(
        )

    def testLookupErrorResponse(self):
        """Test LookupErrorResponse"""
        instance = self.make_instance(True)
        assert instance is not None
        assert isinstance(instance, LookupErrorResponse)
        assert instance.links == []
        assert instance.data is None
        assert len(instance.errors) == 1
        error = instance.errors[0]
        assert error.code == 'NO-MATCH'
        assert error.description == 'Example error description'
        assert error.type == 'NumberInventory'
        assert error.meta.phone_numbers == ["+13992077164", "+19196104424"]
        assert error.meta.message == 'Invalid TNs'
        assert error.meta.code == 1001

if __name__ == '__main__':
    unittest.main()
