# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from bandwidth.models.rbm_card_content import RbmCardContent
from bandwidth.models.multi_channel_action import MultiChannelAction
from bandwidth.models.rbm_action_base import RbmActionBase
from bandwidth.models.rbm_card_content_media import RbmCardContentMedia

class TestRbmCardContent(unittest.TestCase):
    """RbmCardContent unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> RbmCardContent:
        """Test RbmCardContent
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        if include_optional:
            return RbmCardContent(
                title = 'Bandwidth',
                description = 'Bandwidth is a communications platform as a service (CPaaS) company.',
                media = RbmCardContentMedia(
                    file_url = 'https://dev.bandwidth.com/images/bandwidth-logo.png',
                    thumbnail_url = 'https://dev.bandwidth.com/images/bandwidth-logo.png',
                    height = 'SHORT'
                ),
                suggestions = [
                    MultiChannelAction(
                        RbmActionBase(
                            type = 'REPLY',
                            text = 'Hello world',
                            postback_data = '[B@32298473'
                        )
                    )
                ]
            )
        else:
            return RbmCardContent(
        )

    def testRbmCardContent(self):
        """Test RbmCardContent"""
        instance = self.make_instance(True)
        assert instance is not None
        assert isinstance(instance, RbmCardContent)
        assert instance.title == 'Bandwidth'
        assert instance.description == 'Bandwidth is a communications platform as a service (CPaaS) company.'
        assert instance.media is not None
        assert isinstance(instance.media, RbmCardContentMedia)
        assert instance.suggestions is not None
        assert isinstance(instance.suggestions, list)
        assert len(instance.suggestions) > 0
        assert isinstance(instance.suggestions[0], MultiChannelAction)

if __name__ == '__main__':
    unittest.main()
