# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from bandwidth.models.rbm_standalone_card import RbmStandaloneCard
from bandwidth.models.rbm_card_content import RbmCardContent
from bandwidth.models.rbm_action_base import RbmActionBase
from bandwidth.models.multi_channel_action import MultiChannelAction
from bandwidth.models.rbm_card_content_media import RbmCardContentMedia

class TestRbmStandaloneCard(unittest.TestCase):
    """RbmStandaloneCard unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> RbmStandaloneCard:
        """Test RbmStandaloneCard
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        if include_optional:
            return RbmStandaloneCard(
                orientation = 'VERTICAL',
                thumbnail_image_alignment = 'LEFT',
                card_content = RbmCardContent(
                    title = 'Bandwidth',
                    description = 'Bandwidth is a communications platform as a service (CPaaS) company.',
                    media = RbmCardContentMedia(
                        file_url = 'https://dev.bandwidth.com/images/bandwidth-logo.png',
                        thumbnail_url = 'https://dev.bandwidth.com/images/bandwidth-logo.png',
                        height = 'SHORT'
                    ),
                    suggestions = [
                        MultiChannelAction(
                            RbmActionBase(
                                type = 'REPLY',
                                text = 'Hello world',
                                postback_data = '[B@32298473'
                            )
                        )
                    ]
                ),
                suggestions = [
                    MultiChannelAction(
                        RbmActionBase(
                            type = 'REPLY',
                            text = 'Hello world',
                            postback_data = '[B@32298473'
                        )
                    )
                ]
            )
        else:
            return RbmStandaloneCard(
                orientation = 'VERTICAL',
                thumbnail_image_alignment = 'LEFT',
                card_content = RbmCardContent(
                title = 'Bandwidth',
                description = 'Bandwidth is a communications platform as a service (CPaaS) company.',
                media = None,
                suggestions = [
                    MultiChannelAction(
                        RbmActionBase(
                            type = 'REPLY',
                            text = 'Hello world',
                            postback_data = '[B@32298473'
                        )
                    )
                ]
            )
        )

    def testRbmStandaloneCard(self):
        """Test RbmStandaloneCard"""
        instance = self.make_instance(True)
        assert instance is not None
        assert isinstance(instance, RbmStandaloneCard)
        assert instance.orientation == 'VERTICAL'
        assert instance.thumbnail_image_alignment == 'LEFT'
        assert isinstance(instance.card_content, RbmCardContent)
        assert isinstance(instance.suggestions, list)
        assert all(isinstance(suggestion, MultiChannelAction) for suggestion in instance.suggestions)
        assert instance.card_content.title == 'Bandwidth'
        assert instance.card_content.description == 'Bandwidth is a communications platform as a service (CPaaS) company.'
        assert instance.card_content.media is not None
        assert isinstance(instance.card_content.media, RbmCardContentMedia)
        assert isinstance(instance.card_content.suggestions[0], MultiChannelAction)
        assert isinstance(instance.suggestions[0], MultiChannelAction)

if __name__ == '__main__':
    unittest.main()
