# coding: utf-8

"""
    Bandwidth

    Bandwidth's Communication APIs

    The version of the OpenAPI document: 1.0.0
    Contact: letstalk@bandwidth.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from bandwidth.models.tfv_submission_info import TfvSubmissionInfo
from bandwidth.models.address import Address
from bandwidth.models.contact import Contact
from bandwidth.models.opt_in_workflow import OptInWorkflow

class TestTfvSubmissionInfo(unittest.TestCase):
    """TfvSubmissionInfo unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> TfvSubmissionInfo:
        """Test TfvSubmissionInfo
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        if include_optional:
            return TfvSubmissionInfo(
                business_address = Address(
                    name = 'Bandwidth Inc.', 
                    addr1 = '2230 Bandmate Way', 
                    addr2 = '', 
                    city = 'Raleigh', 
                    state = 'NC', 
                    zip = '27606', 
                    url = 'https://www.example.com/path/to/resource', ),
                business_contact = Contact(
                    first_name = 'John', 
                    last_name = 'Doe', 
                    email = 'foo@bar.com', 
                    phone_number = '+19192654500', ),
                message_volume = 10000,
                use_case = '2FA',
                use_case_summary = 'Text summarizing the use case for the toll-free number',
                production_message_content = 'Production message content',
                opt_in_workflow = OptInWorkflow(
                    description = 'Opt In Flow', 
                    image_urls = [
                        'https://www.example.com/path/to/resource'
                    ],
                    confirmation_response = 'Thank you for opting in!', ),
                additional_information = 'Any additional information',
                isv_reseller = 'Test ISV',
                privacy_policy_url = 'https://www.example.com/path/to/resource',
                terms_and_conditions_url = 'https://www.example.com/path/to/resource',
                business_dba = 'Bandwidth Inc.',
                business_registration_number = '12-3456789',
                business_registration_type = 'EIN',
                business_entity_type = 'SOLE_PROPRIETOR'
            )
        else:
            return TfvSubmissionInfo(
        )

    def testTfvSubmissionInfo(self):
        """Test TfvSubmissionInfo"""
        instance = self.make_instance(True)
        assert instance is not None
        assert isinstance(instance, TfvSubmissionInfo)
        assert isinstance(instance.business_address, Address)
        assert instance.business_address.name == 'Bandwidth Inc.'
        assert instance.business_address.addr1 == '2230 Bandmate Way'
        assert instance.business_address.addr2 == ''
        assert instance.business_address.city == 'Raleigh'
        assert instance.business_address.state == 'NC'
        assert instance.business_address.zip == '27606'
        assert instance.business_address.url == 'https://www.example.com/path/to/resource'
        assert isinstance(instance.business_contact, Contact)
        assert instance.business_contact.first_name == 'John'
        assert instance.business_contact.last_name == 'Doe'
        assert instance.business_contact.email == 'foo@bar.com'
        assert instance.business_contact.phone_number == '+19192654500'
        assert instance.message_volume == 10000
        assert instance.use_case == '2FA'
        assert instance.use_case_summary == 'Text summarizing the use case for the toll-free number'
        assert instance.production_message_content == 'Production message content'
        assert isinstance(instance.opt_in_workflow, OptInWorkflow)
        assert instance.opt_in_workflow.description == 'Opt In Flow'
        assert isinstance(instance.opt_in_workflow.image_urls, list)
        assert len(instance.opt_in_workflow.image_urls) == 1
        assert instance.opt_in_workflow.image_urls[0] == 'https://www.example.com/path/to/resource'
        assert instance.opt_in_workflow.confirmation_response == 'Thank you for opting in!'
        assert instance.additional_information == 'Any additional information'
        assert instance.isv_reseller == 'Test ISV'
        assert instance.privacy_policy_url == 'https://www.example.com/path/to/resource'
        assert instance.terms_and_conditions_url == 'https://www.example.com/path/to/resource'
        assert instance.business_dba == 'Bandwidth Inc.'
        assert instance.business_registration_number == '12-3456789'
        assert instance.business_registration_type == 'EIN'
        assert instance.business_entity_type == 'SOLE_PROPRIETOR'

if __name__ == '__main__':
    unittest.main()
