"""

iceaddr: Look up information about Icelandic streets, addresses,
         placenames, landmarks, locations and postcodes.

Copyright (c) 2018-2025 Sveinbjorn Thordarson.

This file contains code and data related to Icelandic postcodes.

"""

from typing import Optional, Union

from collections import defaultdict

POSTCODES: dict[int, dict[str, str]] = {
    101: {
        "lysing": "Miðborg",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    102: {
        "lysing": "Vatnsmýri og Skerjafjörður",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    103: {
        "lysing": "Háaleitis- og Bústaðahverfi",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    104: {
        "lysing": "Laugardalur",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    105: {
        "lysing": "Hlíðar",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    107: {
        "lysing": "Vesturbær",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    108: {
        "lysing": "Háaleitis- og Bústaðahverfi",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    109: {
        "lysing": "Breiðholt",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    110: {
        "lysing": "Árbær",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    111: {
        "lysing": "Breiðholt",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    112: {
        "lysing": "Grafarvogur",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    113: {
        "lysing": "Grafarholt og Úlfarsárdalur",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    116: {
        "lysing": "Kjalarnes",
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    121: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    123: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    124: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    125: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    127: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    128: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    129: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    130: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    132: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    150: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Dreifbýli",
    },
    155: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Dreifbýli",
    },
    161: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Dreifbýli",
    },
    162: {
        "stadur_nf": "Reykjavík",
        "stadur_tgf": "Reykjavík",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Dreifbýli",
    },
    170: {
        "stadur_nf": "Seltjarnarnes",
        "stadur_tgf": "Seltjarnarnesi",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    172: {
        "stadur_nf": "Seltjarnarnes",
        "stadur_tgf": "Seltjarnarnesi",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    190: {
        "stadur_nf": "Vogar",
        "stadur_tgf": "Vogum",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    191: {
        "stadur_nf": "Vogar",
        "stadur_tgf": "Vogum",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    200: {
        "stadur_nf": "Kópavogur",
        "stadur_tgf": "Kópavogi",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    201: {
        "stadur_nf": "Kópavogur",
        "stadur_tgf": "Kópavogi",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    202: {
        "stadur_nf": "Kópavogur",
        "stadur_tgf": "Kópavogi",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    203: {
        "stadur_nf": "Kópavogur",
        "stadur_tgf": "Kópavogi",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    206: {
        "stadur_nf": "Kópavogur",
        "stadur_tgf": "Kópavogi",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Dreifbýli",
    },
    210: {
        "stadur_nf": "Garðabær",
        "stadur_tgf": "Garðabæ",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    212: {
        "stadur_nf": "Garðabær",
        "stadur_tgf": "Garðabæ",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    220: {
        "stadur_nf": "Hafnarfjörður",
        "stadur_tgf": "Hafnarfirði",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    221: {
        "stadur_nf": "Hafnarfjörður",
        "stadur_tgf": "Hafnarfirði",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    222: {
        "stadur_nf": "Hafnarfjörður",
        "stadur_tgf": "Hafnarfirði",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Pósthólf",
    },
    225: {
        "stadur_nf": "Garðabær",
        "stadur_tgf": "Garðabæ",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    230: {
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    232: {
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Pósthólf",
    },
    233: {
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    235: {
        "lysing": "Keflavíkurflugvöllur",
        "stadur_nf": "Keflavíkurflugvöllur",
        "stadur_tgf": "Keflavíkurflugvelli",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    240: {
        "stadur_nf": "Grindavík",
        "stadur_tgf": "Grindavík",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    241: {
        "stadur_nf": "Grindavík",
        "stadur_tgf": "Grindavík",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    245: {
        "stadur_nf": "Sandgerði",
        "stadur_tgf": "Sandgerði",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    246: {
        "stadur_nf": "Sandgerði",
        "stadur_tgf": "Sandgerði",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    250: {
        "stadur_nf": "Garður",
        "stadur_tgf": "Garði",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    251: {
        "stadur_nf": "Garður",
        "stadur_tgf": "Garði",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    260: {
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    262: {
        "lysing": "Ásbrú",
        "stadur_nf": "Reykjanesbær",
        "stadur_tgf": "Reykjanesbæ",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    270: {
        "stadur_nf": "Mosfellsbær",
        "stadur_tgf": "Mosfellsbæ",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    271: {
        "stadur_nf": "Mosfellsbær",
        "stadur_tgf": "Mosfellsbæ",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    276: {
        "lysing": "Kjós",
        "stadur_nf": "Kjós",
        "stadur_tgf": "Kjós",
        "svaedi_nf": "Höfuðborgarsvæðið",
        "svaedi_tgf": "Höfuðborgarsvæðinu",
        "tegund": "Stærra dreifbýli",
    },
    300: {
        "stadur_nf": "Akranes",
        "stadur_tgf": "Akranesi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    301: {
        "stadur_nf": "Akranes",
        "stadur_tgf": "Akranesi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    302: {
        "stadur_nf": "Akranes",
        "stadur_tgf": "Akranesi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Pósthólf",
    },
    310: {
        "stadur_nf": "Borgarnes",
        "stadur_tgf": "Borgarnesi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    311: {
        "stadur_nf": "Borgarnes",
        "stadur_tgf": "Borgarnesi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    320: {
        "stadur_nf": "Reykholt",
        "stadur_tgf": "Reykholti",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    340: {
        "stadur_nf": "Stykkishólmur",
        "stadur_tgf": "Stykkishólmi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    341: {
        "stadur_nf": "Stykkishólmur",
        "stadur_tgf": "Stykkishólmi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    342: {
        "stadur_nf": "Stykkishólmur",
        "stadur_tgf": "Stykkishólmi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    345: {
        "stadur_nf": "Flatey",
        "stadur_tgf": "Flatey",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    350: {
        "stadur_nf": "Grundarfjörður",
        "stadur_tgf": "Grundarfirði",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    351: {
        "stadur_nf": "Grundarfjörður",
        "stadur_tgf": "Grundarfirði",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    355: {
        "stadur_nf": "Ólafsvík",
        "stadur_tgf": "Ólafsvík",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    356: {
        "stadur_nf": "Snæfellsbær",
        "stadur_tgf": "Snæfellsbæ",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    360: {
        "stadur_nf": "Hellissandur",
        "stadur_tgf": "Hellissandi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    370: {
        "stadur_nf": "Búðardalur",
        "stadur_tgf": "Búðardal",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    371: {
        "stadur_nf": "Búðardalur",
        "stadur_tgf": "Búðardal",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    380: {
        "stadur_nf": "Reykhólahreppur",
        "stadur_tgf": "Reykhólahreppi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    381: {
        "stadur_nf": "Reykhólahreppur",
        "stadur_tgf": "Reykhólahreppi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    400: {
        "stadur_nf": "Ísafjörður",
        "stadur_tgf": "Ísafirði",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    401: {
        "stadur_nf": "Ísafjörður",
        "stadur_tgf": "Ísafirði",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    410: {
        "stadur_nf": "Hnífsdalur",
        "stadur_tgf": "Hnífsdal",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    415: {
        "stadur_nf": "Bolungarvík",
        "stadur_tgf": "Bolungarvík",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    416: {
        "stadur_nf": "Bolungarvík",
        "stadur_tgf": "Bolungarvík",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    420: {
        "stadur_nf": "Súðavík",
        "stadur_tgf": "Súðavík",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    421: {
        "stadur_nf": "Súðavík",
        "stadur_tgf": "Súðavík",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    425: {
        "stadur_nf": "Flateyri",
        "stadur_tgf": "Flateyri",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    426: {
        "stadur_nf": "Flateyri",
        "stadur_tgf": "Flateyri",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    430: {
        "stadur_nf": "Suðureyri",
        "stadur_tgf": "Suðureyri",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    431: {
        "stadur_nf": "Suðureyri",
        "stadur_tgf": "Suðureyri",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    450: {
        "stadur_nf": "Patreksfjörður",
        "stadur_tgf": "Patreksfirði",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    451: {
        "stadur_nf": "Patreksfjörður",
        "stadur_tgf": "Patreksfirði",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    460: {
        "stadur_nf": "Tálknafjörður",
        "stadur_tgf": "Tálknafirði",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    461: {
        "stadur_nf": "Tálknafjörður",
        "stadur_tgf": "Tálknafirði",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    465: {
        "stadur_nf": "Bíldudalur",
        "stadur_tgf": "Bíldudal",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    466: {
        "stadur_nf": "Bíldudalur",
        "stadur_tgf": "Bíldudal",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    470: {
        "stadur_nf": "Þingeyri",
        "stadur_tgf": "Þingeyri",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    471: {
        "stadur_nf": "Þingeyri",
        "stadur_tgf": "Þingeyri",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    500: {
        "stadur_nf": "Staður",
        "stadur_tgf": "Stað",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    510: {
        "stadur_nf": "Hólmavík",
        "stadur_tgf": "Hólmavík",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    511: {
        "stadur_nf": "Hólmavík",
        "stadur_tgf": "Hólmavík",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    512: {
        "stadur_nf": "Hólmavík",
        "stadur_tgf": "Hólmavík",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    520: {
        "stadur_nf": "Drangsnes",
        "stadur_tgf": "Drangsnesi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Stærra dreifbýli",
    },
    524: {
        "stadur_nf": "Árneshreppur",
        "stadur_tgf": "Árneshreppi",
        "svaedi_nf": "Vesturland og Vestfirðir",
        "svaedi_tgf": "Vesturlandi og Vestfjörðum",
        "tegund": "Dreifbýli",
    },
    530: {
        "stadur_nf": "Hvammstangi",
        "stadur_tgf": "Hvammstanga",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    531: {
        "stadur_nf": "Hvammstangi",
        "stadur_tgf": "Hvammstanga",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    540: {
        "stadur_nf": "Blönduós",
        "stadur_tgf": "Blönduósi",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    541: {
        "stadur_nf": "Blönduós",
        "stadur_tgf": "Blönduósi",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    545: {
        "stadur_nf": "Skagaströnd",
        "stadur_tgf": "Skagaströnd",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    546: {
        "stadur_nf": "Skagaströnd",
        "stadur_tgf": "Skagaströnd",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    550: {
        "stadur_nf": "Sauðárkrókur",
        "stadur_tgf": "Sauðárkróki",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    551: {
        "stadur_nf": "Sauðárkrókur",
        "stadur_tgf": "Sauðárkróki",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    560: {
        "stadur_nf": "Varmahlíð",
        "stadur_tgf": "Varmahlíð",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    561: {
        "stadur_nf": "Varmahlíð",
        "stadur_tgf": "Varmahlíð",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    565: {
        "stadur_nf": "Hofsós",
        "stadur_tgf": "Hofsósi",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    566: {
        "stadur_nf": "Hofsós",
        "stadur_tgf": "Hofsósi",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    570: {
        "stadur_nf": "Fljót",
        "stadur_tgf": "Fljótum",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    580: {
        "stadur_nf": "Siglufjörður",
        "stadur_tgf": "Siglufirði",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    581: {
        "stadur_nf": "Siglufjörður",
        "stadur_tgf": "Siglufirði",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    600: {
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    601: {
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    602: {
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Pósthólf",
    },
    603: {
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    604: {
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    605: {
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    606: {
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    607: {
        "stadur_nf": "Akureyri",
        "stadur_tgf": "Akureyri",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    610: {
        "stadur_nf": "Grenivík",
        "stadur_tgf": "Grenivík",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    611: {
        "stadur_nf": "Grímsey",
        "stadur_tgf": "Grímsey",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    616: {
        "stadur_nf": "Grenivík",
        "stadur_tgf": "Grenivík",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    620: {
        "stadur_nf": "Dalvík",
        "stadur_tgf": "Dalvík",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    621: {
        "stadur_nf": "Dalvík",
        "stadur_tgf": "Dalvík",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    625: {
        "stadur_nf": "Ólafsfjörður",
        "stadur_tgf": "Ólafsfirði",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    626: {
        "stadur_nf": "Ólafsfjörður",
        "stadur_tgf": "Ólafsfirði",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    630: {
        "stadur_nf": "Hrísey",
        "stadur_tgf": "Hrísey",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    640: {
        "stadur_nf": "Húsavík",
        "stadur_tgf": "Húsavík",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    641: {
        "stadur_nf": "Húsavík",
        "stadur_tgf": "Húsavík",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    645: {
        "stadur_nf": "Fosshóll",
        "stadur_tgf": "Fosshóli",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    650: {
        "stadur_nf": "Laugar",
        "stadur_tgf": "Laugum",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    660: {
        "stadur_nf": "Mývatn",
        "stadur_tgf": "Mývatni",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    670: {
        "stadur_nf": "Kópasker",
        "stadur_tgf": "Kópaskeri",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    671: {
        "stadur_nf": "Kópasker",
        "stadur_tgf": "Kópaskeri",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    675: {
        "stadur_nf": "Raufarhöfn",
        "stadur_tgf": "Raufarhöfn",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    676: {
        "stadur_nf": "Raufarhöfn",
        "stadur_tgf": "Raufarhöfn",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    680: {
        "stadur_nf": "Þórshöfn",
        "stadur_tgf": "Þórshöfn",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    681: {
        "stadur_nf": "Þórshöfn",
        "stadur_tgf": "Þórshöfn",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    685: {
        "stadur_nf": "Bakkafjörður",
        "stadur_tgf": "Bakkafirði",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    686: {
        "stadur_nf": "Bakkafjörður",
        "stadur_tgf": "Bakkafirði",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    690: {
        "stadur_nf": "Vopnafjörður",
        "stadur_tgf": "Vopnafirði",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Stærra dreifbýli",
    },
    691: {
        "stadur_nf": "Vopnafjörður",
        "stadur_tgf": "Vopnafirði",
        "svaedi_nf": "Norðurland",
        "svaedi_tgf": "Norðurlandi",
        "tegund": "Dreifbýli",
    },
    700: {
        "stadur_nf": "Egilsstaðir",
        "stadur_tgf": "Egilsstöðum",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    701: {
        "stadur_nf": "Egilsstaðir",
        "stadur_tgf": "Egilsstöðum",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    710: {
        "stadur_nf": "Seyðisfjörður",
        "stadur_tgf": "Seyðisfirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    711: {
        "stadur_nf": "Seyðisfjörður",
        "stadur_tgf": "Seyðisfirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    715: {
        "stadur_nf": "Mjóifjörður",
        "stadur_tgf": "Mjóafirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    720: {
        "stadur_nf": "Borgarfjörður eystra",
        "stadur_tgf": "Borgarfirði eystra",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    721: {
        "stadur_nf": "Borgarfjörður eystra",
        "stadur_tgf": "Borgarfirði eystra",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    730: {
        "stadur_nf": "Reyðarfjörður",
        "stadur_tgf": "Reyðarfirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    731: {
        "stadur_nf": "Reyðarfjörður",
        "stadur_tgf": "Reyðarfirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    735: {
        "stadur_nf": "Eskifjörður",
        "stadur_tgf": "Eskifirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    736: {
        "stadur_nf": "Eskifjörður",
        "stadur_tgf": "Eskifirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    740: {
        "stadur_nf": "Neskaupstaður",
        "stadur_tgf": "Neskaupstað",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    741: {
        "stadur_nf": "Neskaupstaður",
        "stadur_tgf": "Neskaupstað",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    750: {
        "stadur_nf": "Fáskrúðsfjörður",
        "stadur_tgf": "Fáskrúðsfirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    751: {
        "stadur_nf": "Fáskrúðsfjörður",
        "stadur_tgf": "Fáskrúðsfirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    755: {
        "stadur_nf": "Stöðvarfjörður",
        "stadur_tgf": "Stöðvarfirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    756: {
        "stadur_nf": "Stöðvarfjörður",
        "stadur_tgf": "Stöðvarfirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    760: {
        "stadur_nf": "Breiðdalsvík",
        "stadur_tgf": "Breiðdalsvík",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    761: {
        "stadur_nf": "Breiðdalsvík",
        "stadur_tgf": "Breiðdalsvík",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    765: {
        "stadur_nf": "Djúpivogur",
        "stadur_tgf": "Djúpavogi",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    766: {
        "stadur_nf": "Djúpivogur",
        "stadur_tgf": "Djúpavogi",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    780: {
        "stadur_nf": "Höfn í Hornafirði",
        "stadur_tgf": "Höfn í Hornafirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    781: {
        "stadur_nf": "Höfn í Hornafirði",
        "stadur_tgf": "Höfn í Hornafirði",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Dreifbýli",
    },
    785: {
        "stadur_nf": "Öræfi",
        "stadur_tgf": "Öræfum",
        "svaedi_nf": "Austurland",
        "svaedi_tgf": "Austurlandi",
        "tegund": "Stærra dreifbýli",
    },
    800: {
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    801: {
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    802: {
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Pósthólf",
    },
    803: {
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    804: {
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    805: {
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    806: {
        "stadur_nf": "Selfoss",
        "stadur_tgf": "Selfossi",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    810: {
        "stadur_nf": "Hveragerði",
        "stadur_tgf": "Hveragerði",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    815: {
        "stadur_nf": "Þorlákshöfn",
        "stadur_tgf": "Þorlákshöfn",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    816: {
        "stadur_nf": "Ölfus",
        "stadur_tgf": "Ölfusi",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    820: {
        "stadur_nf": "Eyrarbakki",
        "stadur_tgf": "Eyrarbakka",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    825: {
        "stadur_nf": "Stokkseyri",
        "stadur_tgf": "Stokkseyri",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    840: {
        "stadur_nf": "Laugarvatn",
        "stadur_tgf": "Laugarvatni",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    845: {
        "stadur_nf": "Flúðir",
        "stadur_tgf": "Flúðum",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    846: {
        "stadur_nf": "Flúðir",
        "stadur_tgf": "Flúðum",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    850: {
        "stadur_nf": "Hella",
        "stadur_tgf": "Hellu",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    851: {
        "stadur_nf": "Hella",
        "stadur_tgf": "Hellu",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    860: {
        "stadur_nf": "Hvolsvöllur",
        "stadur_tgf": "Hvolsvelli",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    861: {
        "stadur_nf": "Hvolsvöllur",
        "stadur_tgf": "Hvolsvelli",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    870: {
        "stadur_nf": "Vík",
        "stadur_tgf": "Vík",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    871: {
        "stadur_nf": "Vík",
        "stadur_tgf": "Vík",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    880: {
        "stadur_nf": "Kirkjubæjarklaustur",
        "stadur_tgf": "Kirkjubæjarklaustri",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    881: {
        "stadur_nf": "Kirkjubæjarklaustur",
        "stadur_tgf": "Kirkjubæjarklaustri",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Dreifbýli",
    },
    900: {
        "stadur_nf": "Vestmannaeyjar",
        "stadur_tgf": "Vestmannaeyjum",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Stærra dreifbýli",
    },
    902: {
        "stadur_nf": "Vestmannaeyjar",
        "stadur_tgf": "Vestmannaeyjum",
        "svaedi_nf": "Suðurland og Reykjanes",
        "svaedi_tgf": "Suðurlandi og Reykjanesi",
        "tegund": "Pósthólf",
    },
}


# Pre-calculate reverse mappings for faster lookups
_PLACENAME_TO_POSTCODES: dict[str, list[int]] = defaultdict(list)
_REGION_TO_POSTCODES: dict[str, list[int]] = defaultdict(list)

for code, data in POSTCODES.items():
    # Placenames (nominative and dative cases)
    _PLACENAME_TO_POSTCODES[data["stadur_nf"].lower()].append(code)
    _PLACENAME_TO_POSTCODES[data["stadur_tgf"].lower()].append(code)

    # Regions (nominative and dative cases)
    _REGION_TO_POSTCODES[data["svaedi_nf"].lower()].append(code)
    _REGION_TO_POSTCODES[data["svaedi_tgf"].lower()].append(code)


def postcode_lookup(postcode: Union[int, str]) -> Optional[dict[str, str]]:
    """Return postcode info dictionary given a postcode.
    Accepts either numeric or string argument."""
    return POSTCODES.get(int(postcode))


def postcodes_for_region(region_name: str, partial: bool = False) -> list[int]:
    """Return postcodes matching a full or partial region name,
    e.g. "Norðurland", "Höfuðborgarsvæðið"."""
    if not partial:
        return sorted(_REGION_TO_POSTCODES.get(region_name.lower(), []))

    matches: list[int] = []
    search_str = region_name.lower()
    for name, codes in _REGION_TO_POSTCODES.items():
        if name.startswith(search_str):
            matches.extend(codes)
    return sorted(set(matches))


def region_for_postcode(postcode: Union[int, str]) -> Optional[str]:
    """Return the region name for a given postcode."""
    code = int(postcode)
    if code in POSTCODES:
        return POSTCODES[code]["svaedi_nf"]
    return None


def postcodes_for_placename(placename: str, partial: bool = False) -> list[int]:
    """Returns postcodes matching a full or partial placename,
    e.g. "Reykjavík", "Dalvík"."""
    if not partial:
        return sorted(_PLACENAME_TO_POSTCODES.get(placename.lower(), []))

    matches: list[int] = []
    search_str = placename.lower()
    for name, codes in _PLACENAME_TO_POSTCODES.items():
        if name.startswith(search_str):
            matches.extend(codes)
    return sorted(set(matches))
