"""Initial migration

Revision ID: f6f1f2437513
Revises:
Create Date: 2024-12-21 17:33:27.187221

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "f6f1f2437513"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "token_usage",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("execution_id", sa.String(), nullable=False),
        sa.Column("provider", sa.String(), nullable=False),
        sa.Column("model", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.Column("prompt_tokens", sa.Integer(), nullable=False),
        sa.Column("completion_tokens", sa.Integer(), nullable=False),
        sa.Column("total_tokens", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index("idx_created_at", "token_usage", ["created_at"], unique=False)
    op.create_index("idx_execution_id", "token_usage", ["execution_id"], unique=False)
    op.create_index("idx_model", "token_usage", ["model"], unique=False)
    op.create_index("idx_provider", "token_usage", ["provider"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("idx_provider", table_name="token_usage")
    op.drop_index("idx_model", table_name="token_usage")
    op.drop_index("idx_execution_id", table_name="token_usage")
    op.drop_index("idx_created_at", table_name="token_usage")
    op.drop_table("token_usage")
    # ### end Alembic commands ###
