from typing import Optional


class JsonCorrectnessTemplate:
    @staticmethod
    def generate_reason(
        actual_output: str, expected_schema: str, is_valid_json: bool
    ):
        return f"""Based on the given generated json, generated by an LLM, and a boolean stating whether it is a valid JSON based on the expected json schema, give a reason why it is OR is not a valid Json.

** 
IMPORTANT: Please make sure to only return in JSON format, with the 'reason' key providing the reason.
Example JSON:
{{
    "reason": "The generated Json is <is_valid_json> because <your_reason>."
}}

If the json is not a valid one, your reason MUST compare `Expected Json Schema` and `Generated Json` in your reason. Keep it SHORT and CONCISE while being very FACTUAL and ACTIONABLE.
**

Generated Json:
{actual_output}

Expected Json Schema:
{expected_schema}

Is Valid Json?
{is_valid_json}

JSON:
"""
