from typing import List
from enum import Enum
from abc import ABC


class BaseVulnerability(ABC):
    def __init__(self, types: List[Enum]):
        """
        Initialize a Vulnerability with a list of specific types.
        :param types: A list of Enum types representing vulnerabilities.
        """
        self.types = types

    def get_types(self) -> List[Enum]:
        """
        Get the list of Enum types.
        :return: List of Enum types.
        """
        return self.types

    def get_values(self) -> List[str]:
        """
        Get the list of values for the Enum types.
        :return: List of string values from the Enum types.
        """
        return [t.value for t in self.types]

    def get_name(self) -> str:
        return self.__class__.__name__

    def __repr__(self):
        """
        Represent the class by listing the Enum types.
        :return: String representation of the Vulnerability class.
        """
        return f"{self.__class__.__name__} (types={self.types})"
