from typing import List

from deepeval.vulnerability import BaseVulnerability
from deepeval.vulnerability.intellectual_property import (
    IntellectualPropertyType,
)


class IntellectualProperty(BaseVulnerability):
    def __init__(self, types: List[IntellectualPropertyType]):
        if not isinstance(types, list):
            raise TypeError(
                "The 'types' attribute must be a list of IntellectualPropertyType enums."
            )
        if not types:
            raise ValueError("The 'types' attribute cannot be an empty list.")
        if not all(isinstance(t, IntellectualPropertyType) for t in types):
            raise TypeError(
                "All items in the 'types' list must be of type IntellectualPropertyType."
            )
        super().__init__(types=types)

    def get_name(self) -> str:
        return "Intellectual Property"
