from typing import List

from deepeval.vulnerability import BaseVulnerability
from deepeval.vulnerability.unauthorized_access import UnauthorizedAccessType


class UnauthorizedAccess(BaseVulnerability):
    def __init__(self, types: List[UnauthorizedAccessType]):
        if not isinstance(types, list):
            raise TypeError(
                "The 'types' attribute must be a list of UnauthorizedAccessType enums."
            )
        if not types:
            raise ValueError("The 'types' attribute cannot be an empty list.")
        if not all(isinstance(t, UnauthorizedAccessType) for t in types):
            raise TypeError(
                "All items in the 'types' list must be of type UnauthorizedAccessType."
            )
        super().__init__(types=types)

    def get_name(self) -> str:
        return "Unauthorized Access"
