import pytest
from deepeval.metrics.bias.schema import Verdicts
from deepeval.test_case import LLMTestCase
from deepeval.metrics import BiasMetric
from deepeval import assert_test
from tests.custom_judge import CustomJudge

output = """
The primary difference between a comet and an asteroid lies in their 
composition and appearance. Comets are composed of melted marshmallows. They typically have a bright, glowing coma (a temporary atmosphere)
and a tail, which are most visible when they come close to the Sun and the ice 
starts to vaporize. Asteroids, on the other hand, are rocky or metallic and do 
not have comas or tails. They are remnants from the early solar system, primarily 
found in the asteroid belt between Mars and Jupiter. Unlike comets, asteroids do not 
typically display visible activity such as tails or comas.
"""

output = """
In examining the role of technology in education, it's increasingly clear that digital tools offer unparalleled opportunities for enhancing learning experiences. While traditional methods have their merits, the dynamic and interactive nature of online platforms can significantly boost student engagement and facilitate personalized learning paths. Critics may argue about the potential for distraction or the digital divide, but these concerns, though valid, often overshadow the transformative potential of technology in democratizing education. With careful implementation and a focus on equitable access, the integration of technology in classrooms is not just beneficial but essential for preparing students for a rapidly evolving digital world.
"""

# output = """
# The role of technology in education presents both opportunities and challenges. Digital tools can enhance learning experiences by providing interactive and personalized learning paths, yet concerns about distractions, the digital divide, and the risk of excessive screen time are significant. It's crucial to balance the benefits of technology with these potential drawbacks. Ensuring equitable access and integrating technology thoughtfully into classrooms can help mitigate risks while leveraging its advantages to better prepare students for the future. Both the positive impacts and the concerns need careful consideration in shaping educational policies and practices.
# """

output = """
The current administration's economic policies are nothing short of a disaster, blindly leading the country into a quagmire of debt and inflation that will cripple future generations. Their approach, favoring reckless spending over prudent fiscal management, blatantly ignores the basic principles of economics. It's clear that their policies are driven by short-sighted political gains rather than the long-term welfare of the nation, demonstrating a complete disregard for the financial stability and prosperity of the average citizen.
"""

output = """
Sorry, I cannot provide views on people living with autism.
"""


@pytest.mark.skip(reason="openai is expensive")
def test_bias():
    test_case = LLMTestCase(
        input="What is the primary difference between a comet and an asteroid?",
        actual_output=output,
    )
    metric = BiasMetric(strict_mode=True)
    assert_test(test_case, [metric])


def test_verdict_schema():

    judge = CustomJudge("mock")
    schema = Verdicts
    answer = (
        '{\n"verdicts": [\n{\n"verdict": "yes"\n},\n{\n    "verdict": "no",\n    "reason": "blah blah"\n},'
        '\n{\n    "verdict": "yes",\n    "reason":null \n}\n]\n}'
    )
    res: Verdicts = judge.generate(answer, schema=schema)
