from deepeval.red_teaming.types import Vulnerability
from deepeval.vulnerability.bias import BiasType
from deepeval.vulnerability.toxicity import ToxicityType
from deepeval.vulnerability.misinformation import MisinformationType
from deepeval.vulnerability.illegal_activity import IllegalActivityType
from deepeval.vulnerability.prompt_leakage import PromptLeakageType
from deepeval.vulnerability.pii_leakage import PIILeakageType
from deepeval.vulnerability.unauthorized_access import UnauthorizedAccessType
from deepeval.vulnerability.excessive_agency import ExcessiveAgencyType
from deepeval.vulnerability.robustness import RobustnessType
from deepeval.vulnerability.intellectual_property import (
    IntellectualPropertyType,
)
from deepeval.vulnerability.competition import CompetitionType
from deepeval.vulnerability.graphic_content import GraphicContentType
from deepeval.vulnerability.personal_safety import PersonalSafetyType
from deepeval.vulnerability import (
    Bias,
    Toxicity,
    Misinformation,
    IllegalActivity,
    PromptLeakage,
    PIILeakage,
    UnauthorizedAccess,
    ExcessiveAgency,
    Robustness,
    IntellectualProperty,
    Competition,
    GraphicContent,
    PersonalSafety,
)

bias = Bias(types=[BiasType.GENDER])
toxicity = Toxicity(types=[ToxicityType.INSULTS])
misinformation = Misinformation(
    types=[MisinformationType.EXPERTISE_MISREPRESENTATION]
)
illegal_activity = IllegalActivity(
    types=[IllegalActivityType.CHILD_EXPLOITATION]
)
prompt_leakage = PromptLeakage(types=[PromptLeakageType.GUARDS])
pii_leakage = PIILeakage(types=[PIILeakageType.DATABASE_ACCESS])
unauthorized_access = UnauthorizedAccess(types=[UnauthorizedAccessType.BFLA])
excessive_agency = ExcessiveAgency(types=[ExcessiveAgencyType.AUTONOMY])
robustness = Robustness(types=[RobustnessType.HIJACKING])
intellectual_property = IntellectualProperty(
    types=[IntellectualPropertyType.COPYRIGHT_VIOLATIONS]
)
competition = Competition(types=[CompetitionType.COMPETITORS_MENTION])
graphic_content = GraphicContent(types=[GraphicContentType.GRAPHIC_CONTENT])
personal_safety = PersonalSafety(types=[PersonalSafetyType.BULLYING])
