from datetime import date
from datetime import timedelta as td

calculate_mean = lambda _l: sum(_l)/len(_l)

get_weekday_initial = lambda x: ['Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa', 'Su'][x]

make_line = lambda x: '|'.join([
  "",
  f" {x['d']:<10} ",
  f" {x['i']:<2} ",
  f" {x['f']:>9} ",
  f" {x['μ']:>4} " if isinstance(x['μ'], str) else f" {x['μ']:>4.1f} ",
  f" {x['n']:<14} ",
  ""
])

hbar = '|------------|----|-----------|------|----------------|'

def f(d_α, d_ω, frequencies={}, public_holidays=set()):
  h = make_line({
    'd': 'Date',
    'i': 'D',
    'f': 'Frequency',
    'μ': 'Mean',
    'n': 'Note'
  })

  y = '\n'.join([
    h,
    hbar
  ])

  d_i = d_α
  _l = []
  while d_i <= d_ω:
    weekday = get_weekday_initial(d_i.weekday())
    f = frequencies[d_i] if d_i in frequencies else 0
    _l.append(f)
    y+='\n'+make_line({
      'd': str(d_i),
      'i': weekday,
      'f': f,
      'μ': calculate_mean(_l),
      'n': ''
    })
    if weekday in ['Fr', 'Su']:
      y+='\n'
      y+=hbar
    
    d_i += td(days=1)
  return y

def t():
  z = f(
    d_α=date(2022,1,6),
    d_ω=date(2022,1,24),
    frequencies={
      date(2022,1,6): 15,
      date(2022,1,7): 2,
      date(2022,1,10): 5,
      date(2022,1,11): 6,
      date(2022,1,12): 8,
      date(2022,1,24): 1,
    },
    public_holidays=set([date(2022,1,26)])
  )
  y = '\n'.join([
    "| Date       | D  | Frequency | Mean | Note           |",
    "|------------|----|-----------|------|----------------|",
    "| 2022-01-06 | Th |        15 | 15.0 |                |",
    "| 2022-01-07 | Fr |         2 |  8.5 |                |",
    "|------------|----|-----------|------|----------------|",
    "| 2022-01-08 | Sa |         0 |  5.7 |                |",
    "| 2022-01-09 | Su |         0 |  4.2 |                |",
    "|------------|----|-----------|------|----------------|",
    "| 2022-01-10 | Mo |         5 |  4.4 |                |",
    "| 2022-01-11 | Tu |         6 |  4.7 |                |",
    "| 2022-01-12 | We |         8 |  5.1 |                |",
    "| 2022-01-13 | Th |         0 |  4.5 |                |",
    "| 2022-01-14 | Fr |         0 |  4.0 |                |",
    "|------------|----|-----------|------|----------------|",
    "| 2022-01-15 | Sa |         0 |  3.6 |                |",
    "| 2022-01-16 | Su |         0 |  3.3 |                |",
    "|------------|----|-----------|------|----------------|",
    "| 2022-01-17 | Mo |         0 |  3.0 |                |",
    "| 2022-01-18 | Tu |         0 |  2.8 |                |",
    "| 2022-01-19 | We |         0 |  2.6 |                |",
    "| 2022-01-20 | Th |         0 |  2.4 |                |",
    "| 2022-01-21 | Fr |         0 |  2.2 |                |",
    "|------------|----|-----------|------|----------------|",
    "| 2022-01-22 | Sa |         0 |  2.1 |                |",
    "| 2022-01-23 | Su |         0 |  2.0 |                |",
    "|------------|----|-----------|------|----------------|",
    "| 2022-01-24 | Mo |         1 |  1.9 |                |",
  ])
  return y == z

z = f(
  d_α=date(2022,1,6),
  d_ω=date(2022,2,28),
  frequencies={
    date(2022,1,6): 15,
    date(2022,1,7): 2,
    date(2022,1,10): 5,
    date(2022,1,11): 6,
    date(2022,1,12): 8,
    date(2022,1,24): 1,
    date(2022,1,25): 1,
    date(2022,1,27): 5,
    date(2022,1,28): 5,
    date(2022,1,31): 2,
  },
  public_holidays=set([
    date(2022,1,26)
  ])
)
