# Dedal library - Wrapper over Spack for building multiple target
# environments: ESD, Virtual Boxes, HPC compatible kernels, etc.

#  (c) Copyright 2025 Dedal developers

#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at

#      http://www.apache.org/licenses/LICENSE-2.0

#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os
from pathlib import Path


class SpackDescriptor:
    """"
    Provides details about the spack environment
    """

    def __init__(self, name: str, path: Path = Path(os.getcwd()).resolve(), git_path: str = None, git_branch: str = ''):
        self.name = name
        self.path = path.resolve() if isinstance(path, Path) else Path(path).resolve()
        self.git_path = git_path
        self.git_branch = git_branch
