import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Base64-url-safe-encoded config data.
     *
     * @stability stable
     */
    readonly data: string;
    /**
     * User-defined name of the config.
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export declare class Config extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ConfigConfig);
    private _data;
    /**
     * @stability stable
     */
    get data(): string;
    /**
     * @stability stable
     */
    set data(value: string);
    /**
     * @stability stable
     */
    get dataInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
