import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DockerProviderConfig {
    /**
     * PEM-encoded content of Docker host CA certificate.
     *
     * @stability stable
     */
    readonly caMaterial?: string;
    /**
     * PEM-encoded content of Docker client certificate.
     *
     * @stability stable
     */
    readonly certMaterial?: string;
    /**
     * Path to directory with Docker TLS config.
     *
     * @stability stable
     */
    readonly certPath?: string;
    /**
     * The Docker daemon address.
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * PEM-encoded content of Docker client private key.
     *
     * @stability stable
     */
    readonly keyMaterial?: string;
    /**
     * Alias name.
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * registry_auth block.
     *
     * @stability stable
     */
    readonly registryAuth?: DockerProviderRegistryAuth[];
}
/**
 * @stability stable
 */
export interface DockerProviderRegistryAuth {
    /**
     * Address of the registry.
     *
     * @stability stable
     */
    readonly address: string;
    /**
     * Path to docker json file for registry auth.
     *
     * @stability stable
     */
    readonly configFile?: string;
    /**
     * Plain content of the docker json file for registry auth.
     *
     * @stability stable
     */
    readonly configFileContent?: string;
    /**
     * Password for the registry.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Username for the registry.
     *
     * @stability stable
     */
    readonly username?: string;
}
/**
 * @stability stable
 */
export declare class DockerProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DockerProviderConfig);
    private _caMaterial?;
    /**
     * @stability stable
     */
    get caMaterial(): string | undefined;
    /**
     * @stability stable
     */
    set caMaterial(value: string | undefined);
    /**
     * @stability stable
     */
    resetCaMaterial(): void;
    /**
     * @stability stable
     */
    get caMaterialInput(): string | undefined;
    private _certMaterial?;
    /**
     * @stability stable
     */
    get certMaterial(): string | undefined;
    /**
     * @stability stable
     */
    set certMaterial(value: string | undefined);
    /**
     * @stability stable
     */
    resetCertMaterial(): void;
    /**
     * @stability stable
     */
    get certMaterialInput(): string | undefined;
    private _certPath?;
    /**
     * @stability stable
     */
    get certPath(): string | undefined;
    /**
     * @stability stable
     */
    set certPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetCertPath(): void;
    /**
     * @stability stable
     */
    get certPathInput(): string | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): string | undefined;
    /**
     * @stability stable
     */
    set host(value: string | undefined);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _keyMaterial?;
    /**
     * @stability stable
     */
    get keyMaterial(): string | undefined;
    /**
     * @stability stable
     */
    set keyMaterial(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyMaterial(): void;
    /**
     * @stability stable
     */
    get keyMaterialInput(): string | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    private _registryAuth?;
    /**
     * @stability stable
     */
    get registryAuth(): DockerProviderRegistryAuth[] | undefined;
    /**
     * @stability stable
     */
    set registryAuth(value: DockerProviderRegistryAuth[] | undefined);
    /**
     * @stability stable
     */
    resetRegistryAuth(): void;
    /**
     * @stability stable
     */
    get registryAuthInput(): DockerProviderRegistryAuth[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
