"""Stub file for reflex_enterprise/components/ag_grid/aggrid.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from dataclasses import dataclass
from typing import Any, Callable, Literal, Mapping, Optional, Sequence, TypedDict

import reflex as rx
from reflex.components.core.breakpoints import Breakpoints
from reflex.event import EventSpec, EventType, PointerEventInfo
from reflex.vars.base import Var
from reflex.vars.function import ArgsFunctionOperation

from reflex_enterprise.components.component import ComponentEnterprise
from reflex_enterprise.vars import JSAPIVar, PassthroughAPI

from .datasource import Datasource, SSRMDatasource
from .resource import (
    AGAggregations,
    AGEditors,
    AGFilters,
    AGRenderers,
    AGStatusPanels,
    SideBarDef,
    StatusPanelDef,
    value_func_factory,
)
from .resources import ColumnDef, ColumnGroupDef
from .resources.params import (
    DetailCellRendererParams,
    FullWidthCellRendererParams,
    LoadingCellRendererParams,
)

class CellEventSpec(TypedDict):
    type: str
    data: Mapping[str, Any]
    value: Any
    colDef: Mapping[str, Any]
    rowIndex: int
    rowPinned: Literal["top", "bottom"] | None

class RowEventSpec(TypedDict):
    type: str
    data: Mapping[str, Any]
    rowIndex: int
    rowPinned: Literal["top", "bottom"] | None

class Column(TypedDict):
    colId: str

class ColumnEventSpec(TypedDict):
    type: str
    columnId: str
    column: dict

class RowSelectionEventSpec(TypedDict):
    type: str
    data: Mapping[str, Any]
    rowIndex: int

class CellValueChangedEventSpec(TypedDict):
    rowIndex: int
    field: str
    newValue: Any
    node_id: str
    colDef: dict
    node: dict

class SelectionChangeEventSpec(TypedDict):
    rows: list[dict]
    source: str
    type: str

class CellRange(TypedDict):
    type: str
    startRow: int
    endRow: int
    columns: list[str]

class CellSelectionChangeEventSpec(TypedDict):
    range: list[CellRange]
    started: bool
    finished: bool

_size_columns_to_fit = ArgsFunctionOperation.create(
    args_names=("event",),
    return_expr=Var("event.api.sizeColumnsToFit()"),
    _var_type=rx.EventChain,
)

class AgGridAPIVar(JSAPIVar): ...

@dataclass
class AgGridAPI(PassthroughAPI):
    ref: str

    @classmethod
    def create(cls, id: str) -> "AgGridAPI": ...
    def set_grid_option(self, key: str, value: Var) -> EventSpec: ...
    def select_rows_by_key(
        self, keys: list[str], node_path_key: str = "key"
    ) -> EventSpec: ...
    def select_all(self) -> EventSpec: ...
    def deselect_all(self) -> EventSpec: ...
    def log_nodes(self, node_path_key: str | None = None) -> EventSpec: ...

class AccessoriesOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        status_bar: Mapping[str, Any]
        | StatusPanelDef
        | Var[Mapping[str, Any] | StatusPanelDef]
        | None = None,
        side_bar: Sequence[str]
        | SideBarDef
        | Var[Sequence[str] | SideBarDef | bool | str]
        | bool
        | str
        | None = None,
        get_context_menu_items: Callable | Var[Callable] | None = None,
        suppress_context_menu: Var[bool] | bool | None = None,
        prevent_default_on_context_menu: Var[bool] | bool | None = None,
        allow_context_menu_with_control_key: Var[bool] | bool | None = None,
        column_menu: Literal["legacy", "new"]
        | Var[Literal["legacy", "new"]]
        | None = None,
        suppress_menu_hide: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "AccessoriesOptions":
        """Create the Reflex Enterprise component."""
        ...

class ClipboardOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        copy_headers_to_clipboard: Var[bool] | bool | None = None,
        copy_group_headers_to_clipboard: Var[bool] | bool | None = None,
        clipboard_delimiter: Var[str] | str | None = None,
        suppress_cut_to_clipboard: Var[bool] | bool | None = None,
        suppress_last_empty_line_on_paste: Var[bool] | bool | None = None,
        suppress_clipboard_paste: Var[bool] | bool | None = None,
        suppress_clipboard_api: Var[bool] | bool | None = None,
        process_cell_for_clipboard: Callable | Var[Callable] | None = None,
        process_header_for_clipboard: Callable | Var[Callable] | None = None,
        process_group_header_for_clipboard: Callable | Var[Callable] | None = None,
        process_cell_from_clipboard: Callable | Var[Callable] | None = None,
        send_to_clipboard: Callable | Var[Callable] | None = None,
        process_data_from_clipboard: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ClipboardOptions":
        """Create the Reflex Enterprise component."""
        ...

class ColumnDefinitionsOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        column_defs: Sequence[ColumnDef | ColumnGroupDef]
        | Sequence[Mapping[str, Any]]
        | Var[Sequence[ColumnDef | ColumnGroupDef] | Sequence[Mapping[str, Any]]]
        | None = None,
        default_col_def: Mapping[str, Any]
        | Var[Mapping[str, Any] | None]
        | None = None,
        default_col_group_def: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        column_types: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        data_types_definitions: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        maintain_column_order: Var[bool] | bool | None = None,
        enable_strict_pivot_column_order: Var[bool] | bool | None = None,
        suppress_field_dot_notation: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ColumnDefinitionsOptions":
        """Create the Reflex Enterprise component."""
        ...

class ColumnHeadersOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        header_height: Var[int] | int | None = None,
        group_header_height: Var[int] | int | None = None,
        floating_filters_height: Var[int] | int | None = None,
        pivot_header_height: Var[int] | int | None = None,
        pivot_group_header_height: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ColumnHeadersOptions":
        """Create the Reflex Enterprise component."""
        ...

class ColumnMovingOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        allow_drag_from_columns_tool_panel: Var[bool] | bool | None = None,
        suppress_movable_columns: Var[bool] | bool | None = None,
        suppress_move_when_column_dragging: Var[bool] | bool | None = None,
        suppress_column_move_animation: Var[bool] | bool | None = None,
        suppress_drag_leave_hides_columns: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ColumnMovingOptions":
        """Create the Reflex Enterprise component."""
        ...

class ColumnPinningOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        process_unpinned_columns: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ColumnPinningOptions":
        """Create the Reflex Enterprise component."""
        ...

class ColumnSizingOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        col_resize_default: Var[str] | str | None = None,
        auto_size_strategy: Var[dict] | dict | None = None,
        suppress_auto_size: Var[bool] | bool | None = None,
        auto_size_padding: Var[int] | int | None = None,
        skip_header_on_auto_size: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ColumnSizingOptions":
        """Create the Reflex Enterprise component."""
        ...

class ComponentsOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        components: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ComponentsOptions":
        """Create the Reflex Enterprise component."""
        ...

class EditingOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        edit_type: Var[str] | str | None = None,
        single_click_edit: Var[bool] | bool | None = None,
        suppress_click_edit: Var[bool] | bool | None = None,
        stop_edit_when_cell_loses_focus: Var[bool] | bool | None = None,
        enter_navigate_vertically: Var[bool] | bool | None = None,
        enter_navigate_vertically_after_edit: Var[bool] | bool | None = None,
        enable_cell_editing_on_backspace: Var[bool] | bool | None = None,
        undo_redo_cell_editing: Var[bool] | bool | None = None,
        undo_redo_cell_editing_limit: Var[int] | int | None = None,
        read_only_edit: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "EditingOptions":
        """Create the Reflex Enterprise component."""
        ...

class ExportOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        default_csv_export_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_csv_export: Var[bool] | bool | None = None,
        default_excel_export_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_excel_export: Var[bool] | bool | None = None,
        excel_styles: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ExportOptions":
        """Create the Reflex Enterprise component."""
        ...

class FilteringOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        quick_filter_text: Var[str] | str | None = None,
        cache_quick_filter: Var[bool] | bool | None = None,
        include_hidden_columns_in_quick_filter: Var[bool] | bool | None = None,
        quick_filter_parser: Callable | Var[Callable] | None = None,
        quick_filter_matcher: Callable | Var[Callable] | None = None,
        apply_quick_filter_before_pivot_or_agg: Var[bool] | bool | None = None,
        is_external_filter_present: Callable | Var[Callable] | None = None,
        does_external_filter_pass: Callable | Var[Callable] | None = None,
        exclude_children_when_tree_data_filtering: Var[bool] | bool | None = None,
        suppress_set_filter_by_default: Var[bool] | bool | None = None,
        enable_advanced_filter: Var[bool] | bool | None = None,
        include_hidden_columns_in_advanced_filter: Var[bool] | bool | None = None,
        advanced_filter_parent: Any | Var[Any] | None = None,
        advanced_filter_built_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        always_pass_filter: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "FilteringOptions":
        """Create the Reflex Enterprise component."""
        ...

class IntegratedChartsOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    def add_imports(self): ...
    def add_custom_code(self) -> list[str]: ...
    @classmethod
    def create(
        cls,
        *children,
        enable_charts: Var[bool] | bool | None = None,
        get_chart_toolbar_items: Callable | Var[Callable] | None = None,
        create_chart_container: Callable | Var[Callable] | None = None,
        chart_themes: Sequence[str] | Var[Sequence[str]] | None = None,
        custom_chart_themes: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_theme_overrides: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_tool_panel_defs: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_menu_items: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "IntegratedChartsOptions":
        """Create the Reflex Enterprise component."""
        ...

class KeyboardNavigationOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        focus_grid_inner_elements: Callable | Var[Callable] | None = None,
        navigate_to_next_header: Callable | Var[Callable] | None = None,
        tab_to_next_header: Callable | Var[Callable] | None = None,
        navigate_to_next_cell: Callable | Var[Callable] | None = None,
        tab_to_next_cell: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "KeyboardNavigationOptions":
        """Create the Reflex Enterprise component."""
        ...

class LoadingCellOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        loading_cell_renderer: Any | Var[Any] | None = None,
        loading_cell_renderer_params: LoadingCellRendererParams
        | Mapping[str, Any]
        | Var[LoadingCellRendererParams | Mapping[str, Any]]
        | None = None,
        loading_cell_renderer_selector: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "LoadingCellOptions":
        """Create the Reflex Enterprise component."""
        ...

class LocalizationOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        locale_text: Mapping[str, str] | Var[Mapping[str, str]] | None = None,
        get_locale_text: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "LocalizationOptions":
        """Create the Reflex Enterprise component."""
        ...

class MasterDetailOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        master_detail: Var[bool] | bool | None = None,
        is_row_master: Callable | Var[Callable] | None = None,
        detail_cell_renderer: Any | Var[Any] | None = None,
        detail_cell_renderer_params: Callable
        | DetailCellRendererParams
        | Mapping[str, Any]
        | Var[Callable | DetailCellRendererParams | Mapping[str, Any]]
        | None = None,
        detail_row_height: Var[int] | int | None = None,
        detail_row_auto_height: Var[bool] | bool | None = None,
        embed_full_width_rows: Var[bool] | bool | None = None,
        keep_detail_rows: Var[bool] | bool | None = None,
        keep_detail_rows_count: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "MasterDetailOptions":
        """Create the Reflex Enterprise component."""
        ...

class MiscellaneousOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        initial_state: Any | Var[Any] | None = None,
        aligned_grids: Callable
        | Sequence[Any]
        | Var[Callable | Sequence[Any]]
        | None = None,
        context: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        tab_index: Var[int] | int | None = None,
        row_buffer: Var[int] | int | None = None,
        row_number: Mapping[str, Any]
        | Var[Mapping[str, Any] | bool]
        | bool
        | None = None,
        value_cache: Var[bool] | bool | None = None,
        value_cache_never_expire: Var[bool] | bool | None = None,
        enable_cell_expressions: Var[bool] | bool | None = None,
        get_document: Callable | Var[Callable] | None = None,
        suppress_touch: Var[bool] | bool | None = None,
        drag_and_drop_image_component: Any | Var[Any] | None = None,
        suppress_focus_after_refresh: Var[bool] | bool | None = None,
        suppress_change_detection: Var[bool] | bool | None = None,
        debug: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "MiscellaneousOptions":
        """Create the Reflex Enterprise component."""
        ...

class OverlayOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        loading: Var[bool] | bool | None = None,
        overlay_loading_template: Var[str] | str | None = None,
        loading_overlay_component: Any | Var[Any] | None = None,
        loading_overlay_component_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_no_rows_overlay: Var[bool] | bool | None = None,
        overlay_no_rows_template: Var[str] | str | None = None,
        no_rows_overlay_component: Any | Var[Any] | None = None,
        no_rows_overlay_component_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "OverlayOptions":
        """Create the Reflex Enterprise component."""
        ...

class PaginationOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        pagination: Var[bool] | bool | None = None,
        pagination_page_size: Var[int] | int | None = None,
        pagination_page_size_selector: Sequence[int]
        | Var[Sequence[int] | bool]
        | bool
        | None = None,
        pagination_number_formatter: Callable | Var[Callable] | None = None,
        pagination_auto_page_size: Var[bool] | bool | None = None,
        paginate_child_rows: Var[bool] | bool | None = None,
        suppress_pagination_panel: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "PaginationOptions":
        """Create the Reflex Enterprise component."""
        ...

class RenderingOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        animate_rows: Var[bool] | bool | None = None,
        cell_flash_duration: Var[int] | int | None = None,
        cell_fade_duration: Var[int] | int | None = None,
        allow_show_change_after_filter: Var[bool] | bool | None = None,
        dom_layout: Literal["autoHeight", "normal", "print"]
        | Var[Literal["autoHeight", "normal", "print"]]
        | None = None,
        ensure_dom_order: Var[bool] | bool | None = None,
        get_business_key_for_node: Callable | Var[Callable] | None = None,
        grid_id: Var[str] | str | None = None,
        process_row_post_create: Callable | Var[Callable] | None = None,
        enable_rtl: Var[bool] | bool | None = None,
        suppress_column_virtualisation: Var[bool] | bool | None = None,
        suppress_row_virtualisation: Var[bool] | bool | None = None,
        suppress_max_rendered_row_restrictions: Var[bool] | bool | None = None,
        enable_cell_span: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RenderingOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowAggregationOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        agg_funcs: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        group_total_row: Callable
        | Literal["bottom", "top"]
        | Var[Callable | Literal["bottom", "top"]]
        | None = None,
        grand_total_row: Literal["bottom", "top"]
        | Var[Literal["bottom", "top"]]
        | None = None,
        suppress_agg_func_in_header: Var[bool] | bool | None = None,
        aggregate_only_changed_columns: Var[bool] | bool | None = None,
        suppress_agg_filtered_only: Var[bool] | bool | None = None,
        group_agg_filtering: Var[bool] | bool | None = None,
        group_suppress_blank_header: Var[bool] | bool | None = None,
        suppress_sticky_total_row: Literal["grand", "group"]
        | Var[Literal["grand", "group"] | bool]
        | bool
        | None = None,
        always_aggregate_at_root_level: Var[bool] | bool | None = None,
        get_group_row_agg: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowAggregationOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowDragOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        row_drag_managed: Var[bool] | bool | None = None,
        row_drag_entire_row: Var[bool] | bool | None = None,
        row_drag_multi_row: Var[bool] | bool | None = None,
        suppress_row_drag: Var[bool] | bool | None = None,
        suppress_move_when_row_dragging: Var[bool] | bool | None = None,
        row_drag_text: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowDragOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowFullWidthOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        full_width_cell_renderer: Any | Var[Any] | None = None,
        full_width_cell_renderer_params: FullWidthCellRendererParams
        | Mapping[str, Any]
        | Var[FullWidthCellRendererParams | Mapping[str, Any]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowFullWidthOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowGroupingOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        group_display_type: Literal[
            "custom", "groupRows", "multipleColumns", "singleColumn"
        ]
        | Var[Literal["custom", "groupRows", "multipleColumns", "singleColumn"]]
        | None = None,
        auto_group_column_def: Any | Var[Any] | None = None,
        group_row_renderer: Any | Var[Any] | None = None,
        group_row_renderer_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        show_opened_group: Var[bool] | bool | None = None,
        group_hide_open_parents: Var[bool] | bool | None = None,
        group_hide_parent_of_single_child: Literal["leafGroupsOnly"]
        | Var[Literal["leafGroupsOnly"] | bool]
        | bool
        | None = None,
        initial_group_order_comparator: Callable | Var[Callable] | None = None,
        group_allow_unbalanced: Var[bool] | bool | None = None,
        group_maintain_order: Var[bool] | bool | None = None,
        group_default_expanded: Var[int] | int | None = None,
        is_group_open_by_default: Callable | Var[Callable] | None = None,
        suppress_group_stickiness: Var[bool] | bool | None = None,
        row_group_panel_show: Var[str] | str | None = None,
        row_group_panel_suppress_sort: Var[bool] | bool | None = None,
        group_lock_group_columns: Var[int] | int | None = None,
        suppress_drag_leave_hides_columns: Var[bool] | bool | None = None,
        suppress_group_changes_column_visibility: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowGroupingOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowPinningOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        pinned_row_top_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        pinned_row_bottom_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowPinningOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowPivotingOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        pivot_mode: Var[bool] | bool | None = None,
        pivot_panel_show: Var[str] | str | None = None,
        pivot_default_expanded: Var[int] | int | None = None,
        pivot_row_totals: Literal["after", "before"]
        | Var[Literal["after", "before"]]
        | None = None,
        pivot_suppress_auto_column: Var[bool] | bool | None = None,
        pivot_max_generated_columns: Var[int] | int | None = None,
        process_pivot_result_col_def: Callable | Var[Callable] | None = None,
        process_pivot_result_col_group_def: Callable | Var[Callable] | None = None,
        suppress_expandable_pivot_groups: Var[bool] | bool | None = None,
        functions_read_only: Var[bool] | bool | None = None,
        remove_pivot_header_row_when_single_value_column: Var[bool]
        | bool
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowPivotingOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowModelOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        row_model_type: Var[str] | str | None = None,
        get_row_id: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowModelOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowModelClientSideOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        row_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        reset_row_data_on_update: Var[bool] | bool | None = None,
        async_transaction_wait_millis: Var[int] | int | None = None,
        suppress_model_update_after_update_transaction: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowModelClientSideOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowModelInfiniteOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        datasource: Datasource | Var[Datasource] | None = None,
        cache_overflow_size: Var[int] | int | None = None,
        max_concurrent_datasource_requests: Var[int] | int | None = None,
        cache_block_size: Var[int] | int | None = None,
        max_blocks_in_cache: Var[int] | int | None = None,
        infinite_initial_row_count: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowModelInfiniteOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowModelServiceSideOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        server_side_datasource: SSRMDatasource | Var[SSRMDatasource] | None = None,
        block_load_debounce_millis: Var[int] | int | None = None,
        suppress_server_side_full_width_loading_row: Var[bool] | bool | None = None,
        purge_closed_row_nodes: Var[bool] | bool | None = None,
        server_side_pivot_result_field_separator: Var[str] | str | None = None,
        server_side_sort_all_levels: Var[bool] | bool | None = None,
        server_side_enable_client_side_sort: Var[bool] | bool | None = None,
        server_side_only_refresh_filtered_groups: Var[bool] | bool | None = None,
        server_side_initial_row_count: Var[int] | int | None = None,
        get_child_count: Callable | Var[Callable] | None = None,
        get_server_side_group_level_params: Callable | Var[Callable] | None = None,
        is_server_side_group_open_by_default: Callable | Var[Callable] | None = None,
        is_apply_server_side_transaction: Callable | Var[Callable] | None = None,
        is_server_side_group: Callable | Var[Callable] | None = None,
        get_server_side_group_key: Callable | Var[Callable] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowModelServiceSideOptions":
        """Create the Reflex Enterprise component."""
        ...

class RowModelViewportOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        viewport_datasource: Any | Var[Any] | None = None,
        viewport_row_model_page_size: Var[int] | int | None = None,
        viewport_row_model_buffer_size: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "RowModelViewportOptions":
        """Create the Reflex Enterprise component."""
        ...

class ScrollingOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        always_show_horizontal_scroll: Var[bool] | bool | None = None,
        always_show_vertical_scroll: Var[bool] | bool | None = None,
        debounce_vertical_scrollbar: Var[bool] | bool | None = None,
        suppress_horizontal_scroll: Var[bool] | bool | None = None,
        suppress_scroll_on_new_data: Var[bool] | bool | None = None,
        suppress_scroll_when_popup_are_open: Var[bool] | bool | None = None,
        suppress_animation_frame: Var[bool] | bool | None = None,
        suppress_middle_click_scroll: Var[bool] | bool | None = None,
        suppress_prevent_default_on_mouse_wheel: Var[bool] | bool | None = None,
        scrollbar_width: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ScrollingOptions":
        """Create the Reflex Enterprise component."""
        ...

class SelectionOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        cell_selection: Var[bool | dict] | bool | dict | None = None,
        row_selection: Var[dict | str] | dict | str | None = None,
        selection_column_def: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        suppress_cell_focus: Var[bool] | bool | None = None,
        suppress_header_focus: Var[bool] | bool | None = None,
        enable_cell_text_selection: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "SelectionOptions":
        """Create the Reflex Enterprise component."""
        ...

class SortingOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        accented_sort: Var[bool] | bool | None = None,
        suppress_multi_sort: Var[bool] | bool | None = None,
        always_multi_sort: Var[bool] | bool | None = None,
        multi_sort_key: Literal["ctrl", "shift"]
        | Var[Literal["ctrl", "shift"]]
        | None = None,
        suppress_maintain_unsorted_order: Var[bool] | bool | None = None,
        post_sort_rows: Callable | Var[Callable] | None = None,
        delta_sort: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "SortingOptions":
        """Create the Reflex Enterprise component."""
        ...

class StylingOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        icons: Mapping[str, str] | Var[Mapping[str, str]] | None = None,
        row_height: Var[int] | int | None = None,
        get_row_height: Callable | Var[Callable] | None = None,
        row_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        get_row_style: Callable | Var[Callable] | None = None,
        row_class: Sequence[str] | Var[Sequence[str] | str] | str | None = None,
        get_row_class: Callable | Var[Callable] | None = None,
        row_class_rules: Mapping[str, Callable]
        | Var[Mapping[str, Callable]]
        | None = None,
        suppress_row_hover_highlight: Var[bool] | bool | None = None,
        column_hover_highlight: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "StylingOptions":
        """Create the Reflex Enterprise component."""
        ...

class ThemeOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        theme: Literal["alpine", "balham", "material", "quartz"]
        | Var[Literal["alpine", "balham", "material", "quartz"]]
        | None = None,
        load_theme_google_fonts: Var[bool] | bool | None = None,
        theme_style_container: Any | Var[Any] | None = None,
        theme_css_layer: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ThemeOptions":
        """Create the Reflex Enterprise component."""
        ...

class TooltipOptions(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        enable_browser_tooltips: Var[bool] | bool | None = None,
        tooltip_show_delay: Var[int] | int | None = None,
        tooltip_hide_delay: Var[int] | int | None = None,
        tooltip_mouse_track: Var[bool] | bool | None = None,
        tooltip_show_mode: Literal["standard", "whenTruncated"]
        | Var[Literal["standard", "whenTruncated"]]
        | None = None,
        tooltip_trigger: Literal["focus", "hover"]
        | Var[Literal["focus", "hover"]]
        | None = None,
        tooltip_interactive: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "TooltipOptions":
        """Create the Reflex Enterprise component."""
        ...

class TreeDataOptions(ComponentEnterprise):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        tree_data: Var[bool] | bool | None = None,
        get_data_path: Callable | Var[Callable] | None = None,
        tree_data_children_field: Var[str] | str | None = None,
        auto_group_column_def: Any | Var[Any] | None = None,
        is_group_open_by_default: Callable | Var[Callable] | None = None,
        suppress_group_rows_sticky: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "TreeDataOptions":
        """Create the Reflex Enterprise component."""
        ...

class GridOptions(
    AccessoriesOptions,
    ClipboardOptions,
    ColumnDefinitionsOptions,
    ColumnHeadersOptions,
    ColumnMovingOptions,
    ColumnPinningOptions,
    ColumnSizingOptions,
    ComponentsOptions,
    EditingOptions,
    ExportOptions,
    FilteringOptions,
    IntegratedChartsOptions,
    KeyboardNavigationOptions,
    LoadingCellOptions,
    LocalizationOptions,
    MasterDetailOptions,
    MiscellaneousOptions,
    OverlayOptions,
    PaginationOptions,
    RenderingOptions,
    RowAggregationOptions,
    RowDragOptions,
    RowFullWidthOptions,
    RowGroupingOptions,
    RowPinningOptions,
    RowPivotingOptions,
    RowModelOptions,
    RowModelClientSideOptions,
    RowModelInfiniteOptions,
    RowModelServiceSideOptions,
    RowModelViewportOptions,
    ScrollingOptions,
    SelectionOptions,
    SortingOptions,
    StylingOptions,
    ThemeOptions,
    TooltipOptions,
    TreeDataOptions,
):
    @classmethod
    def get_modules(cls, props: dict[str, Any]) -> dict[str, set[str]]: ...
    @classmethod
    def create(
        cls,
        *children,
        status_bar: Mapping[str, Any]
        | StatusPanelDef
        | Var[Mapping[str, Any] | StatusPanelDef]
        | None = None,
        side_bar: Sequence[str]
        | SideBarDef
        | Var[Sequence[str] | SideBarDef | bool | str]
        | bool
        | str
        | None = None,
        get_context_menu_items: Callable | Var[Callable] | None = None,
        suppress_context_menu: Var[bool] | bool | None = None,
        prevent_default_on_context_menu: Var[bool] | bool | None = None,
        allow_context_menu_with_control_key: Var[bool] | bool | None = None,
        column_menu: Literal["legacy", "new"]
        | Var[Literal["legacy", "new"]]
        | None = None,
        suppress_menu_hide: Var[bool] | bool | None = None,
        copy_headers_to_clipboard: Var[bool] | bool | None = None,
        copy_group_headers_to_clipboard: Var[bool] | bool | None = None,
        clipboard_delimiter: Var[str] | str | None = None,
        suppress_cut_to_clipboard: Var[bool] | bool | None = None,
        suppress_last_empty_line_on_paste: Var[bool] | bool | None = None,
        suppress_clipboard_paste: Var[bool] | bool | None = None,
        suppress_clipboard_api: Var[bool] | bool | None = None,
        process_cell_for_clipboard: Callable | Var[Callable] | None = None,
        process_header_for_clipboard: Callable | Var[Callable] | None = None,
        process_group_header_for_clipboard: Callable | Var[Callable] | None = None,
        process_cell_from_clipboard: Callable | Var[Callable] | None = None,
        send_to_clipboard: Callable | Var[Callable] | None = None,
        process_data_from_clipboard: Callable | Var[Callable] | None = None,
        column_defs: Sequence[ColumnDef | ColumnGroupDef]
        | Sequence[Mapping[str, Any]]
        | Var[Sequence[ColumnDef | ColumnGroupDef] | Sequence[Mapping[str, Any]]]
        | None = None,
        default_col_def: Mapping[str, Any]
        | Var[Mapping[str, Any] | None]
        | None = None,
        default_col_group_def: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        column_types: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        data_types_definitions: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        maintain_column_order: Var[bool] | bool | None = None,
        enable_strict_pivot_column_order: Var[bool] | bool | None = None,
        suppress_field_dot_notation: Var[bool] | bool | None = None,
        header_height: Var[int] | int | None = None,
        group_header_height: Var[int] | int | None = None,
        floating_filters_height: Var[int] | int | None = None,
        pivot_header_height: Var[int] | int | None = None,
        pivot_group_header_height: Var[int] | int | None = None,
        allow_drag_from_columns_tool_panel: Var[bool] | bool | None = None,
        suppress_movable_columns: Var[bool] | bool | None = None,
        suppress_move_when_column_dragging: Var[bool] | bool | None = None,
        suppress_column_move_animation: Var[bool] | bool | None = None,
        suppress_drag_leave_hides_columns: Var[bool] | bool | None = None,
        process_unpinned_columns: Callable | Var[Callable] | None = None,
        col_resize_default: Var[str] | str | None = None,
        auto_size_strategy: Var[dict] | dict | None = None,
        suppress_auto_size: Var[bool] | bool | None = None,
        auto_size_padding: Var[int] | int | None = None,
        skip_header_on_auto_size: Var[bool] | bool | None = None,
        components: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        edit_type: Var[str] | str | None = None,
        single_click_edit: Var[bool] | bool | None = None,
        suppress_click_edit: Var[bool] | bool | None = None,
        stop_edit_when_cell_loses_focus: Var[bool] | bool | None = None,
        enter_navigate_vertically: Var[bool] | bool | None = None,
        enter_navigate_vertically_after_edit: Var[bool] | bool | None = None,
        enable_cell_editing_on_backspace: Var[bool] | bool | None = None,
        undo_redo_cell_editing: Var[bool] | bool | None = None,
        undo_redo_cell_editing_limit: Var[int] | int | None = None,
        read_only_edit: Var[bool] | bool | None = None,
        default_csv_export_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_csv_export: Var[bool] | bool | None = None,
        default_excel_export_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_excel_export: Var[bool] | bool | None = None,
        excel_styles: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        quick_filter_text: Var[str] | str | None = None,
        cache_quick_filter: Var[bool] | bool | None = None,
        include_hidden_columns_in_quick_filter: Var[bool] | bool | None = None,
        quick_filter_parser: Callable | Var[Callable] | None = None,
        quick_filter_matcher: Callable | Var[Callable] | None = None,
        apply_quick_filter_before_pivot_or_agg: Var[bool] | bool | None = None,
        is_external_filter_present: Callable | Var[Callable] | None = None,
        does_external_filter_pass: Callable | Var[Callable] | None = None,
        exclude_children_when_tree_data_filtering: Var[bool] | bool | None = None,
        suppress_set_filter_by_default: Var[bool] | bool | None = None,
        enable_advanced_filter: Var[bool] | bool | None = None,
        include_hidden_columns_in_advanced_filter: Var[bool] | bool | None = None,
        advanced_filter_parent: Any | Var[Any] | None = None,
        advanced_filter_built_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        always_pass_filter: Callable | Var[Callable] | None = None,
        enable_charts: Var[bool] | bool | None = None,
        get_chart_toolbar_items: Callable | Var[Callable] | None = None,
        create_chart_container: Callable | Var[Callable] | None = None,
        chart_themes: Sequence[str] | Var[Sequence[str]] | None = None,
        custom_chart_themes: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_theme_overrides: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_tool_panel_defs: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_menu_items: Callable | Var[Callable] | None = None,
        focus_grid_inner_elements: Callable | Var[Callable] | None = None,
        navigate_to_next_header: Callable | Var[Callable] | None = None,
        tab_to_next_header: Callable | Var[Callable] | None = None,
        navigate_to_next_cell: Callable | Var[Callable] | None = None,
        tab_to_next_cell: Callable | Var[Callable] | None = None,
        loading_cell_renderer: Any | Var[Any] | None = None,
        loading_cell_renderer_params: LoadingCellRendererParams
        | Mapping[str, Any]
        | Var[LoadingCellRendererParams | Mapping[str, Any]]
        | None = None,
        loading_cell_renderer_selector: Callable | Var[Callable] | None = None,
        locale_text: Mapping[str, str] | Var[Mapping[str, str]] | None = None,
        get_locale_text: Callable | Var[Callable] | None = None,
        master_detail: Var[bool] | bool | None = None,
        is_row_master: Callable | Var[Callable] | None = None,
        detail_cell_renderer: Any | Var[Any] | None = None,
        detail_cell_renderer_params: Callable
        | DetailCellRendererParams
        | Mapping[str, Any]
        | Var[Callable | DetailCellRendererParams | Mapping[str, Any]]
        | None = None,
        detail_row_height: Var[int] | int | None = None,
        detail_row_auto_height: Var[bool] | bool | None = None,
        embed_full_width_rows: Var[bool] | bool | None = None,
        keep_detail_rows: Var[bool] | bool | None = None,
        keep_detail_rows_count: Var[int] | int | None = None,
        initial_state: Any | Var[Any] | None = None,
        aligned_grids: Callable
        | Sequence[Any]
        | Var[Callable | Sequence[Any]]
        | None = None,
        context: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        tab_index: Var[int] | int | None = None,
        row_buffer: Var[int] | int | None = None,
        row_number: Mapping[str, Any]
        | Var[Mapping[str, Any] | bool]
        | bool
        | None = None,
        value_cache: Var[bool] | bool | None = None,
        value_cache_never_expire: Var[bool] | bool | None = None,
        enable_cell_expressions: Var[bool] | bool | None = None,
        get_document: Callable | Var[Callable] | None = None,
        suppress_touch: Var[bool] | bool | None = None,
        drag_and_drop_image_component: Any | Var[Any] | None = None,
        suppress_focus_after_refresh: Var[bool] | bool | None = None,
        suppress_change_detection: Var[bool] | bool | None = None,
        debug: Var[bool] | bool | None = None,
        loading: Var[bool] | bool | None = None,
        overlay_loading_template: Var[str] | str | None = None,
        loading_overlay_component: Any | Var[Any] | None = None,
        loading_overlay_component_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_no_rows_overlay: Var[bool] | bool | None = None,
        overlay_no_rows_template: Var[str] | str | None = None,
        no_rows_overlay_component: Any | Var[Any] | None = None,
        no_rows_overlay_component_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        pagination: Var[bool] | bool | None = None,
        pagination_page_size: Var[int] | int | None = None,
        pagination_page_size_selector: Sequence[int]
        | Var[Sequence[int] | bool]
        | bool
        | None = None,
        pagination_number_formatter: Callable | Var[Callable] | None = None,
        pagination_auto_page_size: Var[bool] | bool | None = None,
        paginate_child_rows: Var[bool] | bool | None = None,
        suppress_pagination_panel: Var[bool] | bool | None = None,
        animate_rows: Var[bool] | bool | None = None,
        cell_flash_duration: Var[int] | int | None = None,
        cell_fade_duration: Var[int] | int | None = None,
        allow_show_change_after_filter: Var[bool] | bool | None = None,
        dom_layout: Literal["autoHeight", "normal", "print"]
        | Var[Literal["autoHeight", "normal", "print"]]
        | None = None,
        ensure_dom_order: Var[bool] | bool | None = None,
        get_business_key_for_node: Callable | Var[Callable] | None = None,
        grid_id: Var[str] | str | None = None,
        process_row_post_create: Callable | Var[Callable] | None = None,
        enable_rtl: Var[bool] | bool | None = None,
        suppress_column_virtualisation: Var[bool] | bool | None = None,
        suppress_row_virtualisation: Var[bool] | bool | None = None,
        suppress_max_rendered_row_restrictions: Var[bool] | bool | None = None,
        enable_cell_span: Var[bool] | bool | None = None,
        agg_funcs: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        group_total_row: Callable
        | Literal["bottom", "top"]
        | Var[Callable | Literal["bottom", "top"]]
        | None = None,
        grand_total_row: Literal["bottom", "top"]
        | Var[Literal["bottom", "top"]]
        | None = None,
        suppress_agg_func_in_header: Var[bool] | bool | None = None,
        aggregate_only_changed_columns: Var[bool] | bool | None = None,
        suppress_agg_filtered_only: Var[bool] | bool | None = None,
        group_agg_filtering: Var[bool] | bool | None = None,
        group_suppress_blank_header: Var[bool] | bool | None = None,
        suppress_sticky_total_row: Literal["grand", "group"]
        | Var[Literal["grand", "group"] | bool]
        | bool
        | None = None,
        always_aggregate_at_root_level: Var[bool] | bool | None = None,
        get_group_row_agg: Callable | Var[Callable] | None = None,
        row_drag_managed: Var[bool] | bool | None = None,
        row_drag_entire_row: Var[bool] | bool | None = None,
        row_drag_multi_row: Var[bool] | bool | None = None,
        suppress_row_drag: Var[bool] | bool | None = None,
        suppress_move_when_row_dragging: Var[bool] | bool | None = None,
        row_drag_text: Callable | Var[Callable] | None = None,
        full_width_cell_renderer: Any | Var[Any] | None = None,
        full_width_cell_renderer_params: FullWidthCellRendererParams
        | Mapping[str, Any]
        | Var[FullWidthCellRendererParams | Mapping[str, Any]]
        | None = None,
        group_display_type: Literal[
            "custom", "groupRows", "multipleColumns", "singleColumn"
        ]
        | Var[Literal["custom", "groupRows", "multipleColumns", "singleColumn"]]
        | None = None,
        auto_group_column_def: Any | Var[Any] | None = None,
        group_row_renderer: Any | Var[Any] | None = None,
        group_row_renderer_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        show_opened_group: Var[bool] | bool | None = None,
        group_hide_open_parents: Var[bool] | bool | None = None,
        group_hide_parent_of_single_child: Literal["leafGroupsOnly"]
        | Var[Literal["leafGroupsOnly"] | bool]
        | bool
        | None = None,
        initial_group_order_comparator: Callable | Var[Callable] | None = None,
        group_allow_unbalanced: Var[bool] | bool | None = None,
        group_maintain_order: Var[bool] | bool | None = None,
        group_default_expanded: Var[int] | int | None = None,
        is_group_open_by_default: Callable | Var[Callable] | None = None,
        suppress_group_stickiness: Var[bool] | bool | None = None,
        row_group_panel_show: Var[str] | str | None = None,
        row_group_panel_suppress_sort: Var[bool] | bool | None = None,
        group_lock_group_columns: Var[int] | int | None = None,
        suppress_group_changes_column_visibility: Var[bool] | bool | None = None,
        pinned_row_top_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        pinned_row_bottom_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        pivot_mode: Var[bool] | bool | None = None,
        pivot_panel_show: Var[str] | str | None = None,
        pivot_default_expanded: Var[int] | int | None = None,
        pivot_row_totals: Literal["after", "before"]
        | Var[Literal["after", "before"]]
        | None = None,
        pivot_suppress_auto_column: Var[bool] | bool | None = None,
        pivot_max_generated_columns: Var[int] | int | None = None,
        process_pivot_result_col_def: Callable | Var[Callable] | None = None,
        process_pivot_result_col_group_def: Callable | Var[Callable] | None = None,
        suppress_expandable_pivot_groups: Var[bool] | bool | None = None,
        functions_read_only: Var[bool] | bool | None = None,
        remove_pivot_header_row_when_single_value_column: Var[bool]
        | bool
        | None = None,
        row_model_type: Var[str] | str | None = None,
        get_row_id: Callable | Var[Callable] | None = None,
        row_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        reset_row_data_on_update: Var[bool] | bool | None = None,
        async_transaction_wait_millis: Var[int] | int | None = None,
        suppress_model_update_after_update_transaction: Var[bool] | bool | None = None,
        datasource: Datasource | Var[Datasource] | None = None,
        cache_overflow_size: Var[int] | int | None = None,
        max_concurrent_datasource_requests: Var[int] | int | None = None,
        cache_block_size: Var[int] | int | None = None,
        max_blocks_in_cache: Var[int] | int | None = None,
        infinite_initial_row_count: Var[int] | int | None = None,
        server_side_datasource: SSRMDatasource | Var[SSRMDatasource] | None = None,
        block_load_debounce_millis: Var[int] | int | None = None,
        suppress_server_side_full_width_loading_row: Var[bool] | bool | None = None,
        purge_closed_row_nodes: Var[bool] | bool | None = None,
        server_side_pivot_result_field_separator: Var[str] | str | None = None,
        server_side_sort_all_levels: Var[bool] | bool | None = None,
        server_side_enable_client_side_sort: Var[bool] | bool | None = None,
        server_side_only_refresh_filtered_groups: Var[bool] | bool | None = None,
        server_side_initial_row_count: Var[int] | int | None = None,
        get_child_count: Callable | Var[Callable] | None = None,
        get_server_side_group_level_params: Callable | Var[Callable] | None = None,
        is_server_side_group_open_by_default: Callable | Var[Callable] | None = None,
        is_apply_server_side_transaction: Callable | Var[Callable] | None = None,
        is_server_side_group: Callable | Var[Callable] | None = None,
        get_server_side_group_key: Callable | Var[Callable] | None = None,
        viewport_datasource: Any | Var[Any] | None = None,
        viewport_row_model_page_size: Var[int] | int | None = None,
        viewport_row_model_buffer_size: Var[int] | int | None = None,
        always_show_horizontal_scroll: Var[bool] | bool | None = None,
        always_show_vertical_scroll: Var[bool] | bool | None = None,
        debounce_vertical_scrollbar: Var[bool] | bool | None = None,
        suppress_horizontal_scroll: Var[bool] | bool | None = None,
        suppress_scroll_on_new_data: Var[bool] | bool | None = None,
        suppress_scroll_when_popup_are_open: Var[bool] | bool | None = None,
        suppress_animation_frame: Var[bool] | bool | None = None,
        suppress_middle_click_scroll: Var[bool] | bool | None = None,
        suppress_prevent_default_on_mouse_wheel: Var[bool] | bool | None = None,
        scrollbar_width: Var[int] | int | None = None,
        cell_selection: Var[bool | dict] | bool | dict | None = None,
        row_selection: Var[dict | str] | dict | str | None = None,
        selection_column_def: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        suppress_cell_focus: Var[bool] | bool | None = None,
        suppress_header_focus: Var[bool] | bool | None = None,
        enable_cell_text_selection: Var[bool] | bool | None = None,
        accented_sort: Var[bool] | bool | None = None,
        suppress_multi_sort: Var[bool] | bool | None = None,
        always_multi_sort: Var[bool] | bool | None = None,
        multi_sort_key: Literal["ctrl", "shift"]
        | Var[Literal["ctrl", "shift"]]
        | None = None,
        suppress_maintain_unsorted_order: Var[bool] | bool | None = None,
        post_sort_rows: Callable | Var[Callable] | None = None,
        delta_sort: Var[bool] | bool | None = None,
        icons: Mapping[str, str] | Var[Mapping[str, str]] | None = None,
        row_height: Var[int] | int | None = None,
        get_row_height: Callable | Var[Callable] | None = None,
        row_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        get_row_style: Callable | Var[Callable] | None = None,
        row_class: Sequence[str] | Var[Sequence[str] | str] | str | None = None,
        get_row_class: Callable | Var[Callable] | None = None,
        row_class_rules: Mapping[str, Callable]
        | Var[Mapping[str, Callable]]
        | None = None,
        suppress_row_hover_highlight: Var[bool] | bool | None = None,
        column_hover_highlight: Var[bool] | bool | None = None,
        theme: Literal["alpine", "balham", "material", "quartz"]
        | Var[Literal["alpine", "balham", "material", "quartz"]]
        | None = None,
        load_theme_google_fonts: Var[bool] | bool | None = None,
        theme_style_container: Any | Var[Any] | None = None,
        theme_css_layer: Var[str] | str | None = None,
        enable_browser_tooltips: Var[bool] | bool | None = None,
        tooltip_show_delay: Var[int] | int | None = None,
        tooltip_hide_delay: Var[int] | int | None = None,
        tooltip_mouse_track: Var[bool] | bool | None = None,
        tooltip_show_mode: Literal["standard", "whenTruncated"]
        | Var[Literal["standard", "whenTruncated"]]
        | None = None,
        tooltip_trigger: Literal["focus", "hover"]
        | Var[Literal["focus", "hover"]]
        | None = None,
        tooltip_interactive: Var[bool] | bool | None = None,
        tree_data: Var[bool] | bool | None = None,
        get_data_path: Callable | Var[Callable] | None = None,
        tree_data_children_field: Var[str] | str | None = None,
        suppress_group_rows_sticky: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "GridOptions":
        """Create the Reflex Enterprise component."""
        ...

class StateUpdatedEvent(TypedDict):
    source: str
    state: str

class FilterOpenedEvent(TypedDict):
    col_id: str
    source: str
    type: str

class FilterChangedEvent(TypedDict):
    source: str
    after_data_change: bool | None
    after_floating_filter: bool | None
    col_ids: list[str]
    type: str

class FilterInstance(TypedDict):
    applied_model: dict
    filter_name_key: str
    filter_type: str

class FilterModifiedEvent(TypedDict):
    filter_instance: FilterInstance
    col_id: str
    type: str

class FilterUiChangedEvent(TypedDict):
    col_id: str
    type: str

class AdvancedFilterBuilderVisibleChangedEvent(TypedDict):
    visible: bool
    source: str
    type: str

class GridEvents(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_advanced_filter_builder_visible_changed: Optional[
            EventType[()] | EventType[AdvancedFilterBuilderVisibleChangedEvent]
        ] = None,
        on_blur: Optional[EventType[()]] = None,
        on_cell_clicked: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_context_menu: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_double_clicked: Optional[
            EventType[()] | EventType[CellEventSpec]
        ] = None,
        on_cell_focused: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_mouse_out: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_mouse_over: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_selection_changed: Optional[
            EventType[()]
            | EventType[list[dict]]
            | EventType[list[dict], bool]
            | EventType[list[dict], bool, bool]
        ] = None,
        on_cell_value_changed: Optional[
            EventType[()] | EventType[CellValueChangedEventSpec]
        ] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_column_header_clicked: Optional[
            EventType[()] | EventType[ColumnEventSpec]
        ] = None,
        on_column_header_context_menu: Optional[
            EventType[()] | EventType[ColumnEventSpec]
        ] = None,
        on_column_moved: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_column_pinned: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_column_resized: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_filter_changed: Optional[
            EventType[()] | EventType[FilterChangedEvent]
        ] = None,
        on_filter_modified: Optional[
            EventType[()] | EventType[FilterModifiedEvent]
        ] = None,
        on_filter_opened: Optional[EventType[()] | EventType[FilterOpenedEvent]] = None,
        on_filter_ui_changed: Optional[
            EventType[()] | EventType[FilterUiChangedEvent]
        ] = None,
        on_first_data_rendered: Optional[
            EventType[()] | EventType[CellEventSpec]
        ] = None,
        on_floating_filter_ui_changed: Optional[
            EventType[()] | EventType[FilterUiChangedEvent]
        ] = None,
        on_focus: Optional[EventType[()]] = None,
        on_grid_pre_destroyed: Optional[EventType[()] | EventType[dict]] = None,
        on_grid_ready: Optional[EventType[()]] = None,
        on_header_focused: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_row_clicked: Optional[EventType[()] | EventType[RowEventSpec]] = None,
        on_row_data_updated: Optional[EventType[()]] = None,
        on_row_double_clicked: Optional[EventType[()] | EventType[RowEventSpec]] = None,
        on_row_selected: Optional[
            EventType[()] | EventType[RowSelectionEventSpec]
        ] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_selection_changed: Optional[
            EventType[()]
            | EventType[list[dict]]
            | EventType[list[dict], str]
            | EventType[list[dict], str, str]
        ] = None,
        on_state_updated: Optional[EventType[()] | EventType[StateUpdatedEvent]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "GridEvents":
        """Create the Reflex Enterprise component."""
        ...

class AgGrid(GridOptions, GridEvents, ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        id: str | None,
        data_path_key: str | None = None,
        is_server_side_group_key: str | None = None,
        server_side_group_key: str | None = None,
        server_side_group_open_level: int | None = None,
        child_count_key: str | None = None,
        row_id_key: str | None = None,
        community_modules: set[str] | None = None,
        enterprise_modules: set[str] | None = None,
        _modules: dict[str, set[str]] | None = None,
        status_bar: Mapping[str, Any]
        | StatusPanelDef
        | Var[Mapping[str, Any] | StatusPanelDef]
        | None = None,
        side_bar: Sequence[str]
        | SideBarDef
        | Var[Sequence[str] | SideBarDef | bool | str]
        | bool
        | str
        | None = None,
        get_context_menu_items: Callable | Var[Callable] | None = None,
        suppress_context_menu: Var[bool] | bool | None = None,
        prevent_default_on_context_menu: Var[bool] | bool | None = None,
        allow_context_menu_with_control_key: Var[bool] | bool | None = None,
        column_menu: Literal["legacy", "new"]
        | Var[Literal["legacy", "new"]]
        | None = None,
        suppress_menu_hide: Var[bool] | bool | None = None,
        copy_headers_to_clipboard: Var[bool] | bool | None = None,
        copy_group_headers_to_clipboard: Var[bool] | bool | None = None,
        clipboard_delimiter: Var[str] | str | None = None,
        suppress_cut_to_clipboard: Var[bool] | bool | None = None,
        suppress_last_empty_line_on_paste: Var[bool] | bool | None = None,
        suppress_clipboard_paste: Var[bool] | bool | None = None,
        suppress_clipboard_api: Var[bool] | bool | None = None,
        process_cell_for_clipboard: Callable | Var[Callable] | None = None,
        process_header_for_clipboard: Callable | Var[Callable] | None = None,
        process_group_header_for_clipboard: Callable | Var[Callable] | None = None,
        process_cell_from_clipboard: Callable | Var[Callable] | None = None,
        send_to_clipboard: Callable | Var[Callable] | None = None,
        process_data_from_clipboard: Callable | Var[Callable] | None = None,
        column_defs: Sequence[ColumnDef | ColumnGroupDef]
        | Sequence[Mapping[str, Any]]
        | Var[Sequence[ColumnDef | ColumnGroupDef] | Sequence[Mapping[str, Any]]]
        | None = None,
        default_col_def: Mapping[str, Any]
        | Var[Mapping[str, Any] | None]
        | None = None,
        default_col_group_def: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        column_types: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        data_types_definitions: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        maintain_column_order: Var[bool] | bool | None = None,
        enable_strict_pivot_column_order: Var[bool] | bool | None = None,
        suppress_field_dot_notation: Var[bool] | bool | None = None,
        header_height: Var[int] | int | None = None,
        group_header_height: Var[int] | int | None = None,
        floating_filters_height: Var[int] | int | None = None,
        pivot_header_height: Var[int] | int | None = None,
        pivot_group_header_height: Var[int] | int | None = None,
        allow_drag_from_columns_tool_panel: Var[bool] | bool | None = None,
        suppress_movable_columns: Var[bool] | bool | None = None,
        suppress_move_when_column_dragging: Var[bool] | bool | None = None,
        suppress_column_move_animation: Var[bool] | bool | None = None,
        suppress_drag_leave_hides_columns: Var[bool] | bool | None = None,
        process_unpinned_columns: Callable | Var[Callable] | None = None,
        col_resize_default: Var[str] | str | None = None,
        auto_size_strategy: Var[dict] | dict | None = None,
        suppress_auto_size: Var[bool] | bool | None = None,
        auto_size_padding: Var[int] | int | None = None,
        skip_header_on_auto_size: Var[bool] | bool | None = None,
        components: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        edit_type: Var[str] | str | None = None,
        single_click_edit: Var[bool] | bool | None = None,
        suppress_click_edit: Var[bool] | bool | None = None,
        stop_edit_when_cell_loses_focus: Var[bool] | bool | None = None,
        enter_navigate_vertically: Var[bool] | bool | None = None,
        enter_navigate_vertically_after_edit: Var[bool] | bool | None = None,
        enable_cell_editing_on_backspace: Var[bool] | bool | None = None,
        undo_redo_cell_editing: Var[bool] | bool | None = None,
        undo_redo_cell_editing_limit: Var[int] | int | None = None,
        read_only_edit: Var[bool] | bool | None = None,
        default_csv_export_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_csv_export: Var[bool] | bool | None = None,
        default_excel_export_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_excel_export: Var[bool] | bool | None = None,
        excel_styles: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        quick_filter_text: Var[str] | str | None = None,
        cache_quick_filter: Var[bool] | bool | None = None,
        include_hidden_columns_in_quick_filter: Var[bool] | bool | None = None,
        quick_filter_parser: Callable | Var[Callable] | None = None,
        quick_filter_matcher: Callable | Var[Callable] | None = None,
        apply_quick_filter_before_pivot_or_agg: Var[bool] | bool | None = None,
        is_external_filter_present: Callable | Var[Callable] | None = None,
        does_external_filter_pass: Callable | Var[Callable] | None = None,
        exclude_children_when_tree_data_filtering: Var[bool] | bool | None = None,
        suppress_set_filter_by_default: Var[bool] | bool | None = None,
        enable_advanced_filter: Var[bool] | bool | None = None,
        include_hidden_columns_in_advanced_filter: Var[bool] | bool | None = None,
        advanced_filter_parent: Any | Var[Any] | None = None,
        advanced_filter_built_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        always_pass_filter: Callable | Var[Callable] | None = None,
        enable_charts: Var[bool] | bool | None = None,
        get_chart_toolbar_items: Callable | Var[Callable] | None = None,
        create_chart_container: Callable | Var[Callable] | None = None,
        chart_themes: Sequence[str] | Var[Sequence[str]] | None = None,
        custom_chart_themes: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_theme_overrides: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_tool_panel_defs: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_menu_items: Callable | Var[Callable] | None = None,
        focus_grid_inner_elements: Callable | Var[Callable] | None = None,
        navigate_to_next_header: Callable | Var[Callable] | None = None,
        tab_to_next_header: Callable | Var[Callable] | None = None,
        navigate_to_next_cell: Callable | Var[Callable] | None = None,
        tab_to_next_cell: Callable | Var[Callable] | None = None,
        loading_cell_renderer: Any | Var[Any] | None = None,
        loading_cell_renderer_params: LoadingCellRendererParams
        | Mapping[str, Any]
        | Var[LoadingCellRendererParams | Mapping[str, Any]]
        | None = None,
        loading_cell_renderer_selector: Callable | Var[Callable] | None = None,
        locale_text: Mapping[str, str] | Var[Mapping[str, str]] | None = None,
        get_locale_text: Callable | Var[Callable] | None = None,
        master_detail: Var[bool] | bool | None = None,
        is_row_master: Callable | Var[Callable] | None = None,
        detail_cell_renderer: Any | Var[Any] | None = None,
        detail_cell_renderer_params: Callable
        | DetailCellRendererParams
        | Mapping[str, Any]
        | Var[Callable | DetailCellRendererParams | Mapping[str, Any]]
        | None = None,
        detail_row_height: Var[int] | int | None = None,
        detail_row_auto_height: Var[bool] | bool | None = None,
        embed_full_width_rows: Var[bool] | bool | None = None,
        keep_detail_rows: Var[bool] | bool | None = None,
        keep_detail_rows_count: Var[int] | int | None = None,
        initial_state: Any | Var[Any] | None = None,
        aligned_grids: Callable
        | Sequence[Any]
        | Var[Callable | Sequence[Any]]
        | None = None,
        context: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        tab_index: Var[int] | int | None = None,
        row_buffer: Var[int] | int | None = None,
        row_number: Mapping[str, Any]
        | Var[Mapping[str, Any] | bool]
        | bool
        | None = None,
        value_cache: Var[bool] | bool | None = None,
        value_cache_never_expire: Var[bool] | bool | None = None,
        enable_cell_expressions: Var[bool] | bool | None = None,
        get_document: Callable | Var[Callable] | None = None,
        suppress_touch: Var[bool] | bool | None = None,
        drag_and_drop_image_component: Any | Var[Any] | None = None,
        suppress_focus_after_refresh: Var[bool] | bool | None = None,
        suppress_change_detection: Var[bool] | bool | None = None,
        debug: Var[bool] | bool | None = None,
        loading: Var[bool] | bool | None = None,
        overlay_loading_template: Var[str] | str | None = None,
        loading_overlay_component: Any | Var[Any] | None = None,
        loading_overlay_component_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_no_rows_overlay: Var[bool] | bool | None = None,
        overlay_no_rows_template: Var[str] | str | None = None,
        no_rows_overlay_component: Any | Var[Any] | None = None,
        no_rows_overlay_component_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        pagination: Var[bool] | bool | None = None,
        pagination_page_size: Var[int] | int | None = None,
        pagination_page_size_selector: Sequence[int]
        | Var[Sequence[int] | bool]
        | bool
        | None = None,
        pagination_number_formatter: Callable | Var[Callable] | None = None,
        pagination_auto_page_size: Var[bool] | bool | None = None,
        paginate_child_rows: Var[bool] | bool | None = None,
        suppress_pagination_panel: Var[bool] | bool | None = None,
        animate_rows: Var[bool] | bool | None = None,
        cell_flash_duration: Var[int] | int | None = None,
        cell_fade_duration: Var[int] | int | None = None,
        allow_show_change_after_filter: Var[bool] | bool | None = None,
        dom_layout: Literal["autoHeight", "normal", "print"]
        | Var[Literal["autoHeight", "normal", "print"]]
        | None = None,
        ensure_dom_order: Var[bool] | bool | None = None,
        get_business_key_for_node: Callable | Var[Callable] | None = None,
        grid_id: Var[str] | str | None = None,
        process_row_post_create: Callable | Var[Callable] | None = None,
        enable_rtl: Var[bool] | bool | None = None,
        suppress_column_virtualisation: Var[bool] | bool | None = None,
        suppress_row_virtualisation: Var[bool] | bool | None = None,
        suppress_max_rendered_row_restrictions: Var[bool] | bool | None = None,
        enable_cell_span: Var[bool] | bool | None = None,
        agg_funcs: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        group_total_row: Callable
        | Literal["bottom", "top"]
        | Var[Callable | Literal["bottom", "top"]]
        | None = None,
        grand_total_row: Literal["bottom", "top"]
        | Var[Literal["bottom", "top"]]
        | None = None,
        suppress_agg_func_in_header: Var[bool] | bool | None = None,
        aggregate_only_changed_columns: Var[bool] | bool | None = None,
        suppress_agg_filtered_only: Var[bool] | bool | None = None,
        group_agg_filtering: Var[bool] | bool | None = None,
        group_suppress_blank_header: Var[bool] | bool | None = None,
        suppress_sticky_total_row: Literal["grand", "group"]
        | Var[Literal["grand", "group"] | bool]
        | bool
        | None = None,
        always_aggregate_at_root_level: Var[bool] | bool | None = None,
        get_group_row_agg: Callable | Var[Callable] | None = None,
        row_drag_managed: Var[bool] | bool | None = None,
        row_drag_entire_row: Var[bool] | bool | None = None,
        row_drag_multi_row: Var[bool] | bool | None = None,
        suppress_row_drag: Var[bool] | bool | None = None,
        suppress_move_when_row_dragging: Var[bool] | bool | None = None,
        row_drag_text: Callable | Var[Callable] | None = None,
        full_width_cell_renderer: Any | Var[Any] | None = None,
        full_width_cell_renderer_params: FullWidthCellRendererParams
        | Mapping[str, Any]
        | Var[FullWidthCellRendererParams | Mapping[str, Any]]
        | None = None,
        group_display_type: Literal[
            "custom", "groupRows", "multipleColumns", "singleColumn"
        ]
        | Var[Literal["custom", "groupRows", "multipleColumns", "singleColumn"]]
        | None = None,
        auto_group_column_def: Any | Var[Any] | None = None,
        group_row_renderer: Any | Var[Any] | None = None,
        group_row_renderer_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        show_opened_group: Var[bool] | bool | None = None,
        group_hide_open_parents: Var[bool] | bool | None = None,
        group_hide_parent_of_single_child: Literal["leafGroupsOnly"]
        | Var[Literal["leafGroupsOnly"] | bool]
        | bool
        | None = None,
        initial_group_order_comparator: Callable | Var[Callable] | None = None,
        group_allow_unbalanced: Var[bool] | bool | None = None,
        group_maintain_order: Var[bool] | bool | None = None,
        group_default_expanded: Var[int] | int | None = None,
        is_group_open_by_default: Callable | Var[Callable] | None = None,
        suppress_group_stickiness: Var[bool] | bool | None = None,
        row_group_panel_show: Var[str] | str | None = None,
        row_group_panel_suppress_sort: Var[bool] | bool | None = None,
        group_lock_group_columns: Var[int] | int | None = None,
        suppress_group_changes_column_visibility: Var[bool] | bool | None = None,
        pinned_row_top_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        pinned_row_bottom_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        pivot_mode: Var[bool] | bool | None = None,
        pivot_panel_show: Var[str] | str | None = None,
        pivot_default_expanded: Var[int] | int | None = None,
        pivot_row_totals: Literal["after", "before"]
        | Var[Literal["after", "before"]]
        | None = None,
        pivot_suppress_auto_column: Var[bool] | bool | None = None,
        pivot_max_generated_columns: Var[int] | int | None = None,
        process_pivot_result_col_def: Callable | Var[Callable] | None = None,
        process_pivot_result_col_group_def: Callable | Var[Callable] | None = None,
        suppress_expandable_pivot_groups: Var[bool] | bool | None = None,
        functions_read_only: Var[bool] | bool | None = None,
        remove_pivot_header_row_when_single_value_column: Var[bool]
        | bool
        | None = None,
        row_model_type: Var[str] | str | None = None,
        get_row_id: Callable | Var[Callable] | None = None,
        row_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        reset_row_data_on_update: Var[bool] | bool | None = None,
        async_transaction_wait_millis: Var[int] | int | None = None,
        suppress_model_update_after_update_transaction: Var[bool] | bool | None = None,
        datasource: Datasource | Var[Datasource] | None = None,
        cache_overflow_size: Var[int] | int | None = None,
        max_concurrent_datasource_requests: Var[int] | int | None = None,
        cache_block_size: Var[int] | int | None = None,
        max_blocks_in_cache: Var[int] | int | None = None,
        infinite_initial_row_count: Var[int] | int | None = None,
        server_side_datasource: SSRMDatasource | Var[SSRMDatasource] | None = None,
        block_load_debounce_millis: Var[int] | int | None = None,
        suppress_server_side_full_width_loading_row: Var[bool] | bool | None = None,
        purge_closed_row_nodes: Var[bool] | bool | None = None,
        server_side_pivot_result_field_separator: Var[str] | str | None = None,
        server_side_sort_all_levels: Var[bool] | bool | None = None,
        server_side_enable_client_side_sort: Var[bool] | bool | None = None,
        server_side_only_refresh_filtered_groups: Var[bool] | bool | None = None,
        server_side_initial_row_count: Var[int] | int | None = None,
        get_child_count: Callable | Var[Callable] | None = None,
        get_server_side_group_level_params: Callable | Var[Callable] | None = None,
        is_server_side_group_open_by_default: Callable | Var[Callable] | None = None,
        is_apply_server_side_transaction: Callable | Var[Callable] | None = None,
        is_server_side_group: Callable | Var[Callable] | None = None,
        get_server_side_group_key: Callable | Var[Callable] | None = None,
        viewport_datasource: Any | Var[Any] | None = None,
        viewport_row_model_page_size: Var[int] | int | None = None,
        viewport_row_model_buffer_size: Var[int] | int | None = None,
        always_show_horizontal_scroll: Var[bool] | bool | None = None,
        always_show_vertical_scroll: Var[bool] | bool | None = None,
        debounce_vertical_scrollbar: Var[bool] | bool | None = None,
        suppress_horizontal_scroll: Var[bool] | bool | None = None,
        suppress_scroll_on_new_data: Var[bool] | bool | None = None,
        suppress_scroll_when_popup_are_open: Var[bool] | bool | None = None,
        suppress_animation_frame: Var[bool] | bool | None = None,
        suppress_middle_click_scroll: Var[bool] | bool | None = None,
        suppress_prevent_default_on_mouse_wheel: Var[bool] | bool | None = None,
        scrollbar_width: Var[int] | int | None = None,
        cell_selection: Var[bool | dict] | bool | dict | None = None,
        row_selection: Var[dict | str] | dict | str | None = None,
        selection_column_def: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        suppress_cell_focus: Var[bool] | bool | None = None,
        suppress_header_focus: Var[bool] | bool | None = None,
        enable_cell_text_selection: Var[bool] | bool | None = None,
        accented_sort: Var[bool] | bool | None = None,
        suppress_multi_sort: Var[bool] | bool | None = None,
        always_multi_sort: Var[bool] | bool | None = None,
        multi_sort_key: Literal["ctrl", "shift"]
        | Var[Literal["ctrl", "shift"]]
        | None = None,
        suppress_maintain_unsorted_order: Var[bool] | bool | None = None,
        post_sort_rows: Callable | Var[Callable] | None = None,
        delta_sort: Var[bool] | bool | None = None,
        icons: Mapping[str, str] | Var[Mapping[str, str]] | None = None,
        row_height: Var[int] | int | None = None,
        get_row_height: Callable | Var[Callable] | None = None,
        row_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        get_row_style: Callable | Var[Callable] | None = None,
        row_class: Sequence[str] | Var[Sequence[str] | str] | str | None = None,
        get_row_class: Callable | Var[Callable] | None = None,
        row_class_rules: Mapping[str, Callable]
        | Var[Mapping[str, Callable]]
        | None = None,
        suppress_row_hover_highlight: Var[bool] | bool | None = None,
        column_hover_highlight: Var[bool] | bool | None = None,
        theme: Literal["alpine", "balham", "material", "quartz"]
        | Var[Literal["alpine", "balham", "material", "quartz"]]
        | None = None,
        load_theme_google_fonts: Var[bool] | bool | None = None,
        theme_style_container: Any | Var[Any] | None = None,
        theme_css_layer: Var[str] | str | None = None,
        enable_browser_tooltips: Var[bool] | bool | None = None,
        tooltip_show_delay: Var[int] | int | None = None,
        tooltip_hide_delay: Var[int] | int | None = None,
        tooltip_mouse_track: Var[bool] | bool | None = None,
        tooltip_show_mode: Literal["standard", "whenTruncated"]
        | Var[Literal["standard", "whenTruncated"]]
        | None = None,
        tooltip_trigger: Literal["focus", "hover"]
        | Var[Literal["focus", "hover"]]
        | None = None,
        tooltip_interactive: Var[bool] | bool | None = None,
        tree_data: Var[bool] | bool | None = None,
        get_data_path: Callable | Var[Callable] | None = None,
        tree_data_children_field: Var[str] | str | None = None,
        suppress_group_rows_sticky: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_advanced_filter_builder_visible_changed: Optional[
            EventType[()] | EventType[AdvancedFilterBuilderVisibleChangedEvent]
        ] = None,
        on_blur: Optional[EventType[()]] = None,
        on_cell_clicked: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_context_menu: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_double_clicked: Optional[
            EventType[()] | EventType[CellEventSpec]
        ] = None,
        on_cell_focused: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_mouse_out: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_mouse_over: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_selection_changed: Optional[
            EventType[()]
            | EventType[list[dict]]
            | EventType[list[dict], bool]
            | EventType[list[dict], bool, bool]
        ] = None,
        on_cell_value_changed: Optional[
            EventType[()] | EventType[CellValueChangedEventSpec]
        ] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_column_header_clicked: Optional[
            EventType[()] | EventType[ColumnEventSpec]
        ] = None,
        on_column_header_context_menu: Optional[
            EventType[()] | EventType[ColumnEventSpec]
        ] = None,
        on_column_moved: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_column_pinned: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_column_resized: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_filter_changed: Optional[
            EventType[()] | EventType[FilterChangedEvent]
        ] = None,
        on_filter_modified: Optional[
            EventType[()] | EventType[FilterModifiedEvent]
        ] = None,
        on_filter_opened: Optional[EventType[()] | EventType[FilterOpenedEvent]] = None,
        on_filter_ui_changed: Optional[
            EventType[()] | EventType[FilterUiChangedEvent]
        ] = None,
        on_first_data_rendered: Optional[
            EventType[()] | EventType[CellEventSpec]
        ] = None,
        on_floating_filter_ui_changed: Optional[
            EventType[()] | EventType[FilterUiChangedEvent]
        ] = None,
        on_focus: Optional[EventType[()]] = None,
        on_grid_pre_destroyed: Optional[EventType[()] | EventType[dict]] = None,
        on_grid_ready: Optional[EventType[()]] = None,
        on_header_focused: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_row_clicked: Optional[EventType[()] | EventType[RowEventSpec]] = None,
        on_row_data_updated: Optional[EventType[()]] = None,
        on_row_double_clicked: Optional[EventType[()] | EventType[RowEventSpec]] = None,
        on_row_selected: Optional[
            EventType[()] | EventType[RowSelectionEventSpec]
        ] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_selection_changed: Optional[
            EventType[()]
            | EventType[list[dict]]
            | EventType[list[dict], str]
            | EventType[list[dict], str, str]
        ] = None,
        on_state_updated: Optional[EventType[()] | EventType[StateUpdatedEvent]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "AgGrid":
        """Create an instance of the AgGrid component."""
        ...

    @classmethod
    def collect_modules(
        cls, props: dict[str, Any], modules: dict[str, set[str]] | None = None
    ) -> dict[str, set[str]]: ...
    @classmethod
    def format_props(cls, props: dict[str, Any]) -> dict[str, Any]: ...
    def add_imports(self): ...
    def add_custom_code(self) -> list[str]: ...
    @property
    def api(self) -> AgGridAPI: ...
    def get_selected_rows(self, callback: rx.EventHandler) -> EventSpec: ...
    def select_all(self) -> EventSpec: ...
    def deselect_all(self) -> EventSpec: ...
    def select_rows_by_key(
        self, keys: list[str], node_path_key: str = "key"
    ) -> EventSpec: ...
    def log_nodes(self, node_path_key: str | None = None) -> EventSpec: ...
    def set_datasource(self, datasource: Datasource): ...
    def set_serverside_datasource(self, datasource: SSRMDatasource): ...
    def show_loading_overlay(self) -> EventSpec: ...
    def show_no_rows_overlay(self) -> EventSpec: ...
    def hide_overlay(self) -> EventSpec: ...
    def redraw_rows(self) -> EventSpec: ...
    def export_data_as_csv(self) -> EventSpec: ...

class WrappedAgGrid(AgGrid):
    @classmethod
    def create(
        cls,
        *children,
        _modules: dict[str, set[str]] | None = None,
        status_bar: Mapping[str, Any]
        | StatusPanelDef
        | Var[Mapping[str, Any] | StatusPanelDef]
        | None = None,
        side_bar: Sequence[str]
        | SideBarDef
        | Var[Sequence[str] | SideBarDef | bool | str]
        | bool
        | str
        | None = None,
        get_context_menu_items: Callable | Var[Callable] | None = None,
        suppress_context_menu: Var[bool] | bool | None = None,
        prevent_default_on_context_menu: Var[bool] | bool | None = None,
        allow_context_menu_with_control_key: Var[bool] | bool | None = None,
        column_menu: Literal["legacy", "new"]
        | Var[Literal["legacy", "new"]]
        | None = None,
        suppress_menu_hide: Var[bool] | bool | None = None,
        copy_headers_to_clipboard: Var[bool] | bool | None = None,
        copy_group_headers_to_clipboard: Var[bool] | bool | None = None,
        clipboard_delimiter: Var[str] | str | None = None,
        suppress_cut_to_clipboard: Var[bool] | bool | None = None,
        suppress_last_empty_line_on_paste: Var[bool] | bool | None = None,
        suppress_clipboard_paste: Var[bool] | bool | None = None,
        suppress_clipboard_api: Var[bool] | bool | None = None,
        process_cell_for_clipboard: Callable | Var[Callable] | None = None,
        process_header_for_clipboard: Callable | Var[Callable] | None = None,
        process_group_header_for_clipboard: Callable | Var[Callable] | None = None,
        process_cell_from_clipboard: Callable | Var[Callable] | None = None,
        send_to_clipboard: Callable | Var[Callable] | None = None,
        process_data_from_clipboard: Callable | Var[Callable] | None = None,
        column_defs: Sequence[ColumnDef | ColumnGroupDef]
        | Sequence[Mapping[str, Any]]
        | Var[Sequence[ColumnDef | ColumnGroupDef] | Sequence[Mapping[str, Any]]]
        | None = None,
        default_col_def: Mapping[str, Any]
        | Var[Mapping[str, Any] | None]
        | None = None,
        default_col_group_def: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        column_types: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        data_types_definitions: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        maintain_column_order: Var[bool] | bool | None = None,
        enable_strict_pivot_column_order: Var[bool] | bool | None = None,
        suppress_field_dot_notation: Var[bool] | bool | None = None,
        header_height: Var[int] | int | None = None,
        group_header_height: Var[int] | int | None = None,
        floating_filters_height: Var[int] | int | None = None,
        pivot_header_height: Var[int] | int | None = None,
        pivot_group_header_height: Var[int] | int | None = None,
        allow_drag_from_columns_tool_panel: Var[bool] | bool | None = None,
        suppress_movable_columns: Var[bool] | bool | None = None,
        suppress_move_when_column_dragging: Var[bool] | bool | None = None,
        suppress_column_move_animation: Var[bool] | bool | None = None,
        suppress_drag_leave_hides_columns: Var[bool] | bool | None = None,
        process_unpinned_columns: Callable | Var[Callable] | None = None,
        col_resize_default: Var[str] | str | None = None,
        auto_size_strategy: Var[dict] | dict | None = None,
        suppress_auto_size: Var[bool] | bool | None = None,
        auto_size_padding: Var[int] | int | None = None,
        skip_header_on_auto_size: Var[bool] | bool | None = None,
        components: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        edit_type: Var[str] | str | None = None,
        single_click_edit: Var[bool] | bool | None = None,
        suppress_click_edit: Var[bool] | bool | None = None,
        stop_edit_when_cell_loses_focus: Var[bool] | bool | None = None,
        enter_navigate_vertically: Var[bool] | bool | None = None,
        enter_navigate_vertically_after_edit: Var[bool] | bool | None = None,
        enable_cell_editing_on_backspace: Var[bool] | bool | None = None,
        undo_redo_cell_editing: Var[bool] | bool | None = None,
        undo_redo_cell_editing_limit: Var[int] | int | None = None,
        read_only_edit: Var[bool] | bool | None = None,
        default_csv_export_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_csv_export: Var[bool] | bool | None = None,
        default_excel_export_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_excel_export: Var[bool] | bool | None = None,
        excel_styles: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        quick_filter_text: Var[str] | str | None = None,
        cache_quick_filter: Var[bool] | bool | None = None,
        include_hidden_columns_in_quick_filter: Var[bool] | bool | None = None,
        quick_filter_parser: Callable | Var[Callable] | None = None,
        quick_filter_matcher: Callable | Var[Callable] | None = None,
        apply_quick_filter_before_pivot_or_agg: Var[bool] | bool | None = None,
        is_external_filter_present: Callable | Var[Callable] | None = None,
        does_external_filter_pass: Callable | Var[Callable] | None = None,
        exclude_children_when_tree_data_filtering: Var[bool] | bool | None = None,
        suppress_set_filter_by_default: Var[bool] | bool | None = None,
        enable_advanced_filter: Var[bool] | bool | None = None,
        include_hidden_columns_in_advanced_filter: Var[bool] | bool | None = None,
        advanced_filter_parent: Any | Var[Any] | None = None,
        advanced_filter_built_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        always_pass_filter: Callable | Var[Callable] | None = None,
        enable_charts: Var[bool] | bool | None = None,
        get_chart_toolbar_items: Callable | Var[Callable] | None = None,
        create_chart_container: Callable | Var[Callable] | None = None,
        chart_themes: Sequence[str] | Var[Sequence[str]] | None = None,
        custom_chart_themes: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_theme_overrides: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_tool_panel_defs: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_menu_items: Callable | Var[Callable] | None = None,
        focus_grid_inner_elements: Callable | Var[Callable] | None = None,
        navigate_to_next_header: Callable | Var[Callable] | None = None,
        tab_to_next_header: Callable | Var[Callable] | None = None,
        navigate_to_next_cell: Callable | Var[Callable] | None = None,
        tab_to_next_cell: Callable | Var[Callable] | None = None,
        loading_cell_renderer: Any | Var[Any] | None = None,
        loading_cell_renderer_params: LoadingCellRendererParams
        | Mapping[str, Any]
        | Var[LoadingCellRendererParams | Mapping[str, Any]]
        | None = None,
        loading_cell_renderer_selector: Callable | Var[Callable] | None = None,
        locale_text: Mapping[str, str] | Var[Mapping[str, str]] | None = None,
        get_locale_text: Callable | Var[Callable] | None = None,
        master_detail: Var[bool] | bool | None = None,
        is_row_master: Callable | Var[Callable] | None = None,
        detail_cell_renderer: Any | Var[Any] | None = None,
        detail_cell_renderer_params: Callable
        | DetailCellRendererParams
        | Mapping[str, Any]
        | Var[Callable | DetailCellRendererParams | Mapping[str, Any]]
        | None = None,
        detail_row_height: Var[int] | int | None = None,
        detail_row_auto_height: Var[bool] | bool | None = None,
        embed_full_width_rows: Var[bool] | bool | None = None,
        keep_detail_rows: Var[bool] | bool | None = None,
        keep_detail_rows_count: Var[int] | int | None = None,
        initial_state: Any | Var[Any] | None = None,
        aligned_grids: Callable
        | Sequence[Any]
        | Var[Callable | Sequence[Any]]
        | None = None,
        context: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        tab_index: Var[int] | int | None = None,
        row_buffer: Var[int] | int | None = None,
        row_number: Mapping[str, Any]
        | Var[Mapping[str, Any] | bool]
        | bool
        | None = None,
        value_cache: Var[bool] | bool | None = None,
        value_cache_never_expire: Var[bool] | bool | None = None,
        enable_cell_expressions: Var[bool] | bool | None = None,
        get_document: Callable | Var[Callable] | None = None,
        suppress_touch: Var[bool] | bool | None = None,
        drag_and_drop_image_component: Any | Var[Any] | None = None,
        suppress_focus_after_refresh: Var[bool] | bool | None = None,
        suppress_change_detection: Var[bool] | bool | None = None,
        debug: Var[bool] | bool | None = None,
        loading: Var[bool] | bool | None = None,
        overlay_loading_template: Var[str] | str | None = None,
        loading_overlay_component: Any | Var[Any] | None = None,
        loading_overlay_component_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_no_rows_overlay: Var[bool] | bool | None = None,
        overlay_no_rows_template: Var[str] | str | None = None,
        no_rows_overlay_component: Any | Var[Any] | None = None,
        no_rows_overlay_component_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        pagination: Var[bool] | bool | None = None,
        pagination_page_size: Var[int] | int | None = None,
        pagination_page_size_selector: Sequence[int]
        | Var[Sequence[int] | bool]
        | bool
        | None = None,
        pagination_number_formatter: Callable | Var[Callable] | None = None,
        pagination_auto_page_size: Var[bool] | bool | None = None,
        paginate_child_rows: Var[bool] | bool | None = None,
        suppress_pagination_panel: Var[bool] | bool | None = None,
        animate_rows: Var[bool] | bool | None = None,
        cell_flash_duration: Var[int] | int | None = None,
        cell_fade_duration: Var[int] | int | None = None,
        allow_show_change_after_filter: Var[bool] | bool | None = None,
        dom_layout: Literal["autoHeight", "normal", "print"]
        | Var[Literal["autoHeight", "normal", "print"]]
        | None = None,
        ensure_dom_order: Var[bool] | bool | None = None,
        get_business_key_for_node: Callable | Var[Callable] | None = None,
        grid_id: Var[str] | str | None = None,
        process_row_post_create: Callable | Var[Callable] | None = None,
        enable_rtl: Var[bool] | bool | None = None,
        suppress_column_virtualisation: Var[bool] | bool | None = None,
        suppress_row_virtualisation: Var[bool] | bool | None = None,
        suppress_max_rendered_row_restrictions: Var[bool] | bool | None = None,
        enable_cell_span: Var[bool] | bool | None = None,
        agg_funcs: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        group_total_row: Callable
        | Literal["bottom", "top"]
        | Var[Callable | Literal["bottom", "top"]]
        | None = None,
        grand_total_row: Literal["bottom", "top"]
        | Var[Literal["bottom", "top"]]
        | None = None,
        suppress_agg_func_in_header: Var[bool] | bool | None = None,
        aggregate_only_changed_columns: Var[bool] | bool | None = None,
        suppress_agg_filtered_only: Var[bool] | bool | None = None,
        group_agg_filtering: Var[bool] | bool | None = None,
        group_suppress_blank_header: Var[bool] | bool | None = None,
        suppress_sticky_total_row: Literal["grand", "group"]
        | Var[Literal["grand", "group"] | bool]
        | bool
        | None = None,
        always_aggregate_at_root_level: Var[bool] | bool | None = None,
        get_group_row_agg: Callable | Var[Callable] | None = None,
        row_drag_managed: Var[bool] | bool | None = None,
        row_drag_entire_row: Var[bool] | bool | None = None,
        row_drag_multi_row: Var[bool] | bool | None = None,
        suppress_row_drag: Var[bool] | bool | None = None,
        suppress_move_when_row_dragging: Var[bool] | bool | None = None,
        row_drag_text: Callable | Var[Callable] | None = None,
        full_width_cell_renderer: Any | Var[Any] | None = None,
        full_width_cell_renderer_params: FullWidthCellRendererParams
        | Mapping[str, Any]
        | Var[FullWidthCellRendererParams | Mapping[str, Any]]
        | None = None,
        group_display_type: Literal[
            "custom", "groupRows", "multipleColumns", "singleColumn"
        ]
        | Var[Literal["custom", "groupRows", "multipleColumns", "singleColumn"]]
        | None = None,
        auto_group_column_def: Any | Var[Any] | None = None,
        group_row_renderer: Any | Var[Any] | None = None,
        group_row_renderer_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        show_opened_group: Var[bool] | bool | None = None,
        group_hide_open_parents: Var[bool] | bool | None = None,
        group_hide_parent_of_single_child: Literal["leafGroupsOnly"]
        | Var[Literal["leafGroupsOnly"] | bool]
        | bool
        | None = None,
        initial_group_order_comparator: Callable | Var[Callable] | None = None,
        group_allow_unbalanced: Var[bool] | bool | None = None,
        group_maintain_order: Var[bool] | bool | None = None,
        group_default_expanded: Var[int] | int | None = None,
        is_group_open_by_default: Callable | Var[Callable] | None = None,
        suppress_group_stickiness: Var[bool] | bool | None = None,
        row_group_panel_show: Var[str] | str | None = None,
        row_group_panel_suppress_sort: Var[bool] | bool | None = None,
        group_lock_group_columns: Var[int] | int | None = None,
        suppress_group_changes_column_visibility: Var[bool] | bool | None = None,
        pinned_row_top_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        pinned_row_bottom_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        pivot_mode: Var[bool] | bool | None = None,
        pivot_panel_show: Var[str] | str | None = None,
        pivot_default_expanded: Var[int] | int | None = None,
        pivot_row_totals: Literal["after", "before"]
        | Var[Literal["after", "before"]]
        | None = None,
        pivot_suppress_auto_column: Var[bool] | bool | None = None,
        pivot_max_generated_columns: Var[int] | int | None = None,
        process_pivot_result_col_def: Callable | Var[Callable] | None = None,
        process_pivot_result_col_group_def: Callable | Var[Callable] | None = None,
        suppress_expandable_pivot_groups: Var[bool] | bool | None = None,
        functions_read_only: Var[bool] | bool | None = None,
        remove_pivot_header_row_when_single_value_column: Var[bool]
        | bool
        | None = None,
        row_model_type: Var[str] | str | None = None,
        get_row_id: Callable | Var[Callable] | None = None,
        row_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        reset_row_data_on_update: Var[bool] | bool | None = None,
        async_transaction_wait_millis: Var[int] | int | None = None,
        suppress_model_update_after_update_transaction: Var[bool] | bool | None = None,
        datasource: Datasource | Var[Datasource] | None = None,
        cache_overflow_size: Var[int] | int | None = None,
        max_concurrent_datasource_requests: Var[int] | int | None = None,
        cache_block_size: Var[int] | int | None = None,
        max_blocks_in_cache: Var[int] | int | None = None,
        infinite_initial_row_count: Var[int] | int | None = None,
        server_side_datasource: SSRMDatasource | Var[SSRMDatasource] | None = None,
        block_load_debounce_millis: Var[int] | int | None = None,
        suppress_server_side_full_width_loading_row: Var[bool] | bool | None = None,
        purge_closed_row_nodes: Var[bool] | bool | None = None,
        server_side_pivot_result_field_separator: Var[str] | str | None = None,
        server_side_sort_all_levels: Var[bool] | bool | None = None,
        server_side_enable_client_side_sort: Var[bool] | bool | None = None,
        server_side_only_refresh_filtered_groups: Var[bool] | bool | None = None,
        server_side_initial_row_count: Var[int] | int | None = None,
        get_child_count: Callable | Var[Callable] | None = None,
        get_server_side_group_level_params: Callable | Var[Callable] | None = None,
        is_server_side_group_open_by_default: Callable | Var[Callable] | None = None,
        is_apply_server_side_transaction: Callable | Var[Callable] | None = None,
        is_server_side_group: Callable | Var[Callable] | None = None,
        get_server_side_group_key: Callable | Var[Callable] | None = None,
        viewport_datasource: Any | Var[Any] | None = None,
        viewport_row_model_page_size: Var[int] | int | None = None,
        viewport_row_model_buffer_size: Var[int] | int | None = None,
        always_show_horizontal_scroll: Var[bool] | bool | None = None,
        always_show_vertical_scroll: Var[bool] | bool | None = None,
        debounce_vertical_scrollbar: Var[bool] | bool | None = None,
        suppress_horizontal_scroll: Var[bool] | bool | None = None,
        suppress_scroll_on_new_data: Var[bool] | bool | None = None,
        suppress_scroll_when_popup_are_open: Var[bool] | bool | None = None,
        suppress_animation_frame: Var[bool] | bool | None = None,
        suppress_middle_click_scroll: Var[bool] | bool | None = None,
        suppress_prevent_default_on_mouse_wheel: Var[bool] | bool | None = None,
        scrollbar_width: Var[int] | int | None = None,
        cell_selection: Var[bool | dict] | bool | dict | None = None,
        row_selection: Var[dict | str] | dict | str | None = None,
        selection_column_def: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        suppress_cell_focus: Var[bool] | bool | None = None,
        suppress_header_focus: Var[bool] | bool | None = None,
        enable_cell_text_selection: Var[bool] | bool | None = None,
        accented_sort: Var[bool] | bool | None = None,
        suppress_multi_sort: Var[bool] | bool | None = None,
        always_multi_sort: Var[bool] | bool | None = None,
        multi_sort_key: Literal["ctrl", "shift"]
        | Var[Literal["ctrl", "shift"]]
        | None = None,
        suppress_maintain_unsorted_order: Var[bool] | bool | None = None,
        post_sort_rows: Callable | Var[Callable] | None = None,
        delta_sort: Var[bool] | bool | None = None,
        icons: Mapping[str, str] | Var[Mapping[str, str]] | None = None,
        row_height: Var[int] | int | None = None,
        get_row_height: Callable | Var[Callable] | None = None,
        row_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        get_row_style: Callable | Var[Callable] | None = None,
        row_class: Sequence[str] | Var[Sequence[str] | str] | str | None = None,
        get_row_class: Callable | Var[Callable] | None = None,
        row_class_rules: Mapping[str, Callable]
        | Var[Mapping[str, Callable]]
        | None = None,
        suppress_row_hover_highlight: Var[bool] | bool | None = None,
        column_hover_highlight: Var[bool] | bool | None = None,
        theme: Literal["alpine", "balham", "material", "quartz"]
        | Var[Literal["alpine", "balham", "material", "quartz"]]
        | None = None,
        load_theme_google_fonts: Var[bool] | bool | None = None,
        theme_style_container: Any | Var[Any] | None = None,
        theme_css_layer: Var[str] | str | None = None,
        enable_browser_tooltips: Var[bool] | bool | None = None,
        tooltip_show_delay: Var[int] | int | None = None,
        tooltip_hide_delay: Var[int] | int | None = None,
        tooltip_mouse_track: Var[bool] | bool | None = None,
        tooltip_show_mode: Literal["standard", "whenTruncated"]
        | Var[Literal["standard", "whenTruncated"]]
        | None = None,
        tooltip_trigger: Literal["focus", "hover"]
        | Var[Literal["focus", "hover"]]
        | None = None,
        tooltip_interactive: Var[bool] | bool | None = None,
        tree_data: Var[bool] | bool | None = None,
        get_data_path: Callable | Var[Callable] | None = None,
        tree_data_children_field: Var[str] | str | None = None,
        suppress_group_rows_sticky: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_advanced_filter_builder_visible_changed: Optional[
            EventType[()] | EventType[AdvancedFilterBuilderVisibleChangedEvent]
        ] = None,
        on_blur: Optional[EventType[()]] = None,
        on_cell_clicked: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_context_menu: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_double_clicked: Optional[
            EventType[()] | EventType[CellEventSpec]
        ] = None,
        on_cell_focused: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_mouse_out: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_mouse_over: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_selection_changed: Optional[
            EventType[()]
            | EventType[list[dict]]
            | EventType[list[dict], bool]
            | EventType[list[dict], bool, bool]
        ] = None,
        on_cell_value_changed: Optional[
            EventType[()] | EventType[CellValueChangedEventSpec]
        ] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_column_header_clicked: Optional[
            EventType[()] | EventType[ColumnEventSpec]
        ] = None,
        on_column_header_context_menu: Optional[
            EventType[()] | EventType[ColumnEventSpec]
        ] = None,
        on_column_moved: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_column_pinned: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_column_resized: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_filter_changed: Optional[
            EventType[()] | EventType[FilterChangedEvent]
        ] = None,
        on_filter_modified: Optional[
            EventType[()] | EventType[FilterModifiedEvent]
        ] = None,
        on_filter_opened: Optional[EventType[()] | EventType[FilterOpenedEvent]] = None,
        on_filter_ui_changed: Optional[
            EventType[()] | EventType[FilterUiChangedEvent]
        ] = None,
        on_first_data_rendered: Optional[
            EventType[()] | EventType[CellEventSpec]
        ] = None,
        on_floating_filter_ui_changed: Optional[
            EventType[()] | EventType[FilterUiChangedEvent]
        ] = None,
        on_focus: Optional[EventType[()]] = None,
        on_grid_pre_destroyed: Optional[EventType[()] | EventType[dict]] = None,
        on_grid_ready: Optional[EventType[()]] = None,
        on_header_focused: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_row_clicked: Optional[EventType[()] | EventType[RowEventSpec]] = None,
        on_row_data_updated: Optional[EventType[()]] = None,
        on_row_double_clicked: Optional[EventType[()] | EventType[RowEventSpec]] = None,
        on_row_selected: Optional[
            EventType[()] | EventType[RowSelectionEventSpec]
        ] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_selection_changed: Optional[
            EventType[()]
            | EventType[list[dict]]
            | EventType[list[dict], str]
            | EventType[list[dict], str, str]
        ] = None,
        on_state_updated: Optional[EventType[()] | EventType[StateUpdatedEvent]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "WrappedAgGrid":
        """Create an instance of the AgGrid component with good default dimensions."""
        ...

class AgGridNamespace(rx.ComponentNamespace):
    api = AgGridAPI.create
    column_def = ColumnDef
    column_group = ColumnGroupDef
    filters = AGFilters
    editors = AGEditors
    aggs = AGAggregations
    renderers = AGRenderers
    status_panels = AGStatusPanels
    size_columns_to_fit = _size_columns_to_fit
    value_func_factory = staticmethod(value_func_factory)
    root = AgGrid.create

    @staticmethod
    def __call__(
        *children,
        _modules: dict[str, set[str]] | None = None,
        status_bar: Mapping[str, Any]
        | StatusPanelDef
        | Var[Mapping[str, Any] | StatusPanelDef]
        | None = None,
        side_bar: Sequence[str]
        | SideBarDef
        | Var[Sequence[str] | SideBarDef | bool | str]
        | bool
        | str
        | None = None,
        get_context_menu_items: Callable | Var[Callable] | None = None,
        suppress_context_menu: Var[bool] | bool | None = None,
        prevent_default_on_context_menu: Var[bool] | bool | None = None,
        allow_context_menu_with_control_key: Var[bool] | bool | None = None,
        column_menu: Literal["legacy", "new"]
        | Var[Literal["legacy", "new"]]
        | None = None,
        suppress_menu_hide: Var[bool] | bool | None = None,
        copy_headers_to_clipboard: Var[bool] | bool | None = None,
        copy_group_headers_to_clipboard: Var[bool] | bool | None = None,
        clipboard_delimiter: Var[str] | str | None = None,
        suppress_cut_to_clipboard: Var[bool] | bool | None = None,
        suppress_last_empty_line_on_paste: Var[bool] | bool | None = None,
        suppress_clipboard_paste: Var[bool] | bool | None = None,
        suppress_clipboard_api: Var[bool] | bool | None = None,
        process_cell_for_clipboard: Callable | Var[Callable] | None = None,
        process_header_for_clipboard: Callable | Var[Callable] | None = None,
        process_group_header_for_clipboard: Callable | Var[Callable] | None = None,
        process_cell_from_clipboard: Callable | Var[Callable] | None = None,
        send_to_clipboard: Callable | Var[Callable] | None = None,
        process_data_from_clipboard: Callable | Var[Callable] | None = None,
        column_defs: Sequence[ColumnDef | ColumnGroupDef]
        | Sequence[Mapping[str, Any]]
        | Var[Sequence[ColumnDef | ColumnGroupDef] | Sequence[Mapping[str, Any]]]
        | None = None,
        default_col_def: Mapping[str, Any]
        | Var[Mapping[str, Any] | None]
        | None = None,
        default_col_group_def: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        column_types: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        data_types_definitions: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        maintain_column_order: Var[bool] | bool | None = None,
        enable_strict_pivot_column_order: Var[bool] | bool | None = None,
        suppress_field_dot_notation: Var[bool] | bool | None = None,
        header_height: Var[int] | int | None = None,
        group_header_height: Var[int] | int | None = None,
        floating_filters_height: Var[int] | int | None = None,
        pivot_header_height: Var[int] | int | None = None,
        pivot_group_header_height: Var[int] | int | None = None,
        allow_drag_from_columns_tool_panel: Var[bool] | bool | None = None,
        suppress_movable_columns: Var[bool] | bool | None = None,
        suppress_move_when_column_dragging: Var[bool] | bool | None = None,
        suppress_column_move_animation: Var[bool] | bool | None = None,
        suppress_drag_leave_hides_columns: Var[bool] | bool | None = None,
        process_unpinned_columns: Callable | Var[Callable] | None = None,
        col_resize_default: Var[str] | str | None = None,
        auto_size_strategy: Var[dict] | dict | None = None,
        suppress_auto_size: Var[bool] | bool | None = None,
        auto_size_padding: Var[int] | int | None = None,
        skip_header_on_auto_size: Var[bool] | bool | None = None,
        components: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        edit_type: Var[str] | str | None = None,
        single_click_edit: Var[bool] | bool | None = None,
        suppress_click_edit: Var[bool] | bool | None = None,
        stop_edit_when_cell_loses_focus: Var[bool] | bool | None = None,
        enter_navigate_vertically: Var[bool] | bool | None = None,
        enter_navigate_vertically_after_edit: Var[bool] | bool | None = None,
        enable_cell_editing_on_backspace: Var[bool] | bool | None = None,
        undo_redo_cell_editing: Var[bool] | bool | None = None,
        undo_redo_cell_editing_limit: Var[int] | int | None = None,
        read_only_edit: Var[bool] | bool | None = None,
        default_csv_export_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_csv_export: Var[bool] | bool | None = None,
        default_excel_export_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_excel_export: Var[bool] | bool | None = None,
        excel_styles: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        quick_filter_text: Var[str] | str | None = None,
        cache_quick_filter: Var[bool] | bool | None = None,
        include_hidden_columns_in_quick_filter: Var[bool] | bool | None = None,
        quick_filter_parser: Callable | Var[Callable] | None = None,
        quick_filter_matcher: Callable | Var[Callable] | None = None,
        apply_quick_filter_before_pivot_or_agg: Var[bool] | bool | None = None,
        is_external_filter_present: Callable | Var[Callable] | None = None,
        does_external_filter_pass: Callable | Var[Callable] | None = None,
        exclude_children_when_tree_data_filtering: Var[bool] | bool | None = None,
        suppress_set_filter_by_default: Var[bool] | bool | None = None,
        enable_advanced_filter: Var[bool] | bool | None = None,
        include_hidden_columns_in_advanced_filter: Var[bool] | bool | None = None,
        advanced_filter_parent: Any | Var[Any] | None = None,
        advanced_filter_built_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        always_pass_filter: Callable | Var[Callable] | None = None,
        enable_charts: Var[bool] | bool | None = None,
        get_chart_toolbar_items: Callable | Var[Callable] | None = None,
        create_chart_container: Callable | Var[Callable] | None = None,
        chart_themes: Sequence[str] | Var[Sequence[str]] | None = None,
        custom_chart_themes: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_theme_overrides: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_tool_panel_defs: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        chart_menu_items: Callable | Var[Callable] | None = None,
        focus_grid_inner_elements: Callable | Var[Callable] | None = None,
        navigate_to_next_header: Callable | Var[Callable] | None = None,
        tab_to_next_header: Callable | Var[Callable] | None = None,
        navigate_to_next_cell: Callable | Var[Callable] | None = None,
        tab_to_next_cell: Callable | Var[Callable] | None = None,
        loading_cell_renderer: Any | Var[Any] | None = None,
        loading_cell_renderer_params: LoadingCellRendererParams
        | Mapping[str, Any]
        | Var[LoadingCellRendererParams | Mapping[str, Any]]
        | None = None,
        loading_cell_renderer_selector: Callable | Var[Callable] | None = None,
        locale_text: Mapping[str, str] | Var[Mapping[str, str]] | None = None,
        get_locale_text: Callable | Var[Callable] | None = None,
        master_detail: Var[bool] | bool | None = None,
        is_row_master: Callable | Var[Callable] | None = None,
        detail_cell_renderer: Any | Var[Any] | None = None,
        detail_cell_renderer_params: Callable
        | DetailCellRendererParams
        | Mapping[str, Any]
        | Var[Callable | DetailCellRendererParams | Mapping[str, Any]]
        | None = None,
        detail_row_height: Var[int] | int | None = None,
        detail_row_auto_height: Var[bool] | bool | None = None,
        embed_full_width_rows: Var[bool] | bool | None = None,
        keep_detail_rows: Var[bool] | bool | None = None,
        keep_detail_rows_count: Var[int] | int | None = None,
        initial_state: Any | Var[Any] | None = None,
        aligned_grids: Callable
        | Sequence[Any]
        | Var[Callable | Sequence[Any]]
        | None = None,
        context: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        tab_index: Var[int] | int | None = None,
        row_buffer: Var[int] | int | None = None,
        row_number: Mapping[str, Any]
        | Var[Mapping[str, Any] | bool]
        | bool
        | None = None,
        value_cache: Var[bool] | bool | None = None,
        value_cache_never_expire: Var[bool] | bool | None = None,
        enable_cell_expressions: Var[bool] | bool | None = None,
        get_document: Callable | Var[Callable] | None = None,
        suppress_touch: Var[bool] | bool | None = None,
        drag_and_drop_image_component: Any | Var[Any] | None = None,
        suppress_focus_after_refresh: Var[bool] | bool | None = None,
        suppress_change_detection: Var[bool] | bool | None = None,
        debug: Var[bool] | bool | None = None,
        loading: Var[bool] | bool | None = None,
        overlay_loading_template: Var[str] | str | None = None,
        loading_overlay_component: Any | Var[Any] | None = None,
        loading_overlay_component_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        suppress_no_rows_overlay: Var[bool] | bool | None = None,
        overlay_no_rows_template: Var[str] | str | None = None,
        no_rows_overlay_component: Any | Var[Any] | None = None,
        no_rows_overlay_component_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        pagination: Var[bool] | bool | None = None,
        pagination_page_size: Var[int] | int | None = None,
        pagination_page_size_selector: Sequence[int]
        | Var[Sequence[int] | bool]
        | bool
        | None = None,
        pagination_number_formatter: Callable | Var[Callable] | None = None,
        pagination_auto_page_size: Var[bool] | bool | None = None,
        paginate_child_rows: Var[bool] | bool | None = None,
        suppress_pagination_panel: Var[bool] | bool | None = None,
        animate_rows: Var[bool] | bool | None = None,
        cell_flash_duration: Var[int] | int | None = None,
        cell_fade_duration: Var[int] | int | None = None,
        allow_show_change_after_filter: Var[bool] | bool | None = None,
        dom_layout: Literal["autoHeight", "normal", "print"]
        | Var[Literal["autoHeight", "normal", "print"]]
        | None = None,
        ensure_dom_order: Var[bool] | bool | None = None,
        get_business_key_for_node: Callable | Var[Callable] | None = None,
        grid_id: Var[str] | str | None = None,
        process_row_post_create: Callable | Var[Callable] | None = None,
        enable_rtl: Var[bool] | bool | None = None,
        suppress_column_virtualisation: Var[bool] | bool | None = None,
        suppress_row_virtualisation: Var[bool] | bool | None = None,
        suppress_max_rendered_row_restrictions: Var[bool] | bool | None = None,
        enable_cell_span: Var[bool] | bool | None = None,
        agg_funcs: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        group_total_row: Callable
        | Literal["bottom", "top"]
        | Var[Callable | Literal["bottom", "top"]]
        | None = None,
        grand_total_row: Literal["bottom", "top"]
        | Var[Literal["bottom", "top"]]
        | None = None,
        suppress_agg_func_in_header: Var[bool] | bool | None = None,
        aggregate_only_changed_columns: Var[bool] | bool | None = None,
        suppress_agg_filtered_only: Var[bool] | bool | None = None,
        group_agg_filtering: Var[bool] | bool | None = None,
        group_suppress_blank_header: Var[bool] | bool | None = None,
        suppress_sticky_total_row: Literal["grand", "group"]
        | Var[Literal["grand", "group"] | bool]
        | bool
        | None = None,
        always_aggregate_at_root_level: Var[bool] | bool | None = None,
        get_group_row_agg: Callable | Var[Callable] | None = None,
        row_drag_managed: Var[bool] | bool | None = None,
        row_drag_entire_row: Var[bool] | bool | None = None,
        row_drag_multi_row: Var[bool] | bool | None = None,
        suppress_row_drag: Var[bool] | bool | None = None,
        suppress_move_when_row_dragging: Var[bool] | bool | None = None,
        row_drag_text: Callable | Var[Callable] | None = None,
        full_width_cell_renderer: Any | Var[Any] | None = None,
        full_width_cell_renderer_params: FullWidthCellRendererParams
        | Mapping[str, Any]
        | Var[FullWidthCellRendererParams | Mapping[str, Any]]
        | None = None,
        group_display_type: Literal[
            "custom", "groupRows", "multipleColumns", "singleColumn"
        ]
        | Var[Literal["custom", "groupRows", "multipleColumns", "singleColumn"]]
        | None = None,
        auto_group_column_def: Any | Var[Any] | None = None,
        group_row_renderer: Any | Var[Any] | None = None,
        group_row_renderer_params: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        show_opened_group: Var[bool] | bool | None = None,
        group_hide_open_parents: Var[bool] | bool | None = None,
        group_hide_parent_of_single_child: Literal["leafGroupsOnly"]
        | Var[Literal["leafGroupsOnly"] | bool]
        | bool
        | None = None,
        initial_group_order_comparator: Callable | Var[Callable] | None = None,
        group_allow_unbalanced: Var[bool] | bool | None = None,
        group_maintain_order: Var[bool] | bool | None = None,
        group_default_expanded: Var[int] | int | None = None,
        is_group_open_by_default: Callable | Var[Callable] | None = None,
        suppress_group_stickiness: Var[bool] | bool | None = None,
        row_group_panel_show: Var[str] | str | None = None,
        row_group_panel_suppress_sort: Var[bool] | bool | None = None,
        group_lock_group_columns: Var[int] | int | None = None,
        suppress_group_changes_column_visibility: Var[bool] | bool | None = None,
        pinned_row_top_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        pinned_row_bottom_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        pivot_mode: Var[bool] | bool | None = None,
        pivot_panel_show: Var[str] | str | None = None,
        pivot_default_expanded: Var[int] | int | None = None,
        pivot_row_totals: Literal["after", "before"]
        | Var[Literal["after", "before"]]
        | None = None,
        pivot_suppress_auto_column: Var[bool] | bool | None = None,
        pivot_max_generated_columns: Var[int] | int | None = None,
        process_pivot_result_col_def: Callable | Var[Callable] | None = None,
        process_pivot_result_col_group_def: Callable | Var[Callable] | None = None,
        suppress_expandable_pivot_groups: Var[bool] | bool | None = None,
        functions_read_only: Var[bool] | bool | None = None,
        remove_pivot_header_row_when_single_value_column: Var[bool]
        | bool
        | None = None,
        row_model_type: Var[str] | str | None = None,
        get_row_id: Callable | Var[Callable] | None = None,
        row_data: Sequence[Mapping[str, Any]]
        | Var[Sequence[Mapping[str, Any]]]
        | None = None,
        reset_row_data_on_update: Var[bool] | bool | None = None,
        async_transaction_wait_millis: Var[int] | int | None = None,
        suppress_model_update_after_update_transaction: Var[bool] | bool | None = None,
        datasource: Datasource | Var[Datasource] | None = None,
        cache_overflow_size: Var[int] | int | None = None,
        max_concurrent_datasource_requests: Var[int] | int | None = None,
        cache_block_size: Var[int] | int | None = None,
        max_blocks_in_cache: Var[int] | int | None = None,
        infinite_initial_row_count: Var[int] | int | None = None,
        server_side_datasource: SSRMDatasource | Var[SSRMDatasource] | None = None,
        block_load_debounce_millis: Var[int] | int | None = None,
        suppress_server_side_full_width_loading_row: Var[bool] | bool | None = None,
        purge_closed_row_nodes: Var[bool] | bool | None = None,
        server_side_pivot_result_field_separator: Var[str] | str | None = None,
        server_side_sort_all_levels: Var[bool] | bool | None = None,
        server_side_enable_client_side_sort: Var[bool] | bool | None = None,
        server_side_only_refresh_filtered_groups: Var[bool] | bool | None = None,
        server_side_initial_row_count: Var[int] | int | None = None,
        get_child_count: Callable | Var[Callable] | None = None,
        get_server_side_group_level_params: Callable | Var[Callable] | None = None,
        is_server_side_group_open_by_default: Callable | Var[Callable] | None = None,
        is_apply_server_side_transaction: Callable | Var[Callable] | None = None,
        is_server_side_group: Callable | Var[Callable] | None = None,
        get_server_side_group_key: Callable | Var[Callable] | None = None,
        viewport_datasource: Any | Var[Any] | None = None,
        viewport_row_model_page_size: Var[int] | int | None = None,
        viewport_row_model_buffer_size: Var[int] | int | None = None,
        always_show_horizontal_scroll: Var[bool] | bool | None = None,
        always_show_vertical_scroll: Var[bool] | bool | None = None,
        debounce_vertical_scrollbar: Var[bool] | bool | None = None,
        suppress_horizontal_scroll: Var[bool] | bool | None = None,
        suppress_scroll_on_new_data: Var[bool] | bool | None = None,
        suppress_scroll_when_popup_are_open: Var[bool] | bool | None = None,
        suppress_animation_frame: Var[bool] | bool | None = None,
        suppress_middle_click_scroll: Var[bool] | bool | None = None,
        suppress_prevent_default_on_mouse_wheel: Var[bool] | bool | None = None,
        scrollbar_width: Var[int] | int | None = None,
        cell_selection: Var[bool | dict] | bool | dict | None = None,
        row_selection: Var[dict | str] | dict | str | None = None,
        selection_column_def: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        suppress_cell_focus: Var[bool] | bool | None = None,
        suppress_header_focus: Var[bool] | bool | None = None,
        enable_cell_text_selection: Var[bool] | bool | None = None,
        accented_sort: Var[bool] | bool | None = None,
        suppress_multi_sort: Var[bool] | bool | None = None,
        always_multi_sort: Var[bool] | bool | None = None,
        multi_sort_key: Literal["ctrl", "shift"]
        | Var[Literal["ctrl", "shift"]]
        | None = None,
        suppress_maintain_unsorted_order: Var[bool] | bool | None = None,
        post_sort_rows: Callable | Var[Callable] | None = None,
        delta_sort: Var[bool] | bool | None = None,
        icons: Mapping[str, str] | Var[Mapping[str, str]] | None = None,
        row_height: Var[int] | int | None = None,
        get_row_height: Callable | Var[Callable] | None = None,
        row_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        get_row_style: Callable | Var[Callable] | None = None,
        row_class: Sequence[str] | Var[Sequence[str] | str] | str | None = None,
        get_row_class: Callable | Var[Callable] | None = None,
        row_class_rules: Mapping[str, Callable]
        | Var[Mapping[str, Callable]]
        | None = None,
        suppress_row_hover_highlight: Var[bool] | bool | None = None,
        column_hover_highlight: Var[bool] | bool | None = None,
        theme: Literal["alpine", "balham", "material", "quartz"]
        | Var[Literal["alpine", "balham", "material", "quartz"]]
        | None = None,
        load_theme_google_fonts: Var[bool] | bool | None = None,
        theme_style_container: Any | Var[Any] | None = None,
        theme_css_layer: Var[str] | str | None = None,
        enable_browser_tooltips: Var[bool] | bool | None = None,
        tooltip_show_delay: Var[int] | int | None = None,
        tooltip_hide_delay: Var[int] | int | None = None,
        tooltip_mouse_track: Var[bool] | bool | None = None,
        tooltip_show_mode: Literal["standard", "whenTruncated"]
        | Var[Literal["standard", "whenTruncated"]]
        | None = None,
        tooltip_trigger: Literal["focus", "hover"]
        | Var[Literal["focus", "hover"]]
        | None = None,
        tooltip_interactive: Var[bool] | bool | None = None,
        tree_data: Var[bool] | bool | None = None,
        get_data_path: Callable | Var[Callable] | None = None,
        tree_data_children_field: Var[str] | str | None = None,
        suppress_group_rows_sticky: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_advanced_filter_builder_visible_changed: Optional[
            EventType[()] | EventType[AdvancedFilterBuilderVisibleChangedEvent]
        ] = None,
        on_blur: Optional[EventType[()]] = None,
        on_cell_clicked: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_context_menu: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_double_clicked: Optional[
            EventType[()] | EventType[CellEventSpec]
        ] = None,
        on_cell_focused: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_mouse_out: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_mouse_over: Optional[EventType[()] | EventType[CellEventSpec]] = None,
        on_cell_selection_changed: Optional[
            EventType[()]
            | EventType[list[dict]]
            | EventType[list[dict], bool]
            | EventType[list[dict], bool, bool]
        ] = None,
        on_cell_value_changed: Optional[
            EventType[()] | EventType[CellValueChangedEventSpec]
        ] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_column_header_clicked: Optional[
            EventType[()] | EventType[ColumnEventSpec]
        ] = None,
        on_column_header_context_menu: Optional[
            EventType[()] | EventType[ColumnEventSpec]
        ] = None,
        on_column_moved: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_column_pinned: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_column_resized: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_filter_changed: Optional[
            EventType[()] | EventType[FilterChangedEvent]
        ] = None,
        on_filter_modified: Optional[
            EventType[()] | EventType[FilterModifiedEvent]
        ] = None,
        on_filter_opened: Optional[EventType[()] | EventType[FilterOpenedEvent]] = None,
        on_filter_ui_changed: Optional[
            EventType[()] | EventType[FilterUiChangedEvent]
        ] = None,
        on_first_data_rendered: Optional[
            EventType[()] | EventType[CellEventSpec]
        ] = None,
        on_floating_filter_ui_changed: Optional[
            EventType[()] | EventType[FilterUiChangedEvent]
        ] = None,
        on_focus: Optional[EventType[()]] = None,
        on_grid_pre_destroyed: Optional[EventType[()] | EventType[dict]] = None,
        on_grid_ready: Optional[EventType[()]] = None,
        on_header_focused: Optional[EventType[()] | EventType[ColumnEventSpec]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_row_clicked: Optional[EventType[()] | EventType[RowEventSpec]] = None,
        on_row_data_updated: Optional[EventType[()]] = None,
        on_row_double_clicked: Optional[EventType[()] | EventType[RowEventSpec]] = None,
        on_row_selected: Optional[
            EventType[()] | EventType[RowSelectionEventSpec]
        ] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_selection_changed: Optional[
            EventType[()]
            | EventType[list[dict]]
            | EventType[list[dict], str]
            | EventType[list[dict], str, str]
        ] = None,
        on_state_updated: Optional[EventType[()] | EventType[StateUpdatedEvent]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "WrappedAgGrid":
        """Create an instance of the AgGrid component with good default dimensions."""
        ...

ag_grid = AgGridNamespace()
