"""Stub file for reflex_enterprise/components/dnd/dnd.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from typing import (
    Any,
    Callable,
    ClassVar,
    Literal,
    Mapping,
    Optional,
    Sequence,
    TypedDict,
    TypeVar,
)

import reflex as rx
from reflex.components.component import MemoizationLeaf
from reflex.components.core.breakpoints import Breakpoints
from reflex.components.el.elements import Div
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var, VarData

from reflex_enterprise.components.component import ComponentEnterprise
from reflex_enterprise.vars import static

JsObj = Mapping[str, Any] | Var[Mapping[str, Any]] | None
ITEM_T = TypeVar("ITEM_T", bound=JsObj)
COLLECT_PARAMS_T = TypeVar(
    "COLLECT_PARAMS_T", bound=rx.vars.ObjectVar[Mapping[str, Any]]
)
ANY_TYPE = Var.create("Any")
DEP_ARRAY = Var.create(["DEP_ARRAY"])
USE_DRAG = "useDrag"
_use_drag = rx.vars.FunctionStringVar(
    _js_expr=USE_DRAG, _var_data=VarData(imports={"react-dnd": [USE_DRAG]})
)
USE_DROP = "useDrop"
_use_drop = rx.vars.FunctionStringVar(
    _js_expr=USE_DROP, _var_data=VarData(imports={"react-dnd": [USE_DROP]})
)
HTML5_BACKEND = "HTML5Backend"
HTML5Backend = Var(
    HTML5_BACKEND,
    _var_data=VarData(imports={"react-dnd-html5-backend": [HTML5_BACKEND]}),
)
TOUCH_BACKEND = "TouchBackend"
TouchBackend = Var(
    TOUCH_BACKEND,
    _var_data=VarData(imports={"react-dnd-touch-backend": [TOUCH_BACKEND]}),
)

class DnDProvider(ComponentEnterprise):
    @classmethod
    def create(
        cls,
        *children,
        backend: Var[str] | str | None = None,
        context: Var[dict[str, Any]] | dict[str, Any] | None = None,
        options: Var[dict[str, Any]] | dict[str, Any] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "DnDProvider":
        """Create the Reflex Enterprise component."""
        ...

class BaseDnDDiv(Div, MemoizationLeaf):
    @classmethod
    def create(
        cls,
        *children,
        access_key: Var[str] | str | None = None,
        auto_capitalize: Literal[
            "characters", "none", "off", "on", "sentences", "words"
        ]
        | Var[Literal["characters", "none", "off", "on", "sentences", "words"]]
        | None = None,
        content_editable: Literal["inherit", "plaintext-only", False, True]
        | Var[Literal["inherit", "plaintext-only", False, True]]
        | None = None,
        context_menu: Var[str] | str | None = None,
        dir: Var[str] | str | None = None,
        draggable: Var[bool] | bool | None = None,
        enter_key_hint: Literal[
            "done", "enter", "go", "next", "previous", "search", "send"
        ]
        | Var[Literal["done", "enter", "go", "next", "previous", "search", "send"]]
        | None = None,
        hidden: Var[bool] | bool | None = None,
        input_mode: Literal[
            "decimal", "email", "none", "numeric", "search", "tel", "text", "url"
        ]
        | Var[
            Literal[
                "decimal", "email", "none", "numeric", "search", "tel", "text", "url"
            ]
        ]
        | None = None,
        item_prop: Var[str] | str | None = None,
        lang: Var[str] | str | None = None,
        role: Literal[
            "alert",
            "alertdialog",
            "application",
            "article",
            "banner",
            "button",
            "cell",
            "checkbox",
            "columnheader",
            "combobox",
            "complementary",
            "contentinfo",
            "definition",
            "dialog",
            "directory",
            "document",
            "feed",
            "figure",
            "form",
            "grid",
            "gridcell",
            "group",
            "heading",
            "img",
            "link",
            "list",
            "listbox",
            "listitem",
            "log",
            "main",
            "marquee",
            "math",
            "menu",
            "menubar",
            "menuitem",
            "menuitemcheckbox",
            "menuitemradio",
            "navigation",
            "none",
            "note",
            "option",
            "presentation",
            "progressbar",
            "radio",
            "radiogroup",
            "region",
            "row",
            "rowgroup",
            "rowheader",
            "scrollbar",
            "search",
            "searchbox",
            "separator",
            "slider",
            "spinbutton",
            "status",
            "switch",
            "tab",
            "table",
            "tablist",
            "tabpanel",
            "term",
            "textbox",
            "timer",
            "toolbar",
            "tooltip",
            "tree",
            "treegrid",
            "treeitem",
        ]
        | Var[
            Literal[
                "alert",
                "alertdialog",
                "application",
                "article",
                "banner",
                "button",
                "cell",
                "checkbox",
                "columnheader",
                "combobox",
                "complementary",
                "contentinfo",
                "definition",
                "dialog",
                "directory",
                "document",
                "feed",
                "figure",
                "form",
                "grid",
                "gridcell",
                "group",
                "heading",
                "img",
                "link",
                "list",
                "listbox",
                "listitem",
                "log",
                "main",
                "marquee",
                "math",
                "menu",
                "menubar",
                "menuitem",
                "menuitemcheckbox",
                "menuitemradio",
                "navigation",
                "none",
                "note",
                "option",
                "presentation",
                "progressbar",
                "radio",
                "radiogroup",
                "region",
                "row",
                "rowgroup",
                "rowheader",
                "scrollbar",
                "search",
                "searchbox",
                "separator",
                "slider",
                "spinbutton",
                "status",
                "switch",
                "tab",
                "table",
                "tablist",
                "tabpanel",
                "term",
                "textbox",
                "timer",
                "toolbar",
                "tooltip",
                "tree",
                "treegrid",
                "treeitem",
            ]
        ]
        | None = None,
        slot: Var[str] | str | None = None,
        spell_check: Var[bool] | bool | None = None,
        tab_index: Var[int] | int | None = None,
        title: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "BaseDnDDiv":
        """Create a new memoization leaf component.

        Args:
            *children: The children of the component.
            access_key: Provides a hint for generating a keyboard shortcut for the current element.
            auto_capitalize: Controls whether and how text input is automatically capitalized as it is entered/edited by the user.
            content_editable: Indicates whether the element's content is editable.
            context_menu: Defines the ID of a <menu> element which will serve as the element's context menu.
            dir: Defines the text direction. Allowed values are ltr (Left-To-Right) or rtl (Right-To-Left)
            draggable: Defines whether the element can be dragged.
            enter_key_hint: Hints what media types the media element is able to play.
            hidden: Defines whether the element is hidden.
            input_mode: Defines the type of the element.
            item_prop: Defines the name of the element for metadata purposes.
            lang: Defines the language used in the element.
            role: Defines the role of the element.
            slot: Assigns a slot in a shadow DOM shadow tree to an element.
            spell_check: Defines whether the element may be checked for spelling errors.
            tab_index: Defines the position of the current element in the tabbing order.
            title: Defines a tooltip for the element.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The memoization leaf
        """
        ...

class MonitorBase(Var):
    def get_item_type(self) -> rx.vars.StringVar | Var[None]: ...
    def get_item(self) -> rx.vars.ObjectVar[dict[str, Any]] | Var[None]: ...
    def get_drop_result(self) -> rx.Var: ...
    def did_drop(self) -> rx.vars.BooleanVar: ...
    def get_initial_client_offset(
        self,
    ) -> rx.vars.ObjectVar[dict[str, int]] | Var[None]: ...
    def get_initial_source_client_offset(
        self,
    ) -> rx.vars.ObjectVar[dict[str, int]] | Var[None]: ...
    def get_client_offset(self) -> rx.vars.ObjectVar[dict[str, int]] | Var[None]: ...
    def get_difference_from_initial_offset(
        self,
    ) -> rx.vars.ObjectVar[dict[str, int]] | Var[None]: ...
    def get_source_client_offset(
        self,
    ) -> rx.vars.ObjectVar[dict[str, int]] | Var[None]: ...

class DragSourceMonitor(MonitorBase):
    def can_drag(self) -> rx.vars.BooleanVar: ...
    def is_dragging(self) -> rx.vars.BooleanVar: ...

class DropTargetMonitor(MonitorBase):
    def can_drop(self) -> rx.vars.BooleanVar: ...
    def is_over(
        self, options: rx.vars.ObjectVar[dict[str, Any]] = Var.create({})
    ) -> rx.vars.BooleanVar: ...

def use_drag(
    type: str | Var[str],
    item: ITEM_T | Callable[[DragSourceMonitor], ITEM_T] = None,
    preview_options: JsObj = None,
    options: JsObj = None,
    end: Callable[[ITEM_T, DragSourceMonitor], None]
    | Var[Callable[[ITEM_T, DragSourceMonitor], None]]
    | None = None,
    can_drag: Callable[[DragSourceMonitor], bool | Var[bool]]
    | Var[Callable[[DragSourceMonitor], bool | Var[bool]]]
    | None = None,
    is_dragging: Callable[[DragSourceMonitor], bool | Var[bool]]
    | Var[Callable[[DragSourceMonitor], bool | Var[bool]]]
    | None = None,
    collect: Callable[[DragSourceMonitor], COLLECT_PARAMS_T]
    | Var[Callable[[DragSourceMonitor], COLLECT_PARAMS_T]]
    | None = None,
    _collected_params: Var[COLLECT_PARAMS_T] | None = None,
    _drag_ref: Var | None = None,
    _drag_preview_ref: Var | None = None,
) -> tuple[COLLECT_PARAMS_T, rx.Var, rx.Var]: ...

class Draggable(BaseDnDDiv):
    @classmethod
    def create(
        cls,
        *children,
        type: Var[str] | str | None = None,
        item: Callable[
            [DragSourceMonitor],
            Mapping[str, Any] | Mapping[str, Any] | Var[Mapping[str, Any]] | None,
        ]
        | Mapping[str, Any]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Var[
            Callable[
                [DragSourceMonitor],
                Mapping[str, Any] | Mapping[str, Any] | Var[Mapping[str, Any]] | None,
            ]
            | Mapping[str, Any]
            | Mapping[str, Any]
            | Var[Mapping[str, Any]]
            | None
        ]
        | None = None,
        preview_options: Mapping[str, Any]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Var[Mapping[str, Any] | Mapping[str, Any] | Var[Mapping[str, Any]] | None]
        | None = None,
        options: Mapping[str, Any]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Var[Mapping[str, Any] | Mapping[str, Any] | Var[Mapping[str, Any]] | None]
        | None = None,
        drag_ref: Any | Var[Any] | None = None,
        drag_preview_ref: Any | Var[Any] | None = None,
        end: Callable[
            [
                Mapping[str, Any] | Mapping[str, Any] | Var[Mapping[str, Any]] | None,
                DragSourceMonitor,
            ]
        ]
        | Var[
            Callable[
                [
                    Mapping[str, Any]
                    | Mapping[str, Any]
                    | Var[Mapping[str, Any]]
                    | None,
                    DragSourceMonitor,
                ]
            ]
        ]
        | None = None,
        can_drag: Callable[[DragSourceMonitor], Var[bool] | bool | bool]
        | Var[Callable[[DragSourceMonitor], Var[bool] | bool | bool]]
        | None = None,
        is_dragging: Callable[[DragSourceMonitor], Var[bool] | bool | bool]
        | Var[Callable[[DragSourceMonitor], Var[bool] | bool | bool]]
        | None = None,
        collect: Callable[
            [DragSourceMonitor],
            Mapping[str, Any] | Mapping[str, Any] | Var[Mapping[str, Any]] | None,
        ]
        | Var[
            Callable[
                [DragSourceMonitor],
                Mapping[str, Any] | Mapping[str, Any] | Var[Mapping[str, Any]] | None,
            ]
        ]
        | None = None,
        access_key: Var[str] | str | None = None,
        auto_capitalize: Literal[
            "characters", "none", "off", "on", "sentences", "words"
        ]
        | Var[Literal["characters", "none", "off", "on", "sentences", "words"]]
        | None = None,
        content_editable: Literal["inherit", "plaintext-only", False, True]
        | Var[Literal["inherit", "plaintext-only", False, True]]
        | None = None,
        context_menu: Var[str] | str | None = None,
        dir: Var[str] | str | None = None,
        draggable: Var[bool] | bool | None = None,
        enter_key_hint: Literal[
            "done", "enter", "go", "next", "previous", "search", "send"
        ]
        | Var[Literal["done", "enter", "go", "next", "previous", "search", "send"]]
        | None = None,
        hidden: Var[bool] | bool | None = None,
        input_mode: Literal[
            "decimal", "email", "none", "numeric", "search", "tel", "text", "url"
        ]
        | Var[
            Literal[
                "decimal", "email", "none", "numeric", "search", "tel", "text", "url"
            ]
        ]
        | None = None,
        item_prop: Var[str] | str | None = None,
        lang: Var[str] | str | None = None,
        role: Literal[
            "alert",
            "alertdialog",
            "application",
            "article",
            "banner",
            "button",
            "cell",
            "checkbox",
            "columnheader",
            "combobox",
            "complementary",
            "contentinfo",
            "definition",
            "dialog",
            "directory",
            "document",
            "feed",
            "figure",
            "form",
            "grid",
            "gridcell",
            "group",
            "heading",
            "img",
            "link",
            "list",
            "listbox",
            "listitem",
            "log",
            "main",
            "marquee",
            "math",
            "menu",
            "menubar",
            "menuitem",
            "menuitemcheckbox",
            "menuitemradio",
            "navigation",
            "none",
            "note",
            "option",
            "presentation",
            "progressbar",
            "radio",
            "radiogroup",
            "region",
            "row",
            "rowgroup",
            "rowheader",
            "scrollbar",
            "search",
            "searchbox",
            "separator",
            "slider",
            "spinbutton",
            "status",
            "switch",
            "tab",
            "table",
            "tablist",
            "tabpanel",
            "term",
            "textbox",
            "timer",
            "toolbar",
            "tooltip",
            "tree",
            "treegrid",
            "treeitem",
        ]
        | Var[
            Literal[
                "alert",
                "alertdialog",
                "application",
                "article",
                "banner",
                "button",
                "cell",
                "checkbox",
                "columnheader",
                "combobox",
                "complementary",
                "contentinfo",
                "definition",
                "dialog",
                "directory",
                "document",
                "feed",
                "figure",
                "form",
                "grid",
                "gridcell",
                "group",
                "heading",
                "img",
                "link",
                "list",
                "listbox",
                "listitem",
                "log",
                "main",
                "marquee",
                "math",
                "menu",
                "menubar",
                "menuitem",
                "menuitemcheckbox",
                "menuitemradio",
                "navigation",
                "none",
                "note",
                "option",
                "presentation",
                "progressbar",
                "radio",
                "radiogroup",
                "region",
                "row",
                "rowgroup",
                "rowheader",
                "scrollbar",
                "search",
                "searchbox",
                "separator",
                "slider",
                "spinbutton",
                "status",
                "switch",
                "tab",
                "table",
                "tablist",
                "tabpanel",
                "term",
                "textbox",
                "timer",
                "toolbar",
                "tooltip",
                "tree",
                "treegrid",
                "treeitem",
            ]
        ]
        | None = None,
        slot: Var[str] | str | None = None,
        spell_check: Var[bool] | bool | None = None,
        tab_index: Var[int] | int | None = None,
        title: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_end: Optional[EventType[()] | EventType[dict[str, Any]]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "Draggable":
        """Create a Draggable component.

        Will use the `collect_hook` to collect the params if
        not provided, which is represented by the `Draggable.CollectedParams`
        type and accessed via `Draggable.collected_params`.
        """
        ...

    class CollectedParams(TypedDict):
        is_dragging: bool
        can_drag: bool

    @staticmethod
    @static
    def collect_hook(
        monitor: DragSourceMonitor,
    ) -> rx.Var[Draggable.CollectedParams]: ...
    collected_params: ClassVar[rx.vars.ObjectVar[Draggable.CollectedParams]] = (
        rx.vars.ObjectVar("draggableCollectedParams", _var_type=CollectedParams)
    )

def use_drop(
    accept: str | Var[str],
    options: JsObj = None,
    drop: Callable[[dict[str, Any], DropTargetMonitor], None]
    | Var[Callable[[dict[str, Any], DropTargetMonitor], None]]
    | None = None,
    hover: Callable[[dict[str, Any], DropTargetMonitor], None]
    | Var[Callable[[dict[str, Any], DropTargetMonitor], None]]
    | None = None,
    can_drop: Callable[[DropTargetMonitor], bool | Var[bool]]
    | Var[Callable[[DropTargetMonitor], bool | Var[bool]]]
    | None = None,
    collect: Callable[[DropTargetMonitor], COLLECT_PARAMS_T]
    | Var[Callable[[DropTargetMonitor], COLLECT_PARAMS_T]]
    | None = None,
    _collected_params: COLLECT_PARAMS_T | None = None,
    _drop_ref: Var | None = None,
) -> tuple[COLLECT_PARAMS_T, rx.Var]: ...

class DropTarget(BaseDnDDiv):
    @classmethod
    def create(
        cls,
        *children,
        accept: Var[list[str] | str] | list[str] | str | None = None,
        options: Mapping[str, Any]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Var[Mapping[str, Any] | Mapping[str, Any] | Var[Mapping[str, Any]] | None]
        | None = None,
        drop_ref: Any | Var[Any] | None = None,
        drop: Callable[[dict[str, Any], DropTargetMonitor]]
        | Var[Callable[[dict[str, Any], DropTargetMonitor]]]
        | None = None,
        hover: Callable[[dict[str, Any], DropTargetMonitor]]
        | Var[Callable[[dict[str, Any], DropTargetMonitor]]]
        | None = None,
        can_drop: Callable[[dict[str, Any], DropTargetMonitor], Var[bool] | bool | bool]
        | Var[Callable[[dict[str, Any], DropTargetMonitor], Var[bool] | bool | bool]]
        | None = None,
        collect: Callable[
            [DropTargetMonitor],
            Mapping[str, Any] | Mapping[str, Any] | Var[Mapping[str, Any]] | None,
        ]
        | Var[
            Callable[
                [DropTargetMonitor],
                Mapping[str, Any] | Mapping[str, Any] | Var[Mapping[str, Any]] | None,
            ]
        ]
        | None = None,
        access_key: Var[str] | str | None = None,
        auto_capitalize: Literal[
            "characters", "none", "off", "on", "sentences", "words"
        ]
        | Var[Literal["characters", "none", "off", "on", "sentences", "words"]]
        | None = None,
        content_editable: Literal["inherit", "plaintext-only", False, True]
        | Var[Literal["inherit", "plaintext-only", False, True]]
        | None = None,
        context_menu: Var[str] | str | None = None,
        dir: Var[str] | str | None = None,
        draggable: Var[bool] | bool | None = None,
        enter_key_hint: Literal[
            "done", "enter", "go", "next", "previous", "search", "send"
        ]
        | Var[Literal["done", "enter", "go", "next", "previous", "search", "send"]]
        | None = None,
        hidden: Var[bool] | bool | None = None,
        input_mode: Literal[
            "decimal", "email", "none", "numeric", "search", "tel", "text", "url"
        ]
        | Var[
            Literal[
                "decimal", "email", "none", "numeric", "search", "tel", "text", "url"
            ]
        ]
        | None = None,
        item_prop: Var[str] | str | None = None,
        lang: Var[str] | str | None = None,
        role: Literal[
            "alert",
            "alertdialog",
            "application",
            "article",
            "banner",
            "button",
            "cell",
            "checkbox",
            "columnheader",
            "combobox",
            "complementary",
            "contentinfo",
            "definition",
            "dialog",
            "directory",
            "document",
            "feed",
            "figure",
            "form",
            "grid",
            "gridcell",
            "group",
            "heading",
            "img",
            "link",
            "list",
            "listbox",
            "listitem",
            "log",
            "main",
            "marquee",
            "math",
            "menu",
            "menubar",
            "menuitem",
            "menuitemcheckbox",
            "menuitemradio",
            "navigation",
            "none",
            "note",
            "option",
            "presentation",
            "progressbar",
            "radio",
            "radiogroup",
            "region",
            "row",
            "rowgroup",
            "rowheader",
            "scrollbar",
            "search",
            "searchbox",
            "separator",
            "slider",
            "spinbutton",
            "status",
            "switch",
            "tab",
            "table",
            "tablist",
            "tabpanel",
            "term",
            "textbox",
            "timer",
            "toolbar",
            "tooltip",
            "tree",
            "treegrid",
            "treeitem",
        ]
        | Var[
            Literal[
                "alert",
                "alertdialog",
                "application",
                "article",
                "banner",
                "button",
                "cell",
                "checkbox",
                "columnheader",
                "combobox",
                "complementary",
                "contentinfo",
                "definition",
                "dialog",
                "directory",
                "document",
                "feed",
                "figure",
                "form",
                "grid",
                "gridcell",
                "group",
                "heading",
                "img",
                "link",
                "list",
                "listbox",
                "listitem",
                "log",
                "main",
                "marquee",
                "math",
                "menu",
                "menubar",
                "menuitem",
                "menuitemcheckbox",
                "menuitemradio",
                "navigation",
                "none",
                "note",
                "option",
                "presentation",
                "progressbar",
                "radio",
                "radiogroup",
                "region",
                "row",
                "rowgroup",
                "rowheader",
                "scrollbar",
                "search",
                "searchbox",
                "separator",
                "slider",
                "spinbutton",
                "status",
                "switch",
                "tab",
                "table",
                "tablist",
                "tabpanel",
                "term",
                "textbox",
                "timer",
                "toolbar",
                "tooltip",
                "tree",
                "treegrid",
                "treeitem",
            ]
        ]
        | None = None,
        slot: Var[str] | str | None = None,
        spell_check: Var[bool] | bool | None = None,
        tab_index: Var[int] | int | None = None,
        title: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_drop: Optional[EventType[()] | EventType[dict[str, Any]]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_hover: Optional[EventType[()] | EventType[dict[str, Any]]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "DropTarget":
        """Create a Droppable component.

        Will use the class `collect_hook` to collect the params if
        not provided, which is represented by the `DropTarget.CollectedParams`
        type and accessed via `DropTarget.collected_params` var.
        """
        ...

    class CollectedParams(TypedDict):
        is_over: bool
        can_drop: bool
        item: dict[str, Any] | None

    @staticmethod
    @static
    def collect_hook(
        monitor: DropTargetMonitor,
    ) -> rx.Var[DropTarget.CollectedParams]: ...
    collected_params: ClassVar[rx.vars.ObjectVar[DropTarget.CollectedParams]] = (
        rx.vars.ObjectVar("dropTargetCollectedParams", _var_type=CollectedParams)
    )

class DnDNamespace(rx.ComponentNamespace):
    HTML5Backend: ...
    TouchBackend: ...
    provider = staticmethod(DnDProvider.create)
    Draggable: type[Draggable]
    draggable = staticmethod(Draggable.create)
    use_drag = staticmethod(use_drag)
    DragSourceMonitor: type[DragSourceMonitor]
    DropTarget: type[DropTarget]
    drop_target = staticmethod(DropTarget.create)
    use_drop = staticmethod(use_drop)
    DropTargetMonitor: type[DropTargetMonitor]

dnd: DnDNamespace
