"""Stub file for reflex_enterprise/components/flow/flow.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from typing import Any, Literal, Mapping, Optional, Sequence, TypedDict, Union

import reflex
from reflex.components.core.breakpoints import Breakpoints
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

from .types import (
    AriaLabelConfig,
    Connection,
    ConnectionInProgress,
    DefaultEdgeOptions,
    Edge,
    FitViewOptions,
    NoConnection,
    Node,
    OnConnectStartParams,
    OnDeleteParams,
    ProOptions,
    Viewport,
    XYPosition,
)
from .types import EdgeAddChange as EdgeAddChange
from .types import EdgeRemoveChange as EdgeRemoveChange
from .types import EdgeReplaceChange as EdgeReplaceChange
from .types import EdgeSelectionChange as EdgeSelectionChange
from .types import NodeAddChange as NodeAddChange
from .types import NodeDimensionChange as NodeDimensionChange
from .types import NodePositionChange as NodePositionChange
from .types import NodeRemoveChange as NodeRemoveChange
from .types import NodeReplaceChange as NodeReplaceChange
from .types import NodeSelectionChange as NodeSelectionChange

LIBRARY = "@xyflow/react@12.8.4"

class Flow(reflex.Component):
    """Sets a fixed width for the flow."""

    "Sets a fixed height for the flow."
    "An array of nodes to render in a controlled flow."
    "An array of edges to render in a controlled flow."
    "The initial nodes to render in an uncontrolled flow."
    "The initial edges to render in an uncontrolled flow."
    "Distance that the mouse can move between mousedown/up that will trigger a click."
    "Distance that the mouse can move between mousedown/up that will trigger a click."
    "Custom node types to be available in a flow. React Flow matches a node’s type to a component in the nodeTypes object."
    "Custom edge types to be available in a flow. React Flow matches an edge’s type to a component in the edgeTypes object."
    "When true, the viewport will pan when a node is focused."
    "The origin of the node to use when placing it in the flow or looking up its x and y position. An origin of [0, 0] means that a node’s top left corner will be placed at the x and y position."
    "By default, we render a small attribution in the corner of your flows that links back to the project.\n\n    Anyone is free to remove this attribution whether they’re a Pro subscriber or not but we ask that you take a quick look at our https://reactflow.dev/learn/troubleshooting/remove-attribution\n    removing attribution guide before doing so.\n    "
    "With a threshold greater than zero you can delay node drag events. If threshold equals 1, you need to drag the node 1 pixel before a drag event is fired. 1 is the default value, so that clicks don’t trigger drag events."
    "The threshold in pixels that the mouse must move before a connection line starts to drag. This is useful to prevent accidental connections when clicking on a handle."
    "Controls color scheme used for styling the flow."
    "If set true, some debug information will be logged to the console like which events are fired."
    "Configuration for customizable labels, descriptions, and UI text.\n\n    Provided keys will override the corresponding defaults.\n    Allows localization, customization of ARIA descriptions, control labels, minimap labels, and other UI strings.\n    "
    "Sets the initial position and zoom of the viewport. If a default viewport is provided but fitView is enabled, the default viewport will be ignored."
    "When you pass a viewport prop, it’s controlled, and you also need to pass onViewportChange to handle internal changes."
    "Used when working with a controlled viewport for updating the user viewport state."
    "When true, the flow will be zoomed and panned to fit all the nodes initially provided."
    "When you typically call fitView on a ReactFlowInstance, you can provide an object of options to customize its behavior.\n\n    This prop lets you do the same for the initial fitView call.\n    "
    "Minimum zoom level."
    "Maximum zoom level."
    "When enabled, nodes will snap to the grid when dragged."
    "If snapToGrid is enabled, this prop configures the grid that nodes will snap to."
    "You can enable this optimisation to instruct React Flow to only render nodes and edges that would be visible in the viewport.\n\n    This might improve performance when you have a large number of nodes and edges but also adds an overhead.\n    "
    "By default, the viewport extends infinitely. You can use this prop to set a boundary.\n\n    The first pair of coordinates is the top left boundary and the second pair is the bottom right.\n    "
    "By default, nodes can be placed on an infinite flow. You can use this prop to set a boundary.\n\n    The first pair of coordinates is the top left boundary and the second pair is the bottom right.\n    "
    "Disabling this prop will allow the user to scroll the page even when their pointer is over the flow."
    "By default, React Flow will render a small attribution in the bottom right corner of the flow.\n\n    You can use this prop to change its position in case you want to place something else there.\n    "
    "Enabling this option will raise the z-index of edges when they are selected."
    "Color of edge markers. You can pass null to use the CSS variable --xy-edge-stroke for the marker color."
    "Defaults to be applied to all new edges that are added to the flow. Properties on a new edge will override these defaults if they exist."
    "The radius around an edge connection that can trigger an edge reconnection."
    "Whether edges can be updated once they are created. When both this prop is true and an onReconnect handler is provided, the user can drag an existing edge to a new source or target.\n\n    Individual edges can override this value with their reconnectable property.\n    "
    "Occasionally something may happen that causes React Flow to throw an error.\n\n    Instead of exploding your application, we log a message to the console and then call this event handler. You might use it for additional logging or to show a message to the user.\n    "
    "This event handler gets called when a node or edge is deleted."
    "This event handler is called when a user clicks on a node."
    "This event handler is called when a user double-clicks on a node."
    "This event handler is called when a user starts to drag a node."
    "This event handler is called when a user drags a node."
    "This event handler is called when a user stops dragging a node."
    "This event handler is called when mouse of a user enters a node."
    "This event handler is called when mouse of a user moves over a node."
    "This event handler is called when mouse of a user leaves a node."
    "This event handler is called when a user right-clicks on a node."
    "This event handler gets called when a node is deleted."
    "Use this event handler to add interactivity to a controlled flow. It is called on node drag, select, and move."
    "This event handler is called when a user clicks on an edge."
    "This event handler is called when a user double-clicks on an edge."
    "This event handler is called when mouse of a user enters an edge."
    "This event handler is called when mouse of a user moves over an edge."
    "This event handler is called when mouse of a user leaves an edge."
    "This event handler is called when a user right-clicks on an edge."
    "This handler is called when the source or target of a reconnectable edge is dragged from the current node.\n\n    It will fire even if the edge’s source or target do not end up changing. You can use the reconnectEdge utility to convert the connection to a new edge.\n    "
    "This event fires when the user begins dragging the source or target of an editable edge."
    "This event fires when the user releases the source or target of an editable edge. It is called even if an edge update does not occur."
    "This event handler gets called when an edge is deleted."
    "Use this event handler to add interactivity to a controlled flow. It is called on edge select and remove."
    "When a connection line is completed and two nodes are connected by the user, this event fires with the new connection.\n\n    You can use the addEdge utility to convert the connection to a complete edge.\n    "
    "This event handler gets called when a user starts to drag a connection line."
    "This callback will fire regardless of whether a valid connection could be made or not. You can use the second connectionState parameter to have different behavior when a connection was unsuccessful."
    "This event handler is called while the user is either panning or zooming the viewport."
    "This event handler is called when the user begins to pan or zoom the viewport."
    "This event handler is called when panning or zooming viewport movement stops. If the movement is not user-initiated, the event parameter will be null."
    "This event handler gets called when user clicks inside the pane."
    "This event handler gets called when user right clicks inside the pane."
    "This event handler gets called when user scroll inside the pane."
    "This event handler gets called when mouse moves over the pane."
    "This event handler gets called when mouse enters the pane."
    "This event handler gets called when mouse leaves the pane."
    'Controls whether all nodes should be draggable or not.\n\n    Individual nodes can override this setting by setting their draggable prop.\n\n    If you want to use the mouse handlers on non-draggable nodes, you need to add the "nopan" class to those nodes.\n    '
    "Controls whether all nodes should be connectable or not.\n\n    Individual nodes can override this setting by setting their connectable prop.\n    "
    "When true, focus between nodes can be cycled with the Tab key and selected with the Enter key.\n\n    This option can be overridden by individual nodes by setting their focusable prop.\n    "
    "When true, focus between edges can be cycled with the Tab key and selected with the Enter key.\n\n    This option can be overridden by individual edges by setting their focusable prop.\n    "
    "When true, elements (nodes and edges) can be selected by clicking on them. This option can be overridden by individual elements by setting their selectable prop."
    "When true, the viewport will pan automatically when the cursor moves to the edge of the viewport while creating a connection"
    "When true, the viewport will pan automatically when the cursor moves to the edge of the viewport while dragging a node."
    "The speed at which the viewport pans while dragging a node or a selection box."
    "Enabling this prop allows users to pan the viewport by clicking and dragging.\n\n    You can also set this prop to an array of numbers to limit which mouse buttons can activate panning.\n    "
    "Select multiple elements with a selection box, without pressing down selectionKey."
    'When set to "partial", when the user creates a selection box by click and dragging nodes that are only partially in the box are still selected.'
    "Controls if the viewport should pan by scrolling inside the container. Can be limited to a specific direction with panOnScrollMode."
    "Controls how fast viewport should be panned on scroll. Use together with panOnScroll prop."
    'This prop is used to limit the direction of panning when panOnScroll is enabled. The "free" option allows panning in any direction.'
    "Controls if the viewport should zoom by scrolling inside the container."
    "Controls if the viewport should zoom by pinching on a touch screen."
    "Controls if the viewport should zoom by double-clicking somewhere on the flow."
    "If true, nodes get selected on drag."
    "Enabling this option will raise the z-index of nodes when they are selected."
    "The connectOnClick option lets you click or tap on a source handle to start a connection and then click on a target handle to complete the connection.\n\n    If you set this option to false, users will need to drag the connection line to the target handle to create a connection.\n    "
    "A loose connection mode will allow you to connect handles with differing types, including source-to-source connections. However, it does not support target-to-target connections.\n\n    Strict mode allows only connections between source handles and target handles.\n    "
    "Styles to be applied to the connection line."
    "The type of edge path to use for connection lines. Although created edges can be of any type, React Flow needs to know what type of path to render for the connection line before the edge is created!"
    "The radius around a handle where you drop a connection line to create a new edge."
    "React Component to be used as a connection line."
    "Styles to be applied to the container of the connection line."
    'If set, pressing the key or chord will delete any selected nodes and edges. Passing an array represents multiple keys that can be pressed.\n\n    For example, ["Delete", "Backspace"] will delete selected elements when either key is pressed.'
    'If set, holding this key will let you click and drag to draw a selection box around multiple nodes and edges. Passing an array represents multiple keys that can be pressed.\n\n    For example, ["Shift", "Meta"] will allow you to draw a selection box when either key is pressed.'
    "Pressing down this key you can select multiple elements by clicking."
    "If a key is set, you can zoom the viewport while that key is held down even if panOnScroll is set to false.\n\n    By setting this prop to null you can disable this functionality."
    "If a key is set, you can pan the viewport while that key is held down even if panOnScroll is set to false.\n\n    By setting this prop to null you can disable this functionality."
    "You can use this prop to disable keyboard accessibility features such as selecting nodes or moving selected nodes with the arrow keys."
    'If an element in the canvas does not stop mouse events from propagating, clicking and dragging that element will pan the viewport. Adding the "nopan" class prevents this behavior and this prop allows you to change the name of that class.'
    'If a node is draggable, clicking and dragging that node will move it around the canvas. Adding the "nodrag" class prevents this behavior and this prop allows you to change the name of that class.'
    'Typically, scrolling the mouse wheel when the mouse is over the canvas will zoom the viewport. Adding the "nowheel" class to an element in the canvas will prevent this behavior and this prop allows you to change the name of that class.'

    def add_imports(self) -> reflex.ImportDict: ...
    @classmethod
    def create(
        cls,
        *children,
        width: Var[float] | float | None = None,
        height: Var[float] | float | None = None,
        nodes: Sequence[Node] | Var[Sequence[Node]] | None = None,
        edges: Sequence[Edge] | Var[Sequence[Edge]] | None = None,
        default_nodes: Sequence[Node] | Var[Sequence[Node]] | None = None,
        default_edges: Sequence[Edge] | Var[Sequence[Edge]] | None = None,
        pane_click_distance: Var[float] | float | None = None,
        node_click_distance: Var[float] | float | None = None,
        node_types: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        edge_types: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        auto_pan_on_node_focus: Var[bool] | bool | None = None,
        node_origin: Var[tuple[float, float]] | tuple[float, float] | None = None,
        pro_options: ProOptions | Var[ProOptions] | None = None,
        node_drag_threshold: Var[float] | float | None = None,
        connection_drag_threshold: Var[float] | float | None = None,
        color_mode: Literal["dark", "light", "system"]
        | Var[Literal["dark", "light", "system"]]
        | None = None,
        debug: Var[bool] | bool | None = None,
        aria_label_config: AriaLabelConfig | Var[AriaLabelConfig] | None = None,
        default_viewport: Var[Viewport] | Viewport | None = None,
        viewport: Var[Viewport] | Viewport | None = None,
        fit_view: Var[bool] | bool | None = None,
        fit_view_options: FitViewOptions | Var[FitViewOptions] | None = None,
        min_zoom: Var[float] | float | None = None,
        max_zoom: Var[float] | float | None = None,
        snap_to_grid: Var[bool] | bool | None = None,
        snap_grid: Var[tuple[float, float]] | tuple[float, float] | None = None,
        only_render_visible_elements: Var[bool] | bool | None = None,
        translate_extent: Var[tuple[tuple[float, float], tuple[float, float]]]
        | tuple[tuple[float, float], tuple[float, float]]
        | None = None,
        node_extent: Var[tuple[tuple[float, float], tuple[float, float]]]
        | tuple[tuple[float, float], tuple[float, float]]
        | None = None,
        prevent_scrolling: Var[bool] | bool | None = None,
        attribution_position: Literal[
            "bottom-center",
            "bottom-left",
            "bottom-right",
            "top-center",
            "top-left",
            "top-right",
        ]
        | Var[
            Literal[
                "bottom-center",
                "bottom-left",
                "bottom-right",
                "top-center",
                "top-left",
                "top-right",
            ]
        ]
        | None = None,
        elevate_edges_on_select: Var[bool] | bool | None = None,
        default_marker_color: Var[str | None] | str | None = None,
        default_edge_options: DefaultEdgeOptions
        | Var[DefaultEdgeOptions]
        | None = None,
        reconnect_radius: Var[float] | float | None = None,
        edges_reconnectable: Var[bool] | bool | None = None,
        nodes_draggable: Var[bool] | bool | None = None,
        nodes_connectable: Var[bool] | bool | None = None,
        nodes_focusable: Var[bool] | bool | None = None,
        edges_focusable: Var[bool] | bool | None = None,
        elements_selectable: Var[bool] | bool | None = None,
        auto_pan_on_connect: Var[bool] | bool | None = None,
        auto_pan_on_node_drag: Var[bool] | bool | None = None,
        auto_pan_speed: Var[float] | float | None = None,
        pan_on_drag: Sequence[float] | Var[Sequence[float] | bool] | bool | None = None,
        selection_on_drag: Var[bool] | bool | None = None,
        selection_mode: Literal["full", "partial"]
        | Var[Literal["full", "partial"]]
        | None = None,
        pan_on_scroll: Var[bool] | bool | None = None,
        pan_on_scroll_speed: Var[float] | float | None = None,
        pan_on_scroll_mode: Literal["free", "horizontal", "vertical"]
        | Var[Literal["free", "horizontal", "vertical"]]
        | None = None,
        zoom_on_scroll: Var[bool] | bool | None = None,
        zoom_on_pinch: Var[bool] | bool | None = None,
        zoom_on_double_click: Var[bool] | bool | None = None,
        select_nodes_on_drag: Var[bool] | bool | None = None,
        elevate_nodes_on_select: Var[bool] | bool | None = None,
        connect_on_click: Var[bool] | bool | None = None,
        connection_mode: Literal["loose", "strict"]
        | Var[Literal["loose", "strict"]]
        | None = None,
        connection_line_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        connection_line_type: Literal[
            "default", "simplebezier", "smoothstep", "step", "straight"
        ]
        | Var[Literal["default", "simplebezier", "smoothstep", "step", "straight"]]
        | None = None,
        connection_radius: Var[float] | float | None = None,
        connection_line_component: Any | Var[Any] | None = None,
        connection_line_container_style: Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | None = None,
        delete_key_code: Sequence[str]
        | Var[Sequence[str] | str | None]
        | str
        | None = None,
        selection_key_code: Sequence[str]
        | Var[Sequence[str] | str | None]
        | str
        | None = None,
        multi_selection_key_code: Sequence[str]
        | Var[Sequence[str] | str | None]
        | str
        | None = None,
        zoom_activation_key_code: Sequence[str]
        | Var[Sequence[str] | str | None]
        | str
        | None = None,
        pan_activation_key_code: Sequence[str]
        | Var[Sequence[str] | str | None]
        | str
        | None = None,
        disable_keyboard_a11y: Var[bool] | bool | None = None,
        no_pan_class_name: Var[str] | str | None = None,
        no_drag_class_name: Var[str] | str | None = None,
        no_wheel_class_name: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_click_connect_end: Optional[
            EventType[()]
            | EventType[Union[NoConnection, ConnectionInProgress]]
            | EventType[Union[NoConnection, ConnectionInProgress], PointerEventInfo]
        ] = None,
        on_click_connect_start: Optional[
            EventType[()]
            | EventType[OnConnectStartParams]
            | EventType[OnConnectStartParams, PointerEventInfo]
        ] = None,
        on_connect: Optional[EventType[()] | EventType[Connection]] = None,
        on_connect_end: Optional[
            EventType[()]
            | EventType[Union[NoConnection, ConnectionInProgress]]
            | EventType[Union[NoConnection, ConnectionInProgress], PointerEventInfo]
        ] = None,
        on_connect_start: Optional[
            EventType[()]
            | EventType[OnConnectStartParams]
            | EventType[OnConnectStartParams, PointerEventInfo]
        ] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_delete: Optional[EventType[()] | EventType[OnDeleteParams]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_edge_click: Optional[
            EventType[()] | EventType[Edge] | EventType[Edge, PointerEventInfo]
        ] = None,
        on_edge_context_menu: Optional[
            EventType[()] | EventType[Edge] | EventType[Edge, PointerEventInfo]
        ] = None,
        on_edge_double_click: Optional[
            EventType[()] | EventType[Edge] | EventType[Edge, PointerEventInfo]
        ] = None,
        on_edge_mouse_enter: Optional[
            EventType[()] | EventType[Edge] | EventType[Edge, PointerEventInfo]
        ] = None,
        on_edge_mouse_leave: Optional[
            EventType[()] | EventType[Edge] | EventType[Edge, PointerEventInfo]
        ] = None,
        on_edge_mouse_move: Optional[
            EventType[()] | EventType[Edge] | EventType[Edge, PointerEventInfo]
        ] = None,
        on_edges_change: Optional[
            EventType[()]
            | EventType[
                list[
                    Union[
                        EdgeAddChange,
                        EdgeRemoveChange,
                        EdgeReplaceChange,
                        EdgeSelectionChange,
                    ]
                ]
            ]
        ] = None,
        on_edges_delete: Optional[EventType[()] | EventType[list[Edge]]] = None,
        on_error: Optional[EventType[()] | EventType[str] | EventType[str, str]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_move: Optional[
            EventType[()]
            | EventType[Viewport]
            | EventType[Viewport, Union[PointerEventInfo, None]]
        ] = None,
        on_move_end: Optional[
            EventType[()]
            | EventType[Viewport]
            | EventType[Viewport, Union[PointerEventInfo, None]]
        ] = None,
        on_move_start: Optional[
            EventType[()]
            | EventType[Viewport]
            | EventType[Viewport, Union[PointerEventInfo, None]]
        ] = None,
        on_node_click: Optional[
            EventType[()] | EventType[Node] | EventType[Node, PointerEventInfo]
        ] = None,
        on_node_context_menu: Optional[
            EventType[()] | EventType[Node] | EventType[Node, PointerEventInfo]
        ] = None,
        on_node_double_click: Optional[
            EventType[()] | EventType[Node] | EventType[Node, PointerEventInfo]
        ] = None,
        on_node_drag: Optional[
            EventType[()] | EventType[Node] | EventType[Node, PointerEventInfo]
        ] = None,
        on_node_drag_starts: Optional[
            EventType[()] | EventType[Node] | EventType[Node, PointerEventInfo]
        ] = None,
        on_node_drag_stop: Optional[
            EventType[()] | EventType[Node] | EventType[Node, PointerEventInfo]
        ] = None,
        on_node_mouse_enter: Optional[
            EventType[()] | EventType[Node] | EventType[Node, PointerEventInfo]
        ] = None,
        on_node_mouse_leave: Optional[
            EventType[()] | EventType[Node] | EventType[Node, PointerEventInfo]
        ] = None,
        on_node_mouse_move: Optional[
            EventType[()] | EventType[Node] | EventType[Node, PointerEventInfo]
        ] = None,
        on_nodes_change: Optional[
            EventType[()]
            | EventType[
                list[
                    Union[
                        NodeDimensionChange,
                        NodePositionChange,
                        NodeSelectionChange,
                        NodeRemoveChange,
                        NodeAddChange,
                        NodeReplaceChange,
                    ]
                ]
            ]
        ] = None,
        on_nodes_delete: Optional[EventType[()] | EventType[list[Node]]] = None,
        on_pane_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_pane_context_menu: Optional[
            EventType[()] | EventType[PointerEventInfo]
        ] = None,
        on_pane_mouse_enter: Optional[
            EventType[()] | EventType[PointerEventInfo]
        ] = None,
        on_pane_mouse_leave: Optional[
            EventType[()] | EventType[PointerEventInfo]
        ] = None,
        on_pane_mouse_move: Optional[
            EventType[()] | EventType[PointerEventInfo]
        ] = None,
        on_pane_scroll: Optional[EventType[()]] = None,
        on_reconnect: Optional[
            EventType[()] | EventType[Edge] | EventType[Edge, Connection]
        ] = None,
        on_reconnect_end: Optional[
            EventType[()]
            | EventType[Edge]
            | EventType[Edge, Literal["source", "target"]]
            | EventType[
                Edge,
                Literal["source", "target"],
                Union[NoConnection, ConnectionInProgress],
            ]
            | EventType[
                Edge,
                Literal["source", "target"],
                Union[NoConnection, ConnectionInProgress],
                PointerEventInfo,
            ]
        ] = None,
        on_reconnect_start: Optional[
            EventType[()]
            | EventType[Edge]
            | EventType[Edge, Literal["source", "target"]]
            | EventType[Edge, Literal["source", "target"], PointerEventInfo]
        ] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        on_viewport_change: Optional[EventType[()] | EventType[Viewport]] = None,
        **props,
    ) -> "Flow":
        """Create the component.

        Args:
            *children: The children of the component.
            on_pane_scroll: TODO: Pass WheelEvent
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class FlowProvider(reflex.Component):
    """These nodes are used to initialize the flow. They are not dynamic."""

    "These edges are used to initialize the flow. They are not dynamic."
    "These nodes are used to initialize the flow. They are not dynamic."
    "These edges are used to initialize the flow. They are not dynamic."
    "The initial width is necessary to be able to use fitView on the server."
    "The initial height is necessary to be able to use fitView on the server."
    "When true, the flow will be zoomed and panned to fit all the nodes initially provided."
    "You can provide an object of options to customize the initial fitView behavior."
    "Initial minimum zoom level."
    "Initial maximum zoom level."
    "The origin of the node to use when placing it in the flow or looking up its x and y position. An origin of [0, 0] means that a node’s top left corner will be placed at the x and y position."
    "By default, nodes can be placed on an infinite flow. You can use this prop to set a boundary.\n\n    The first pair of coordinates is the top left boundary and the second pair is the bottom right."

    @classmethod
    def create(
        cls,
        *children,
        initial_nodes: Sequence[Node] | Var[Sequence[Node]] | None = None,
        initial_edges: Sequence[Edge] | Var[Sequence[Edge]] | None = None,
        default_nodes: Sequence[Node] | Var[Sequence[Node]] | None = None,
        default_edges: Sequence[Edge] | Var[Sequence[Edge]] | None = None,
        initial_width: Var[float] | float | None = None,
        initial_height: Var[float] | float | None = None,
        fit_view: Var[bool] | bool | None = None,
        initial_fit_view_options: FitViewOptions | Var[FitViewOptions] | None = None,
        initial_min_zoom: Var[float] | float | None = None,
        initial_max_zoom: Var[float] | float | None = None,
        node_origin: Var[tuple[float, float]] | tuple[float, float] | None = None,
        node_extent: Var[tuple[tuple[float, float], tuple[float, float]]]
        | tuple[tuple[float, float], tuple[float, float]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "FlowProvider":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class Background(reflex.Component):
    """Color of the pattern."""

    "Color of the background."
    "Class applied to the pattern."
    "The gap between patterns. Passing in a tuple allows you to control the x and y gap independently."
    "The radius of each dot or the size of each rectangle if BackgroundVariant.Dots or BackgroundVariant.Cross is used. This defaults to 1 or 6 respectively, or ignored if BackgroundVariant.Lines is used."
    "Offset of the pattern."
    "The width of the line used in the pattern."
    "Variant of the pattern."

    @classmethod
    def create(
        cls,
        *children,
        color: Var[str] | str | None = None,
        bg_color: Var[str] | str | None = None,
        pattern_class_name: Var[str] | str | None = None,
        gap: Var[float | tuple[float, float]]
        | float
        | tuple[float, float]
        | None = None,
        size: Var[float] | float | None = None,
        offset: Var[float | tuple[float, float]]
        | float
        | tuple[float, float]
        | None = None,
        line_width: Var[float] | float | None = None,
        variant: Literal["cross", "dots", "lines"]
        | Var[Literal["cross", "dots", "lines"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "Background":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class BaseEdge(reflex.Component):
    """The SVG path string that defines the edge. This should look something like 'M 0 0 L 100 100' for a simple line. The utility functions like getSimpleBezierEdge can be used to generate this string for you."""

    "The id of the SVG marker to use at the start of the edge. This should be defined in a <defs> element in a separate SVG document or element. Use the format “url(#markerId)” where markerId is the id of your marker definition."
    "The id of the SVG marker to use at the end of the edge. This should be defined in a <defs> element in a separate SVG document or element. Use the format “url(#markerId)” where markerId is the id of your marker definition."
    "The label or custom element to render along the edge. This is commonly a text label or some custom controls."
    "Custom styles to apply to the label."
    "The width of the invisible area around the edge that the user can interact with. This is useful for making the edge easier to click or hover over."
    "The x position of edge label."
    "The y position of edge label."

    @classmethod
    def create(
        cls,
        *children,
        path: Var[str] | str | None = None,
        marker_start: Var[str] | str | None = None,
        marker_end: Var[str] | str | None = None,
        label: Any | Var[Any] | None = None,
        label_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        label_show_bg: Var[bool] | bool | None = None,
        label_bg_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        label_bg_padding: Var[tuple[float, float]] | tuple[float, float] | None = None,
        label_bg_border_radius: Var[float] | float | None = None,
        interaction_width: Var[float] | float | None = None,
        label_x: Var[float] | float | None = None,
        label_y: Var[float] | float | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "BaseEdge":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class ControlButton(reflex.el.elements.Button):
    @classmethod
    def create(
        cls,
        *children,
        auto_focus: Var[bool] | bool | None = None,
        disabled: Var[bool] | bool | None = None,
        form: Var[str] | str | None = None,
        form_action: Var[str] | str | None = None,
        form_enc_type: Var[str] | str | None = None,
        form_method: Var[str] | str | None = None,
        form_no_validate: Var[bool] | bool | None = None,
        form_target: Var[str] | str | None = None,
        name: Var[str] | str | None = None,
        type: Literal["button", "reset", "submit"]
        | Var[Literal["button", "reset", "submit"]]
        | None = None,
        value: Var[float | int | str] | float | int | str | None = None,
        access_key: Var[str] | str | None = None,
        auto_capitalize: Literal[
            "characters", "none", "off", "on", "sentences", "words"
        ]
        | Var[Literal["characters", "none", "off", "on", "sentences", "words"]]
        | None = None,
        content_editable: Literal["inherit", "plaintext-only", False, True]
        | Var[Literal["inherit", "plaintext-only", False, True]]
        | None = None,
        context_menu: Var[str] | str | None = None,
        dir: Var[str] | str | None = None,
        draggable: Var[bool] | bool | None = None,
        enter_key_hint: Literal[
            "done", "enter", "go", "next", "previous", "search", "send"
        ]
        | Var[Literal["done", "enter", "go", "next", "previous", "search", "send"]]
        | None = None,
        hidden: Var[bool] | bool | None = None,
        input_mode: Literal[
            "decimal", "email", "none", "numeric", "search", "tel", "text", "url"
        ]
        | Var[
            Literal[
                "decimal", "email", "none", "numeric", "search", "tel", "text", "url"
            ]
        ]
        | None = None,
        item_prop: Var[str] | str | None = None,
        lang: Var[str] | str | None = None,
        role: Literal[
            "alert",
            "alertdialog",
            "application",
            "article",
            "banner",
            "button",
            "cell",
            "checkbox",
            "columnheader",
            "combobox",
            "complementary",
            "contentinfo",
            "definition",
            "dialog",
            "directory",
            "document",
            "feed",
            "figure",
            "form",
            "grid",
            "gridcell",
            "group",
            "heading",
            "img",
            "link",
            "list",
            "listbox",
            "listitem",
            "log",
            "main",
            "marquee",
            "math",
            "menu",
            "menubar",
            "menuitem",
            "menuitemcheckbox",
            "menuitemradio",
            "navigation",
            "none",
            "note",
            "option",
            "presentation",
            "progressbar",
            "radio",
            "radiogroup",
            "region",
            "row",
            "rowgroup",
            "rowheader",
            "scrollbar",
            "search",
            "searchbox",
            "separator",
            "slider",
            "spinbutton",
            "status",
            "switch",
            "tab",
            "table",
            "tablist",
            "tabpanel",
            "term",
            "textbox",
            "timer",
            "toolbar",
            "tooltip",
            "tree",
            "treegrid",
            "treeitem",
        ]
        | Var[
            Literal[
                "alert",
                "alertdialog",
                "application",
                "article",
                "banner",
                "button",
                "cell",
                "checkbox",
                "columnheader",
                "combobox",
                "complementary",
                "contentinfo",
                "definition",
                "dialog",
                "directory",
                "document",
                "feed",
                "figure",
                "form",
                "grid",
                "gridcell",
                "group",
                "heading",
                "img",
                "link",
                "list",
                "listbox",
                "listitem",
                "log",
                "main",
                "marquee",
                "math",
                "menu",
                "menubar",
                "menuitem",
                "menuitemcheckbox",
                "menuitemradio",
                "navigation",
                "none",
                "note",
                "option",
                "presentation",
                "progressbar",
                "radio",
                "radiogroup",
                "region",
                "row",
                "rowgroup",
                "rowheader",
                "scrollbar",
                "search",
                "searchbox",
                "separator",
                "slider",
                "spinbutton",
                "status",
                "switch",
                "tab",
                "table",
                "tablist",
                "tabpanel",
                "term",
                "textbox",
                "timer",
                "toolbar",
                "tooltip",
                "tree",
                "treegrid",
                "treeitem",
            ]
        ]
        | None = None,
        slot: Var[str] | str | None = None,
        spell_check: Var[bool] | bool | None = None,
        tab_index: Var[int] | int | None = None,
        title: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ControlButton":
        """Create the component.

        Args:
            *children: The children of the component.
            auto_focus: Automatically focuses the button when the page loads
            disabled: Disables the button
            form: Associates the button with a form (by id)
            form_action: URL to send the form data to (for type="submit" buttons)
            form_enc_type: How the form data should be encoded when submitting to the server (for type="submit" buttons)
            form_method: HTTP method to use for sending form data (for type="submit" buttons)
            form_no_validate: Bypasses form validation when submitting (for type="submit" buttons)
            form_target: Specifies where to display the response after submitting the form (for type="submit" buttons)
            name: Name of the button, used when sending form data
            type: Type of the button (submit, reset, or button)
            value: Value of the button, used when sending form data
            access_key: Provides a hint for generating a keyboard shortcut for the current element.
            auto_capitalize: Controls whether and how text input is automatically capitalized as it is entered/edited by the user.
            content_editable: Indicates whether the element's content is editable.
            context_menu: Defines the ID of a <menu> element which will serve as the element's context menu.
            dir: Defines the text direction. Allowed values are ltr (Left-To-Right) or rtl (Right-To-Left)
            draggable: Defines whether the element can be dragged.
            enter_key_hint: Hints what media types the media element is able to play.
            hidden: Defines whether the element is hidden.
            input_mode: Defines the type of the element.
            item_prop: Defines the name of the element for metadata purposes.
            lang: Defines the language used in the element.
            role: Defines the role of the element.
            slot: Assigns a slot in a shadow DOM shadow tree to an element.
            spell_check: Defines whether the element may be checked for spelling errors.
            tab_index: Defines the position of the current element in the tabbing order.
            title: Defines a tooltip for the element.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class Controls(reflex.Component):
    """Whether or not to show the zoom in and zoom out buttons. These buttons will adjust the viewport zoom by a fixed amount each press."""

    "Whether or not to show the fit view button. By default, this button will adjust the viewport so that all nodes are visible at once."
    "Show button for toggling interactivity."
    "Customise the options for the fit view button. These are the same options you would pass to the fitView function."
    "Called in addition the default zoom behavior when the zoom in button is clicked."
    "Called in addition the default zoom behavior when the zoom out button is clicked."
    "Called when the fit view button is clicked. When this is not provided, the viewport will be adjusted so that all nodes are visible."
    "Called when the interactive (lock) button is clicked."
    "Position of the controls on the pane"

    @classmethod
    def create(
        cls,
        *children,
        show_zoom: Var[bool] | bool | None = None,
        show_fit_view: Var[bool] | bool | None = None,
        show_interactive: Var[bool] | bool | None = None,
        fit_view_options: FitViewOptions | Var[FitViewOptions] | None = None,
        position: Literal[
            "bottom-center",
            "bottom-left",
            "bottom-right",
            "top-center",
            "top-left",
            "top-right",
        ]
        | Var[
            Literal[
                "bottom-center",
                "bottom-left",
                "bottom-right",
                "top-center",
                "top-left",
                "top-right",
            ]
        ]
        | None = None,
        orientation: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_fit_view: Optional[EventType[()]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_interactive_change: Optional[EventType[()] | EventType[bool]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        on_zoom_in: Optional[EventType[()]] = None,
        on_zoom_out: Optional[EventType[()]] = None,
        **props,
    ) -> "Controls":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class EdgeLabelRenderer(reflex.Component):
    @classmethod
    def create(
        cls,
        *children,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "EdgeLabelRenderer":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class EdgeText(reflex.Component):
    """The x position where the label should be rendered."""

    "The y position where the label should be rendered."
    "The label or custom element to render along the edge. This is commonly a text label or some custom controls."
    "Custom styles to apply to the label."

    @classmethod
    def create(
        cls,
        *children,
        x: Var[float] | float | None = None,
        y: Var[float] | float | None = None,
        label: Any | Var[Any] | None = None,
        label_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        label_show_bg: Var[bool] | bool | None = None,
        label_bg_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        label_bg_padding: Var[tuple[float, float]] | tuple[float, float] | None = None,
        label_bg_border_radius: Var[float] | float | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "EdgeText":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class Handle(reflex.Component):
    """Type of the handle."""

    "The position of the handle relative to the node. In a horizontal flow source handles are typically Position.Right and in a vertical flow they are typically Position.Top."
    "Should you be able to connect to/from this handle."
    "Dictates whether a connection can start from this handle."
    "Dictates whether a connection can end on this handle."
    "Callback called when connection is made"

    @classmethod
    def create(
        cls,
        *children,
        type: Literal["source", "target"]
        | Var[Literal["source", "target"]]
        | None = None,
        position: Literal["bottom", "left", "right", "top"]
        | Var[Literal["bottom", "left", "right", "top"]]
        | None = None,
        is_connectable: Var[bool] | bool | None = None,
        is_connectable_start: Var[bool] | bool | None = None,
        is_connectable_end: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_connect: Optional[EventType[()] | EventType[Connection]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "Handle":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class MiniMap(reflex.Component):
    """Position of minimap on pane."""

    "Callback called when minimap is clicked."
    "Color of nodes on minimap."
    "Stroke color of nodes on minimap."
    "Class name applied to nodes on minimap."
    "Border radius of nodes on minimap."
    "Stroke width of nodes on minimap."
    "A custom component to render the nodes in the minimap. This component must render an SVG element!"
    "Background color of minimap."
    "The color of the mask that covers the portion of the minimap not currently visible in the viewport."
    "Stroke color of mask representing viewport."
    "Stroke width of mask representing viewport."
    "Callback called when node on minimap is clicked."
    "Determines whether you can pan the viewport by dragging inside the minimap."
    "Determines whether you can zoom the viewport by scrolling inside the minimap."
    "There is no text inside the minimap for a screen reader to use as an accessible name, so it’s important we provide one to make the minimap accessible. The default is sufficient, but you may want to replace it with something more relevant to your app or product."
    "Invert direction when panning the minimap viewport."
    "Step size for zooming in/out on minimap."
    "Scale factor for offsetting the minimap viewport."

    @classmethod
    def create(
        cls,
        *children,
        position: Literal[
            "bottom-center",
            "bottom-left",
            "bottom-right",
            "top-center",
            "top-left",
            "top-right",
        ]
        | Var[
            Literal[
                "bottom-center",
                "bottom-left",
                "bottom-right",
                "top-center",
                "top-left",
                "top-right",
            ]
        ]
        | None = None,
        node_color: Any | Var[Any | str] | str | None = None,
        node_stroke_color: Any | Var[Any | str] | str | None = None,
        node_class_name: Any | Var[Any | str] | str | None = None,
        node_border_radius: Var[float] | float | None = None,
        node_stroke_width: Var[float] | float | None = None,
        node_component: Any | Var[Any] | None = None,
        bg_color: Var[str] | str | None = None,
        mask_color: Var[str] | str | None = None,
        mask_stroke_color: Var[str] | str | None = None,
        mask_stroke_width: Var[float] | float | None = None,
        pannable: Var[bool] | bool | None = None,
        zoomable: Var[bool] | bool | None = None,
        aria_label: str | None = None,
        inverse_pan: Var[bool] | bool | None = None,
        zoom_step: Var[float] | float | None = None,
        offset_scale: Var[float] | float | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[
            EventType[()]
            | EventType[XYPosition]
            | EventType[XYPosition, PointerEventInfo]
        ] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_node_click: Optional[
            EventType[()] | EventType[Node] | EventType[Node, PointerEventInfo]
        ] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "MiniMap":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class ResizeParams(TypedDict):
    x: float
    y: float
    width: float
    height: float

class ResizeParamsWithDirection(TypedDict):
    direction: list[float]

ControlLinePosition = Literal["left", "right", "top", "bottom"]
ControlPosition = (
    ControlLinePosition
    | Literal["top-left", "top-right", "bottom-left", "bottom-right"]
)
ResizeControlVariant = Literal["line", "handle"]
ResizeControlDirection = Literal["horizontal", "vertical"]

class NodeResizeControl(reflex.Component):
    """Id of the node it is resizing."""

    "Color of the resize handle."
    "Minimum width of node."
    "Minimum height of node."
    "Maximum width of node."
    "Maximum height of node."
    "Keep aspect ratio when resizing."
    "Scale the controls with the zoom level."
    "Callback called when resizing starts."
    "Callback called when resizing."
    "Callback called when resizing ends."
    "Position of the control."
    "Variant of the control."
    "The direction the user can resize the node. If not provided, the user can resize in any direction."

    @classmethod
    def create(
        cls,
        *children,
        node_id: Var[str] | str | None = None,
        color: Var[str] | str | None = None,
        min_width: Var[float] | float | None = None,
        min_height: Var[float] | float | None = None,
        max_width: Var[float] | float | None = None,
        max_height: Var[float] | float | None = None,
        keep_aspect_ratio: Var[bool] | bool | None = None,
        auto_scale: Var[bool] | bool | None = None,
        position: Literal["bottom", "left", "right", "top"]
        | Literal["bottom-left", "bottom-right", "top-left", "top-right"]
        | Var[
            Literal["bottom", "left", "right", "top"]
            | Literal["bottom-left", "bottom-right", "top-left", "top-right"]
        ]
        | None = None,
        variant: Literal["handle", "line"]
        | Var[Literal["handle", "line"]]
        | None = None,
        resize_direction: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_resize: Optional[
            EventType[()] | EventType[ResizeParamsWithDirection]
        ] = None,
        on_resize_end: Optional[EventType[()] | EventType[ResizeParams]] = None,
        on_resize_start: Optional[EventType[()] | EventType[ResizeParams]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "NodeResizeControl":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class NodeResizer(reflex.Component):
    """Id of the node it is resizing."""

    "Color of the resize handle."
    "Class name applied to handle."
    "Style applied to handle."
    "Class name applied to line."
    "Style applied to line."
    "Are the controls visible."
    "Minimum width of node."
    "Minimum height of node."
    "Maximum width of node."
    "Maximum height of node."
    "Keep aspect ratio when resizing."
    "Scale the controls with the zoom level."
    "Callback called when resizing starts."
    "Callback called when resizing."
    "Callback called when resizing ends."

    @classmethod
    def create(
        cls,
        *children,
        node_id: Var[str] | str | None = None,
        color: Var[str] | str | None = None,
        handle_class_name: Var[str] | str | None = None,
        handle_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        line_class_name: Var[str] | str | None = None,
        line_style: Mapping[str, Any] | Var[Mapping[str, Any]] | None = None,
        is_visible: Var[bool] | bool | None = None,
        min_width: Var[float] | float | None = None,
        min_height: Var[float] | float | None = None,
        max_width: Var[float] | float | None = None,
        max_height: Var[float] | float | None = None,
        keep_aspect_ratio: Var[bool] | bool | None = None,
        auto_scale: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_resize: Optional[
            EventType[()] | EventType[ResizeParamsWithDirection]
        ] = None,
        on_resize_end: Optional[EventType[()] | EventType[ResizeParams]] = None,
        on_resize_start: Optional[EventType[()] | EventType[ResizeParams]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "NodeResizer":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

Align = Literal["center", "start", "end"]

class NodeToolbar(reflex.Component):
    """By passing in an array of node id’s you can render a single tooltip for a group or collection of nodes."""

    "If true, node toolbar is visible even if node is not selected."
    "Position of the toolbar relative to the node."
    "The space between the node and the toolbar, measured in pixels."
    "Align the toolbar relative to the node."

    @classmethod
    def create(
        cls,
        *children,
        node_id: Sequence[str] | Var[Sequence[str] | str] | str | None = None,
        is_visible: Var[bool] | bool | None = None,
        position: Literal["bottom", "left", "right", "top"]
        | Var[Literal["bottom", "left", "right", "top"]]
        | None = None,
        offset: Var[float] | float | None = None,
        align: Literal["center", "end", "start"]
        | Var[Literal["center", "end", "start"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "NodeToolbar":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class Panel(reflex.Component):
    """The position of the panel."""

    @classmethod
    def create(
        cls,
        *children,
        position: Literal[
            "bottom-center",
            "bottom-left",
            "bottom-right",
            "top-center",
            "top-left",
            "top-right",
        ]
        | Var[
            Literal[
                "bottom-center",
                "bottom-left",
                "bottom-right",
                "top-center",
                "top-left",
                "top-right",
            ]
        ]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "Panel":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

class ViewportPortal(reflex.Component):
    @classmethod
    def create(
        cls,
        *children,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: Optional[EventType[()]] = None,
        on_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_context_menu: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_double_click: Optional[EventType[()] | EventType[PointerEventInfo]] = None,
        on_focus: Optional[EventType[()]] = None,
        on_mount: Optional[EventType[()]] = None,
        on_mouse_down: Optional[EventType[()]] = None,
        on_mouse_enter: Optional[EventType[()]] = None,
        on_mouse_leave: Optional[EventType[()]] = None,
        on_mouse_move: Optional[EventType[()]] = None,
        on_mouse_out: Optional[EventType[()]] = None,
        on_mouse_over: Optional[EventType[()]] = None,
        on_mouse_up: Optional[EventType[()]] = None,
        on_scroll: Optional[EventType[()]] = None,
        on_scroll_end: Optional[EventType[()]] = None,
        on_unmount: Optional[EventType[()]] = None,
        **props,
    ) -> "ViewportPortal":
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
        ...

flow = Flow.create
provider = FlowProvider.create
background = Background.create
base_edge = BaseEdge.create
control_button = ControlButton.create
controls = Controls.create
edge_label_renderer = EdgeLabelRenderer.create
edge_text = EdgeText.create
handle = Handle.create
mini_map = MiniMap.create
node_resize_control = NodeResizeControl.create
node_resizer = NodeResizer.create
node_toolbar = NodeToolbar.create
panel = Panel.create
viewport_portal = ViewportPortal.create
