"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddCfnInitProxy = exports.ProxyType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_autoscaling_1 = require("aws-cdk-lib/aws-autoscaling");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
/**
 * Whether an http-proxy or https-proxy
 */
var ProxyType;
(function (ProxyType) {
    /**
     * --http-proxy
     */
    ProxyType[ProxyType["HTTP"] = 0] = "HTTP";
    /**
     * --https-proxy
     */
    ProxyType[ProxyType["HTTPS"] = 1] = "HTTPS";
})(ProxyType || (exports.ProxyType = ProxyType = {}));
/**
 * Add proxy configuration to Cloudformation helper functions
 *
 * @extends IAspect
 */
class AddCfnInitProxy {
    constructor(props) {
        this._proxyHost = props.proxyHost;
        this._proxyPort = props.proxyPort;
        this._proxyType = props.proxyType || ProxyType.HTTP;
        this._proxyCredentials = props.proxyCredentials || undefined;
        this._proxyValue = this.determineProxyValue();
        this._initResourceTypes = [
            'AWS::AutoScaling::LaunchConfiguration',
            'AWS::EC2::Instance',
        ];
    }
    visit(node) {
        if (node instanceof aws_cdk_lib_1.CfnResource &&
            this._initResourceTypes.includes(node.cfnResourceType)) {
            let userData;
            if (node.cfnResourceType == aws_ec2_1.CfnInstance.CFN_RESOURCE_TYPE_NAME) {
                const instanceNode = node;
                userData = aws_cdk_lib_1.Stack.of(node).resolve(instanceNode.userData);
            }
            else if (node.cfnResourceType == aws_autoscaling_1.CfnLaunchConfiguration.CFN_RESOURCE_TYPE_NAME) {
                const launchConfigNode = node;
                userData = aws_cdk_lib_1.Stack.of(node).resolve(launchConfigNode.userData);
            }
            const commandList = userData['Fn::Base64']['Fn::Join'][1];
            const resourceIndexes = this.indexOfList('--resource', commandList);
            for (let i = 0, j = 0; i < resourceIndexes.length; i++, j += this._proxyValue.length) {
                const lineIdx = resourceIndexes[i] + j;
                commandList.splice(lineIdx, 0, ...this._proxyValue);
            }
            node.addPropertyOverride('UserData.Fn::Base64.Fn::Join', [
                '',
                commandList,
            ]);
        }
    }
    determineProxyValue() {
        const result = [];
        if (this._proxyType == ProxyType.HTTP) {
            result.push(' --http-proxy http://');
        }
        else {
            result.push(' --https-proxy https://');
        }
        if (this._proxyCredentials) {
            result.push(`${this._proxyCredentials
                .secretValueFromJson('user')
                .unsafeUnwrap()}:${this._proxyCredentials
                .secretValueFromJson('password')
                .unsafeUnwrap()}@`);
        }
        result.push(`${this._proxyHost}:${this._proxyPort}`);
        return result;
    }
    indexOfList(needle, haystack) {
        const result = [];
        for (let idx = 0; idx < haystack.length; idx++) {
            const command = haystack[idx];
            if (command instanceof Object)
                continue;
            if (command.indexOf(needle) >= 0) {
                result.push(idx);
            }
        }
        return result;
    }
}
exports.AddCfnInitProxy = AddCfnInitProxy;
_a = JSII_RTTI_SYMBOL_1;
AddCfnInitProxy[_a] = { fqn: "@cdklabs/cdk-enterprise-iac.AddCfnInitProxy", version: "0.0.411" };
//# sourceMappingURL=data:application/json;base64,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