"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddLambdaEnvironmentVariables = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
/**
 * Add one or more environment variables to _all_ lambda functions within a scope
 *
 * @extends IAspect
 */
class AddLambdaEnvironmentVariables {
    /**
     *
     * @param props {[key: string]: string} props - Key Value pair(s) for environment variables to add to all lambda functions
     */
    constructor(props) {
        this._environmentKeyValues = props;
    }
    visit(node) {
        if (node instanceof aws_lambda_1.Function) {
            const lmb = node;
            for (const [key, value] of Object.entries(this._environmentKeyValues)) {
                lmb.addEnvironment(key, value);
            }
        }
    }
}
exports.AddLambdaEnvironmentVariables = AddLambdaEnvironmentVariables;
_a = JSII_RTTI_SYMBOL_1;
AddLambdaEnvironmentVariables[_a] = { fqn: "@cdklabs/cdk-enterprise-iac.AddLambdaEnvironmentVariables", version: "0.0.411" };
//# sourceMappingURL=data:application/json;base64,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