"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddPermissionBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const utils_1 = require("../utils/utils");
/**
 * A patch for Adding Permissions Boundaries to all IAM roles
 *
 * Additional options for adding prefixes to IAM role, policy and instance profile names
 *
 * Can account for non commercial partitions (e.g. aws-gov, aws-cn)
 */
class AddPermissionBoundary {
    constructor(props) {
        this._permissionsBoundaryPolicyName = props.permissionsBoundaryPolicyName;
        this._rolePrefix = props.rolePrefix || '';
        this._policyPrefix = props.policyPrefix || '';
        this._instanceProfilePrefix = props.instanceProfilePrefix || '';
    }
    checkAndOverride(node, prefix, length, cfnProp, cdkProp) {
        if (!cdkProp?.startsWith(prefix)) {
            let policySuffix;
            if (cdkProp != undefined) {
                policySuffix = !aws_cdk_lib_1.Token.isUnresolved(cdkProp)
                    ? cdkProp
                    : (0, utils_1.getResourceId)(node.node.path);
            }
            else if (cdkProp == undefined && prefix != '') {
                policySuffix = (0, utils_1.getResourceId)(node.node.path);
            }
            else {
                return;
            }
            node.addPropertyOverride(cfnProp, `${prefix}${policySuffix.replace(/\s/g, '')}`.substring(0, length - 1));
        }
    }
    visit(node) {
        if (node instanceof aws_cdk_lib_1.CfnResource) {
            const cfnResourceNode = node;
            if (cfnResourceNode.cfnResourceType == 'AWS::IAM::Role') {
                const permissionsBoundaryPolicyArn = aws_cdk_lib_1.Stack.of(node).formatArn({
                    service: 'iam',
                    resource: 'policy',
                    region: '',
                    resourceName: this._permissionsBoundaryPolicyName,
                });
                node.addPropertyOverride('PermissionsBoundary', permissionsBoundaryPolicyArn);
                const roleName = 
                // eslint-disable-next-line dot-notation
                cfnResourceNode['cfnProperties'].roleName ||
                    cfnResourceNode.logicalId;
                this.checkAndOverride(node, this._rolePrefix, 64, 'RoleName', roleName);
            }
        }
        if (node instanceof aws_iam_1.CfnPolicy) {
            this.checkAndOverride(node, this._policyPrefix, 128, 'PolicyName', node.policyName);
        }
        else if (node instanceof aws_iam_1.CfnManagedPolicy) {
            this.checkAndOverride(node, this._policyPrefix, 128, 'ManagedPolicyName', node.managedPolicyName);
        }
        else if (node instanceof aws_iam_1.CfnInstanceProfile) {
            this.checkAndOverride(node, this._instanceProfilePrefix, 128, 'InstanceProfileName', node.instanceProfileName);
        }
    }
}
exports.AddPermissionBoundary = AddPermissionBoundary;
_a = JSII_RTTI_SYMBOL_1;
AddPermissionBoundary[_a] = { fqn: "@cdklabs/cdk-enterprise-iac.AddPermissionBoundary", version: "0.0.411" };
//# sourceMappingURL=data:application/json;base64,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