import { IAspect } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
/**
 * Patch for turning all Policies into ConvertInlinePoliciesToManaged
 *
 * Some users have policies in place that make it impossible to create inline policies. Instead,
 * they must use managed policies.
 *
 * Note that order matters with this aspect. Specifically, it should generally be added first.
 * This is because other aspects may add overrides that would be lost if applied before
 * this aspect since the original aspect is removed and replaced.
 *
 * @example
 * // Replace all AWS::IAM::Policy resources with equivalent AWS::IAM::ManagedPolicy
 * Aspects.of(stack).add(new ConvertInlinePoliciesToManaged())
 */
export declare class ConvertInlinePoliciesToManaged implements IAspect {
    visit(node: IConstruct): void;
}
