"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemovePublicAccessBlockConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
/**
 * Looks for S3 Buckets, and removes the `PublicAccessBlockConfiguration` property.
 *
 * For use in regions where Cloudformation doesn't support this property
 */
class RemovePublicAccessBlockConfiguration {
    visit(node) {
        if (node instanceof aws_s3_1.Bucket) {
            const cfnBucket = node.node.defaultChild;
            cfnBucket.addPropertyDeletionOverride('PublicAccessBlockConfiguration');
        }
    }
}
exports.RemovePublicAccessBlockConfiguration = RemovePublicAccessBlockConfiguration;
_a = JSII_RTTI_SYMBOL_1;
RemovePublicAccessBlockConfiguration[_a] = { fqn: "@cdklabs/cdk-enterprise-iac.RemovePublicAccessBlockConfiguration", version: "0.0.411" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVtb3ZlUHVibGljQWNjZXNzQmxvY2tDb25maWd1cmF0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3BhdGNoZXMvcmVtb3ZlUHVibGljQWNjZXNzQmxvY2tDb25maWd1cmF0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBS0EsK0NBQXVEO0FBR3ZEOzs7O0dBSUc7QUFDSCxNQUFhLG9DQUFvQztJQUN4QyxLQUFLLENBQUMsSUFBZ0I7UUFDM0IsSUFBSSxJQUFJLFlBQVksZUFBTSxFQUFFO1lBQzFCLE1BQU0sU0FBUyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBeUIsQ0FBQztZQUN0RCxTQUFTLENBQUMsMkJBQTJCLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztTQUN6RTtJQUNILENBQUM7O0FBTkgsb0ZBT0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IElBc3BlY3QgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBCdWNrZXQsIENmbkJ1Y2tldCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1zMyc7XG5pbXBvcnQgeyBJQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogTG9va3MgZm9yIFMzIEJ1Y2tldHMsIGFuZCByZW1vdmVzIHRoZSBgUHVibGljQWNjZXNzQmxvY2tDb25maWd1cmF0aW9uYCBwcm9wZXJ0eS5cbiAqXG4gKiBGb3IgdXNlIGluIHJlZ2lvbnMgd2hlcmUgQ2xvdWRmb3JtYXRpb24gZG9lc24ndCBzdXBwb3J0IHRoaXMgcHJvcGVydHlcbiAqL1xuZXhwb3J0IGNsYXNzIFJlbW92ZVB1YmxpY0FjY2Vzc0Jsb2NrQ29uZmlndXJhdGlvbiBpbXBsZW1lbnRzIElBc3BlY3Qge1xuICBwdWJsaWMgdmlzaXQobm9kZTogSUNvbnN0cnVjdCk6IHZvaWQge1xuICAgIGlmIChub2RlIGluc3RhbmNlb2YgQnVja2V0KSB7XG4gICAgICBjb25zdCBjZm5CdWNrZXQgPSBub2RlLm5vZGUuZGVmYXVsdENoaWxkIGFzIENmbkJ1Y2tldDtcbiAgICAgIGNmbkJ1Y2tldC5hZGRQcm9wZXJ0eURlbGV0aW9uT3ZlcnJpZGUoJ1B1YmxpY0FjY2Vzc0Jsb2NrQ29uZmlndXJhdGlvbicpO1xuICAgIH1cbiAgfVxufVxuIl19