"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveTags = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Patch for removing tags from a specific Cloudformation Resource
 *
 * In some regions, the 'Tags' property isn't supported in Cloudformation. This patch makes it easy to remove
 *
 * @example
 * // Remove tags on a resource
 * Aspects.of(stack).add(new RemoveTags({
 *   cloudformationResource: 'AWS::ECS::Cluster',
 * }));
 * // Remove tags without the standard 'Tags' name
 * Aspects.of(stack).add(new RemoveTags({
 *   cloudformationResource: 'AWS::Backup::BackupPlan',
 *    tagPropertyName: 'BackupPlanTags',
 * }));
 */
class RemoveTags {
    constructor(props) {
        this._cloudformationResource = props.cloudformationResource;
        this._tagPropertyName = props.tagPropertyName || 'Tags';
    }
    visit(node) {
        if (aws_cdk_lib_1.CfnResource.isCfnResource(node) &&
            node.cfnResourceType == this._cloudformationResource) {
            node.addPropertyDeletionOverride(this._tagPropertyName);
        }
    }
}
exports.RemoveTags = RemoveTags;
_a = JSII_RTTI_SYMBOL_1;
RemoveTags[_a] = { fqn: "@cdklabs/cdk-enterprise-iac.RemoveTags", version: "0.0.411" };
//# sourceMappingURL=data:application/json;base64,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