import { CfnResource } from 'aws-cdk-lib';
import { CloudFormationStackArtifact } from 'aws-cdk-lib/cx-api';
import { ResourceExtractorShareMethod } from './resourceExtractor';
import { FlatJson, Json } from './types';
export interface CfnStoreProps {
    readonly stackArtifacts: CloudFormationStackArtifact[];
    readonly valueShareMethod: ResourceExtractorShareMethod;
    readonly extractedStackName: string;
    readonly region: string;
}
export declare class CfnStore {
    readonly templates: Json;
    readonly flatTemplates: FlatJson;
    readonly extractedStackExports: FlatJson;
    readonly fnJoins: Json;
    constructor(props: CfnStoreProps);
    /**
     * Determine what the export value should be, for example if it should be a
     * `Ref` or `Fn::GetAtt`
     *
     * @param resource
     * @param flattendKey
     * @returns
     */
    determineExportValue(resource: CfnResource, flattendKey: string): string | false | import("aws-cdk-lib").Reference;
    /**
     * Retrieve a Stack Name from a given Logical ID
     *
     * @param logicalId the Logical ID of the Resource to find
     * @returns the Stack Name that the Logical ID is found to be in
     */
    getStackNameFromLogicalId(logicalId: string): string;
    /**
     * Retrieve a Resource Type from a given Logical ID
     *
     * @param logicalId the logical ID of the Resource to find
     * @returns the Resource Type of the provided Logical ID
     */
    getResourceTypeFromLogicalId(logicalId: string): string;
    /**
     *
     * @param stackName Stack name
     * @param logicalId the logical ID of the Resource to find
     * @returns Json object of the Cloudformation resource properties
     */
    getResourcePropertiesFromLogicalId(stackName: string, logicalId: string): Json;
    /**
     * Performs a Describe Stack API call with the AWS SDK to determine what
     * the CloudFormation Exports are for a given Stack Name.
     *
     * @param stackName the CloudFormation stack name to query against
     * @param region the AWS region to target
     * @returns CloudFormation Stack object
     */
    private describeStack;
    /**
     * Builds an Export lookup table from the provided AWS SDK CloudFormation
     * stack object. This will be in the form of `{ 'MyExport': 'foobar' }`.
     *
     * @param stack
     * @returns
     */
    private createExportMap;
    /**
     * Rebuilds an `Fn::Join` statement from the Flat Json path. This is
     * necessary because CDK does not correctly inject values back into
     * `Fn::Join` blocks. The rebuilt object is injected back into the spot where
     * the original `Fn::Join` was at. By using this method, we can get around
     * the problem where `addPropertyOverride` does not work for Fn::Join lists.
     *
     * @param fnJoinFlatJsonPath
     * @returns string of Fn::Join (may be string or Json string depending on
     * if CloudFormation needs to reference values or if the entire string can
     * be hardcoded back)
     */
    rebuildFnJoin(fnJoinFlatJsonPath: string): string;
}
